/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.formplugin.vehicle;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.plugin.impt.BatchImportPlugin;
import kd.bos.form.plugin.impt.ImportBillData;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.constant.InvoiceType;
import kd.imc.bdm.common.dto.SaleAddrAndPayeeDTO;
import kd.imc.bdm.common.helper.AddressSplitHelper;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.bdm.common.util.UUID;
import kd.imc.sim.common.AsyncCheckDTO;
import kd.imc.sim.common.dto.vehicle.VehicleInvoiceCheckDTO;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.formplugin.issuing.helper.VehicleImportHelper;
import kd.imc.sim.formplugin.vehicle.validator.VehicleInvoiceValidator;
import org.apache.commons.lang3.tuple.Pair;

public class VehicleDataImportPlugin
extends BatchImportPlugin {
    private static final Log LOGGER = LogFactory.getLog(VehicleDataImportPlugin.class);
    public static final String NEW = "new";
    private static ThreadLocal<VehicleInvoiceCheckDTO> checkDtoLocal = new ThreadLocal();

    protected void beforeSave(List<ImportBillData> billdatas, ImportLogger logger) {
    }

    private Map<String, String> checkSaleAddrAndPayeeDTO(SaleAddrAndPayeeDTO addrAndPayee) {
        Pair addrPhonePair = AddressSplitHelper.splitAddressAndTel((String)addrAndPayee.getInvoiceAddr());
        Pair bankAndAccPair = AddressSplitHelper.splitBankAndName((String)addrAndPayee.getOpenUserBank());
        HashMap<String, String> result = new HashMap<String, String>();
        result.put("saleraddress", (String)addrPhonePair.getKey());
        result.put("salerphone", (String)addrPhonePair.getValue());
        result.put("salerbankname", (String)bankAndAccPair.getKey());
        result.put("saleraccount", (String)bankAndAccPair.getValue());
        return result;
    }

    private void fillInData(SaleAddrAndPayeeDTO addrAndPayee, ImportBillData data, Map<String, String> addrInfo) {
        JSONObject json = data.getData();
        String invoiceType = json.getString("invoicetype");
        if (InvoiceType.ALL_E_PAPER_USED_CAR.getDescription().equals(invoiceType) || InvoiceType.ALL_E_PAPER_USED_CAR_ELE.getDescription().equals(invoiceType)) {
            Object usedCarNature;
            DynamicObject org;
            String SalerCardType;
            String buyerCardType;
            this.removeKey(json, "producingname", "certificatenum", "importcertificate", "commodityinspectionnum", "enginenum", "version", "jqbh", "totalton", "producingarea", "uuid", "invoicecopytype");
            json.put("issuename", (Object)addrAndPayee.getSaleName());
            json.put("issuetaxno", (Object)addrAndPayee.getSaleTaxNo());
            if (StringUtils.isBlank((CharSequence)json.getString("account"))) {
                try {
                    String account = AllEleAuthHelper.getEleAccount((String)addrAndPayee.getSaleTaxNo(), (boolean)true);
                    json.put("account", (Object)account);
                }
                catch (Exception account) {
                    // empty catch block
                }
            }
            if (null != VehicleInvoiceValidator.cardTypeMap.get(buyerCardType = json.getString("buyercardtype"))) {
                json.put("buyercardtype", VehicleInvoiceValidator.cardTypeMap.get(buyerCardType));
            }
            if (null != VehicleInvoiceValidator.cardTypeMap.get(SalerCardType = json.getString("cardtype"))) {
                json.put("cardtype", VehicleInvoiceValidator.cardTypeMap.get(SalerCardType));
            }
            if (StringUtils.isBlank((CharSequence)json.getString("issuebankaccount"))) {
                json.put("issuebankaccount", (Object)addrInfo.get("saleraccount"));
            }
            if (StringUtils.isBlank((CharSequence)json.getString("issuebankname"))) {
                json.put("issuebankname", (Object)addrInfo.get("salerbankname"));
            }
            if (StringUtils.isBlank((CharSequence)json.getString("issueaddress"))) {
                json.put("issueaddress", (Object)addrInfo.get("saleraddress"));
            }
            if (StringUtils.isBlank((CharSequence)json.getString("issuephone"))) {
                json.put("issuephone", (Object)addrInfo.get("salerphone"));
            }
            if ("\u4e2a\u4eba".equals(json.get((Object)"buyerproperty"))) {
                json.put("buyerproperty", (Object)"1");
            }
            if ("\u4e2a\u4eba".equals(json.get((Object)"salerproperty"))) {
                json.put("salerproperty", (Object)"1");
            }
            if ("\u4f01\u4e1a".equals(json.get((Object)"buyerproperty"))) {
                json.put("buyerproperty", (Object)"0");
            }
            if ("\u4f01\u4e1a".equals(json.get((Object)"salerproperty"))) {
                json.put("salerproperty", (Object)"0");
            }
            if ("\u975e\u4f01\u4e1a\u5355\u4f4d".equals(json.get((Object)"buyerproperty"))) {
                json.put("buyerproperty", (Object)"2");
            }
            if ("\u975e\u4f01\u4e1a\u5355\u4f4d".equals(json.get((Object)"salerproperty"))) {
                json.put("salerproperty", (Object)"2");
            }
            if (ResManager.loadKDString((String)"\u4e8c\u624b\u8f66\u7ecf\u9500\u4f01\u4e1a", (String)"VehicleDataImportPlugin_4", (String)"imc-sim-formplugin", (Object[])new Object[0]).equals(json.getString("usedcarenterprisenature"))) {
                json.put("usedcarenterprisenature", (Object)"08");
            }
            if (ResManager.loadKDString((String)"\u4e8c\u624b\u8f66\u5e02\u573a", (String)"VehicleDataImportPlugin_5", (String)"imc-sim-formplugin", (Object[])new Object[0]).equals(json.getString("usedcarenterprisenature"))) {
                json.put("usedcarenterprisenature", (Object)"07");
            }
            if (StringUtils.isBlank((CharSequence)json.getString("usedcarenterprisenature")) && null != (org = BusinessDataServiceHelper.loadSingle((Object)RequestContext.get().getOrgId(), (String)"bdm_org"))) {
                QFilter filter = new QFilter("epinfo", "=", (Object)DynamicObjectUtil.getDynamicObjectLongValue((Object)org.get("epinfo")));
                DynamicObject[] epInfos = BusinessDataServiceHelper.load((String)"bdm_enterprise_info", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"bdm_enterprise_info", (boolean)true), (QFilter[])filter.toArray());
                if (epInfos.length > 0) {
                    String usedCarEnterpriseNature = null;
                    String tobaccoMark = epInfos[0].getString("tobaccomark");
                    if ("8".equals(tobaccoMark)) {
                        usedCarEnterpriseNature = "08";
                    }
                    if ("9".equals(tobaccoMark)) {
                        usedCarEnterpriseNature = "07";
                    }
                    json.put("usedcarenterprisenature", (Object)usedCarEnterpriseNature);
                }
            }
            if (StringUtils.isBlank((Object)json.get((Object)"usedcarenterprisenature"))) {
                json.put("usedcarenterprisenature", (Object)"08");
            }
            if (ResManager.loadKDString((String)"\u53cd\u5411\u5f00\u7968", (String)"VehicleDataImportPlugin_3", (String)"imc-sim-formplugin", (Object[])new Object[0]).equals(json.getString("issueway"))) {
                json.put("issueway", (Object)"1");
            } else {
                json.put("issueway", (Object)"0");
            }
            String issueWay = json.getString("issueway");
            if (!"1".equals(json.getString("salerproperty"))) {
                json.put("nation", null);
            }
            if (!"1".equals(json.getString("buyerproperty"))) {
                json.put("buyernation", null);
            }
            if ("08".equals(usedCarNature = json.get((Object)"usedcarenterprisenature"))) {
                if ("0".equals(issueWay)) {
                    json.put("salername", (Object)addrAndPayee.getSaleName());
                    json.put("salertaxno", (Object)addrAndPayee.getSaleTaxNo());
                    if ("08".equals(json.getString("usedcarenterprisenature"))) {
                        json.put("salerproperty", (Object)"0");
                    }
                    if (StringUtils.isBlank((CharSequence)json.getString("saleraccount"))) {
                        json.put("saleraccount", (Object)addrInfo.get("saleraccount"));
                    }
                    if (StringUtils.isBlank((CharSequence)json.getString("salerbankname"))) {
                        json.put("salerbankname", (Object)addrInfo.get("salerbankname"));
                    }
                    if (StringUtils.isBlank((CharSequence)json.getString("saleraddress"))) {
                        json.put("saleraddress", (Object)addrInfo.get("saleraddress"));
                    }
                    if (StringUtils.isBlank((CharSequence)json.getString("salerphone"))) {
                        json.put("salerphone", (Object)addrInfo.get("salerphone"));
                    }
                } else {
                    json.put("buyername", (Object)addrAndPayee.getSaleName());
                    json.put("buyertaxno", (Object)addrAndPayee.getSaleTaxNo());
                    String nature = json.getString("usedcarenterprisenature");
                    if ("08".equals(nature)) {
                        json.put("salerproperty", (Object)"1");
                        json.put("buyerproperty", (Object)"0");
                    }
                    if (StringUtils.isBlank((CharSequence)json.getString("buyeraddr"))) {
                        json.put("buyeraddr", (Object)addrInfo.get("saleraddress"));
                    }
                    if (StringUtils.isBlank((CharSequence)json.getString("buyerphone"))) {
                        json.put("buyerphone", (Object)addrInfo.get("salerphone"));
                    }
                }
            }
        } else {
            this.removeKey(json, "issueway", "buyerproperty", "buyercardtype", "cardtype", "licenseplatenumber", "usedcarenterprisenature", "buyernation", "nation", "vehicleadminname", "issuephone", "issuebankaccount", "issuebankname", "issuebankaccount", "registernumber", "issueaddress", "salerproperty");
            json.put("salername", (Object)addrAndPayee.getSaleName());
            json.put("salertaxno", (Object)addrAndPayee.getSaleTaxNo());
            json.put("saleraccount", (Object)addrInfo.get("saleraccount"));
            json.put("salerbankname", (Object)addrInfo.get("salerbankname"));
            json.put("saleraddress", (Object)addrInfo.get("saleraddress"));
            json.put("salerphone", (Object)addrInfo.get("salerphone"));
            if (InvoiceType.ALL_E_VEHICLE_NORMAL.getDescription().equals(invoiceType) && StringUtils.isBlank((CharSequence)json.getString("account"))) {
                try {
                    String account = AllEleAuthHelper.getEleAccount((String)addrAndPayee.getSaleTaxNo(), (boolean)true);
                    json.put("account", (Object)account);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
        json.put("orgid", (Object)RequestContext.get().getOrgId());
        json.put("taxorg", (Object)IssueInvoiceService.getTaxOrgLongValue((String)addrAndPayee.getSaleTaxNo()));
        json.put("createtime", (Object)new Date());
        json.put("orderno", (Object)("vehicle_" + UUID.next()));
        json.put("billsource", (Object)"5");
        if (StringUtils.isBlank((CharSequence)json.getString("batchno"))) {
            json.put("batchno", (Object)("200_" + UUID.getBatchNumber() + "_0001"));
        }
        json.put("invoicestatus", null);
    }

    private void removeKey(JSONObject json, String ... arr) {
        for (String s : arr) {
            json.remove((Object)s);
        }
    }

    protected ApiResult save(List<ImportBillData> rowdatas, ImportLogger logger) {
        LOGGER.info("VehicleDataImportPluginStart");
        String importType = (String)this.ctx.getOption().get("importtype");
        if (NEW.equals(importType)) {
            try {
                this.fillAndCheck(rowdatas, logger);
            }
            catch (Exception e) {
                LOGGER.error(e.getMessage(), (Throwable)e);
                throw e;
            }
        }
        return super.save(rowdatas, logger);
    }

    void fillAndCheck(List<ImportBillData> rowdatas, ImportLogger logger) {
        HashMap<String, List<Integer>> billNoMap;
        HashSet<Object> billNos;
        Iterator<ImportBillData> it = rowdatas.iterator();
        VehicleInvoiceCheckDTO checkDto = checkDtoLocal.get();
        if (checkDto == null) {
            checkDto = new VehicleInvoiceCheckDTO();
            checkDtoLocal.set(checkDto);
            billNos = new HashSet<Object>();
            billNoMap = new HashMap<String, List<Integer>>();
            ArrayList checkedRowList = new ArrayList();
            checkDto.setBillNoMap(billNoMap);
            checkDto.setBillNos(billNos);
            checkDto.setCheckedList(checkedRowList);
            Set jspSet = VehicleImportHelper.getJspSet((String)VehicleImportHelper.getCurrentOrgTaxNo(), null);
            checkDto.setJspEquipmentNoSet(jspSet);
        } else {
            billNoMap = checkDto.getBillNoMap();
            billNos = checkDto.getBillNos();
        }
        HashSet<String> billSet = new HashSet<String>();
        for (ImportBillData rowdata : rowdatas) {
            String billNo = rowdata.getData().getString("billno");
            if (!StringUtils.isNotBlank((CharSequence)billNo)) continue;
            billSet.add(billNo);
        }
        HashSet<Object> repeatBillNos = new HashSet<Object>();
        if (billSet.size() > 0) {
            DynamicObject[] bills;
            QFilter filter = new QFilter("billno", "in", (Object)billSet.toArray(new Object[0]));
            for (DynamicObject bill : bills = BusinessDataServiceHelper.load((String)"sim_vatinvoice_vehicles", (String)"billno", (QFilter[])filter.toArray())) {
                repeatBillNos.add(bill.getString("billno"));
            }
        }
        SaleAddrAndPayeeDTO addrAndPayee = TaxUtils.getDefaultAddrAndPayee(null);
        Map<String, String> addrInfo = this.checkSaleAddrAndPayeeDTO(addrAndPayee);
        this.fillAndvalidBill(logger, it, checkDto, billNoMap, billNos, repeatBillNos, addrAndPayee, addrInfo);
    }

    public void fillAndvalidBill(ImportLogger logger, Iterator<ImportBillData> it, VehicleInvoiceCheckDTO checkDto, HashMap<String, List<Integer>> billNoMap, HashSet<Object> billNos, HashSet<Object> repeatBillNos, SaleAddrAndPayeeDTO addrAndPayee, Map<String, String> addrInfo) {
        while (it.hasNext()) {
            ImportBillData data = it.next();
            this.fillInData(addrAndPayee, data, addrInfo);
            boolean isSuccess = this.validBillData(data, billNos, logger, billNoMap);
            String billNo = data.getData().getString("billno");
            if (repeatBillNos.contains(billNo)) {
                isSuccess = false;
                logger.log(Integer.valueOf(data.getStartIndex()), ResManager.loadKDString((String)"\u8be5\u884c\u5355\u636e\u7f16\u53f7\u5df2\u7ecf\u5b58\u5728", (String)"VehicleDataImportPlugin_1", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            }
            if (isSuccess) continue;
            checkDto.setCheckSuccess(isSuccess);
            it.remove();
            logger.fail();
        }
    }

    private boolean validBillData(ImportBillData data, Set<Object> billNos, ImportLogger logger, HashMap<String, List<Integer>> billNoMap) {
        int index = data.getStartIndex();
        JSONObject json = data.getData();
        boolean isValidSuccess = true;
        AsyncCheckDTO dto = new AsyncCheckDTO(true);
        VehicleInvoiceCheckDTO dto2 = new VehicleInvoiceCheckDTO();
        String billNo = json.getString("billno");
        String billNoValidResult = VehicleInvoiceValidator.checkNullAndLengthMessage(billNo, 40, ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7", (String)"VehicleDataImportPlugin_0", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        isValidSuccess = this.appendErrorMessage(index, logger, billNoValidResult, isValidSuccess);
        try {
            VehicleInvoiceValidator.checkEmail(json.getString("buyeremail"));
        }
        catch (MsgException e) {
            this.appendErrorMessage(index, logger, e.getErrorMsg(), isValidSuccess);
            isValidSuccess = false;
        }
        try {
            VehicleInvoiceValidator.checkPhone(json.getString("recipientphone"));
        }
        catch (MsgException e) {
            this.appendErrorMessage(index, logger, e.getErrorMsg(), isValidSuccess);
            isValidSuccess = false;
        }
        if (StringUtils.isBlank((CharSequence)billNoValidResult)) {
            List<Object> list;
            billNos.add(billNo);
            if (billNoMap.containsKey(billNo)) {
                list = billNoMap.get(billNo);
                isValidSuccess = this.appendErrorMessage(index, logger, ResManager.loadKDString((String)"\u8be5\u884c\u5355\u636e\u7f16\u53f7\u5728\u5bfc\u5165\u7684excel\u4e2d\u91cd\u590d", (String)"VehicleDataImportPlugin_2", (String)"imc-sim-formplugin", (Object[])new Object[0]), isValidSuccess);
                dto.setSuccess(isValidSuccess);
            } else {
                list = new ArrayList();
                billNoMap.put(billNo, list);
            }
            list.add(index);
        }
        dto2.setJspEquipmentNoSet(checkDtoLocal.get().getJspEquipmentNoSet());
        dto2.setFrom(VehicleInvoiceCheckDTO.From.ISSUE);
        isValidSuccess = VehicleImportHelper.commonCheck((ImportLogger)logger, (ImportBillData)data, (AsyncCheckDTO)dto, (VehicleInvoiceCheckDTO)dto2);
        return isValidSuccess;
    }

    private boolean appendErrorMessage(int rowIndex, ImportLogger logger, String errorMessage, boolean isSuccess) {
        if (StringUtils.isNotBlank((CharSequence)errorMessage)) {
            logger.log(Integer.valueOf(rowIndex), errorMessage);
            return false;
        }
        return isSuccess;
    }
}

