/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.schedule.factory;

import java.util.LinkedHashSet;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.sim.schedule.service.BusinessAutoHandle;
import kd.imc.sim.schedule.service.impl.InvoiceDataAutoSyncImpl;
import kd.imc.sim.schedule.service.impl.InvoicePurposeStatusAutoSyncImpl;
import kd.imc.sim.schedule.service.impl.RedConfirmBillAutoConfirmImpl;
import kd.imc.sim.schedule.service.impl.RedConfirmBillAutoDownloadImpl;
import kd.imc.sim.schedule.service.impl.RedConfirmBillAutoIssueImpl;
import kd.imc.sim.schedule.service.impl.RedConfirmBillUpdateImpl;

public class HandleBusinessFacotry {
    private static final Log LOG = LogFactory.getLog(HandleBusinessFacotry.class);
    private static LinkedHashSet<BusinessAutoHandle> set = new LinkedHashSet();

    public static BusinessAutoHandle getIssueInvoice(DynamicObject autoTask) {
        try {
            for (BusinessAutoHandle handle : set) {
                if (!handle.supportTask(autoTask)) continue;
                return handle;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return null;
    }

    static {
        set.add(new RedConfirmBillAutoIssueImpl());
        set.add(new RedConfirmBillAutoDownloadImpl());
        set.add(new RedConfirmBillUpdateImpl());
        set.add(new RedConfirmBillAutoConfirmImpl());
        set.add(new InvoiceDataAutoSyncImpl());
        set.add(new InvoicePurposeStatusAutoSyncImpl());
        try {
            Map value = ImcConfigUtil.getValue((String)CacheKeyEnum.BDM_AUTO_TASK_CLASS.getConfigType());
            for (Map.Entry entry : value.entrySet()) {
                String classFullName = (String)entry.getValue();
                if (!StringUtils.isNotBlank((CharSequence)classFullName)) continue;
                BusinessAutoHandle extHandler = (BusinessAutoHandle)Class.forName(classFullName).newInstance();
                set.add(extHandler);
            }
        }
        catch (Exception e) {
            LOG.error(String.format("getExtInstanceFail:%s", e.getMessage()), (Throwable)e);
        }
    }
}

