/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.schedule.giftreceipt;

import java.util.ArrayList;
import java.util.Date;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.sim.common.helper.LyServerInvoiceHelper;
import kd.imc.sim.formplugin.giftreceipt.op.GiftReceiptDisableOp;

public class GiftReceiptTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(LyServerInvoiceHelper.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try (DLock lock = DLock.create((String)GiftReceiptTask.class.getName());){
            if (!lock.tryLock(1000L)) {
                return;
            }
            Date today = new Date();
            QFilter qFilter = new QFilter("receiptstate", "=", (Object)"1").and("expiringdate", ">=", (Object)DateUtils.trunc((Date)today)).and("expiringdate", "<", (Object)DateUtils.trunc((Date)DateUtils.addDay((Date)today, (int)1)));
            DynamicObject[] giftReceipts = BusinessDataServiceHelper.load((String)"sim_gift_receipt", (String)String.join((CharSequence)",", "receiptstate", "source", "billcenterid"), (QFilter[])qFilter.toArray());
            if (giftReceipts.length == 0) {
                return;
            }
            try {
                LOGGER.info(String.format("GiftReceiptTask valid size: %d", giftReceipts.length));
                ArrayList<Object> billcenterIdList = new ArrayList<Object>();
                for (DynamicObject giftReceipt : giftReceipts) {
                    giftReceipt.set("receiptstate", (Object)"4");
                    if (!"billcenter".equals(giftReceipt.getString("source"))) continue;
                    billcenterIdList.add(giftReceipt.get("billcenterid"));
                }
                ImcSaveServiceHelper.update((DynamicObject[])giftReceipts);
                new GiftReceiptDisableOp().updateBillCenterGiftStatus(billcenterIdList);
            }
            catch (Exception e) {
                LOGGER.error("GiftReceiptTask error ", (Throwable)e);
            }
        }
    }
}

