/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.schedule.issue;

import com.google.common.base.Splitter;
import com.google.common.collect.ImmutableMap;
import java.time.LocalDate;
import java.time.LocalTime;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.dlock.DLock;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.api.ApiResult;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.exception.KDBizException;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.imc.bdm.common.constant.BillStatusEnum;
import kd.imc.bdm.common.constant.PermissionEnum;
import kd.imc.bdm.common.dto.BillCheckProcessDto;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.common.constant.OpenApiInterfaceCodeEnum;
import kd.imc.sim.common.helper.BillValidaterHelper;
import kd.imc.sim.common.helper.ExecutorServiceHelper;
import kd.imc.sim.common.helper.OriginalBillHelper;
import kd.imc.sim.formplugin.issuing.helper.IssueInvoiceControlHelper;
import kd.imc.sim.formplugin.match.MinusBillMatchHelper;
import kd.imc.sim.schedule.issue.autoissue.BillAutoCreateRedConfirmHandler;
import kd.imc.sim.schedule.issue.autoissue.BillAutoCreateWaitHandler;
import kd.imc.sim.schedule.issue.autoissue.BillAutoIssueHandler;
import kd.imc.sim.schedule.issue.autoissue.BillAutoMatchHandler;
import kd.imc.sim.schedule.issue.autoissue.BillAutoUploadRedConfirmHandler;
import org.apache.commons.collections.CollectionUtils;

public class BillAutoIssueTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(BillAutoIssueTask.class);
    private static final String fields = "id, ctrlstrategy, useorg.id as useorg";
    private static final QFilter baseQFilter = new QFilter("enable", "=", (Object)"1").and("status", "=", (Object)"C");
    private static final String[] repeatModeStr = new String[]{"month", "week", "day"};
    private static final QFilter authedFilter = new QFilter("authstate", "=", (Object)"1").and("servergroup", "=", (Object)PermissionEnum.ISSUE_INVOICE_SERVICE.getPermissionNo());
    private static final QFilter billCommonFilter = new QFilter("confirmstate", "=", (Object)"0").and("validstate", "=", (Object)"0").and("billstatus", "in", (Object)BillStatusEnum.notApproval).and("closestatus", "!=", (Object)"1");
    private static final ImmutableMap<String, BillAutoMatchHandler> negativeHandlerMap = new ImmutableMap.Builder().put((Object)"10", (Object)new BillAutoCreateRedConfirmHandler()).put((Object)"5", (Object)new BillAutoUploadRedConfirmHandler()).put((Object)"0", (Object)new BillAutoCreateWaitHandler()).put((Object)"1", (Object)new BillAutoIssueHandler()).build();

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("BillAutoIssueTaskStart");
        }
        try (DLock lock = DLock.create((String)BillAutoIssueTask.class.getName());){
            if (!lock.tryLock()) {
                LOGGER.info("\u672a\u83b7\u53d6\u5230\u9501\uff0c\u6b63\u5728\u6267\u884c\u81ea\u52a8\u5f00\u7968");
                return;
            }
            int localTime = LocalTime.now().toSecondOfDay();
            HashSet<Object> ids = new HashSet<Object>(16);
            Set<Object> orgIdSet = new HashSet<Object>(16);
            boolean allPrivate = true;
            for (String repeatMode : repeatModeStr) {
                allPrivate = allPrivate && this.getMonthDayRun(localTime, ids, orgIdSet, repeatMode);
            }
            if (CollectionUtils.isEmpty(ids)) {
                LOGGER.info("\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u81ea\u52a8\u5f00\u7968\u8bbe\u7f6e");
                return;
            }
            if (!allPrivate) {
                DynamicObjectCollection orgList = QueryServiceHelper.query((String)"bdm_org", (String)"id", (QFilter[])new QFilter("epinfo", "!=", (Object)0).toArray());
                orgIdSet = orgList.stream().map(org -> org.get("id")).collect(Collectors.toSet());
            }
            Set<Object> filterOrgSet = this.filterNoAuthOrg(orgIdSet);
            ExecutorService executorService = ExecutorServiceHelper.newFixedExcecutorService();
            CountDownLatch countdownlatch = new CountDownLatch(filterOrgSet.size());
            RequestContext context = RequestContext.get();
            for (Object orgId : filterOrgSet) {
                executorService.execute(new BillAutoIssueThread(orgId, ids, context, countdownlatch));
                countdownlatch.countDown();
            }
            try {
                countdownlatch.await();
                executorService.shutdown();
            }
            catch (Exception e) {
                throw new KDBizException(e.toString());
            }
        }
        catch (Exception e) {
            LOGGER.error("BillAutoIssueTask error ", (Throwable)e);
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u5f00\u7968\u7533\u8bf7\u5355\u81ea\u52a8\u5f00\u7968\u5b9a\u65f6\u4efb\u52a1\u7ed3\u675f");
        }
    }

    private Set<Object> filterNoAuthOrg(Set<Object> orgIdSet) {
        HashSet<Object> filterOrgIdSet = new HashSet<Object>(orgIdSet.size());
        List<Set<Object>> orgIdSetList = this.skipList(orgIdSet);
        for (Set<Object> orgIds : orgIdSetList) {
            Map<Object, List<DynamicObject>> epInfo2OrgMap;
            DynamicObjectCollection epInfoList;
            DynamicObjectCollection orgs = QueryServiceHelper.query((String)"bdm_org", (String)"id, epinfo.id as epinfo", (QFilter[])new QFilter("id", "in", orgIds).toArray());
            if (CollectionUtils.isEmpty((Collection)orgs) || CollectionUtils.isEmpty((Collection)(epInfoList = QueryServiceHelper.query((String)"bdm_invoice_permission", (String)"epinfo.id as epinfo", (QFilter[])new QFilter("epinfo", "in", (epInfo2OrgMap = orgs.stream().collect(Collectors.groupingBy(k -> k.get("epinfo")))).keySet()).and(authedFilter).toArray())))) continue;
            Set epInfoSet = epInfoList.stream().map(epInfo -> epInfo.get("epinfo")).collect(Collectors.toSet());
            for (Object epInfo2 : epInfoSet) {
                List<DynamicObject> orgList = epInfo2OrgMap.get(epInfo2);
                if (!CollectionUtils.isNotEmpty(orgList)) continue;
                filterOrgIdSet.addAll(orgList.stream().map(org -> org.get("id")).collect(Collectors.toSet()));
            }
        }
        return filterOrgIdSet;
    }

    private <T> List<Set<T>> skipList(Set<T> skipSet) {
        int size = 1000;
        List<Set<T>> setList = new ArrayList<Set<T>>(16);
        if (skipSet.size() > size) {
            int group = (skipSet.size() + size - 1) / size;
            setList = Stream.iterate(0, i -> i + 1).limit(group).map(i -> skipSet.stream().skip(i * size).limit(size).collect(Collectors.toSet())).collect(Collectors.toList());
        } else {
            setList.add(skipSet);
        }
        return setList;
    }

    private boolean getMonthDayRun(int localTime, Set<Object> ids, Set<Object> orgIdSet, String repeatMode) {
        DynamicObjectCollection autoIssueList;
        QFilter dayOrWeekFilter;
        LocalDate today = LocalDate.now();
        QFilter qFilter = new QFilter("repeatmode", "=", (Object)repeatMode).and("issuetimestart", "<=", (Object)localTime).and("issuetimeend", ">=", (Object)localTime);
        if ("month".equals(repeatMode)) {
            dayOrWeekFilter = this.getDayOrWeekFilter(today.getDayOfMonth());
            if (today.equals(today.with(TemporalAdjusters.lastDayOfMonth()))) {
                dayOrWeekFilter.or("day", "like", (Object)"%999%");
            }
        } else {
            dayOrWeekFilter = "week".equals(repeatMode) ? this.getDayOrWeekFilter(today.getDayOfWeek().getValue()) : new QFilter("1", "=", (Object)1);
        }
        if (CollectionUtils.isEmpty((Collection)(autoIssueList = QueryServiceHelper.query((String)"bdm_auto_issue", (String)fields, (QFilter[])new QFilter[]{baseQFilter, qFilter, dayOrWeekFilter})))) {
            return true;
        }
        ids.addAll(autoIssueList.stream().map(autoIssue -> autoIssue.get("id")).collect(Collectors.toList()));
        orgIdSet.addAll(autoIssueList.stream().map(autoIssue -> autoIssue.get("useorg")).collect(Collectors.toSet()));
        return autoIssueList.stream().allMatch(autoIssue -> "7".equals(autoIssue.getString("ctrlstrategy")));
    }

    private QFilter getDayOrWeekFilter(int dayOfMonth) {
        return new QFilter("day", "=", (Object)String.valueOf(dayOfMonth)).or("day", "like", (Object)(dayOfMonth + ",%")).or("day", "like", (Object)("%," + dayOfMonth + ",%")).or("day", "like", (Object)("%," + dayOfMonth));
    }

    static class BillAutoIssueThread
    implements Runnable {
        private Object orgId;
        private Set<Object> autoIssueIds;
        private RequestContext context;
        private CountDownLatch countdownlatch;

        public BillAutoIssueThread(Object orgId, Set<Object> autoIssueIds, RequestContext context, CountDownLatch countdownlatch) {
            this.orgId = orgId;
            this.autoIssueIds = autoIssueIds;
            this.context = context;
            this.countdownlatch = countdownlatch;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                RequestContext.copyAndSet((RequestContext)this.context);
                LOGGER.info(String.format("traceid[%s]", this.context.getTraceId()));
                QFilter idFilter = OrgHelper.getIdFilter(this.autoIssueIds);
                QFilter baseDataFilter = BaseDataServiceHelper.getBaseDataFilter((String)"bdm_auto_issue", (Long)DynamicObjectUtil.getDynamicObjectLongValue((Object)this.orgId));
                DynamicObjectCollection autoIssueList = QueryServiceHelper.query((String)"bdm_auto_issue", (String)"id, filter_tag, mergeflag, pushtype, name, number, billproperties, billnotrelate", (QFilter[])new QFilter[]{idFilter, baseDataFilter, baseQFilter}, (String)"priority asc, ctrlstrategy desc");
                if (CollectionUtils.isEmpty((Collection)autoIssueList)) {
                    LOGGER.info("\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u81ea\u52a8\u5f00\u7968\u8bbe\u7f6e");
                    return;
                }
                Date today = new Date();
                for (DynamicObject autoIssue : autoIssueList) {
                    String filterStr = autoIssue.getString("filter_tag");
                    QFilter qFilter = new QFilter("orgid", "=", this.orgId).and("createdate", ">=", (Object)DateUtils.getFirstDateOfMonth((Date)today)).and("createdate", "<=", (Object)today).and(billCommonFilter);
                    qFilter.and("billproperties", "in", (Object)Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)autoIssue.getString("billproperties")));
                    if ("-1".equals(autoIssue.getString("billproperties"))) {
                        qFilter.and("invoicetype", "in", (Object)InvoiceUtils.getAllEInvoiceType()).and("specialtype", "in", (Object)MinusBillMatchHelper.normalSpecialTypeSet);
                    }
                    if (StringUtils.isNotBlank((CharSequence)filterStr)) {
                        FilterCondition filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterStr, FilterCondition.class);
                        FilterBuilder builder = new FilterBuilder(EntityMetadataCache.getDataEntityType((String)"sim_original_bill"), filterCondition);
                        builder.buildFilter();
                        qFilter.and(builder.getQFilter());
                    }
                    LOGGER.info(String.format("\u67e5\u8be2\u9700\u8981\u81ea\u52a8\u5f00\u7968\u7684\u5f00\u7968\u7533\u8bf7\u5355\u6570\u636e\uff0c\u81ea\u52a8\u5f00\u7968\u8bbe\u7f6e\u540d\u79f0\u7f16\u7801[%s]\uff0c\u7ec4\u7ec7[%s]\uff0c\u67e5\u8be2\u6761\u4ef6[%s]", autoIssue.getString("number") + autoIssue.getString("name"), this.orgId, qFilter));
                    DynamicObjectCollection bills = QueryServiceHelper.query((String)"sim_original_bill", (String)"id", (QFilter[])qFilter.toArray());
                    if (CollectionUtils.isEmpty((Collection)bills)) {
                        LOGGER.info(String.format("\u6ca1\u6709\u6ee1\u8db3\u6761\u4ef6\u7684\u5f00\u7968\u7533\u8bf7\u5355\u6570\u636e\uff0c\u7ec4\u7ec7[%s]\uff0c\u67e5\u8be2\u6761\u4ef6[%s]", this.orgId, qFilter));
                        continue;
                    }
                    this.issuePush(bills, autoIssue);
                }
            }
            finally {
                this.countdownlatch.countDown();
            }
        }

        private void issuePush(DynamicObjectCollection bills, DynamicObject autoIssue) {
            DynamicObject[] oriBills = OriginalBillHelper.queryOriginalbillsByIds((Object[])bills.stream().map(bill -> bill.get("id")).toArray());
            boolean mergeBill = "2".equals(autoIssue.getString("mergeflag")) || "4".equals(autoIssue.getString("mergeflag"));
            boolean mergeBillDetail = "3".equals(autoIssue.getString("mergeflag")) || "4".equals(autoIssue.getString("mergeflag"));
            int autoInvoice = "1".equals(autoIssue.getString("pushtype")) ? 1 : 0;
            BillCheckProcessDto process = new BillCheckProcessDto(Boolean.valueOf(true), true);
            Map groupBillMap = Arrays.stream(oriBills).collect(Collectors.groupingBy(bill -> this.getGrouplKey((DynamicObject)bill, mergeBill), LinkedHashMap::new, Collectors.toList()));
            Collection billArrList = groupBillMap.values();
            boolean isPositiveBill = "1".equals(autoIssue.getString("billproperties"));
            for (List billArr : billArrList) {
                try {
                    ArrayList<DynamicObject> verificationBills = new ArrayList<DynamicObject>(billArr.size());
                    LOGGER.info(String.format("\u5f00\u59cb\u6821\u9a8c\u81ea\u52a8\u5f00\u7968\uff0c\u5355\u636e\u5408\u5e76[%s]\uff0c\u660e\u7ec6\u5408\u5e76[%s]\uff0c\u4e0b\u63a8\u7c7b\u578b[%s]\uff0c\u5355\u636e\u7f16\u53f7[%s]", mergeBill, mergeBillDetail, autoIssue.getString("pushtype"), billArr.stream().map(bill -> bill.getString("billno")).collect(Collectors.joining(","))));
                    for (DynamicObject bill2 : billArr) {
                        ApiResult apiResult = BillValidaterHelper.validBillInvoice((DynamicObject)bill2, (!isPositiveBill ? 1 : 0) != 0, (BillCheckProcessDto)process);
                        if (!apiResult.getSuccess()) {
                            LOGGER.info(String.format("\u5355\u636e\u7f16\u53f7[%s]\u6821\u9a8c\u4e0d\u901a\u8fc7\u7684\u5355\u636e\uff0c\u6821\u9a8c\u4fe1\u606f[%s]", bill2.getString("billno"), apiResult.getMessage()));
                            continue;
                        }
                        verificationBills.add(bill2);
                    }
                    if (CollectionUtils.isEmpty(verificationBills)) {
                        LOGGER.info("\u6821\u9a8c\u901a\u8fc7\u7684\u5355\u636e\u4e3a\u7a7a");
                        continue;
                    }
                    LOGGER.info(String.format("\u5f00\u59cb\u81ea\u52a8\u5f00\u7968\uff0c\u5355\u636e\u5408\u5e76[%s]\uff0c\u660e\u7ec6\u5408\u5e76[%s]\uff0c\u4e0b\u63a8\u7c7b\u578b[%s]\uff0c\u6821\u9a8c\u901a\u8fc7\u7684\u5355\u636e\u7f16\u53f7[%s]", mergeBill, mergeBillDetail, autoIssue.getString("pushtype"), verificationBills.stream().map(bill -> bill.getString("billno")).collect(Collectors.joining(","))));
                    if (mergeBill) {
                        if (isPositiveBill) {
                            IssueInvoiceControlHelper.issueInvoice((DynamicObject[])verificationBills.toArray(new DynamicObject[0]), (String)((DynamicObject)billArr.get(0)).getString("jqbh"), (String)((DynamicObject)billArr.get(0)).getString("terminalno"), (String)OpenApiInterfaceCodeEnum.BILL_PUSH.getCode(), (Integer)autoInvoice, (boolean)true, (boolean)mergeBillDetail);
                            continue;
                        }
                        this.issueNegativeBill(verificationBills, autoIssue);
                        continue;
                    }
                    for (DynamicObject verificationBill : verificationBills) {
                        try {
                            if (isPositiveBill) {
                                IssueInvoiceControlHelper.issueInvoice((DynamicObject[])new DynamicObject[]{verificationBill}, (String)((DynamicObject)billArr.get(0)).getString("jqbh"), (String)((DynamicObject)billArr.get(0)).getString("terminalno"), (String)OpenApiInterfaceCodeEnum.BILL_PUSH.getCode(), (Integer)autoInvoice, (boolean)false, (boolean)mergeBillDetail);
                                continue;
                            }
                            this.issueNegativeBill(Collections.singletonList(verificationBill), autoIssue);
                        }
                        catch (Exception e) {
                            LOGGER.error(String.format("\u81ea\u52a8\u5f00\u7968\u5931\u8d25\uff0c\u5355\u636e\u7f16\u53f7[%s]", verificationBill.getString("billno")), (Throwable)e);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error(String.format("\u81ea\u52a8\u5f00\u7968\u5931\u8d25\uff0c\u5355\u636e\u7f16\u53f7[%s]", billArr.stream().map(bill -> bill.getString("billno")).collect(Collectors.joining(","))), (Throwable)e);
                }
            }
        }

        private String getGrouplKey(DynamicObject bill, boolean mergeBill) {
            ArrayList<String> list = new ArrayList<String>(50);
            list.add(InvoiceUtils.isAllEInvoice((Object)bill.getString("invoicetype")) ? "1" : "0");
            list.add(bill.getString("jqbh"));
            list.add(bill.getString("terminalno"));
            list.add("00".equals(bill.getString("specialtype")) ? "" : bill.getString("specialtype"));
            list.add("Kingdee_Excel".equals(bill.getString("systemsource")) ? "" : bill.getString("systemsource"));
            list.add("A".equals(bill.getString("billsourcetype")) ? "" : bill.getString("billsourcetype"));
            if (mergeBill) {
                list.add(String.valueOf(DynamicObjectUtil.getDynamicObjectLongValue((Object)bill.get("mergerule"))));
                list.add(bill.getString("buyername"));
                list.add(bill.getString("buyertaxno"));
                list.add(bill.getString("invoicetype"));
                list.add(bill.getString("taxationstyle"));
                list.add(bill.getString("hsbz"));
                list.add(bill.getString("buyerproperty"));
                list.add(bill.getString("bizcontroltype"));
            }
            return String.join((CharSequence)"\u25cf\u25c6\u25a0", list);
        }

        private void issueNegativeBill(List<DynamicObject> bills, DynamicObject autoIssue) {
            if (CollectionUtils.isEmpty(bills)) {
                return;
            }
            BillAutoMatchHandler handler = (BillAutoMatchHandler)negativeHandlerMap.get((Object)autoIssue.getString("pushtype"));
            if (handler == null) {
                LOGGER.info(String.format("\u67e5\u8be2\u9700\u8981\u81ea\u52a8\u5f00\u7968\u7684\u5f00\u7968\u7533\u8bf7\u5355\u6570\u636e\uff0c\u81ea\u52a8\u5f00\u7968\u8bbe\u7f6e\u540d\u79f0\u7f16\u7801[%s]\uff0c\u7ec4\u7ec7[%s]\uff0c\u672a\u627e\u5230\u5bf9\u5e94\u7684\u5b9e\u73b0\u7c7b", autoIssue.getString("number") + autoIssue.getString("name"), this.orgId));
                return;
            }
            handler.setAutoIssue(autoIssue);
            handler.execute(bills);
        }
    }
}

