/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.schedule.issue.autoissue;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.sim.common.constant.RedConfirmStatusEnum;
import kd.imc.sim.common.helper.issueinvoice.IssueInvoiceMqHelper;
import kd.imc.sim.formplugin.redconfirm.helper.RedConfirmBillHelper;
import kd.imc.sim.schedule.issue.autoissue.BillAutoUploadRedConfirmHandler;
import org.apache.commons.collections.CollectionUtils;

public class BillAutoCreateWaitHandler
extends BillAutoUploadRedConfirmHandler {
    private static final Log LOGGER = LogFactory.getLog(BillAutoCreateWaitHandler.class);

    @Override
    public List<DynamicObject> execute(List<DynamicObject> bills) {
        List<DynamicObject> redConfirmList = super.execute(bills);
        ArrayList<String> orderNoList = new ArrayList<String>(redConfirmList.size());
        for (DynamicObject redConfirm : redConfirmList) {
            try {
                if (RedConfirmStatusEnum.isNotInvoiceByNumber((String)redConfirm.getString("confirmstatus"))) continue;
                LOGGER.info(String.format("\u7ea2\u5b57\u786e\u8ba4\u5355\u6d41\u6c34\u53f7[%s]\uff0c\u5f00\u59cb\u751f\u6210\u5f85\u5f00", redConfirm.getString("orderno")));
                DynamicObject waitInvoice = RedConfirmBillHelper.createWaitInvoice((DynamicObject)redConfirm);
                ImcSaveServiceHelper.save((DynamicObject)waitInvoice);
                orderNoList.add(waitInvoice.getString("orderno"));
            }
            catch (Exception e) {
                LOGGER.error(String.format("\u7ea2\u5b57\u786e\u8ba4\u5355\u6d41\u6c34\u53f7[%s]\uff0c\u751f\u6210\u5f85\u5f00\u5931\u8d25\uff0c\u5931\u8d25\u539f\u56e0[%s]", redConfirm.getString("orderno"), e.getMessage()), (Throwable)e);
            }
        }
        if (this.getClass().equals(BillAutoCreateWaitHandler.class) || CollectionUtils.isEmpty(orderNoList)) {
            return new ArrayList<DynamicObject>(1);
        }
        DynamicObject[] invoices = BusinessDataServiceHelper.load((String)"sim_vatinvoice", (String)IssueInvoiceMqHelper.submitMqField, (QFilter[])OrgHelper.getIdFilter(orderNoList, (String)"orderno").toArray());
        return Arrays.stream(invoices).collect(Collectors.toList());
    }
}

