/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.schedule.issue.autoissue;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.dto.BillRelationDTO;
import kd.imc.bdm.common.dto.merge.MergeRequestDTO;
import kd.imc.bdm.common.dto.merge.MergeResponseDTO;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.sim.common.constant.RedConfirmBillRedReasonEnum;
import kd.imc.sim.common.constant.table.MatchBillConstant;
import kd.imc.sim.common.dto.minusbill.MatchBillRequest;
import kd.imc.sim.common.dto.minusbill.MinusBillDTO;
import kd.imc.sim.common.dto.minusbill.MinusBillMatchConfig;
import kd.imc.sim.common.helper.OriginalBillHelper;
import kd.imc.sim.common.utils.BillOperationLockUtil;
import kd.imc.sim.formplugin.bill.originalbill.workbench.alleevent.AllEBillTabCustomEvent;
import kd.imc.sim.formplugin.bill.splitMerge.helper.BillMergeHelper;
import kd.imc.sim.formplugin.match.BillComprehensiveStatusHelper;
import kd.imc.sim.formplugin.match.BillMatchHelper;
import kd.imc.sim.formplugin.match.MinusBillMatchHelper;
import kd.imc.sim.formplugin.match.RedConfirmMatchHelper;
import kd.imc.sim.schedule.bill.NegativeBillMatchTask;
import org.apache.commons.collections.CollectionUtils;

public class BillAutoMatchHandler {
    private static final Log LOGGER = LogFactory.getLog(BillAutoMatchHandler.class);
    private DynamicObject autoIssue;

    public void setAutoIssue(DynamicObject autoIssue) {
        this.autoIssue = autoIssue;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<DynamicObject> execute(List<DynamicObject> bills) {
        List billNos = bills.stream().map(bill -> bill.getString("billno")).collect(Collectors.toList());
        long orgId = DynamicObjectUtil.getDynamicObjectLongValue((Object)bills.get(0).get("orgid"));
        boolean matchRedConfirm = "2".equals(this.autoIssue.getString("billnotrelate"));
        HashSet<Object> successMatchIds = new HashSet<Object>(bills.size());
        ArrayList<BillRelationDTO> relations = new ArrayList(bills.size());
        ArrayList<DynamicObject> unMatchBills = new ArrayList<DynamicObject>(bills.size());
        HashMap<Object, DynamicObject> matchOriInvSettingConfig = new HashMap(bills.size());
        try {
            BillOperationLockUtil.getBillsLock(billNos, (boolean)true, (long)orgId);
            MergeRequestDTO billRequest = new MergeRequestDTO.Builder().mergeBill("2".equals(this.autoIssue.getString("mergeflag")) || "4".equals(this.autoIssue.getString("mergeflag"))).mergeBillDetail("3".equals(this.autoIssue.getString("mergeflag")) || "4".equals(this.autoIssue.getString("mergeflag"))).bills(bills.toArray(new DynamicObject[0])).build();
            MergeResponseDTO mergeResponseDTO = new BillMergeHelper().mergeBill(billRequest);
            List mergeBillList = mergeResponseDTO.getBills();
            relations = mergeResponseDTO.getRelations();
            Map matchRedConfirmConfig = new HashMap(mergeBillList.size());
            if (matchRedConfirm) {
                matchRedConfirmConfig = BillMatchHelper.getMatchRedConfirmConfig((List)mergeBillList);
            }
            matchOriInvSettingConfig = BillMatchHelper.getMatchOriInvSettingConfig((List)mergeBillList);
            String operateBatch = new AllEBillTabCustomEvent().getOperateBatch() + "red";
            AllEBillTabCustomEvent allEBillTabCustomEvent = new AllEBillTabCustomEvent();
            for (DynamicObject mergeBill : mergeBillList) {
                DynamicObject matchRedConfig;
                DynamicObject matchBill = MinusBillMatchHelper.createMatchBillByOriginalBill((DynamicObject)mergeBill, (String)operateBatch);
                TXHandle tx = TX.requiresNew();
                try {
                    allEBillTabCustomEvent.autoSpecifyMatchBill(null, mergeBill, matchBill, true);
                    if (MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode().equals(matchBill.getString("matchstatus"))) {
                        LOGGER.info(String.format("\u5355\u636e\u7f16\u53f7[%s]\uff0c\u5355\u636e\u4e2d\u6709\u539f\u84dd\u7968\u4ee3\u7801\u53f7\u7801\u6216\u7ea2\u5b57\u786e\u8ba4\u5355\uff0c\u8d70\u624b\u5de5\u6307\u5b9a\u903b\u8f91", mergeBill.getString("billno")));
                        List billRelation = relations.stream().filter(relation -> relation.gettBillId().equals(mergeBill.get("id"))).collect(Collectors.toList());
                        allEBillTabCustomEvent.saveRelationAndUpdateOriginalBill(matchBill, billRelation, StringUtils.isNotBlank((CharSequence)mergeBill.getString("infocode")));
                        relations.removeIf(relation -> relation.gettBillId().equals(mergeBill.get("id")));
                        successMatchIds.add(matchBill.get("id"));
                        continue;
                    }
                }
                catch (Exception e) {
                    LOGGER.error(String.format("\u5355\u636e\u7f16\u53f7[%s]\uff0c\u5355\u636e\u4e2d\u6709\u539f\u84dd\u7968\u4ee3\u7801\u53f7\u7801\u6216\u7ea2\u5b57\u786e\u8ba4\u5355\uff0c\u624b\u5de5\u6307\u5b9a\u5931\u8d25\uff0c\u5f02\u5e38\u4fe1\u606f[%s]", mergeBill.getString("billno"), e.getMessage()), (Throwable)e);
                    tx.markRollback();
                    relations.removeIf(relation -> relation.gettBillId().equals(mergeBill.get("id")));
                    continue;
                }
                finally {
                    tx.close();
                    continue;
                }
                boolean isNormalSpecialType = "".equals(mergeBill.getString("specialtype")) || "00".equals(mergeBill.getString("specialtype"));
                boolean needMatch = false;
                if (matchRedConfirm && isNormalSpecialType && (matchRedConfig = (DynamicObject)matchRedConfirmConfig.get(matchBill.get("id"))) != null) {
                    LOGGER.info(String.format("\u5355\u636e\u7f16\u53f7[%s]\uff0c\u5339\u914d\u5230\u5339\u7ea2\u5b57\u786e\u8ba4\u5355\u89c4\u5219\uff0c\u5339\u786e\u8ba4\u5355\u89c4\u5219[%s]", mergeBill.getString("billno"), matchRedConfig.getString("number")));
                    matchBill.set("matchconfig", (Object)matchRedConfig);
                    needMatch = true;
                }
                DynamicObject matchBlueConfig = (DynamicObject)matchOriInvSettingConfig.get(matchBill.get("id"));
                DynamicObjectCollection billItems = mergeBill.getDynamicObjectCollection("sim_original_bill_item");
                if (isNormalSpecialType && !RedConfirmBillRedReasonEnum.INVOICE_ERR.getBillCode().equals(mergeBill.getString("redreason")) && matchBlueConfig != null && billItems.stream().allMatch(item -> item.getInt("originalseq") == 0)) {
                    LOGGER.info(String.format("\u5355\u636e\u7f16\u53f7[%s]\uff0c\u5339\u914d\u5230\u5339\u84dd\u7968\u89c4\u5219\uff0c\u5339\u84dd\u7968\u89c4\u5219[%s]", mergeBill.getString("billno"), matchBlueConfig.getString("number")));
                    matchBill.set("matchrule", (Object)matchBlueConfig);
                    needMatch = true;
                }
                if (needMatch) {
                    unMatchBills.add(matchBill);
                    continue;
                }
                LOGGER.info(String.format("\u5355\u636e\u7f16\u53f7[%s]\uff0c\u6ca1\u6709\u5bf9\u5e94\u7684\u5339\u914d\u89c4\u5219", mergeBill.getString("billno")));
                relations.removeIf(relation -> relation.gettBillId().equals(mergeBill.get("id")));
            }
            MatchBillRequest matchBillRequest = new MatchBillRequest();
            matchBillRequest.setRelations(relations);
            Set collect = relations.stream().map(BillRelationDTO::getsBillId).collect(Collectors.toSet());
            matchBillRequest.setNoMatchOriginalBills(bills.stream().filter(bill -> collect.contains(bill.getLong("id"))).collect(Collectors.toList()));
            new MinusBillMatchHelper().saveCreateMatchBills(unMatchBills, matchBillRequest, new HashMap(1));
            ImcSaveServiceHelper.save((List)matchBillRequest.getNoMatchOriginalBills());
        }
        catch (Exception e) {
            if (e instanceof MsgException) {
                MsgException msgException = (MsgException)((Object)e);
                if ("singleMoreThanTaxControl".equals(msgException.getErrorCode()) || "mergeMoreThanTaxControl".equals(msgException.getErrorCode())) {
                    LOGGER.error(String.format("\u8d1f\u6570\u81ea\u52a8\u5f00\u7968\u5408\u5e76\u5931\u8d25\uff0c\u5355\u636e\u7f16\u53f7[%s],\u5931\u8d25\u4fe1\u606f[%s]", billNos, String.format("%s \u5355\u636e\u5b58\u5728\u660e\u7ec6\u8d85\u8fc7\u7a0e\u63a7\u5c3e\u5dee\uff0c\u8bf7\u8c03\u6574\u6570\u636e\u540e\u5339\u914d\u3002", msgException.getErrorMsg())), (Throwable)e);
                } else {
                    LOGGER.error(String.format("\u8d1f\u6570\u81ea\u52a8\u5f00\u7968\u5408\u5e76\u5931\u8d25\uff0c\u5355\u636e\u7f16\u53f7[%s],\u5931\u8d25\u4fe1\u606f[%s]", billNos, msgException.getErrorMsg()), (Throwable)e);
                }
            } else {
                LOGGER.error(String.format("\u8d1f\u6570\u81ea\u52a8\u5f00\u7968\u5408\u5e76\u5931\u8d25\uff0c\u5355\u636e\u7f16\u53f7[%s],\u5931\u8d25\u4fe1\u606f[%s]", billNos, e.getMessage()), (Throwable)e);
            }
        }
        finally {
            BillOperationLockUtil.unOperationLook((String)String.valueOf(orgId), billNos);
        }
        if (CollectionUtils.isNotEmpty(unMatchBills)) {
            DynamicObject[] unMatchBillArr = OriginalBillHelper.queryMatchBillByIds((Object[])unMatchBills.stream().map(unMatchBill -> unMatchBill.get("id")).toArray());
            HashSet<DynamicObject> matchBlueList = new HashSet<DynamicObject>(unMatchBillArr.length);
            ArrayList<DynamicObject> matchRedConfirmList = new ArrayList<DynamicObject>(unMatchBillArr.length);
            for (DynamicObject unMatchBill2 : unMatchBillArr) {
                if (matchRedConfirm && unMatchBill2.getDynamicObject("matchconfig") != null) {
                    matchRedConfirmList.add(unMatchBill2);
                    continue;
                }
                if (unMatchBill2.getDynamicObject("matchrule") == null) continue;
                matchBlueList.add(unMatchBill2);
            }
            this.matchRedConfirm(matchRedConfirmList, matchBlueList, successMatchIds);
            this.matchBillInvoice(matchBlueList, matchOriInvSettingConfig, successMatchIds);
            this.setOriginalBillMatchStatus(bills, relations, unMatchBillArr);
            for (DynamicObject unMatchBill2 : unMatchBillArr) {
                new BillComprehensiveStatusHelper().setBillComprehensiveStatusByMatchBill(unMatchBill2);
            }
            ImcSaveServiceHelper.save((DynamicObject[])unMatchBillArr);
        }
        return Arrays.stream(OriginalBillHelper.queryMatchBillByIds((Object[])successMatchIds.toArray())).collect(Collectors.toList());
    }

    private void matchRedConfirm(List<DynamicObject> matchRedConfirmList, Set<DynamicObject> matchBlueList, Set<Object> successMatchIds) {
        if (CollectionUtils.isEmpty(matchRedConfirmList)) {
            return;
        }
        new RedConfirmMatchHelper().matchRedConfirm(matchRedConfirmList);
        for (DynamicObject matchBill : matchRedConfirmList) {
            if (!MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode().equals(matchBill.getString("matchstatus")) && !MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode().equals(matchBill.getString("matchstatus"))) {
                matchBlueList.add(matchBill);
                LOGGER.info(String.format("\u5355\u636e\u7f16\u53f7[%s]\uff0c\u96f6\u5339\u914d\u5230\u7ea2\u5b57\u786e\u8ba4\u5355", matchBill.getString("billno")));
                continue;
            }
            successMatchIds.add(matchBill.get("id"));
            LOGGER.info(String.format("\u5355\u636e\u7f16\u53f7[%s]\uff0c\u5339\u914d\u5230\u7ea2\u5b57\u786e\u8ba4\u5355", matchBill.getString("billno")));
        }
    }

    private void matchBillInvoice(Set<DynamicObject> matchBlueList, Map<Object, DynamicObject> matchOriInvSettingConfig, Set<Object> successMatchIds) {
        MinusBillMatchHelper minusBillMatchHelper = new MinusBillMatchHelper();
        List isvExtFieldList = new MinusBillMatchHelper().getIsvExtFieldList();
        HashSet oriInvoiceIdSet = new HashSet(matchBlueList.size());
        for (DynamicObject matchBill : matchBlueList) {
            DynamicObject matchOriInvSetting = matchOriInvSettingConfig.get(matchBill.get("id"));
            if (matchOriInvSetting == null) continue;
            MinusBillMatchConfig matchConfig = NegativeBillMatchTask.buildMatchConfigByDynamicObject(matchOriInvSetting);
            MinusBillDTO minusBill = minusBillMatchHelper.createMinusBillByMatchBill(matchConfig, matchBill);
            minusBill.setConfig(matchConfig);
            minusBill.setMatchInvoiceIds(oriInvoiceIdSet);
            LOGGER.info(String.format("\u5355\u636e\u7f16\u53f7[%s]\uff0c\u5339\u914d\u84dd\u7968", matchBill.getString("billno")));
            minusBillMatchHelper.match(minusBill);
            matchBill.set("matchtarget", (Object)"0");
            matchBill.set("matchtype", (Object)"1");
            minusBillMatchHelper.updateMatchBill(isvExtFieldList, minusBill, matchBill, oriInvoiceIdSet);
            if (!MatchBillConstant.MatchStatusEnum.MATCH_PART_SUCCESS.getCode().equals(matchBill.getString("matchstatus")) && !MatchBillConstant.MatchStatusEnum.MATCH_SUCCESS.getCode().equals(matchBill.getString("matchstatus"))) continue;
            successMatchIds.add(matchBill.get("id"));
        }
        if (CollectionUtils.isNotEmpty(oriInvoiceIdSet)) {
            minusBillMatchHelper.updateInvoiceOccupyStatus(oriInvoiceIdSet, "1", "sim_vatinvoice");
        }
    }

    private void setOriginalBillMatchStatus(List<DynamicObject> bills, List<BillRelationDTO> relations, DynamicObject[] unMatchBillArr) {
        Map<Long, DynamicObject> billId2BillMap = bills.stream().collect(Collectors.toMap(k -> k.getLong("id"), v -> v, (v1, v2) -> v1));
        HashMap<Long, Set> matchBill2Bill = new HashMap<Long, Set>(relations.size());
        for (BillRelationDTO relation : relations) {
            Set billIds = matchBill2Bill.computeIfAbsent(relation.gettBillId(), k -> new HashSet());
            billIds.add(relation.getsBillId());
        }
        ArrayList<DynamicObject> updateBills = new ArrayList<DynamicObject>(unMatchBillArr.length);
        for (DynamicObject matchBill : unMatchBillArr) {
            Set billIds = (Set)matchBill2Bill.get(matchBill.getLong("id"));
            for (Long billId : billIds) {
                DynamicObject bill = billId2BillMap.get(billId);
                if (bill == null) continue;
                bill.set("matchstatus", matchBill.get("matchstatus"));
                updateBills.add(bill);
            }
        }
        ImcSaveServiceHelper.save(updateBills);
    }
}

