/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.schedule.report;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.form.CloseCallBack;
import kd.bos.form.IFormView;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.api.JobInfo;
import kd.bos.schedule.api.JobType;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.schedule.form.JobForm;
import kd.bos.schedule.form.JobFormInfo;
import kd.imc.bdm.common.constant.allele.AllEleInterfaceTypeEnum;
import kd.imc.bdm.common.dto.allele.AllEleRequestDTO;
import kd.imc.bdm.common.dto.allele.AllEleResponseListDTO;
import kd.imc.bdm.common.helper.AllEleServiceHelper;
import kd.imc.sim.common.dto.allele.AllEleQueryInvoiceBodyDTO;
import kd.imc.sim.common.dto.allele.AllEleQueryInvoiceBodyResponseDTO;
import kd.imc.sim.formplugin.report.plugin.SimAllEleAccountCheckPlugin;

public class AllEleInvoiceBodyQueryTask
extends AbstractTask {
    private static Log LOGGER = LogFactory.getLog(AllEleInvoiceBodyQueryTask.class);

    public static void dispatchTask(SimAllEleAccountCheckPlugin listPlugin, AllEleQueryInvoiceBodyDTO request) {
        JobInfo jobInfo = new JobInfo();
        jobInfo.setAppId(listPlugin.getView().getFormShowParameter().getAppId());
        jobInfo.setJobType(JobType.REALTIME);
        jobInfo.setName(ResManager.loadKDString((String)"\u6570\u7535\u5bf9\u8d26\u5b9a\u65f6\u4efb\u52a1", (String)"AllEleInvoiceBodyQueryTask_10", (String)"imc-sim-formplugin", (Object[])new Object[0]));
        jobInfo.setId(UUID.randomUUID().toString());
        jobInfo.setTaskClassname(AllEleInvoiceBodyQueryTask.class.getName());
        jobInfo.setRunByUserId(Long.parseLong(RequestContext.get().getUserId()));
        HashMap<String, AllEleQueryInvoiceBodyDTO> params = new HashMap<String, AllEleQueryInvoiceBodyDTO>();
        params.put("request", request);
        jobInfo.setParams(params);
        JobFormInfo formInfo = new JobFormInfo(jobInfo);
        formInfo.setCloseCallBack(new CloseCallBack((IFormPlugin)listPlugin, "dispatchTask"));
        formInfo.setCanBackground(true);
        formInfo.setTimeout(600);
        JobForm.dispatch((JobFormInfo)formInfo, (IFormView)listPlugin.getView());
    }

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        this.feedbackProgress(0, ResManager.loadKDString((String)"\u5f00\u59cb\u8fdb\u884c\u6570\u7535\u5bf9\u8d26", (String)"AllEleInvoiceBodyQueryTask_5", (String)"imc-sim-formplugin", (Object[])new Object[0]), null);
        LOGGER.info("AllEleInvoiceBodyQueryTaskStart");
        AllEleQueryInvoiceBodyDTO request = (AllEleQueryInvoiceBodyDTO)SerializationUtils.fromJsonString((String)SerializationUtils.toJsonString((Object)map.get("request")), AllEleQueryInvoiceBodyDTO.class);
        String sellerTaxNo = request.getSellerTaxNo();
        try (DLock lock = DLock.create((String)(sellerTaxNo + "allEleInvoiceBodyQuery"), (String)ResManager.loadKDString((String)"\u6570\u7535\u5bf9\u8d26\u9501", (String)"AllEleInvoiceBodyQueryTask_6", (String)"imc-sim-formplugin", (Object[])new Object[0]));){
            if (!lock.tryLock(1000L)) {
                HashMap<String, Object> result = new HashMap<String, Object>();
                result.put("success", Boolean.FALSE);
                result.put("errMsg", String.format(ResManager.loadKDString((String)"\u7a0e\u53f7%s\u6b63\u5728\u5bf9\u8d26\uff0c\u8bf7\u7b49\u5f85\u672c\u6b21\u5bf9\u8d26\u4efb\u52a1\u5b8c\u6210\u540e\u518d\u64cd\u4f5c\u3002", (String)"AllEleInvoiceBodyQueryTask_3", (String)"imc-sim-formplugin", (Object[])new Object[0]), sellerTaxNo));
                this.feedbackCustomdata(result);
                return;
            }
            this.queryInvoiceBody(request, sellerTaxNo);
        }
    }

    private void queryInvoiceBody(AllEleQueryInvoiceBodyDTO request, String sellerTaxNo) {
        try {
            int totalPage;
            request.setRequest_path(AllEleInterfaceTypeEnum.PAGE_QUERY_INVOICE_BODY.getRequestPath());
            request.setPageSize(50);
            int pageNo = 1;
            ArrayList responseLists = new ArrayList();
            do {
                List data;
                request.setPage(pageNo);
                AllEleResponseListDTO response = AllEleServiceHelper.doPostList((String)sellerTaxNo, (AllEleRequestDTO)request, AllEleQueryInvoiceBodyResponseDTO.class);
                int totalElement = response.getTotalElement();
                int lastElement = totalElement % 50;
                totalPage = totalElement / 50;
                if (lastElement > 0) {
                    ++totalPage;
                }
                if (null != (data = response.getData())) {
                    responseLists.addAll(data);
                }
                String desc = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u4e0b\u8f7d\u7b2c%1$s\u9875\uff0c\u5171%2$s\u9875", (String)"AllEleInvoiceBodyQueryTask_9", (String)"imc-sim-formplugin", (Object[])new Object[0]), pageNo, totalPage);
                int progress = totalPage == 0 ? 100 : pageNo * 100 / totalPage;
                this.feedbackProgress(progress, desc, new HashMap());
            } while (++pageNo <= totalPage);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("success", Boolean.TRUE);
            result.put("errMsg", ResManager.loadKDString((String)"\u67e5\u8be2\u6210\u529f", (String)"AllEleInvoiceBodyQueryTask_8", (String)"imc-sim-formplugin", (Object[])new Object[0]));
            result.put("responseLists", responseLists);
            this.feedbackCustomdata(result);
        }
        catch (Exception e) {
            LOGGER.error("AllEleInvoiceBodyQueryTask" + e.getMessage(), (Throwable)e);
            HashMap<String, Object> result = new HashMap<String, Object>();
            result.put("success", Boolean.FALSE);
            result.put("errMsg", e.getMessage());
            this.feedbackCustomdata(result);
        }
    }
}

