/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.schedule.service;

import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.OrgHelper;
import kd.imc.bdm.common.util.CacheHelper;
import kd.imc.bdm.common.util.DynamicObjectUtil;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.sim.common.utils.DateUtils;
import kd.imc.sim.formplugin.issuing.dataimport.HistoryInvoiceDataImportService;
import kd.imc.sim.schedule.service.BusinessAutoHandle;

public class AbstractInvoiceSyncHandle
implements BusinessAutoHandle {
    private static final Log LOGGER = LogFactory.getLog(AbstractInvoiceSyncHandle.class);
    private static final String CACHE_KEY = "AbstractInvoiceSyncHandle:%s:%s";
    private static final String CONFIG_TYPE = "sim_his_inv_data_imp";
    private static final String CONFIG_KEY = "task_date";
    private static final int EXEC_DAY = 5;

    @Override
    public boolean supportTask(DynamicObject autoTaskObj) {
        return false;
    }

    @Override
    public void handleTask(DynamicObject autoTaskObj) {
    }

    protected boolean checkData(DynamicObject autoTaskObj) {
        String taskDateStr = ImcConfigUtil.getValue((String)CONFIG_TYPE, (String)CONFIG_KEY);
        if ("4".equals(autoTaskObj.getString("type")) && null != autoTaskObj.getString("querytime")) {
            String queryTime = autoTaskObj.getString("querytime");
            String[] taskDates = queryTime.split(",");
            boolean runTimeFlag = false;
            for (int i = 0; i < taskDates.length; ++i) {
                if (StringUtils.isEmpty((CharSequence)taskDates[i]) || !this.checkTaskDate(Integer.parseInt(taskDates[i]))) continue;
                runTimeFlag = true;
                break;
            }
            if (StringUtils.isNotEmpty((CharSequence)taskDateStr) && !runTimeFlag) {
                runTimeFlag = this.checkTaskDate(Integer.parseInt(taskDateStr));
            }
            if (!runTimeFlag) {
                LOGGER.info("AbstractInvoiceSyncHandle \u672a\u5230\u6267\u884c\u4efb\u52a1\u7684\u65e5\u671f\uff0c\u8df3\u8fc7");
                return Boolean.FALSE;
            }
        } else {
            int taskDate = 5;
            if (StringUtils.isNotEmpty((CharSequence)taskDateStr)) {
                taskDate = Integer.parseInt(taskDateStr);
            }
            if (!this.checkTaskDate(taskDate)) {
                LOGGER.info("AbstractInvoiceSyncHandle \u672a\u5230\u6267\u884c\u4efb\u52a1\u7684\u65e5\u671f\uff0c\u8df3\u8fc7");
                return Boolean.FALSE;
            }
        }
        String orgId = autoTaskObj.getDynamicObject("org").getString("id");
        String taskType = autoTaskObj.getString("type");
        return this.checkRepeatTask(orgId, taskType);
    }

    private boolean checkTaskDate(int day) {
        LocalDate now = LocalDate.now();
        return now.getDayOfMonth() == day;
    }

    private boolean checkRepeatTask(String orgId, String taskType) {
        String cacheKey = String.format(CACHE_KEY, taskType, orgId);
        if (StringUtils.isNotBlank((CharSequence)CacheHelper.get((String)cacheKey))) {
            LOGGER.info("AbstractInvoiceSyncHandle is Running,this task is stopped:{}", (Object)cacheKey);
            return Boolean.FALSE;
        }
        CacheHelper.put((String)cacheKey, (String)"id", (int)3600);
        return Boolean.TRUE;
    }

    protected void saveImportTaskData(DynamicObject autoTaskObj, String dataType) {
        DynamicObject orgInfo = BusinessDataServiceHelper.loadSingle((Object)autoTaskObj.getDynamicObject("org").getPkValue(), (String)"bdm_org");
        DynamicObject epInfo = orgInfo.getDynamicObject("epinfo");
        if (epInfo == null) {
            LOGGER.info("AbstractInvoiceSyncHandle \u901a\u8fc7\u7ec4\u7ec7:{}\u83b7\u53d6\u4f01\u4e1a\u4e3a\u7a7a\uff0c\u8df3\u8fc7", autoTaskObj.getDynamicObject("org").getPkValue());
            return;
        }
        epInfo = BusinessDataServiceHelper.loadSingle((Object)epInfo.getPkValue(), (String)"bdm_enterprise_baseinfo");
        Set<Long> useOrgs = this.getUseOrgIds(autoTaskObj);
        String orgFields = "epinfo";
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bdm_org", (String)orgFields, (QFilter[])new QFilter("id", "in", useOrgs).toArray());
        List epPks = Arrays.stream(orgs).map(o -> DynamicObjectUtil.getDynamicObjectLongValue((Object)o.getDynamicObject("epinfo"))).collect(Collectors.toList());
        String epFields = "issuechannel,number,name";
        DynamicObject[] epInfos = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)epFields, (QFilter[])new QFilter("id", "in", epPks).toArray());
        Map<Long, DynamicObject> epInfoMap = Arrays.stream(epInfos).collect(Collectors.toMap(o -> o.getLong("id"), o -> o));
        ArrayList<DynamicObject> saveObjs = new ArrayList<DynamicObject>();
        HashSet<Long> epPkSet = new HashSet<Long>();
        for (DynamicObject org : orgs) {
            long epInfoPk = DynamicObjectUtil.getDynamicObjectLongValue((Object)org.getDynamicObject("epinfo"));
            DynamicObject epObj = epInfoMap.get(epInfoPk);
            if (epPkSet.contains(epInfoPk)) continue;
            epPkSet.add(epInfoPk);
            if (null == epObj) continue;
            try {
                DynamicObject task = this.generateTask(autoTaskObj, dataType, org, epObj);
                saveObjs.add(task);
            }
            catch (Exception e) {
                LOGGER.error("saveImportTaskDataError:" + e.getMessage(), (Throwable)e);
            }
        }
        if (saveObjs.size() > 0) {
            ImcSaveServiceHelper.save(saveObjs);
        }
    }

    private Set<Long> getUseOrgIds(DynamicObject autoTaskObj) {
        String strategy = autoTaskObj.getString("ctrlstrategy");
        HashSet<Long> orgs = new HashSet<Long>();
        Set allAuthedOrgs = InvoiceUtils.getAllAuthedOrgs();
        if ("5".equals(strategy)) {
            return allAuthedOrgs;
        }
        if ("7".equals(strategy)) {
            LOGGER.info("fromPrivateOrg");
            orgs.add(DynamicObjectUtil.getDynamicObjectLongValue((Object)autoTaskObj.getDynamicObject("org")));
            orgs = orgs.stream().filter(allAuthedOrgs::contains).collect(Collectors.toSet());
            return orgs;
        }
        if ("6".equals(strategy)) {
            List childrenOrgIds = OrgHelper.getChildrenOrgIds((long)DynamicObjectUtil.getDynamicObjectLongValue((Object)autoTaskObj.getDynamicObject("org")));
            orgs.addAll(childrenOrgIds);
            orgs = orgs.stream().filter(allAuthedOrgs::contains).collect(Collectors.toSet());
            return orgs;
        }
        HashSet queryUseOrgIds = InvoiceUtils.queryUseOrgIds((String)"t_bdm_auto_task_u", (Object)autoTaskObj.getPkValue());
        queryUseOrgIds.add(DynamicObjectUtil.getDynamicObjectLongValue((Object)autoTaskObj.getDynamicObject("org")));
        orgs = queryUseOrgIds.stream().filter(allAuthedOrgs::contains).collect(Collectors.toSet());
        return orgs;
    }

    private DynamicObject generateTask(DynamicObject autoTaskObj, String dataType, DynamicObject orgInfo, DynamicObject epInfo) {
        String issueChannel;
        boolean rpaChannel;
        String invoiceType = autoTaskObj.getString("invoicetype");
        List<String> dateRangeList = Collections.singletonList(DateUtils.getminusMonths((int)1));
        if ("4".equals(autoTaskObj.getString("type"))) {
            dateRangeList = new ArrayList<String>(1);
            String timeperiod = autoTaskObj.getString("timeperiod");
            if ("0".equals(timeperiod)) {
                dateRangeList.add(DateUtils.getminusMonths((int)1));
            } else {
                int minusMonth = 1;
                if ("2".equals(timeperiod)) {
                    minusMonth = 2;
                }
                if ("3".equals(timeperiod)) {
                    minusMonth = 3;
                }
                if ("4".equals(timeperiod)) {
                    minusMonth = 6;
                }
                for (int i = 0; i < minusMonth; ++i) {
                    dateRangeList.add(DateUtils.getminusMonths((int)i));
                }
            }
        }
        String downloadChannel = (rpaChannel = "0".equals(issueChannel = epInfo.getString("issuechannel"))) ? "2" : "1";
        DynamicObject historyImportTaskData = HistoryInvoiceDataImportService.getHistoryImportTaskData((DynamicObject)epInfo, (String)dataType, (String)invoiceType, (String)downloadChannel, null, dateRangeList);
        historyImportTaskData.set("org", (Object)orgInfo);
        return historyImportTaskData;
    }
}

