/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.schedule.service.impl;

import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.operate.result.OperationResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.OperationServiceHelper;
import kd.imc.bdm.common.helper.ImcBaseDataHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.sim.common.dto.RedConfirmConfirmDTO;
import kd.imc.sim.schedule.service.AbstractRedConfirmBillHandle;

public class RedConfirmBillAutoConfirmImpl
extends AbstractRedConfirmBillHandle {
    private static final Log LOGGER = LogFactory.getLog(RedConfirmBillAutoConfirmImpl.class);
    private static final String NeedBueryConfirm = "02";
    private static final String NeedSalerConfirm = "03";

    @Override
    public boolean supportTask(DynamicObject autoTaskObj) {
        return "2".equals(autoTaskObj.getString("type"));
    }

    @Override
    public void handleTask(DynamicObject autoTaskObj) {
        super.handleTask(autoTaskObj);
        Date uploadTimeStart = this.getStartTime(autoTaskObj.getString("timeperiod"));
        String[] array = new String[]{NeedBueryConfirm, NeedSalerConfirm};
        QFilter filter = new QFilter("uploaddate", ">=", (Object)uploadTimeStart).and("confirmstatus", "in", (Object)array);
        Object source = autoTaskObj.get("source");
        if (StringUtils.isNotBlank((Object)source)) {
            Set sourceSet = Arrays.stream(((String)source).split(",")).filter(StringUtils::isNotBlank).collect(Collectors.toSet());
            QFilter sourceFilter = new QFilter("source", "in", sourceSet);
            filter = filter.and(sourceFilter);
        }
        HashMap<Long, Boolean> orgAuthorityMap = new HashMap<Long, Boolean>();
        Set<Long> queryAuthorityOrgs = this.getUsedOrgSet(autoTaskObj);
        RedConfirmConfirmDTO dto = this.getConfirmRedConfirmDto(autoTaskObj);
        this.excuteConfirm(autoTaskObj, orgAuthorityMap, queryAuthorityOrgs, filter, 0L, dto);
    }

    private RedConfirmConfirmDTO getConfirmRedConfirmDto(DynamicObject autoTaskObj) {
        DynamicObjectCollection items2;
        HashSet<String> taxNos = new HashSet<String>();
        if (autoTaskObj.getBoolean("allconfirm")) {
            DynamicObject[] eps = BusinessDataServiceHelper.load((String)"bdm_enterprise_baseinfo", (String)"number", null);
            for (DynamicObject ep : eps) {
                taxNos.add(ep.getString("number"));
            }
        }
        if (null != (items2 = autoTaskObj.getDynamicObjectCollection("items")) && items2.size() > 0) {
            for (DynamicObject item : items2) {
                if (!StringUtils.isNotBlank((CharSequence)item.getString("confirmtaxno"))) continue;
                taxNos.add(item.getString("confirmtaxno"));
            }
        }
        RedConfirmConfirmDTO dto = new RedConfirmConfirmDTO();
        dto.setOtherTaxNos(taxNos);
        String orgFields = String.join((CharSequence)",", "epinfo", "enterprisemainorg");
        DynamicObject[] orgs = BusinessDataServiceHelper.load((String)"bdm_org", (String)orgFields, null);
        HashMap<Long, String> orgEpNameMap = new HashMap<Long, String>();
        HashMap<String, DynamicObject> taxNoOrgMap = new HashMap<String, DynamicObject>();
        for (DynamicObject org : orgs) {
            DynamicObject epInfo = org.getDynamicObject("epinfo");
            if (null == epInfo) continue;
            orgEpNameMap.put(org.getLong("id"), epInfo.getString("name"));
            String taxNo = epInfo.getString("number");
            if (!"1".equals(org.getString("enterprisemainorg"))) continue;
            taxNoOrgMap.put(taxNo, org);
        }
        dto.setOrgEpNameMap(orgEpNameMap);
        dto.setTaxNoOrgMap(taxNoOrgMap);
        String identity = autoTaskObj.getString("identity");
        if (StringUtils.isBlank((CharSequence)identity)) {
            dto.setAllIdentity(true);
            return dto;
        }
        if (!identity.contains("0") && identity.contains("1")) {
            dto.setAllIdentity(true);
            return dto;
        }
        if (identity.contains("0") && identity.contains("1")) {
            dto.setAllIdentity(true);
            return dto;
        }
        if (identity.contains("0")) {
            dto.setSellerIdentity(true);
        }
        return dto;
    }

    private void excuteConfirm(DynamicObject autoTaskObj, Map<Long, Boolean> orgAuthorityMap, Set<Long> queryAuthorityOrgs, QFilter filter, long minId, RedConfirmConfirmDTO dto) {
        String fields = String.join((CharSequence)",", "buyertaxno", "buyername", "salertaxno", "salername", "confirmstatus");
        if (minId != 0L) {
            filter = filter.copy().and("id", "<", (Object)minId);
        }
        DynamicObject[] redConfirms = BusinessDataServiceHelper.load((String)"sim_red_confirm_bill", (String)fields, (QFilter[])filter.toArray(), (String)"id desc", (int)500);
        LOGGER.info("excuteConfirmRedConfirmLength:" + redConfirms.length);
        if (redConfirms.length <= 0) {
            return;
        }
        minId = redConfirms[redConfirms.length - 1].getLong("id");
        OperateOption option = OperateOption.create();
        for (DynamicObject redConfirm : redConfirms) {
            if (!this.needConfirm(autoTaskObj, redConfirm, orgAuthorityMap, queryAuthorityOrgs, dto)) continue;
            Object[] array = new Object[]{redConfirm.getLong("id")};
            try {
                OperationResult result = OperationServiceHelper.executeOperate((String)"btn_confirm", (String)"sim_red_confirm_bill", (Object[])array, (OperateOption)option);
                if (!result.isSuccess()) {
                    LOGGER.info(String.format("excuteConfirmFail:[%s]", result.getMessage()));
                    continue;
                }
                if (!"04".equals(redConfirm.getString("confirmstatus"))) continue;
                redConfirm.set("confirmdate", (Object)new Date());
                ImcSaveServiceHelper.save((DynamicObject)redConfirm);
            }
            catch (Exception e) {
                LOGGER.error(String.format("excuteConfirmError:[%s]", e.getMessage()), (Throwable)e);
            }
        }
        if (redConfirms.length > 0) {
            this.excuteConfirm(autoTaskObj, orgAuthorityMap, queryAuthorityOrgs, filter, minId, dto);
        }
    }

    private boolean needConfirm(DynamicObject autoTaskObj, DynamicObject redConfirm, Map<Long, Boolean> orgAuthorityMap, Set<Long> queryAuthorityOrgs, RedConfirmConfirmDTO dto) {
        String confirmStatue;
        switch (confirmStatue = redConfirm.getString("confirmstatus")) {
            case "02": {
                return this.buyerConfirm(autoTaskObj, redConfirm, orgAuthorityMap, queryAuthorityOrgs, dto);
            }
            case "03": {
                return this.sellerConfirm(autoTaskObj, redConfirm, orgAuthorityMap, queryAuthorityOrgs, dto);
            }
        }
        return false;
    }

    private boolean sellerConfirm(DynamicObject autoTaskObj, DynamicObject redConfirm, Map<Long, Boolean> orgAuthorityMap, Set<Long> queryAuthorityOrgs, RedConfirmConfirmDTO dto) {
        String otherTaxNo = redConfirm.getString("buyertaxno");
        Set otherTaxNos = dto.getOtherTaxNos();
        if (!otherTaxNos.contains(otherTaxNo)) {
            return false;
        }
        if (!this.isIdentityCanConfirm(autoTaskObj, "0")) {
            return false;
        }
        String sellerTaxNo = redConfirm.getString("salertaxno");
        Map taxNoMainOrgMap = dto.getTaxNoOrgMap();
        DynamicObject sellerOrg = (DynamicObject)taxNoMainOrgMap.get(sellerTaxNo);
        if (null != sellerOrg) {
            if (null != queryAuthorityOrgs) {
                return queryAuthorityOrgs.contains(sellerOrg.getLong("id"));
            }
            if (orgAuthorityMap.containsKey(sellerOrg.getLong("id"))) {
                return orgAuthorityMap.get(sellerOrg.getLong("id"));
            }
            QFilter filter = new QFilter("id", "=", autoTaskObj.getPkValue()).and(ImcBaseDataHelper.getAutoTaskFilter((Object)sellerOrg.getLong("id")));
            if (QueryServiceHelper.exists((String)"bdm_auto_task", (QFilter[])filter.toArray())) {
                orgAuthorityMap.put(sellerOrg.getLong("id"), Boolean.TRUE);
                return true;
            }
            orgAuthorityMap.put(sellerOrg.getLong("id"), Boolean.FALSE);
            return false;
        }
        return false;
    }

    private boolean buyerConfirm(DynamicObject autoTaskObj, DynamicObject redConfirm, Map<Long, Boolean> orgAuthorityMap, Set<Long> queryAuthorityOrgs, RedConfirmConfirmDTO dto) {
        String buyerTaxNo = redConfirm.getString("buyertaxno");
        String otherTaxNo = redConfirm.getString("salertaxno");
        Set otherTaxNos = dto.getOtherTaxNos();
        Map taxNoMainOrgMap = dto.getTaxNoOrgMap();
        if (!this.isIdentityCanConfirm(autoTaskObj, "1")) {
            return false;
        }
        if (!otherTaxNos.contains(otherTaxNo)) {
            return false;
        }
        DynamicObject buyerOrg = (DynamicObject)taxNoMainOrgMap.get(buyerTaxNo);
        if (null != buyerOrg) {
            if (null != queryAuthorityOrgs) {
                return queryAuthorityOrgs.contains(buyerOrg.getLong("id"));
            }
            if (orgAuthorityMap.containsKey(buyerOrg.getLong("id"))) {
                return orgAuthorityMap.get(buyerOrg.getLong("id"));
            }
            QFilter filter = new QFilter("id", "=", autoTaskObj.getPkValue()).and(ImcBaseDataHelper.getAutoTaskFilter((Object)buyerOrg.getLong("id")));
            if (QueryServiceHelper.exists((String)"bdm_auto_task", (QFilter[])filter.toArray())) {
                orgAuthorityMap.put(buyerOrg.getLong("id"), Boolean.TRUE);
                return true;
            }
            orgAuthorityMap.put(buyerOrg.getLong("id"), Boolean.FALSE);
            return false;
        }
        return false;
    }

    private boolean isIdentityCanConfirm(DynamicObject autoTaskObj, String identityStr) {
        String identity = autoTaskObj.getString("identity");
        if (StringUtils.isBlank((CharSequence)identity)) {
            return true;
        }
        return identity.contains(identityStr);
    }
}

