/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.schedule.service.impl;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.EnterpriseHelper;
import kd.imc.bdm.common.model.SaleInfo;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.TaxUtils;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmDownLoadRequestDTO;
import kd.imc.sim.common.dto.allele.redconfirm.AllEleRedConfirmDownLoadResponseDTO;
import kd.imc.sim.common.helper.ExecutorServiceHelper;
import kd.imc.sim.schedule.service.AbstractRedConfirmBillHandle;

public class RedConfirmBillUpdateImpl
extends AbstractRedConfirmBillHandle {
    private static Log LOGGER = LogFactory.getLog(RedConfirmBillUpdateImpl.class);

    @Override
    public boolean supportTask(DynamicObject autoTaskObj) {
        return "1".equals(autoTaskObj.getString("type"));
    }

    @Override
    public void handleTask(final DynamicObject autoTaskObj) {
        String timePeriod = autoTaskObj.getString("timeperiod");
        final Date timeStart = this.getStartTime(timePeriod);
        final String taskNos = autoTaskObj.getString("taxnos");
        String[] taxNoArray = taskNos.split(",");
        taxNoArray = Arrays.stream(taxNoArray).filter(StringUtils::isNotBlank).collect(Collectors.toList()).toArray(new String[0]);
        List<Long> orgPks = this.getUsedOrgs(autoTaskObj);
        LOGGER.info("UpdateRedConfirmControlStrategyOrgs" + JSONObject.toJSONString(orgPks));
        HashSet<Long> orgSet = this.getLongs(orgPks);
        orgPks = this.filterAllEleOrgs(orgSet, autoTaskObj);
        LOGGER.info("UpdateRedConfirmOrgs:" + JSONObject.toJSONString(orgPks));
        final Date now = new Date();
        final Map saleInfoMap = TaxUtils.getOrgPkSaleInfoMap(orgPks);
        ExecutorService executorService = ExecutorServiceHelper.newFixedExcecutorService((int)5, (int)5);
        final CountDownLatch countdownlatch = new CountDownLatch(orgPks.size());
        final RequestContext requestContext = RequestContext.get();
        for (final Long orgPk : orgPks) {
            executorService.execute(new Runnable(){

                @Override
                public void run() {
                    try {
                        LOGGER.info("enterRedConfirmBillUpdate,orgPk:" + orgPk);
                        RequestContext.copyAndSet((RequestContext)requestContext);
                        String[] taxNoArray = taskNos.split(",");
                        taxNoArray = Arrays.stream(taxNoArray).filter(StringUtils::isNotBlank).collect(Collectors.toList()).toArray(new String[0]);
                        RedConfirmBillUpdateImpl.this.updateOneOrgRedConfirm(autoTaskObj, timeStart, taxNoArray, now, saleInfoMap, orgPk);
                    }
                    catch (Exception e) {
                        LOGGER.error("RedConfirmBillUpdateImpl:" + e.getMessage(), (Throwable)e);
                    }
                    finally {
                        countdownlatch.countDown();
                    }
                }
            });
        }
        try {
            countdownlatch.await();
            executorService.shutdown();
        }
        catch (Exception e) {
            LOGGER.error("RedConfirmBillAutoDownloadImplError:" + e.getMessage(), (Throwable)e);
        }
    }

    private void updateOneOrgRedConfirm(DynamicObject autoTaskObj, Date timeStart, String[] taxNoArray, Date now, Map<Long, SaleInfo> saleInfoMap, Long orgPk) {
        SaleInfo saleInfo = saleInfoMap.get(orgPk);
        if (null == saleInfo) {
            return;
        }
        try {
            if (taxNoArray.length != 0) {
                for (String s : taxNoArray) {
                    AllEleRedConfirmDownLoadRequestDTO request = this.getAllEleRedConfirmDownLoadRequestDTO(autoTaskObj, timeStart, now, orgPk, saleInfo, s);
                    this.downloadRedConfirmBill(request, saleInfo);
                }
            } else {
                AllEleRedConfirmDownLoadRequestDTO request = this.getAllEleRedConfirmDownLoadRequestDTO(autoTaskObj, timeStart, now, orgPk, saleInfo, null);
                this.downloadRedConfirmBill(request, saleInfo);
            }
        }
        catch (Exception e) {
            LOGGER.error("RedConfirmBillUpdateImplError:" + e.getMessage(), (Throwable)e);
        }
    }

    private AllEleRedConfirmDownLoadRequestDTO getAllEleRedConfirmDownLoadRequestDTO(DynamicObject autoTaskObj, Date timeStart, Date now, Long orgPk, SaleInfo saleInfo, String s) {
        AllEleRedConfirmDownLoadRequestDTO request = new AllEleRedConfirmDownLoadRequestDTO();
        boolean isLqpt = EnterpriseHelper.isLqptChannel((String)saleInfo.getSaleTaxNo());
        if (!isLqpt) {
            String account = AllEleAuthHelper.getEleAccount((String)saleInfo.getSaleTaxNo(), (boolean)true);
            request.setAccount(account);
        }
        request.setIdentity(autoTaskObj.getString("appliertype"));
        request.setStartDate(DateUtils.format((Date)timeStart));
        request.setEndDate(DateUtils.format((Date)now));
        request.setOrgId(orgPk.longValue());
        request.setUpdateHead(Boolean.valueOf(true));
        request.setOtherSideTaxNo(s);
        request.setOtherSideName(null);
        return request;
    }

    /*
     * Exception decompiling
     */
    private void downloadRedConfirmBill(AllEleRedConfirmDownLoadRequestDTO request, SaleInfo saleInfo) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [2[DOLOOP]], but top level block is 4[SIMPLE_IF_TAKEN]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void addTempLog(List<AllEleRedConfirmDownLoadResponseDTO> responseList) {
        if (!"1".equals(ImcConfigUtil.getValue((String)"RedConfirmBillUpdateImpl", (String)"addTempLog"))) {
            return;
        }
        ArrayList<AllEleRedConfirmDownLoadResponseDTO> logList = new ArrayList<AllEleRedConfirmDownLoadResponseDTO>();
        for (AllEleRedConfirmDownLoadResponseDTO dto : responseList) {
            logList.add(dto);
            if (logList.size() <= 10) continue;
            this.addTempLoggs(logList);
            logList.clear();
        }
        if (logList.size() > 0) {
            this.addTempLoggs(logList);
        }
    }

    private void addTempLoggs(ArrayList<AllEleRedConfirmDownLoadResponseDTO> logList) {
        LOGGER.info(String.format("Temp10Logs:%s", JSONObject.toJSONString(logList)));
    }
}

