/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.schedule.vatinvoicefile;

import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DataEntityBase;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dlock.DLock;
import kd.bos.exception.KDException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.schedule.executor.AbstractTask;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imc.bdm.common.constant.FileType;
import kd.imc.bdm.common.constant.OpenApiCallbackInterfaceCodeEnum;
import kd.imc.bdm.common.enums.CacheKeyEnum;
import kd.imc.bdm.common.enums.PushStatusEnum;
import kd.imc.bdm.common.helper.BatchPushMailSettingHelper;
import kd.imc.bdm.common.helper.ConfigCacheHelper;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.helper.RelationHelper;
import kd.imc.bdm.common.invoicecallback.impl.InvoiceCallBackServiceImpl;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.DateUtils;
import kd.imc.bdm.common.util.ImcConfigUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import kd.imc.sim.common.dto.allele.AllEleQueryInvoiceRequestDTO;
import kd.imc.sim.common.helper.InvoiceMailTimingHelper;
import kd.imc.sim.common.helper.allele.AllEleInvoiceFileHelper;
import kd.imc.sim.common.helper.allele.RpaInvoiceFileHelper;
import kd.imc.sim.common.service.IssueInvoiceService;
import kd.imc.sim.formplugin.issuing.task.SyncTGInvoiceTask;
import org.apache.commons.lang3.StringUtils;

public class SimVatInvoiceFileTask
extends AbstractTask {
    private static final Log LOGGER = LogFactory.getLog(SimVatInvoiceFileTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) throws KDException {
        try (DLock lock = DLock.create((String)SimVatInvoiceFileTask.class.getName());){
            if (!lock.tryLock(1000L)) {
                return;
            }
            QFilter qFilter = new QFilter("issuetime", ">=", (Object)DateUtils.addDay((Date)DateUtils.trunc((Date)new Date()), (int)this.getQueryDay())).and("filetype", "!=", (Object)FileType.JPG.getFileExtension());
            QFilter localFail = new QFilter("localfilestatus", "!=", (Object)"1").and("callbacktype", "=", (Object)"local");
            QFilter remoteFail = new QFilter("remotefilestatus", "!=", (Object)"1").and("callbacktype", "=", (Object)"remote");
            localFail.or(remoteFail);
            DynamicObject[] invoiceFiles = BusinessDataServiceHelper.load((String)"sim_vatinvoice_file", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice_file"), (QFilter[])qFilter.and(localFail).toArray(), (String)String.format("%s asc", "issuetime"), (int)SyncTGInvoiceTask.getQueryCount());
            if (invoiceFiles.length == 0) {
                return;
            }
            try {
                Map<Long, List<DynamicObject>> invoiceIdFileMap = Arrays.stream(invoiceFiles).filter(o -> !InvoiceUtils.isAllEVehicleOrAllEUsedCar((String)o.getString("invoicetype"))).collect(Collectors.groupingBy(k -> k.getLong("invoiceid")));
                Map<Long, List<DynamicObject>> vehicleInvoiceIdFileMap = Arrays.stream(invoiceFiles).filter(o -> InvoiceUtils.isAllEVehicleOrAllEUsedCar((String)o.getString("invoicetype"))).collect(Collectors.groupingBy(k -> k.getLong("invoiceid")));
                if (LOGGER.isInfoEnabled()) {
                    LOGGER.info(String.format("SimVatInvoiceFileTask size: %d", invoiceIdFileMap.size()));
                }
                DynamicObject[] invoices = this.queryDbInvoice(invoiceIdFileMap, "sim_vatinvoice");
                DynamicObject[] vehicleInvoices = this.queryDbInvoice(vehicleInvoiceIdFileMap, "sim_vatinvoice_vehicles");
                this.executeCreateFile(invoiceIdFileMap, invoices);
                this.executeCreateFile(vehicleInvoiceIdFileMap, vehicleInvoices);
                this.saveInvoiceAndFile(invoiceFiles, invoices, vehicleInvoices);
                this.sendEmailAndCallBack(invoices);
            }
            catch (Exception e) {
                LOGGER.error("SimVatInvoiceFileTask error ", (Throwable)e);
            }
        }
    }

    private void sendEmailAndCallBack(DynamicObject[] invoices) {
        String systemSourceCallbackType = ConfigCacheHelper.getCacheValue((String)"sim_system_source_callback_type");
        LOGGER.info("ofdStatusSuccessList systemSourceCallbackType: " + systemSourceCallbackType);
        try {
            Thread.sleep(20000L);
            for (DynamicObject invoice : invoices) {
                if (!"1".equals(invoice.getString("ofdstatus"))) continue;
                String systemSource = invoice.getString("systemsource");
                if (StringUtils.isBlank((CharSequence)systemSource) && "1".equals(ImcConfigUtil.getValue((CacheKeyEnum)CacheKeyEnum.INVOICE_SYSTEMSOURCE_FROM_BUYER_RED_INFO))) {
                    systemSource = RelationHelper.getSystemSourceFromBuyerDownloadRedInfo((DynamicObject)invoice);
                }
                if (PushStatusEnum.underway.getCode().equals(invoice.getString("pushstatus"))) {
                    DynamicObject pushMailStrategy = BatchPushMailSettingHelper.matchBatchPushMailSetting((DynamicObject)invoice);
                    InvoiceMailTimingHelper.sendSmsOrEmail((DynamicObject)invoice, (DynamicObject)pushMailStrategy);
                }
                String businessType = OpenApiCallbackInterfaceCodeEnum.INVOICE_OPEN.getCode();
                QFilter filter = new QFilter("invoicecode", "=", (Object)invoice.getString("invoicecode")).and("invoiceno", "=", (Object)invoice.getString("invoiceno"));
                if (QueryServiceHelper.exists((String)"invsm_callback_log", (QFilter[])filter.toArray()) || !InvoiceCallBackServiceImpl.checkFileExists((Date)invoice.getDate("issuetime"), (String)invoice.getString("invoiceno"))) continue;
                CallbackHelperUtil.sendCallbackMessage((DynamicObject)invoice, (String)systemSource, (String)businessType);
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage(), (Throwable)e);
        }
    }

    private void saveInvoiceAndFile(DynamicObject[] invoiceFiles, DynamicObject[] invoices, DynamicObject[] vehicleInvoices) {
        if (invoices.length > 0) {
            ImcSaveServiceHelper.update((DynamicObject[])invoices);
        }
        if (vehicleInvoices.length > 0) {
            ImcSaveServiceHelper.update((DynamicObject[])vehicleInvoices);
        }
        ImcSaveServiceHelper.update((DynamicObject[])invoiceFiles);
    }

    private DynamicObject[] queryDbInvoice(Map<Long, List<DynamicObject>> invoiceIdFileMap, String billKey) {
        DynamicObject[] invoices = new DynamicObject[]{};
        if (invoiceIdFileMap.size() > 0) {
            invoices = BusinessDataServiceHelper.load((String)billKey, (String)PropertieUtil.getAllPropertiesSplitByComma((String)billKey, (boolean)true), (QFilter[])new QFilter("id", "in", invoiceIdFileMap.keySet()).toArray());
        }
        return invoices;
    }

    private void executeCreateFile(Map<Long, List<DynamicObject>> invoiceIdFileMap, DynamicObject[] invoices) {
        if (invoices.length == 0) {
            return;
        }
        Map<Object, DynamicObject> invoiceMap = Stream.of(invoices).collect(Collectors.toMap(DataEntityBase::getPkValue, v -> v, (v1, v2) -> v1));
        AllEleQueryInvoiceRequestDTO request = new AllEleQueryInvoiceRequestDTO();
        Set<Map.Entry<Long, List<DynamicObject>>> entries = invoiceIdFileMap.entrySet();
        for (Map.Entry<Long, List<DynamicObject>> entry : entries) {
            DynamicObject invoice = invoiceMap.get(entry.getKey());
            if (invoice == null) continue;
            List<DynamicObject> invoiceFileList = entry.getValue();
            if ("rpa".equals(invoiceFileList.get(0).getString("issuechannel"))) {
                RpaInvoiceFileHelper.rpaFileBatchDownload((AllEleQueryInvoiceRequestDTO)request, (DynamicObject)invoice, invoiceFileList);
                continue;
            }
            boolean isCreateFailed = false;
            for (DynamicObject invoiceFile : invoiceFileList) {
                try {
                    switch (invoiceFile.getString("filetype")) {
                        case "ofd": {
                            isCreateFailed = "-1".equals(invoiceFile.getString("localfilestatus"));
                            AllEleInvoiceFileHelper.createOfd((DynamicObject)invoice, (DynamicObject)invoiceFile);
                            break;
                        }
                        case "pdf": {
                            AllEleInvoiceFileHelper.createPdf((DynamicObject)invoice, (DynamicObject)invoiceFile);
                            break;
                        }
                        case "xml": {
                            AllEleInvoiceFileHelper.createXml((DynamicObject)invoice, (DynamicObject)invoiceFile);
                        }
                    }
                }
                catch (Exception e) {
                    LOGGER.error(String.format("\u6587\u4ef6\u8bb0\u5f55\u5b9a\u65f6\u540c\u6b65\u5931\u8d25,\u6587\u4ef6\u4e3a:[%s]", SerializationUtils.toJsonString((Object)invoiceFile)), (Throwable)e);
                }
            }
            LOGGER.info(String.format("isCreateField:%s,pushStatus:%s", isCreateFailed, invoice.getString("pushstatus")));
            if (!PushStatusEnum.none.getCode().equals(invoice.getString("pushstatus"))) continue;
            IssueInvoiceService.warpPushStatus((DynamicObject)invoice);
        }
    }

    private int getQueryDay() {
        int queryDay = 10;
        try {
            String queryDayStr = ImcConfigUtil.getValue((String)"async_issue_invoice", (String)"query_file_day");
            queryDay = Integer.parseInt(queryDayStr);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0 - queryDay;
    }
}

