/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.mservice.bill.botp.util;

import java.math.BigDecimal;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.dto.BillVo;
import kd.imc.bdm.common.dto.GoodsInfoVo;
import kd.imc.bdm.common.helper.AllEleAuthHelper;
import kd.imc.bdm.common.helper.BotpHelper;
import kd.imc.sim.common.dto.goodsinfo.GoodsInfoBotpConfigDTO;
import kd.imc.sim.common.dto.goodsinfo.UnitConversionConfig;
import kd.imc.sim.common.helper.InvTitleMatchHelper;
import kd.imc.sim.common.helper.MaterialToGoodsInfoHelp2;
import kd.imc.sim.formplugin.bill.botp.MatchRulesEnum;
import org.apache.commons.lang3.time.StopWatch;

public class FiBill2OriginalBillCommonUtil {
    private static final Log LOG = LogFactory.getLog(FiBill2OriginalBillCommonUtil.class);
    public static final String FROM_GOODS_INFO = "1";

    public static void setBuyerInfoForPerson(long orgId, String buyerName, DynamicObject originalBill, BillVo billVo) {
        Map buyerInfoMap = InvTitleMatchHelper.matchBuyerPersonInfo((long)orgId, (String)buyerName);
        if (null == buyerInfoMap) {
            return;
        }
        String matchedName = (String)buyerInfoMap.get("name");
        String matchedIdCode = (String)buyerInfoMap.get("idcode");
        billVo.setBuyerTaxpayerId(matchedIdCode);
        originalBill.set("buyertaxno", (Object)matchedIdCode);
        originalBill.set("buyername", (Object)matchedName);
    }

    public static String setDetailTax(DynamicObject bill, DynamicObject tgtEntryRow, String matchRules, GoodsInfoBotpConfigDTO configDTO, int precision, int pricePrecision, boolean isLogPushDetail, boolean isAllEle) {
        String spbm = tgtEntryRow.getString("spbm");
        String goodsName = tgtEntryRow.getString("origoodsname");
        boolean isForceMatch = BotpHelper.isForceGoodsMatch();
        StopWatch stopWatch = new StopWatch();
        stopWatch.start();
        GoodsInfoVo goodByMaterial = null;
        MatchRulesEnum valueByCode = MatchRulesEnum.getValueByCode((String)matchRules);
        switch (valueByCode) {
            case DEFAULT: {
                goodByMaterial = MaterialToGoodsInfoHelp2.getGoodByMaterial((Object)bill, (String)spbm, (String)goodsName);
                if (null != goodByMaterial) break;
                goodByMaterial = MaterialToGoodsInfoHelp2.getGoodByType((Object)bill, (String)tgtEntryRow.getString("materialtype.number"), (String)tgtEntryRow.getString("materialtype.name"), (boolean)isLogPushDetail);
                break;
            }
            case MATCH_NAME: {
                goodByMaterial = MaterialToGoodsInfoHelp2.getGoodByMaterial((Object)bill, (String)spbm, (String)goodsName);
                break;
            }
            case MATCH_TYPE_NAME: {
                goodByMaterial = MaterialToGoodsInfoHelp2.getGoodByType((Object)bill, (String)tgtEntryRow.getString("materialtype.number"), (String)tgtEntryRow.getString("materialtype.name"), (boolean)isLogPushDetail);
                break;
            }
            case MATCH_TYPE_SOURCE: {
                goodByMaterial = MaterialToGoodsInfoHelp2.getGoodByType((Object)bill, (String)tgtEntryRow.getString("materialtype.number"), (String)tgtEntryRow.getString("materialtype.name"), (boolean)isLogPushDetail);
                if (null == goodByMaterial) break;
                tgtEntryRow.set("goodsname", (Object)tgtEntryRow.getString("materialtype.name"));
                break;
            }
            case MATCH_EXPENSE_ITEM: {
                String expenseItemNumber;
                spbm = expenseItemNumber = tgtEntryRow.getString("expenseitem.number");
                String expenseItemName = tgtEntryRow.getString("expenseitem.name");
                if (isLogPushDetail) {
                    LOG.info(String.format("MaterialToGoodsInfoHelp getGoodByExpenseItem bill:%s code:%s name:%s", SerializationUtils.toJsonString((Object)bill), expenseItemNumber, expenseItemName));
                }
                goodByMaterial = MaterialToGoodsInfoHelp2.getGoodByExpenseItem((Object)bill, (String)expenseItemNumber, (String)expenseItemName, (boolean)isLogPushDetail);
            }
        }
        stopWatch.stop();
        if (null != goodByMaterial) {
            UnitConversionConfig unitConversionConfig = new UnitConversionConfig();
            if (null == configDTO) {
                tgtEntryRow.set("spbm", (Object)StringUtils.trimToEmpty((String)goodByMaterial.getNumber()));
                tgtEntryRow.set("goodsname", (Object)StringUtils.trimToEmpty((String)goodByMaterial.getGoodsName()));
                tgtEntryRow.set("origoodsname", tgtEntryRow.get("goodsname"));
                tgtEntryRow.set("goodscode", (Object)StringUtils.trimToEmpty((String)goodByMaterial.getTaxCode().getString("mergecode")));
                tgtEntryRow.set("taxratecodeid", (Object)goodByMaterial.getTaxCode());
                tgtEntryRow.set("goodsid", (Object)goodByMaterial.getPkValue());
                tgtEntryRow.set("goodssimplename", (Object)goodByMaterial.getTaxCode().getString("simplename"));
                tgtEntryRow.set("policylogo", (Object)goodByMaterial.getPrivilegeFlag());
                tgtEntryRow.set("policycontants", (Object)goodByMaterial.getPrivilegeType());
                unitConversionConfig.setUnitToGoodsInfo(Boolean.TRUE);
            } else {
                FiBill2OriginalBillCommonUtil.setItemByGoodsInfo(tgtEntryRow, goodByMaterial, configDTO);
                unitConversionConfig.setUnitToGoodsInfo(Boolean.valueOf(FROM_GOODS_INFO.equals(configDTO.getUnit())));
            }
            unitConversionConfig.setMatchRulesType(valueByCode.getCode());
            unitConversionConfig.setPrecision(Integer.valueOf(precision));
            unitConversionConfig.setFromPricePricision(Integer.valueOf(pricePrecision));
            StringBuilder stringBuilder = new StringBuilder("unitExchange\uff1a");
            unitConversionConfig.setBuilder(stringBuilder);
            MaterialToGoodsInfoHelp2.setUnitConversion((UnitConversionConfig)unitConversionConfig, (GoodsInfoVo)goodByMaterial, (DynamicObject)tgtEntryRow, (boolean)isAllEle);
            if (isLogPushDetail) {
                LOG.info(stringBuilder.toString());
            }
        } else {
            if (isLogPushDetail) {
                LOG.info(String.format("FiBill2OriginalBillCommonUtil setDetailTax spbm:[%s], name:[%s] ,matchRules:[%s]", spbm, goodsName, valueByCode.getValue()));
            }
            if (isForceMatch) {
                return String.format(ResManager.loadKDString((String)"\u7f16\u7801[%1$s]\uff0c\u540d\u79f0[%2$s]", (String)"FiBill2OriginalBillCommonUtil_0", (String)"imc-sim-mservice", (Object[])new Object[0]), spbm, tgtEntryRow.getString("goodsname"));
            }
        }
        return "";
    }

    private static void setItemByGoodsInfo(DynamicObject item, GoodsInfoVo goodsInfo, GoodsInfoBotpConfigDTO configDTO) {
        item.set("spbm", (Object)StringUtils.trimToEmpty((String)goodsInfo.getGoodsCode()));
        item.set("goodsid", (Object)goodsInfo.getPkValue());
        String rowType = item.getString("rowtype");
        if (null == configDTO) {
            LOG.info("FiBill2OriginalBillCommonUtil setItemByGoodsInfo is null run defulat");
            return;
        }
        if (FROM_GOODS_INFO.equals(configDTO.getGoodsCode()) || "2".equals(configDTO.getGoodsName()) && StringUtils.isNotBlank((CharSequence)goodsInfo.getGoodsCode())) {
            item.set("taxratecodeid", (Object)goodsInfo.getTaxCode());
            item.set("goodssimplename", (Object)goodsInfo.getTaxCode().getString("simplename"));
            item.set("goodscode", (Object)StringUtils.trimToEmpty((String)goodsInfo.getTaxCode().getString("mergecode")));
        }
        if (FROM_GOODS_INFO.equals(configDTO.getGoodsName()) || "2".equals(configDTO.getGoodsName()) && StringUtils.isNotBlank((CharSequence)goodsInfo.getGoodsName())) {
            item.set("goodsname", (Object)StringUtils.trimToEmpty((String)goodsInfo.getGoodsName()));
        }
        item.set("origoodsname", item.get("goodsname"));
        if (FiBill2OriginalBillCommonUtil.isNormal(rowType) && FROM_GOODS_INFO.equals(configDTO.getSpecification()) || "2".equals(configDTO.getSpecification()) && StringUtils.isNotBlank((CharSequence)goodsInfo.getSpecifications())) {
            item.set("specification", (Object)StringUtils.trimToEmpty((String)goodsInfo.getSpecifications()));
        }
        item.set("orispecification", item.get("specification"));
        if (FiBill2OriginalBillCommonUtil.isNormal(rowType) && (FROM_GOODS_INFO.equals(configDTO.getUnit()) || "2".equals(configDTO.getUnit()) && StringUtils.isNotBlank((CharSequence)goodsInfo.getUnit()))) {
            item.set("unit", (Object)StringUtils.trimToEmpty((String)goodsInfo.getUnit()));
        }
        if (FROM_GOODS_INFO.equals(configDTO.getPolicyLogo()) || "2".equals(configDTO.getPolicyLogo()) && StringUtils.isNotBlank((CharSequence)goodsInfo.getPrivilegeFlag())) {
            item.set("policylogo", (Object)goodsInfo.getPrivilegeFlag());
        }
        if (FROM_GOODS_INFO.equals(configDTO.getPolicyContants()) || "2".equals(configDTO.getPolicyContants()) && StringUtils.isNotBlank((CharSequence)goodsInfo.getPrivilegeType())) {
            item.set("policycontants", (Object)goodsInfo.getPrivilegeType());
        }
    }

    public static void setConstantData(DynamicObject dataEntity) {
        BigDecimal totalAmount;
        dataEntity.set("confirmstate", (Object)"0");
        dataEntity.set("validstate", (Object)"0");
        dataEntity.set("split", (Object)FROM_GOODS_INFO);
        dataEntity.set("priority", (Object)"0");
        if (StringUtils.isBlank((Object)dataEntity.get("taxationstyle"))) {
            dataEntity.set("taxationstyle", (Object)"0");
        }
        dataEntity.set("billsource", (Object)"3");
        if (StringUtils.isBlank((Object)dataEntity.get("splitormergeflag"))) {
            dataEntity.set("splitormergeflag", (Object)"0");
        }
        if (StringUtils.isBlank((Object)dataEntity.get("biztype"))) {
            dataEntity.set("biztype", (Object)"01");
        }
        String billProperty = BigDecimal.ZERO.compareTo(totalAmount = dataEntity.getBigDecimal("totalamount")) > 0 ? "-1" : FROM_GOODS_INFO;
        dataEntity.set("billproperties", (Object)billProperty);
    }

    public static void setElePaperLable(DynamicObject dataEntity) {
        String invoiceType = dataEntity.getString("invoicetype");
        String sellerTaxNo = dataEntity.getString("salertaxno");
        if (AllEleAuthHelper.elePaperSetValue((Object)sellerTaxNo, (Object)invoiceType)) {
            dataEntity.set("iselepaper", (Object)FROM_GOODS_INFO);
        }
    }

    private static boolean isNormal(String rowType) {
        return "2".equals(rowType);
    }
}

