/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.mservice.fiapi;

import com.alibaba.fastjson.JSON;
import java.util.List;
import java.util.stream.Collectors;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.imc.bdm.common.interfaceservice.IOpenInterfaceService;
import kd.imc.bdm.common.message.exception.MsgException;
import kd.imc.sim.common.vo.openapi.RequestVo;
import kd.imc.sim.common.vo.openapi.ResponseVo;
import kd.imc.sim.formplugin.openapi.service.impl.bill.BillPushServiceImpl;
import kd.imc.sim.mservice.vo.FiBillDateSynVo;

public class FiBillPushServiceImpl
implements IOpenInterfaceService {
    private static final Log LOGGER = LogFactory.getLog(FiBillPushServiceImpl.class);

    public String doBusiness(String requestData) {
        RequestVo vo = new RequestVo();
        vo.setData(requestData);
        vo.setBusinessSystemCode("KINGDEE_FI");
        ApiResult response = new ApiResult();
        try (TXHandle txHandle = TX.notSupported();){
            String code;
            ApiResult result = this.processer(vo);
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info("\u5f00\u7968\u5355\u636e\u4e0b\u63a8 \u540c\u6b65\u63a5\u53e3\u7ed3\u679c--\u300b" + SerializationUtils.toJsonString((Object)result));
            }
            if ("0".equals(code = result.getErrorCode()) || "1200".equals(code)) {
                response.setErrorCode("0000");
            } else {
                response.setErrorCode("1300");
            }
            response.setMessage(result.getMessage());
            response.setData(result.getData());
        }
        catch (Exception e) {
            LOGGER.error("\u5f00\u7968\u5355\u636e\u4e0b\u63a8 \u5f02\u5e38--\u300b", (Throwable)e);
            response.setErrorCode("1100");
            response.setMessage(String.format(ResManager.loadKDString((String)"\u670d\u52a1\u5668\u5f02\u5e38 %s", (String)"FiBillPushServiceImpl_0", (String)"imc-sim-mservice", (Object[])new Object[0]), e.getMessage()));
        }
        return SerializationUtils.toJsonString((Object)response);
    }

    public ApiResult processer(RequestVo requestVo) {
        if (null == requestVo) {
            return ResponseVo.fail((String)"1200", (String)ResManager.loadKDString((String)"\u6570\u636e\u4f20\u5165\u4e3a\u7a7a", (String)"FiBillPushServiceImpl_1", (String)"imc-sim-mservice", (Object[])new Object[0]));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u5f00\u7968\u5355\u4e0b\u63a8 \u5165\u53c2--\u300b" + requestVo.getData());
        }
        List synVoList = null;
        if (StringUtils.isNotBlank((CharSequence)requestVo.getData())) {
            synVoList = JSON.parseArray((String)requestVo.getData(), FiBillDateSynVo.class);
        }
        if (null == synVoList || synVoList.isEmpty()) {
            return ResponseVo.fail((String)"1200", (String)ResManager.loadKDString((String)"\u672a\u4f20\u5165\u5f00\u7968\u6570\u636e", (String)"FiBillPushServiceImpl_2", (String)"imc-sim-mservice", (Object[])new Object[0]));
        }
        try {
            List billList = synVoList.stream().map(FiBillDateSynVo::toBill).collect(Collectors.toList());
            requestVo.setData(JSON.toJSONString(billList));
        }
        catch (MsgException e) {
            LOGGER.error("\u5f00\u7968\u5355\u636e\u4e0b\u63a8 ", (Throwable)e);
            return ResponseVo.fail((String)"1100", (String)e.getErrorMsg());
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u5f00\u7968\u5355\u636e\u4e0b\u63a8\u8f6c\u6362BillVo " + requestVo.getData());
        }
        return new BillPushServiceImpl().processer(requestVo);
    }
}

