/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.mservice.fiapi;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.db.tx.TX;
import kd.bos.db.tx.TXHandle;
import kd.bos.entity.api.ApiResult;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.orm.util.CollectionUtils;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.threads.ThreadPools;
import kd.imc.bdm.common.enums.IssueStatusEnum;
import kd.imc.bdm.common.helper.ImcSaveServiceHelper;
import kd.imc.bdm.common.interfaceservice.IOpenInterfaceService;
import kd.imc.bdm.common.message.constant.ErrorType;
import kd.imc.bdm.common.moduleservice.ResultResponse;
import kd.imc.bdm.common.openapi.FindOrderOpenVo;
import kd.imc.bdm.common.openapi.InvoiceDataDetailVo;
import kd.imc.bdm.common.openapi.InvoiceDataVo;
import kd.imc.bdm.common.openapi.InvoiceDetailVo;
import kd.imc.bdm.common.openapi.OrderDetailVo;
import kd.imc.bdm.common.util.CallbackHelperUtil;
import kd.imc.bdm.common.util.ConvertUpMoneyUtils;
import kd.imc.bdm.common.util.InvoiceQueryUtil;
import kd.imc.bdm.common.util.InvoiceUtils;
import kd.imc.bdm.common.util.PropertieUtil;
import org.apache.commons.lang3.StringUtils;

public class FiInvoiceQueryServiceImpl
implements IOpenInterfaceService {
    private static Log LOGGER = LogFactory.getLog(FiInvoiceQueryServiceImpl.class);

    public String doBusiness(String requestData) {
        try (TXHandle tx = TX.notSupported();){
            if (LOGGER.isInfoEnabled()) {
                LOGGER.info(String.format("\u63a5\u6536\u5230\u7684\u8f6c\u53d1\u8bf7\u6c42\u662f\uff1a%s", requestData));
            }
            if (StringUtils.isBlank((CharSequence)requestData)) {
                String string = SerializationUtils.toJsonString((Object)ApiResult.fail((String)ResManager.loadKDString((String)"\u8bf7\u6c42\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a", (String)"FiInvoiceQueryServiceImpl_0", (String)"imc-sim-mservice", (Object[])new Object[0]), (String)ErrorType.FI_BILL_NOT_CONTINUE.getCode()));
                return string;
            }
            JSONObject dataObj = JSONObject.parseObject((String)requestData);
            String billNo = dataObj.getString("billNo");
            if (StringUtils.isBlank((CharSequence)billNo)) {
                String string = SerializationUtils.toJsonString((Object)ApiResult.fail((String)ResManager.loadKDString((String)"\u5355\u636e\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a!", (String)"FiInvoiceQueryServiceImpl_1", (String)"imc-sim-mservice", (Object[])new Object[0]), (String)ErrorType.FI_BILL_NOT_CONTINUE.getCode()));
                return string;
            }
            DynamicObject bill = BusinessDataServiceHelper.loadSingle((String)"sim_original_bill", (String)String.join((CharSequence)",", "salertaxno", "orgid"), (QFilter[])new QFilter("billno", "=", (Object)billNo).toArray());
            if (bill == null) {
                String string = SerializationUtils.toJsonString((Object)ApiResult.fail((String)ResManager.loadKDString((String)"\u67e5\u65e0\u6b64\u5355\u636e", (String)"FiInvoiceQueryServiceImpl_2", (String)"imc-sim-mservice", (Object[])new Object[0]), (String)ErrorType.FI_BILL_NOT_CONTINUE.getCode()));
                return string;
            }
            boolean isAllIssue = this.checkBillIsAllIssue(bill);
            if (!isAllIssue) {
                String string = SerializationUtils.toJsonString((Object)ApiResult.fail((String)ResManager.loadKDString((String)"\u5b58\u5728\u5f85\u5f00\u53d1\u7968,\u8bf7\u7a0d\u540e\u91cd\u8bd5!", (String)"FiInvoiceQueryServiceImpl_3", (String)"imc-sim-mservice", (Object[])new Object[0]), (String)ErrorType.FI_BILL_UN_ISSUE.getCode()));
                return string;
            }
            FindOrderOpenVo vo = new FindOrderOpenVo();
            vo.setSellerTaxpayerId(bill.getString("salertaxno"));
            vo.setSerialNo(billNo);
            Map invoiceDataMap = InvoiceQueryUtil.getInvoiceDataByOriginalBillNo((FindOrderOpenVo)vo);
            String string = this.convertResult(invoiceDataMap, billNo, bill);
            return string;
        }
    }

    private boolean checkBillIsAllIssue(DynamicObject oriBillObj) {
        QFilter qFilter = new QFilter("sbillid", "=", oriBillObj.getPkValue()).and("isdelete", "!=", (Object)"Y");
        DynamicObject[] billInvRelations = BusinessDataServiceHelper.load((String)"sim_bill_inv_relation", (String)String.join((CharSequence)",", "ttable", "tbillid"), (QFilter[])qFilter.toArray());
        List invoiceIds = Stream.of(billInvRelations).filter(o -> "sim_vatinvoice".equals(o.getString("ttable"))).map(o -> o.getLong("tbillid")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(invoiceIds)) {
            DynamicObjectCollection invoices = QueryServiceHelper.query((String)"sim_vatinvoice", (String)"issuestatus", (QFilter[])new QFilter("id", "in", invoiceIds).toArray());
            return invoices.stream().allMatch(invoice -> IssueStatusEnum.ok.getCode().equals(invoice.getString("issuestatus")));
        }
        List redInfoIds = Stream.of(billInvRelations).filter(o -> "sim_red_info".equals(o.getString("ttable"))).map(o -> o.getLong("tbillid")).collect(Collectors.toList());
        if (!CollectionUtils.isEmpty(redInfoIds)) {
            DynamicObjectCollection redInfos = QueryServiceHelper.query((String)"sim_red_info", (String)"infocode", (QFilter[])new QFilter("id", "in", redInfoIds).toArray());
            if (redInfos.stream().anyMatch(redInfo -> StringUtils.isBlank((CharSequence)redInfo.getString("infocode")))) {
                return false;
            }
            List infoCodes = redInfos.stream().map(redInfo -> redInfo.getString("infocode")).collect(Collectors.toList());
            DynamicObjectCollection invoices = QueryServiceHelper.query((String)"sim_vatinvoice", (String)"issuestatus", (QFilter[])new QFilter("infocode", "in", infoCodes).toArray());
            return invoices.stream().allMatch(invoice -> IssueStatusEnum.ok.getCode().equals(invoice.getString("issuestatus")));
        }
        List redConfirmIds = Stream.of(billInvRelations).filter(o -> "sim_red_confirm_bill".equals(o.getString("ttable"))).map(o -> o.getLong("tbillid")).collect(Collectors.toList());
        DynamicObjectCollection redConfirms = QueryServiceHelper.query((String)"sim_red_confirm_bill", (String)"invoiceno", (QFilter[])new QFilter("id", "in", redConfirmIds).toArray());
        return redConfirms.stream().allMatch(redConfirm -> StringUtils.isNotBlank((CharSequence)redConfirm.getString("invoiceno")));
    }

    private String convertResult(Map<String, List<OrderDetailVo>> rMap, String billNo, DynamicObject bill) {
        if (null == rMap) {
            return SerializationUtils.toJsonString((Object)ApiResult.fail((String)ErrorType.FI_BILL_UN_ISSUE.getCode(), (String)ResManager.loadKDString((String)"\u67e5\u65e0\u7ed3\u679c", (String)"FiInvoiceQueryServiceImpl_4", (String)"imc-sim-mservice", (Object[])new Object[0])));
        }
        List<OrderDetailVo> rList = rMap.get(billNo);
        if (null == rList || rList.isEmpty()) {
            return SerializationUtils.toJsonString((Object)ApiResult.fail((String)ErrorType.FI_BILL_UN_ISSUE.getCode(), (String)ResManager.loadKDString((String)"\u67e5\u65e0\u7ed3\u679c", (String)"FiInvoiceQueryServiceImpl_4", (String)"imc-sim-mservice", (Object[])new Object[0])));
        }
        List<InvoiceDataVo> resultList = this.buildOtherInvoiceInfo(rList, billNo);
        if (null == resultList || resultList.isEmpty()) {
            return SerializationUtils.toJsonString((Object)ApiResult.fail((String)ErrorType.FI_BILL_UN_ISSUE.getCode(), (String)ResManager.loadKDString((String)"\u5b58\u5728\u5f85\u5f00\u53d1\u7968,\u8bf7\u7a0d\u540e\u91cd\u8bd5!", (String)"FiInvoiceQueryServiceImpl_3", (String)"imc-sim-mservice", (Object[])new Object[0])));
        }
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info(String.format("\u5e94\u6536\u53d1\u7968\u67e5\u8be2\u63a5\u53e3\u8fd4\u56de\u62a5\u6587\u662f\uff1a%s", JSON.toJSONString(resultList)));
        }
        ThreadPools.executeOnce((String)"updateLogs", () -> this.updateCallbackLog(bill));
        return SerializationUtils.toJsonString((Object)ResultResponse.valueOfApiResultSuccess(resultList));
    }

    private List<InvoiceDataVo> buildOtherInvoiceInfo(List<OrderDetailVo> rList, String billNo) {
        ArrayList<InvoiceDataVo> resultList = new ArrayList<InvoiceDataVo>(rList.size());
        for (OrderDetailVo vo : rList) {
            String invoiceNum;
            String imcInvoiceType = vo.getInvoiceType();
            InvoiceDataVo dataVo = this.buildMainInfo(vo);
            dataVo.setBillNo(billNo);
            String invoiceCode = null == vo.getInvoiceCode() ? "" : vo.getInvoiceCode();
            String string = invoiceNum = null == vo.getInvoiceNumber() ? "" : vo.getInvoiceNumber();
            if (InvoiceUtils.isAllEInvoice((Object)imcInvoiceType) && StringUtils.isBlank((CharSequence)invoiceNum)) {
                return new ArrayList<InvoiceDataVo>();
            }
            if (!InvoiceUtils.isAllEInvoice((Object)imcInvoiceType) && (StringUtils.isBlank((CharSequence)invoiceCode) || StringUtils.isBlank((CharSequence)invoiceNum))) {
                return new ArrayList<InvoiceDataVo>();
            }
            DynamicObject vatInvoiceObj = null;
            if (InvoiceUtils.isAllEInvoice((Object)imcInvoiceType) && StringUtils.isNotBlank((CharSequence)invoiceNum)) {
                vatInvoiceObj = this.getVatInvoiceByInvCodeNum(invoiceCode, invoiceNum);
            }
            if (!InvoiceUtils.isAllEInvoice((Object)imcInvoiceType) && StringUtils.isNotBlank((CharSequence)invoiceCode) && StringUtils.isNotBlank((CharSequence)invoiceNum)) {
                vatInvoiceObj = this.getVatInvoiceByInvCodeNum(invoiceCode, invoiceNum);
            }
            if (vatInvoiceObj == null) {
                dataVo.setSerialNo("");
                dataVo.setCheckCode("");
                dataVo.setPdfUrl("");
            } else {
                dataVo.setSerialNo(vatInvoiceObj.getString("orderno"));
                dataVo.setCheckCode(vatInvoiceObj.getString("checkcode"));
                dataVo.setPdfUrl(vatInvoiceObj.getString("fileurl"));
            }
            dataVo.setInvoiceCode(invoiceCode);
            dataVo.setInvoiceNo(invoiceNum);
            dataVo.setInvoiceAmount(vo.getTotalAmount());
            dataVo.setTotalTaxAmount(vo.getTotalTaxAmount());
            dataVo.setTotalAmount(vo.getIncludeTaxAmount());
            dataVo.setTotalAmountCn(ConvertUpMoneyUtils.toChinese((String)vo.getIncludeTaxAmount().toPlainString()));
            dataVo.setOriginalInvoiceCode(vo.getOriginalInvoiceCode());
            dataVo.setOriginalInvoiceNo(vo.getOriginalInvoiceNumber());
            dataVo.setRemark(vo.getRemark());
            LOGGER.info("FiInvoiceQuery invoiceStatus " + vo.getIssueStatus());
            dataVo.setInvoiceStatus(CallbackHelperUtil.convertInvStatus((Integer)vo.getInvoiceStatus()));
            dataVo.setInventoryFlag(String.valueOf(vo.getInventoryFlag()));
            String inventoryProjectName = "";
            if (1 == vo.getInventoryFlag() && 1 == vo.getInvoiceProperty()) {
                inventoryProjectName = ResManager.loadKDString((String)"\u8be6\u89c1\u9500\u8d27\u6e05\u5355", (String)"FiInvoiceQueryServiceImpl_5", (String)"imc-sim-mservice", (Object[])new Object[0]);
            }
            if (1 == vo.getInventoryFlag() && 0 == vo.getInvoiceProperty()) {
                inventoryProjectName = ResManager.loadKDString((String)"\u8be6\u89c1\u9500\u8d27\u6e05\u5355", (String)"FiInvoiceQueryServiceImpl_5", (String)"imc-sim-mservice", (Object[])new Object[0]);
            }
            dataVo.setInventoryProjectName(inventoryProjectName);
            List<InvoiceDataDetailVo> detailVos = this.buildDetails(vo.getGoods());
            dataVo.setTaxFlag(detailVos.isEmpty() ? null : detailVos.get(0).getTaxFlag());
            dataVo.setItems(detailVos);
            resultList.add(dataVo);
        }
        return resultList;
    }

    private void updateCallbackLog(DynamicObject bill) {
        QFilter callBackLogFilter;
        DynamicObject[] callbackLogs;
        if (LOGGER.isInfoEnabled()) {
            LOGGER.info("\u5e94\u6536\u4e3b\u52a8\u67e5\u8be2\u53d1\u7968\u6570\u636e\u8fd4\u56de\u524d\u66f4\u65b0\u53d1\u7968\u56de\u8c03\u65e5\u5fd7\u8868");
        }
        if (null != (callbackLogs = BusinessDataServiceHelper.load((String)"invsm_callback_log", (String)"callback_status", (QFilter[])(callBackLogFilter = new QFilter("business_fid", "=", bill.getPkValue())).toArray())) && callbackLogs.length > 0) {
            ArrayList logObjs = Lists.newArrayListWithCapacity((int)callbackLogs.length);
            for (DynamicObject log : callbackLogs) {
                log.set("callback_status", (Object)"0");
                logObjs.add(log);
            }
            ImcSaveServiceHelper.update((List)logObjs);
        }
    }

    private InvoiceDataVo buildMainInfo(OrderDetailVo orderRs) {
        InvoiceDataVo dataVo = new InvoiceDataVo();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        String invoiceDate = "";
        try {
            invoiceDate = sdf.format(orderRs.getInvoiceDate());
        }
        catch (Exception e) {
            LOGGER.error(String.format("\u5e94\u6536\u67e5\u8be2\u53d1\u7968\u4fe1\u606f\u65e5\u671f\u8f6c\u6362\u5f02\u5e38:%s", e.getMessage()));
        }
        dataVo.setType(Integer.valueOf(orderRs.getInvoiceProperty()));
        dataVo.setInvoiceDate(invoiceDate);
        dataVo.setDrawer(orderRs.getDrawer());
        dataVo.setPayee(orderRs.getPayee());
        dataVo.setReviewer(orderRs.getReviewer());
        dataVo.setSalerTaxNo(orderRs.getSellerTaxpayerId());
        dataVo.setSalerName(orderRs.getSellerName());
        dataVo.setSalerAddressPhone(orderRs.getSellerAddressAndTel());
        dataVo.setSalerAccount(orderRs.getSellerBankAndAccount());
        dataVo.setBuyerTaxNo(orderRs.getBuyerTaxpayerId());
        dataVo.setBuyerName(orderRs.getBuyerName());
        dataVo.setBuyerAddressPhone(orderRs.getBuyerAddressAndTel());
        dataVo.setBuyerAccount(orderRs.getBuyerBankAndAccount());
        dataVo.setBuyerMobilePhone(orderRs.getBuyerRecipientPhone());
        dataVo.setInvoiceType(CallbackHelperUtil.convertInvoiceType((String)orderRs.getInvoiceType()));
        dataVo.setWxCardBagUrl("");
        dataVo.setSplitOrMergeFlag(orderRs.getSplitOrMergeFlag());
        dataVo.setMergeDifferTaxAmount(orderRs.getMergeDifferTaxAmount());
        return dataVo;
    }

    private DynamicObject getVatInvoiceByInvCodeNum(String invoiceCode, String invoiceNum) {
        QFilter filter = new QFilter("invoicecode", "=", (Object)invoiceCode).and("invoiceno", "=", (Object)invoiceNum);
        return QueryServiceHelper.queryOne((String)"sim_vatinvoice", (String)PropertieUtil.getAllPropertiesSplitByComma((String)"sim_vatinvoice", (boolean)true), (QFilter[])filter.toArray());
    }

    private List<InvoiceDataDetailVo> buildDetails(List<InvoiceDetailVo> items) {
        ArrayList<InvoiceDataDetailVo> details = new ArrayList<InvoiceDataDetailVo>(items.size());
        for (InvoiceDetailVo item : items) {
            InvoiceDataDetailVo detailVo = new InvoiceDataDetailVo();
            detailVo.setUnit(item.getUnits());
            detailVo.setSpecModel(item.getSpecification());
            detailVo.setTaxAmount(item.getTaxAmount());
            detailVo.setGoodsName(item.getGoodsName());
            detailVo.setGoodsCode(item.getRevenueCode());
            detailVo.setUnitPrice(StringUtils.isBlank((CharSequence)item.getPrice()) ? null : new BigDecimal(item.getPrice()));
            detailVo.setNum(StringUtils.isBlank((CharSequence)item.getQuantity()) ? new BigDecimal("0") : new BigDecimal(item.getQuantity()));
            detailVo.setDetailAmount(item.getAmount());
            detailVo.setTaxRate(StringUtils.isBlank((CharSequence)item.getTaxRate()) ? null : new BigDecimal(item.getTaxRate()).toPlainString());
            detailVo.setZeroTaxRateFlag(item.getZeroTaxRateFlag());
            detailVo.setDiscountType(item.getLineProperty() + "");
            detailVo.setPreferentialPolicy(String.valueOf(item.getPrivilegeFlag()));
            detailVo.setVatException(item.getPrivilegeContent());
            detailVo.setTaxFlag(Integer.valueOf(StringUtils.isBlank((CharSequence)item.getTaxFlag()) ? 0 : Integer.parseInt(item.getTaxFlag())));
            detailVo.setItemId(item.getBillSourceId());
            details.add(detailVo);
        }
        return details;
    }
}

