/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.split.methods;

import java.math.BigDecimal;
import kd.imc.sim.split.dto.SmruleConfigDto;
import kd.imc.sim.split.enums.EnumType;

public class BackCalcUtilMethods {
    public BigDecimal recursionAmtsCut(BigDecimal amounts, BigDecimal price, int digit, SmruleConfigDto smruleConfigDto) {
        int maxDigitLimit = smruleConfigDto.getAmtNumber();
        if (digit < maxDigitLimit) {
            digit = maxDigitLimit;
        }
        if (price.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal amts = amounts.divide(price, digit, 3);
        BigDecimal calcProLineErr = amounts.subtract(price.multiply(amts)).abs();
        return calcProLineErr.compareTo(EnumType.DiffErrorEnum.AMOUNT.getDiff()) > 0 ? this.recursionAmtsCut(amounts, price, digit + 1, smruleConfigDto) : amts;
    }

    public BigDecimal recursionAmounts(BigDecimal amts, BigDecimal price, int digit) {
        BigDecimal amounts = amts.multiply(price).setScale(digit, 4);
        BigDecimal calcProLineErr = amounts.subtract(price.multiply(amts)).abs();
        return calcProLineErr.compareTo(EnumType.DiffErrorEnum.AMOUNT.getDiff()) > 0 ? this.recursionAmounts(amts, price, digit + 1) : amounts;
    }

    public BigDecimal recursionPrice(BigDecimal amounts, BigDecimal amts, int digit, SmruleConfigDto smruleConfigDto) {
        int maxLimit = smruleConfigDto.getPriceNumber();
        if (digit < maxLimit) {
            digit = maxLimit;
        }
        if (amts.compareTo(BigDecimal.ZERO) == 0) {
            return BigDecimal.ZERO;
        }
        BigDecimal price = amounts.divide(amts, digit, 4);
        BigDecimal calcProLineErr = amounts.subtract(price.multiply(amts)).abs();
        return calcProLineErr.compareTo(EnumType.DiffErrorEnum.AMOUNT.getDiff()) > 0 ? this.recursionPrice(amounts, amts, digit + 1, smruleConfigDto) : price;
    }

    public BigDecimal calcTaxAmt(BigDecimal amounts, BigDecimal taxRate, int digit) {
        if (EnumType.TAX_015.compareTo(taxRate) == 0) {
            return amounts.multiply(EnumType.TAX_015).divide(new BigDecimal("1.05"), 2, 4);
        }
        return amounts.multiply(taxRate).divide(BigDecimal.ONE.add(taxRate), digit, 4);
    }

    public BigDecimal calcTaxAmtByTaxMoneyDec(BigDecimal amounts, BigDecimal deduction, BigDecimal taxRate, int digit) {
        if (deduction == null) {
            deduction = BigDecimal.ZERO;
        }
        if (EnumType.TAX_015.compareTo(taxRate) == 0) {
            return amounts.subtract(deduction).multiply(EnumType.TAX_015).divide(new BigDecimal("1.05"), digit, 4);
        }
        return amounts.subtract(deduction).multiply(taxRate).divide(BigDecimal.ONE.add(taxRate), digit, 4);
    }

    public BigDecimal calcTaxAmtByNoTaxMoneyDec(BigDecimal amounts, BigDecimal deduction, BigDecimal taxRate, int digit) {
        if (deduction == null) {
            deduction = BigDecimal.ZERO;
        }
        if (EnumType.TAX_015.compareTo(taxRate) == 0) {
            return amounts.multiply(EnumType.TAX_015).divide(new BigDecimal("1.035"), 2, 4);
        }
        return amounts.subtract(deduction).multiply(taxRate).setScale(digit, 4);
    }
}

