/*
 * Decompiled with CFR 0.152.
 */
package kd.imc.sim.split.methods;

import java.math.BigDecimal;
import java.util.HashSet;
import java.util.List;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.imc.sim.split.dto.BillDealResultDto;
import kd.imc.sim.split.dto.BillDetailDto;
import kd.imc.sim.split.dto.BillSubjectDto;
import kd.imc.sim.split.dto.SmsRequestDto;
import kd.imc.sim.split.dto.SmsResultDto;
import kd.imc.sim.split.enums.EnumType;
import kd.imc.sim.split.service.BillsCheckService;
import kd.imc.sim.split.utils.ComUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class BillCheckMethods {
    public void checkBill(SmsRequestDto requestDto, SmsResultDto resultDto) {
        BillSubjectDto billSubjectDto = requestDto.getBillSubject();
        String billNo = billSubjectDto.getBillNO();
        if (StringUtils.isBlank((CharSequence)billNo)) {
            BillDealResultDto dealResultDto = BillsCheckService.getBDR(billNo, false, ResManager.loadKDString((String)"\u4f20\u5165\u5355\u636e\u7f16\u53f7\u4e3a\u7a7a", (String)"BillCheckMethods_0", (String)"imc-sim-split", (Object[])new Object[0]));
            resultDto.getBdrList().add(dealResultDto);
            billSubjectDto.setCheckPassed(Boolean.FALSE);
            return;
        }
        if (CollectionUtils.isEmpty(billSubjectDto.getBillDList())) {
            BillDealResultDto dealResultDto = BillsCheckService.getBDR(billNo, false, ResManager.loadKDString((String)"\u4f20\u5165\u5355\u636e\u660e\u7ec6\u4e3a\u7a7a", (String)"BillCheckMethods_1", (String)"imc-sim-split", (Object[])new Object[0]));
            resultDto.getBdrList().add(dealResultDto);
            billSubjectDto.setCheckPassed(Boolean.FALSE);
            return;
        }
        int invKind = billSubjectDto.getInvKind();
        if (EnumType.InvKindEnum.notExisted(invKind)) {
            BillDealResultDto dealResultDto = BillsCheckService.getBDR(billNo, false, String.format(ResManager.loadKDString((String)"\u4f20\u5165\u7684\u53d1\u7968\u79cd\u7c7b:%s\u4e0d\u6b63\u786e\u3002", (String)"BillCheckMethods_2", (String)"imc-sim-split", (Object[])new Object[0]), invKind));
            resultDto.getBdrList().add(dealResultDto);
            billSubjectDto.setCheckPassed(Boolean.FALSE);
            return;
        }
        if (EnumType.InvKindEnum.SPECIAL.getValue() == invKind && requestDto.getSiAmt().compareTo(BigDecimal.ZERO) <= 0) {
            BillDealResultDto dealResultDto = BillsCheckService.getBDR(billNo, false, ResManager.loadKDString((String)"\u4f20\u5165\u7eb8\u8d28\u4e13\u7528\u53d1\u7968\u62c6\u5206\u9650\u989d\u4e3a0", (String)"BillCheckMethods_3", (String)"imc-sim-split", (Object[])new Object[0]));
            resultDto.getBdrList().add(dealResultDto);
            billSubjectDto.setCheckPassed(Boolean.FALSE);
        } else if (EnumType.InvKindEnum.NORMAL.getValue() == invKind && requestDto.getCiAmt().compareTo(BigDecimal.ZERO) <= 0) {
            BillDealResultDto dealResultDto = BillsCheckService.getBDR(billNo, false, ResManager.loadKDString((String)"\u4f20\u5165\u7eb8\u8d28\u666e\u901a\u53d1\u7968\u62c6\u5206\u9650\u989d\u4e3a0", (String)"BillCheckMethods_4", (String)"imc-sim-split", (Object[])new Object[0]));
            resultDto.getBdrList().add(dealResultDto);
            billSubjectDto.setCheckPassed(Boolean.FALSE);
        } else if (EnumType.InvKindEnum.EINV.getValue() == invKind && requestDto.getEiAmt().compareTo(BigDecimal.ZERO) <= 0) {
            BillDealResultDto dealResultDto = BillsCheckService.getBDR(billNo, false, ResManager.loadKDString((String)"\u4f20\u5165\u7535\u5b50\u666e\u901a\u53d1\u7968\u62c6\u5206\u9650\u989d\u4e3a0", (String)"BillCheckMethods_5", (String)"imc-sim-split", (Object[])new Object[0]));
            resultDto.getBdrList().add(dealResultDto);
            billSubjectDto.setCheckPassed(Boolean.FALSE);
        } else if (EnumType.InvKindEnum.ESINV.getValue() == invKind && requestDto.getEsiAmt().compareTo(BigDecimal.ZERO) <= 0) {
            BillDealResultDto dealResultDto = BillsCheckService.getBDR(billNo, false, ResManager.loadKDString((String)"\u4f20\u5165\u7535\u5b50\u4e13\u7528\u53d1\u7968\u62c6\u5206\u9650\u989d\u4e3a0", (String)"BillCheckMethods_6", (String)"imc-sim-split", (Object[])new Object[0]));
            resultDto.getBdrList().add(dealResultDto);
            billSubjectDto.setCheckPassed(Boolean.FALSE);
        } else if (EnumType.InvKindEnum.ROLL.getValue() == invKind && requestDto.getVlAmt().compareTo(BigDecimal.ZERO) <= 0) {
            BillDealResultDto dealResultDto = BillsCheckService.getBDR(billNo, false, ResManager.loadKDString((String)"\u4f20\u5165\u5377\u7968\u7968\u62c6\u5206\u9650\u989d\u4e3a0", (String)"BillCheckMethods_7", (String)"imc-sim-split", (Object[])new Object[0]));
            resultDto.getBdrList().add(dealResultDto);
            billSubjectDto.setCheckPassed(Boolean.FALSE);
        }
    }

    public void checkNull(String fieldValue, BillDetailDto detailDto, int index, String errorMsg) {
        String billNo = detailDto.getBillNO();
        String billDetailNO = detailDto.getBillDetailNO();
        if (fieldValue != null && fieldValue.trim().length() == 0) {
            String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u53f7\uff1a%1$s \u7b2c%2$s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%3$s %4$s", (String)"BillCheckMethods_8", (String)"imc-sim-split", (Object[])new Object[0]), billNo, index, billDetailNO, errorMsg);
            throw new KDBizException(msg);
        }
        if (StringUtils.isEmpty((CharSequence)fieldValue)) {
            String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u53f7\uff1a%1$s \u7b2c%2$s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%3$s %4$s", (String)"BillCheckMethods_8", (String)"imc-sim-split", (Object[])new Object[0]), billNo, index, billDetailNO, errorMsg);
            throw new KDBizException(msg);
        }
    }

    public void specilNo0TaxRate(BigDecimal taxRate, Integer invKind, BillDetailDto detailDto, int index, String errMsg) {
        BigDecimal zeroBg = BigDecimal.ZERO;
        String billNo = detailDto.getBillNO();
        String billDetailNO = detailDto.getBillDetailNO();
        if (taxRate == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u7a0e\u7387\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillCheckMethods_9", (String)"imc-sim-split", (Object[])new Object[0]));
        }
        if (invKind == null) {
            throw new KDBizException(ResManager.loadKDString((String)"\u53d1\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillCheckMethods_10", (String)"imc-sim-split", (Object[])new Object[0]));
        }
        if (taxRate.compareTo(zeroBg) == 0 && invKind.compareTo(EnumType.InvKindEnum.SPECIAL.getValue()) == 0) {
            String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u53f7\uff1a%1$s \u7b2c%2$s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%3$s \u7a0e\u7387[%4$s] %5$s", (String)"BillCheckMethods_11", (String)"imc-sim-split", (Object[])new Object[0]), billNo, index, billDetailNO, taxRate, errMsg);
            throw new KDBizException(msg);
        }
    }

    public void verfTaxRateNew(BigDecimal taxRate, BillDetailDto detailDto, int index, String errMsg) {
        String billNo = detailDto.getBillNO();
        String billDetailNO = detailDto.getBillDetailNO();
        if (taxRate.compareTo(BigDecimal.ZERO) >= 0 && taxRate.compareTo(BigDecimal.ONE) <= 0) {
            int place = taxRate.scale();
            if (place > 3) {
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u53f7\uff1a%1$s \u7b2c%2$s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%3$s \u7a0e\u7387[%4$s] %5$s", (String)"BillCheckMethods_11", (String)"imc-sim-split", (Object[])new Object[0]), billNo, index, billDetailNO, taxRate, errMsg);
                throw new KDBizException(msg);
            }
        } else {
            String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u53f7\uff1a%1$s \u7b2c%2$s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%3$s \u7a0e\u7387[%4$s] %5$s", (String)"BillCheckMethods_11", (String)"imc-sim-split", (Object[])new Object[0]), billNo, index, billDetailNO, taxRate, errMsg);
            throw new KDBizException(msg);
        }
    }

    public void taxRate15NotMultiTax(List<BillDetailDto> billDList, BigDecimal taxRate, BillDetailDto detailDto, int index, String errMsg) {
        String billNo = detailDto.getBillNO();
        String billDetailNO = detailDto.getBillDetailNO();
        if (CollectionUtils.isEmpty(billDList)) {
            throw new KDBizException(ResManager.loadKDString((String)"\u96c6\u5408\u4e0d\u80fd\u4e3a\u7a7a", (String)"BillCheckMethods_12", (String)"imc-sim-split", (Object[])new Object[0]));
        }
        HashSet<BigDecimal> set = new HashSet<BigDecimal>(10);
        for (BillDetailDto dto : billDList) {
            set.add(dto.getTaxRate());
        }
        if (set.size() > 1 && taxRate.compareTo(new BigDecimal("0.015")) == 0) {
            String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u53f7\uff1a%1$s \u7b2c%2$s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%3$s %4$s", (String)"BillCheckMethods_8", (String)"imc-sim-split", (Object[])new Object[0]), billNo, index, billDetailNO, errMsg);
            throw new KDBizException(msg);
        }
    }

    public void decNottaxRate15(BigDecimal dec, BigDecimal taxRate, BillDetailDto detailDto, int index, String errMsg) {
        BigDecimal zeroBg = BigDecimal.ZERO;
        String billNo = detailDto.getBillNO();
        String billDetailNO = detailDto.getBillDetailNO();
        if (dec != null && dec.compareTo(zeroBg) != 0 && taxRate.compareTo(new BigDecimal("0.015")) == 0) {
            String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u53f7\uff1a%1$s \u7b2c%2$s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%3$s %4$s", (String)"BillCheckMethods_8", (String)"imc-sim-split", (Object[])new Object[0]), billNo, index, billDetailNO, errMsg);
            throw new KDBizException(msg);
        }
    }

    public void disLineMoneyNotGt0(BigDecimal amounts, Integer lineProperty, BillDetailDto detailDto, int index, String errMsg) {
        if (ComUtil.isDisLine(detailDto)) {
            String billNo = detailDto.getBillNO();
            String billDetailNO = detailDto.getBillDetailNO();
            BigDecimal zeroBg = BigDecimal.ZERO;
            if (lineProperty.compareTo(detailDto.getLineProperty()) == 0 && amounts.compareTo(zeroBg) > 0) {
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u53f7\uff1a%1$s \u7b2c%2$s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%3$s %4$s", (String)"BillCheckMethods_8", (String)"imc-sim-split", (Object[])new Object[0]), billNo, index, billDetailNO, errMsg);
                throw new KDBizException(msg);
            }
        }
    }

    public void checkDisRows(BillDetailDto detailDto, int index, String errMsg) {
        String billNo = detailDto.getBillNO();
        String billDetailNO = detailDto.getBillDetailNO();
        Integer lineProperty = detailDto.getLineProperty();
        Integer disRows = detailDto.getDisRows();
        if (EnumType.LinePropertyEnum.FOUR.getValue().compareTo(lineProperty) == 0 && disRows < -1) {
            String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u53f7\uff1a%1$s \u7b2c%2$s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%3$s \u6298\u6263\u884c\u6570[%4$s] %5$s", (String)"BillCheckMethods_13", (String)"imc-sim-split", (Object[])new Object[0]), billNo, index, billDetailNO, disRows, errMsg);
            throw new KDBizException(msg);
        }
    }

    public void discount1LineNotExist(List<BillDetailDto> billDList, BillDetailDto detailDto, int index) {
        BigDecimal zeroBg = BigDecimal.ZERO;
        String billNo = detailDto.getBillNO();
        String billDetailNO = detailDto.getBillDetailNO();
        Integer lineProperty = detailDto.getLineProperty();
        Integer disRows = detailDto.getDisRows();
        if (EnumType.LinePropertyEnum.FOUR.getValue().compareTo(lineProperty) == 0 && (disRows == 0 || disRows == 1)) {
            BigDecimal disMoney;
            int j = ComUtil.findObjIndexInList(billDList, detailDto);
            if (j - 1 < 0) {
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u53f7\uff1a%1$s \u7b2c%2$s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%3$s \u88ab\u6298\u6263\u884c\u4e0d\u5b58\u5728", (String)"BillCheckMethods_14", (String)"imc-sim-split", (Object[])new Object[0]), billNo, index, billDetailNO);
                throw new KDBizException(msg);
            }
            BillDetailDto lastBillDeailDto = billDList.get(j - 1);
            if (lastBillDeailDto.getAmounts().compareTo(zeroBg) < 0) {
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u53f7\uff1a%1$s \u7b2c%2$s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%3$s \u88ab\u6298\u6263\u884c\u91d1\u989d\u975e\u6b63\u6570\u884c", (String)"BillCheckMethods_15", (String)"imc-sim-split", (Object[])new Object[0]), billNo, index, billDetailNO);
                throw new KDBizException(msg);
            }
            BigDecimal amounts = EnumType.TaxFlag.YES.getVal().equals(lastBillDeailDto.getIncludeTax()) ? lastBillDeailDto.getAmountsIncTax() : lastBillDeailDto.getAmounts();
            if (amounts.compareTo((disMoney = detailDto.getAmounts()).abs()) < 0) {
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u53f7\uff1a%1$s \u7b2c%2$s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%3$s \u6298\u6263\u884c\u91d1\u989d[%4$s]\u5927\u4e8e\u88ab\u6298\u91d1\u989d[%5$s]", (String)"BillCheckMethods_16", (String)"imc-sim-split", (Object[])new Object[0]), billNo, index, billDetailNO, disMoney, amounts);
                throw new KDBizException(msg);
            }
        }
    }

    public void discountNLineNotExist(List<BillDetailDto> billDList, BillDetailDto detailDto, int index) {
        BigDecimal zeroBg = BigDecimal.ZERO;
        String billNo = detailDto.getBillNO();
        String billDetailNO = detailDto.getBillDetailNO();
        Integer lineProperty = detailDto.getLineProperty();
        Integer disRows = detailDto.getDisRows();
        if (EnumType.LinePropertyEnum.FOUR.getValue().compareTo(lineProperty) == 0 && disRows > 1) {
            int j = ComUtil.findObjIndexInList(billDList, detailDto);
            int positiveLine = 0;
            BigDecimal disMoney = detailDto.getAmounts();
            BigDecimal sumMoney = BigDecimal.ZERO;
            for (int i = j - 1; i >= 0; --i) {
                BigDecimal amounts;
                BillDetailDto billDetailDto = billDList.get(i);
                BigDecimal bigDecimal = amounts = EnumType.TaxFlag.YES.getVal().equals(billDetailDto.getIncludeTax()) ? billDetailDto.getAmountsIncTax() : billDetailDto.getAmounts();
                if (billDetailDto.getAmounts().compareTo(zeroBg) > 0) {
                    ++positiveLine;
                    sumMoney = sumMoney.add(amounts);
                }
                if (positiveLine == disRows) break;
            }
            if (positiveLine < disRows) {
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u53f7\uff1a%1$s \u7b2c%2$s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%3$s \u6298\u6263\u884c\u627e\u4e0d\u5230\u8db3\u591f\u7684\u6298\u6263\u884c\u6570", (String)"BillCheckMethods_17", (String)"imc-sim-split", (Object[])new Object[0]), billNo, index, billDetailNO);
                throw new KDBizException(msg);
            }
            if (sumMoney.compareTo(disMoney.abs()) < 0) {
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u53f7\uff1a%1$s \u7b2c%2$s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%3$s \u6298\u6263\u884c\u91d1\u989d[%4$s]\u5927\u4e8e\u88ab\u6298\u91d1\u989d[%5$s]", (String)"BillCheckMethods_16", (String)"imc-sim-split", (Object[])new Object[0]), billNo, index, billDetailNO, disMoney, sumMoney);
                throw new KDBizException(msg);
            }
        }
    }

    public void checkNDline(BillDetailDto detailDto, int index) {
        BigDecimal zeroBd = BigDecimal.ZERO;
        BigDecimal amounts = detailDto.getAmounts();
        BigDecimal amts = detailDto.getAmts();
        BigDecimal price = detailDto.getPrice();
        String billNo = detailDto.getBillNO();
        String billDetailNO = detailDto.getBillDetailNO();
        Integer lineProperty = detailDto.getLineProperty();
        if (EnumType.LinePropertyEnum.FOUR.getValue().compareTo(lineProperty) != 0) {
            BigDecimal disMoney;
            BigDecimal err;
            if (amounts.compareTo(zeroBd) == 0 && amts.compareTo(zeroBd) == 0 && price.compareTo(zeroBd) == 0) {
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u53f7\uff1a%1$s \u7b2c%2$s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%3$s \u666e\u901a\u5546\u54c1\u884c\u6216\u88ab\u6298\u6263\u884c\uff0c\u6570\u91cf\u3001\u5355\u4ef7\u3001\u91d1\u989d\u4e0d\u80fd\u540c\u65f6\u4e3a0", (String)"BillCheckMethods_18", (String)"imc-sim-split", (Object[])new Object[0]), billNo, index, billDetailNO);
                throw new KDBizException(msg);
            }
            if (amts != null && price != null && amts.compareTo(zeroBd) == 0 && price.compareTo(zeroBd) > 0 && amounts.compareTo(zeroBd) == 0) {
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u53f7\uff1a%1$s \u7b2c%2$s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%3$s \u91d1\u989d\uff0c\u6570\u91cf\u672a\u4f20\u5165", (String)"BillCheckMethods_19", (String)"imc-sim-split", (Object[])new Object[0]), billNo, index, billDetailNO);
                throw new KDBizException(msg);
            }
            if (amts != null && price != null && amts.compareTo(zeroBd) > 0 && price.compareTo(zeroBd) == 0 && amounts.compareTo(zeroBd) == 0) {
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u53f7\uff1a%1$s \u7b2c%2$s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%3$s \u91d1\u989d\uff0c\u5355\u4ef7\u672a\u4f20\u5165", (String)"BillCheckMethods_20", (String)"imc-sim-split", (Object[])new Object[0]), billNo, index, billDetailNO);
                throw new KDBizException(msg);
            }
            if (amts != null && price != null && amts.compareTo(zeroBd) > 0 && price.compareTo(zeroBd) > 0 && amounts.compareTo(zeroBd) > 0 && (err = (disMoney = amts.multiply(price)).subtract(amounts).abs()).compareTo(EnumType.DiffErrorEnum.AMOUNT.getDiff()) > 0) {
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u53f7\uff1a%1$s \u7b2c%2$s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%3$s \u6570\u91cf(%4$s)*\u5355\u4ef7(%5$s)\u4e0d\u7b49\u4e8e\u91d1\u989d(%6$s)", (String)"BillCheckMethods_21", (String)"imc-sim-split", (Object[])new Object[0]), billNo, index, billDetailNO, amts, price, amounts);
                throw new KDBizException(msg);
            }
            disMoney = detailDto.getDisAmt();
            if (disMoney != null && amounts.compareTo(zeroBd) < 0 && disMoney.compareTo(zeroBd) < 0) {
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u53f7\uff1a%1$s \u7b2c%2$s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%3$s \u8d1f\u6570\u884c\u4e0d\u5141\u8bb8\u6709\u6298\u6263", (String)"BillCheckMethods_22", (String)"imc-sim-split", (Object[])new Object[0]), billNo, index, billDetailNO);
                throw new KDBizException(msg);
            }
            if (disMoney != null && disMoney.abs().compareTo(amounts) > 0 && disMoney.compareTo(zeroBd) < 0) {
                String msg = String.format(ResManager.loadKDString((String)"\u5355\u636e\u53f7\uff1a%1$s \u7b2c%2$s\u884c\u5355\u636e\u660e\u7ec6\u7f16\u53f7\u4e3a:%3$s \u6298\u6263\u91d1\u989d\u5927\u4e8e\u91d1\u989d", (String)"BillCheckMethods_23", (String)"imc-sim-split", (Object[])new Object[0]), billNo, index, billDetailNO);
                throw new KDBizException(msg);
            }
        }
    }

    public void checkBillTotal(BillSubjectDto billSubjectDto) {
        List<BillDetailDto> billDList = billSubjectDto.getBillDList();
        BigDecimal billAmountsSum = BigDecimal.ZERO;
        BigDecimal billTaxAmtsSum = BigDecimal.ZERO;
        for (BillDetailDto billDetailDto : billDList) {
            billAmountsSum = billAmountsSum.add(billDetailDto.getAmounts() != null ? billDetailDto.getAmounts() : BigDecimal.ZERO);
            billTaxAmtsSum = billTaxAmtsSum.add(billDetailDto.getTaxAmt() != null ? billDetailDto.getTaxAmt() : BigDecimal.ZERO);
        }
        BigDecimal billAmountsIncTaxSum = billAmountsSum.add(billTaxAmtsSum);
        if (billAmountsSum.compareTo(BigDecimal.ZERO) == 0 || billAmountsIncTaxSum.compareTo(BigDecimal.ZERO) == 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u9500\u552e\u5355\u603b\u91d1\u989d\u6216\u62c6\u5408\u5904\u7406\u540e\u6709\u53d1\u7968\u7684\u91d1\u989d\u4e3a0\uff0c\u8bf7\u68c0\u67e5\u6570\u636e\u6216\u8c03\u6574\u62c6\u5408\u89c4\u5219", (String)"BillCheckMethods_24", (String)"imc-sim-split", (Object[])new Object[0]));
        }
    }
}

