/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.install.excel;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import kd.bos.coderule.api.ICodeRuleService;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.plugin.ImportLogger;
import kd.bos.form.IPageCache;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.mvc.SessionManager;
import kd.bos.orm.query.QFilter;
import kd.bos.service.ServiceFactory;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.TimeServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imsc.cc.business.builder.ScheduleTaskBuilder;
import kd.imsc.cc.business.proxy.ImportParamAdapterProxy;
import kd.imsc.cc.common.entity.SubDataInstallResult;
import kd.imsc.cc.common.exception.KdXkIprmException;
import kd.imsc.cc.common.utils.CommonUtils;

public class StdImportLoggerHelper {
    private static final Log logger = LogFactory.getLog(StdImportLoggerHelper.class);
    private static final long DEFAULT_TIMEOUT_MIN = 900000L;

    public static Object createImportLog(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        MainEntityType objType = EntityMetadataCache.getDataEntityType((String)"bos_importlog");
        DynamicObject dyn = (DynamicObject)objType.createInstance();
        dyn.set("name", (Object)name);
        dyn.set("billstatus", (Object)"C");
        dyn.set("importstatus", (Object)"0");
        dyn.set("createtime", (Object)TimeServiceHelper.now());
        ICodeRuleService coderule = (ICodeRuleService)ServiceFactory.getService(ICodeRuleService.class);
        String billno = coderule.getNumber("bos_importlog", dyn, null);
        dyn.set("billno", (Object)billno);
        Object[] result = SaveServiceHelper.save((IDataEntityType)objType, (Object[])new Object[]{dyn});
        if (result == null || result.length == 0) {
            return null;
        }
        dyn = (DynamicObject)result[0];
        return dyn.getPkValue();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String wait2ImportEnd(Object logId, String formId, String pageId) {
        logger.info(logId + " start waiting " + System.currentTimeMillis());
        if (logId == null) {
            return ResManager.loadKDString((String)"\u67e5\u8be2\u5f15\u5165\u65e5\u5fd7ID\u5f02\u5e38", (String)"StdImportLoggerHelper_0", (String)"imsc-cc", (Object[])new Object[0]);
        }
        String msg = "";
        int sleepSecond = 500;
        long start = System.currentTimeMillis();
        int interruptedCount = 0;
        int progress = 0;
        try {
            while (!StdImportLoggerHelper.isComplete(logId)) {
                block11: {
                    Integer lastProgress = StdImportLoggerHelper.getLatestProgress(pageId);
                    if (lastProgress > progress) {
                        progress = lastProgress;
                        start = System.currentTimeMillis();
                    }
                    if (System.currentTimeMillis() - start > 900000L) {
                        throw new KdXkIprmException(ResManager.loadKDString((String)"\r\n\u5f15\u5165\u5df2\u8d85\u65f6\uff0c\u8bf7\u7a0d\u540e\u53bb\u8be5\u5355\u636e\u7684\u5217\u8868\u754c\u9762\u67e5\u770b\u5f15\u5165\u7ed3\u679c\u3002", (String)"StdImportLoggerHelper_1", (String)"imsc-cc", (Object[])new Object[0]), 3001);
                    }
                    try {
                        Thread.sleep(sleepSecond);
                    }
                    catch (InterruptedException e) {
                        int n = interruptedCount;
                        interruptedCount = (byte)(interruptedCount + 1);
                        if (n <= 3) break block11;
                        logger.info(logId + " InterruptedException " + CommonUtils.getExceptionDetailInfo(e));
                        throw new KdXkIprmException(ResManager.loadKDString((String)"%n \u4efb\u52a1\u5df2\u88ab\u591a\u6b21\u4e2d\u65ad\u3002", (String)"StdImportLoggerHelper_2", (String)"imsc-cc", (Object[])new Object[0]), e, 3001);
                    }
                }
                sleepSecond = ScheduleTaskBuilder.getDynamicSleepSecond(sleepSecond, 5000);
            }
        }
        catch (KdXkIprmException e) {
            msg = ResManager.loadKDString((String)"\u7b49\u5f85\u5f15\u5165\u4efb\u52a1\u7ed3\u675f\u65f6\u53d1\u751f\u5f02\u5e38\uff1a", (String)"StdImportLoggerHelper_3", (String)"imsc-cc", (Object[])new Object[0]) + e.getMessage() + ResManager.loadKDString((String)"\u5f15\u5165\u65e5\u5fd7id\uff1a", (String)"StdImportLoggerHelper_4", (String)"imsc-cc", (Object[])new Object[0]) + logId;
        }
        finally {
            ImportParamAdapterProxy.closeFormView(formId, pageId);
        }
        logger.info(logId + " end waiting " + System.currentTimeMillis());
        return msg;
    }

    public static void parseExcelImportResult(Object importLogId, SubDataInstallResult result) {
        if (importLogId == null) {
            result.setError(ResManager.loadKDString((String)"\u67e5\u8be2\u5f15\u5165\u65e5\u5fd7ID\u5f02\u5e38", (String)"StdImportLoggerHelper_0", (String)"imsc-cc", (Object[])new Object[0]));
            return;
        }
        DynamicObject log = QueryServiceHelper.queryOne((String)"bos_importlog", (String)"id, importstatus, data, total, failed", (QFilter[])new QFilter("id", "=", importLogId).toArray());
        if (log == null) {
            result.setError(ResManager.loadKDString((String)"%n\u5f15\u5165\u65e5\u5fd7\u4e2d\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u89e3\u6790\uff0c\u8bf7\u5230\u5355\u636e\u5217\u8868\u754c\u9762\u67e5\u770b\u5f15\u5165\u7ed3\u679c\u8fdb\u884c\u786e\u8ba4\uff0c\u5f15\u5165\u65e5\u5fd7id\uff1a", (String)"StdImportLoggerHelper_5", (String)"imsc-cc", (Object[])new Object[0])).append(importLogId.toString());
            return;
        }
        String data = log.getString("data");
        if (StringUtils.isEmpty((CharSequence)data)) {
            result.setError(ResManager.loadKDString((String)"%n\u5f15\u5165\u65e5\u5fd7\u4e2d\u6570\u636e\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u89e3\u6790\uff0c\u8bf7\u5230\u5355\u636e\u5217\u8868\u754c\u9762\u67e5\u770b\u5f15\u5165\u7ed3\u679c\u8fdb\u884c\u786e\u8ba4\uff0c\u5f15\u5165\u65e5\u5fd7id\uff1a", (String)"StdImportLoggerHelper_5", (String)"imsc-cc", (Object[])new Object[0])).append(importLogId.toString());
            return;
        }
        JSONObject info = JSON.parseObject((String)data).getJSONObject("info");
        boolean success = true;
        for (Object value : info.values()) {
            ImportLogger importLogger = (ImportLogger)SerializationUtils.fromJsonString((String)value.toString(), ImportLogger.class);
            if (importLogger.getFailed() > 0) {
                success = false;
            } else if (importLogger.getTotal() <= 0) {
                success = false;
            }
            result.setTotal(result.getTotal() + importLogger.getTotal());
            result.setFailed(result.getFailed() + importLogger.getFailed());
            result.setSuccess(success);
            result.append(importLogger.toString());
        }
    }

    private static Integer getLatestProgress(String pageId) {
        IPageCache cache = SessionManager.getCurrent().getPageCache(pageId);
        if (cache == null) {
            return 0;
        }
        String importLog = cache.get("Cached_Import_Logger");
        if (StringUtils.isEmpty((CharSequence)importLog)) {
            return 0;
        }
        JSONObject map = JSON.parseObject((String)importLog);
        Object obj = map.get((Object)"progress");
        if (obj != null && !"".equals(obj)) {
            try {
                return Integer.parseInt(String.valueOf(obj).trim());
            }
            catch (NumberFormatException e) {
                logger.info("ExcelImpl.import.getProgress\u51fa\u73b0\u8f6c\u6362\u95ee\u9898\uff0c\u65e0\u6cd5\u5c06\u83b7\u53d6\u7684progress\u8f6c\u6362\u6210int\uff1a{}", obj);
            }
        }
        return 0;
    }

    private static boolean isComplete(Object logId) {
        return QueryServiceHelper.exists((String)"bos_importlog", (QFilter[])new QFilter("id", "=", logId).and("importstatus", "=", (Object)"1").toArray());
    }
}

