/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.business.utils;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Objects;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.util.StringUtils;
import kd.bos.zip.ZipFile;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.io.FileUtils;

public final class IprmFileUtils {
    public static String getFileNameWithOutExtension(String fileName) {
        if (StringUtils.isEmpty((String)fileName)) {
            return "";
        }
        if (fileName.indexOf(46) == -1) {
            return fileName;
        }
        return fileName.substring(0, fileName.lastIndexOf(46));
    }

    public static boolean isFileExistWithFilePath(String filePath) {
        if (StringUtils.isEmpty((String)filePath)) {
            return false;
        }
        File file = new File(filePath);
        return file.exists();
    }

    public static boolean isFileZipFormatWithFileName(String fileName) {
        if (StringUtils.isEmpty((String)fileName)) {
            return false;
        }
        return fileName.endsWith(".zip") || fileName.endsWith(".ZIP");
    }

    public static boolean isFileDirectoryEmptyWithFilePath(String filePath) {
        if (StringUtils.isEmpty((String)filePath)) {
            return true;
        }
        File file = new File(filePath);
        if (!file.exists()) {
            return true;
        }
        if (!file.isDirectory()) {
            return true;
        }
        return file.listFiles() == null || Objects.requireNonNull(file.listFiles()).length <= 0;
    }

    public static File createTempFile(String dir) throws IOException {
        return Files.createTempDirectory(dir, new FileAttribute[0]).toFile();
    }

    public static File createTempFile(File dir, String fileName, String fileFormat) throws IOException {
        return Files.createTempFile(dir.toPath(), fileName, fileFormat, new FileAttribute[0]).toFile();
    }

    public static void deleteLocalFile(File fileTemp) throws IOException {
        FileUtils.deleteDirectory((File)fileTemp);
    }

    public static URL linkToURL(String url) throws IOException {
        return new URL(url);
    }

    public static File unzipPackage(File zipFilePath) throws IOException {
        if (zipFilePath == null) {
            throw new IOException(ResManager.loadKDString((String)"\u89e3\u538b\u5931\u8d25\uff0c\u6587\u4ef6\u4e0d\u5b58\u5728\u3002", (String)"IprmFileUtils_0", (String)"imsc-cc", (Object[])new Object[0]));
        }
        File unzipDir = new File(zipFilePath.getParentFile().getAbsolutePath() + File.separator + IprmFileUtils.getFileNameWithOutExtension(zipFilePath.getName()));
        ZipFile zipFile = new ZipFile(zipFilePath);
        zipFile.extractAll(unzipDir.getPath());
        File[] files = unzipDir.listFiles();
        if (files != null) {
            for (File file : files) {
                JSONObject dataJson;
                String parentPath = file.getParent();
                String fileName = file.getName();
                if (!fileName.endsWith("_convert.json")) continue;
                try {
                    String data = FileUtils.readFileToString((File)file, (Charset)StandardCharsets.UTF_8);
                    dataJson = (JSONObject)JSON.parseObject((String)data, (TypeReference)new TypeReference<JSONObject>(){}, (Feature[])new Feature[]{Feature.OrderedField});
                }
                catch (Exception e) {
                    return null;
                }
                if (!dataJson.containsKey((Object)"fileName") || dataJson.getString("fileName") == null) continue;
                String fullFilePath = parentPath + File.separator + dataJson.getString("fileName");
                String data = dataJson.getString("data");
                byte[] bytes = Base64.decodeBase64((String)data);
                File dataFile = new File(fullFilePath);
                FileUtils.writeByteArrayToFile((File)dataFile, (byte[])bytes);
            }
        }
        return unzipDir;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFileMd5(String filePath) {
        if (StringUtils.isEmpty((String)filePath)) {
            return "";
        }
        File file = new File(filePath);
        if (!file.exists()) {
            return "";
        }
        try (FileInputStream fileInputStream = new FileInputStream(filePath);){
            String string = DigestUtils.md5Hex((InputStream)fileInputStream);
            return string;
        }
        catch (IOException iOException) {
            return "";
        }
    }
}

