/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.formplugin;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.read.builder.ExcelReaderSheetBuilder;
import com.alibaba.fastjson.JSONObject;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.exception.KDException;
import kd.bos.form.FormShowParameter;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.CollectionUtils;
import kd.imsc.cc.business.install.IDataPackagePreviewListener;
import kd.imsc.cc.business.proxy.DataPackageInstallerProxy;
import kd.imsc.cc.common.entity.DataPackageInputModel;
import kd.imsc.cc.common.entity.DataPackageModifyConfig;
import kd.imsc.cc.common.entity.DataPackageModifyResult;
import org.apache.commons.io.FileUtils;

public class ExcelPreviewPlugin
extends AbstractFormPlugin {
    private static final Log logger = LogFactory.getLog(ExcelPreviewPlugin.class);
    private static int SET_COLUMN_NUM = 150;
    private static int HEAD_ROW_NUM = 3;
    private static int LIMIT_ROW = 100000;
    private static int START_FIRST_ROW = 0;
    private static final String CACHE_COLUMN_TOO_LONG = "column_is_too_long";
    private static final String COLUMN_TOO_LONG_FLAG = "true";
    private static final String CACHE_ROW_IS_TOO_BIG = "row_is_too_big";
    private static final String ROW_IS_TOO_BIG_FLAG = "true";
    private List<List<String>> headExcel;
    private List<List<String>> listExcel;
    private static final String ENTRY_ENTITY = "entryentity";
    private static final String ENTRY_TEXTFIELD = "textfield";
    private static final String FLEXPANELAP = "flexpanelap";
    private static final String KEY_MAX_COLUMN = "maxColumn";
    private static final String KEY_LIST_EXCEL = "listExcel";
    private static final String CACHE_KEY_REVIEW_FILE_PATH = "catch_key_preview_file_path";
    private static final String CACHE_KEY_HEADMAXCOLUMN = "catch_key_head_max_column";
    private static final String CACHE_KEY_BODYMAXCOLUMN = "catch_key_body_max_column";

    public void registerListener(EventObject e) {
        super.registerListener(e);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        Object cloudContent = formShowParameter.getCustomParam("c_c_i");
        if (ObjectUtils.isEmpty((Object)cloudContent)) {
            logger.warn("cloudContentStr is null!");
            return;
        }
        final String previewFileInfo = (String)formShowParameter.getCustomParam("p_f_n");
        if (ObjectUtils.isEmpty((Object)previewFileInfo)) {
            logger.warn("cloudContentStr is null!");
            return;
        }
        DataPackageInputModel model = this.parseDataPackageModel(cloudContent.toString());
        DataPackageInstallerProxy proxy = new DataPackageInstallerProxy(model, new IDataPackagePreviewListener(){

            @Override
            public void dataPackageInstallFail(int code, String errMsg) {
                logger.info("dataPackageInstallFail: code : {} msg : {}", (Object)code, (Object)errMsg);
                ExcelPreviewPlugin.this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u9519\u8bef\u7801\uff1a%1$d\uff0c\u5f02\u5e38\u4fe1\u606f\uff1a%2$s\u3002", (String)"ExcelPreviewPlugin_0", (String)"imsc-cc", (Object[])new Object[0]), code, errMsg));
            }

            @Override
            public Map<String, DataPackageModifyResult> checkDataPackageReplaceCallBack(Map<String, DataPackageModifyConfig> beforeDataPackageMap) {
                DataPackageModifyConfig config = beforeDataPackageMap.get(previewFileInfo);
                if (ObjectUtils.isEmpty((Object)config)) {
                    logger.error("checkDataPackageReplaceCallBack config is null. sourcename : {}", (Object)previewFileInfo);
                    ExcelPreviewPlugin.this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u63d0\u4ea4\u8bc4\u4ef7\u53cd\u9988\u6216\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ExcelPreviewPlugin_1", (String)"imsc-cc", (Object[])new Object[0]));
                    return null;
                }
                logger.info("LoadPackagePlugin config : {}", (Object)JSONObject.toJSONString((Object)config));
                String previewFilePath = config.getPath();
                if (!new File(previewFilePath).exists()) {
                    logger.error("LoadPackagePlugin checkDataPackageReplaceCallBack file is not exists. sourcename : {}, previewFilePath : {}", (Object)previewFileInfo, (Object)previewFilePath);
                    ExcelPreviewPlugin.this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u63d0\u4ea4\u8bc4\u4ef7\u53cd\u9988\u6216\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ExcelPreviewPlugin_1", (String)"imsc-cc", (Object[])new Object[0]));
                    return null;
                }
                ExcelPreviewPlugin.this.invokeFilePreview(previewFilePath);
                return null;
            }
        });
        proxy.invokeDataPackageInstallCheck(false);
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        try {
            String previewFilePath = (String)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_KEY_REVIEW_FILE_PATH), String.class);
            File file = new File(previewFilePath);
            File parentFile = file.getParentFile().getParentFile();
            FileUtils.deleteDirectory((File)parentFile);
        }
        catch (Exception ex) {
            logger.error("\u9884\u89c8\u5220\u9664\u6587\u4ef6\u5931\u8d25 \uff1a", (Throwable)ex);
        }
    }

    private void invokeFilePreview(String previewFilePath) {
        this.getPageCache().put(CACHE_KEY_REVIEW_FILE_PATH, SerializationUtils.toJsonString((Object)previewFilePath));
        if (CollectionUtils.isEmpty(this.headExcel)) {
            this.dealHeadExcel(previewFilePath, START_FIRST_ROW, HEAD_ROW_NUM);
        }
        this.dealExcel(previewFilePath, START_FIRST_ROW, LIMIT_ROW);
        DynamicObjectCollection dynamicObjects = this.getModel().getEntryEntity(ENTRY_ENTITY);
        this.getDataHeadExcel(dynamicObjects);
        int size = this.listExcel.size();
        for (int i = 0; i < LIMIT_ROW && i <= size - 1; ++i) {
            List<String> list = this.listExcel.get(i);
            DynamicObject dynamicObject = dynamicObjects.addNew();
            int columnSize = list.size();
            for (int j = 0; j < columnSize && j < SET_COLUMN_NUM; ++j) {
                dynamicObject.set(ENTRY_TEXTFIELD + j, (Object)list.get(j));
            }
            if (columnSize <= SET_COLUMN_NUM) continue;
            this.getPageCache().put(CACHE_COLUMN_TOO_LONG, SerializationUtils.toJsonString((Object)"true"));
        }
        this.dealUnVisibleColumn();
        this.getView().updateView(ENTRY_ENTITY);
        this.getView().setEnable(Boolean.valueOf(false), new String[]{FLEXPANELAP});
        this.dealNotification();
    }

    private DataPackageInputModel parseDataPackageModel(String cloudContentStr) {
        JSONObject cloudObj = JSONObject.parseObject((String)cloudContentStr);
        JSONObject objInfoMap = cloudObj.getJSONObject("objInfoMap");
        Set keySet = objInfoMap.keySet();
        HashMap<String, String> buildMap = new HashMap<String, String>(keySet.size());
        for (String key : keySet) {
            buildMap.put(key, objInfoMap.getString(key));
        }
        return new DataPackageInputModel.Builder().id(cloudObj.getString("id")).name(cloudObj.getString("name")).ver(cloudObj.getString("ver")).type(cloudObj.getString("type")).resourceFileUrl(cloudObj.getString("resourceFileUrl")).objInfoMap(buildMap).builder();
    }

    private void dealUnVisibleColumn() {
        int maxColumn;
        for (int k = maxColumn = (headMaxColumn = ((Integer)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_KEY_HEADMAXCOLUMN), Integer.class)).intValue()) >= (bodyMaxColumn = ((Integer)SerializationUtils.fromJsonString((String)this.getPageCache().get(CACHE_KEY_BODYMAXCOLUMN), Integer.class)).intValue()) ? headMaxColumn : bodyMaxColumn; k < SET_COLUMN_NUM; ++k) {
            this.getView().setVisible(Boolean.valueOf(false), new String[]{ENTRY_TEXTFIELD + k});
        }
    }

    private void dealNotification() {
        String rowFlag;
        String rowContentCache;
        String columnFlag;
        String columnContentCache = this.getPageCache().get(CACHE_COLUMN_TOO_LONG);
        if (!kd.bos.util.StringUtils.isEmpty((String)columnContentCache) && "true".equals(columnFlag = (String)SerializationUtils.fromJsonString((String)columnContentCache, String.class))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u9884\u89c8150\u5217\u6570\u636e\u3002", (String)"ExcelPreviewPlugin_2", (String)"imsc-cc", (Object[])new Object[0]));
        }
        if (!kd.bos.util.StringUtils.isEmpty((String)(rowContentCache = this.getPageCache().get(CACHE_ROW_IS_TOO_BIG))) && "true".equals(rowFlag = (String)SerializationUtils.fromJsonString((String)rowContentCache, String.class))) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u9884\u89c8100000\u884c\u6570\u636e\u3002", (String)"ExcelPreviewPlugin_3", (String)"imsc-cc", (Object[])new Object[0]));
        }
    }

    private void getDataHeadExcel(DynamicObjectCollection dynamicObjects) {
        dynamicObjects.clear();
        for (int i = 0; i < 4; ++i) {
            List<String> list = this.headExcel.get(i);
            DynamicObject dynamicObject = dynamicObjects.addNew();
            int columnSize = list.size();
            for (int j = 0; j < columnSize && j < SET_COLUMN_NUM; ++j) {
                dynamicObject.set(ENTRY_TEXTFIELD + j, (Object)list.get(j));
            }
            if (columnSize <= SET_COLUMN_NUM) continue;
            this.getPageCache().put(CACHE_COLUMN_TOO_LONG, SerializationUtils.toJsonString((Object)"true"));
        }
    }

    private void dealHeadExcel(String previewFilePath, int start, int limit) {
        Map<String, Object> map = this.readExcel(previewFilePath, start, limit);
        if (null == map || map.get(KEY_MAX_COLUMN) == null || StringUtils.isEmpty((CharSequence)String.valueOf(map.get(KEY_MAX_COLUMN))) || null == map.get(KEY_LIST_EXCEL)) {
            throw new KDException("read head excel fail");
        }
        this.headExcel = (List)map.get(KEY_LIST_EXCEL);
        this.getPageCache().put(CACHE_KEY_HEADMAXCOLUMN, SerializationUtils.toJsonString((Object)map.get(KEY_MAX_COLUMN)));
    }

    private void dealExcel(String previewFilePath, int start, int limit) {
        Map<String, Object> map = this.readExcel(previewFilePath, start + 4, 0);
        if (null == map || map.get(KEY_MAX_COLUMN) == null || StringUtils.isEmpty((CharSequence)String.valueOf(map.get(KEY_MAX_COLUMN))) || null == map.get(KEY_LIST_EXCEL)) {
            throw new KDException("read excel fail");
        }
        this.getPageCache().put(CACHE_KEY_BODYMAXCOLUMN, SerializationUtils.toJsonString((Object)map.get(KEY_MAX_COLUMN)));
        this.listExcel = (List)map.get(KEY_LIST_EXCEL);
        int listExcelSize = this.listExcel.size();
        if (listExcelSize <= 0) {
            throw new KDException("listExcel row is error");
        }
    }

    private Map<String, Object> readExcel(String previewFilePath, int start, int limit) {
        if (!new File(previewFilePath).exists()) {
            logger.error("ExcelPreviewPlugin readExcelData previewFilePath : {}", (Object)previewFilePath);
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u6587\u4ef6\u4e0d\u5b58\u5728\uff0c\u8bf7\u63d0\u4ea4\u8bc4\u4ef7\u53cd\u9988\u6216\u7a0d\u540e\u518d\u8bd5\u3002", (String)"ExcelPreviewPlugin_1", (String)"imsc-cc", (Object[])new Object[0]));
            return null;
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        try {
            List dataList = ((ExcelReaderSheetBuilder)EasyExcel.read((File)new File(previewFilePath)).sheet(Integer.valueOf(0)).headRowNumber(Integer.valueOf(start))).doReadSync();
            ArrayList listTotal = new ArrayList(10);
            int maxColumn = 0;
            if (CollectionUtils.isNotEmpty((Collection)dataList)) {
                int limitIndex = dataList.size() - 1;
                if (start == 0) {
                    limitIndex = limit;
                }
                for (int index = 0; index <= limitIndex; ++index) {
                    Map rowData = (Map)dataList.get(index);
                    ArrayList cellList = new ArrayList(10);
                    maxColumn = Math.max(rowData.size(), maxColumn);
                    for (Map.Entry entry : rowData.entrySet()) {
                        cellList.add(entry.getValue());
                    }
                    listTotal.add(cellList);
                }
            }
            map.put(KEY_MAX_COLUMN, maxColumn);
            map.put(KEY_LIST_EXCEL, listTotal);
            return map;
        }
        catch (Exception e) {
            logger.error("\u8bfb\u53d6\u6587\u4ef6\u5931\u8d25 \uff1a", (Throwable)e);
            return map;
        }
    }
}

