/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.cc.formplugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.ObjectUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.form.CloseCallBack;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.ConfirmTypes;
import kd.bos.form.FormShowParameter;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.ShowType;
import kd.bos.form.control.Control;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Image;
import kd.bos.form.control.Label;
import kd.bos.form.control.Rate;
import kd.bos.form.control.RichTextEditor;
import kd.bos.form.control.events.ClickListener;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.portal.service.VersionService;
import kd.bos.portal.service.bo.Version;
import kd.imsc.cc.business.gcpmanage.GcpManager;
import kd.imsc.cc.business.helper.NewResourceHelper;
import kd.imsc.cc.business.resource.ResourceListProxy;
import kd.imsc.cc.business.utils.ResourceInfoUtil;
import kd.imsc.cc.common.constants.iprm.model.BizOperationResult;
import kd.imsc.cc.common.entity.DataPackageInputModel;
import kd.imsc.cc.common.exception.KdXkIprmException;
import kd.imsc.cc.common.model.ContentDetailModel;
import kd.imsc.cc.common.utils.ContentHelper;
import kd.imsc.cc.common.utils.PackUploadUtils;
import kd.imsc.cc.formplugin.helper.CollectHelper;

public class NewResourcePlugin
extends AbstractFormPlugin
implements RowClickEventListener {
    private static final Log logger = LogFactory.getLog(NewResourcePlugin.class);
    private static final String OPERATION_KEY_INSTALL = "install";
    private static final String OPERATION_KEY_SCORE = "score";
    private static final String CALLBACK_KEY_LOAD_PACKAGE = "callback_iprm_loadpackage";
    private static final String CALLBACK_KEY_RESOURCE_SCORE = "callback_resource_score";
    private static final String CONTROL_RICH_TEXT = "richtexteditorap";
    private static final String ENTITY_LOAD_PACKAGE = "cc_loadpackage";
    private static final String ENTITY_RESOURCE_SCORE = "cc_resource_score";
    private static final String CACHE_KEY_RESOURCEINFO = "cache_key_resourceinfo";
    private static final String CACHE_KEY_INDEX = "cache_key_index";
    private static final String CONTROL_TITLE = "labelaptitle";
    private static final String CONTROL_LABEL_001 = "industry_1";
    private static final String CONTROL_LABEL_002 = "domain_1";
    private static final String CONTROL_LABEL_003 = "theme";
    private static final String RATE_CONTROL = "rateap";
    private static final String LABEI_SCORE = "labelap2";

    private ContentDetailModel getResourceInfo() {
        String content = this.getPageCache().get(CACHE_KEY_RESOURCEINFO);
        if (kd.bos.util.StringUtils.isEmpty((String)content)) {
            return null;
        }
        return (ContentDetailModel)SerializationUtils.fromJsonString((String)content, ContentDetailModel.class);
    }

    public void afterCreateNewData(EventObject e) {
        FormShowParameter formShowParameter = this.getView().getFormShowParameter();
        String billno = (String)formShowParameter.getCustomParam("billno");
        this.getModel().setValue("billno", (Object)billno);
    }

    public void afterBindData(EventObject e) {
        String resourceNumber = this.getModel().getValue("billno").toString();
        try {
            this.setFormValue(resourceNumber);
        }
        catch (KdXkIprmException ex) {
            String msg = ResManager.loadKDString((String)"\u5185\u5bb9\u5305\u5df2\u4e0b\u67b6\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002", (String)"NewResourcePlugin_0", (String)"imsc-cc", (Object[])new Object[0]);
            if (ex.getCode() == 99) {
                msg = "Network error!";
            }
            if (ex.getCode() == 5002) {
                msg = ex.getMessage();
            }
            if (this.getView().getParentView() != null) {
                this.getView().returnDataToParent((Object)msg);
            }
            this.getView().close();
        }
    }

    private void setFormValue(String resourceNumber) throws KdXkIprmException {
        ContentDetailModel dataMap = this.getInfoData(resourceNumber);
        if (dataMap == null) {
            return;
        }
        NewResourceHelper.recordBrowseCount(resourceNumber);
        Image image = (Image)this.getControl("picture");
        this.getView().getPageCache().put("pictUrlCache", PackUploadUtils.getPictureInfo(dataMap.getPicList(), image));
        Label label = (Label)this.getView().getControl(CONTROL_TITLE);
        label.setText(dataMap.getPkgName());
        Label billNo = (Label)this.getView().getControl("billno_1");
        billNo.setText(dataMap.getPkgNumber());
        this.setLabValueAndVisible("versions", dataMap.getVersion());
        String indValue = kd.bos.util.StringUtils.getStringValue((Object)ResourceInfoUtil.getIndustry(dataMap.getAdaindustry(), Boolean.FALSE));
        this.setLabValueAndVisible(CONTROL_LABEL_001, indValue);
        String domainValue = kd.bos.util.StringUtils.getStringValue((Object)ResourceInfoUtil.getDomain(dataMap.getDomain(), Boolean.FALSE));
        this.setLabValueAndVisible(CONTROL_LABEL_002, domainValue);
        String typeValue = kd.bos.util.StringUtils.getStringValue((Object)ResourceInfoUtil.getClassification(dataMap.getClassification(), Boolean.FALSE));
        this.setLabValueAndVisible(CONTROL_LABEL_003, typeValue);
        List<String> sceneList = dataMap.getScene();
        ContentHelper.setScene(sceneList, this.getView());
        this.getModel().setValue("brief", (Object)dataMap.getPkgSummery());
        this.getView().updateView("brief");
        String authorName = dataMap.getAuthorName();
        this.setLabValueAndVisible("writer", authorName);
        Label creatorOrgLabel = (Label)this.getView().getControl("createorg");
        String createOrg = dataMap.getCreateTeam();
        creatorOrgLabel.setText(createOrg == null ? null : String.valueOf(createOrg));
        Label dataLab = (Label)this.getView().getControl("data");
        Date dataVal = dataMap.getReleaseDate();
        if (dataVal != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            dataLab.setText(sdf.format(dataVal));
        }
        Label appVisionLab = (Label)this.getView().getControl("appvisionstr");
        List<String> starryVersion = dataMap.getStarryVersion();
        boolean backwards = dataMap.isBackwards();
        StringBuilder appVision = new StringBuilder();
        starryVersion.forEach(y -> appVision.append((String)y).append(','));
        appVision.deleteCharAt(appVision.lastIndexOf(","));
        appVisionLab.setText(backwards ? String.format(ResManager.loadKDString((String)"%s\u53ca\u4ee5\u4e0a\u7248\u672c", (String)"NewResourcePlugin_1", (String)"imsc-cc", (Object[])new Object[0]), appVision) : appVision.toString());
        this.getPageCache().put(CACHE_KEY_RESOURCEINFO, SerializationUtils.toJsonString((Object)dataMap));
        this.getModel().setValue("name", (Object)dataMap.getPkgName());
        this.getModel().setValue("createdate", (Object)dataMap.getCreateDate());
        RichTextEditor contentHighlights = (RichTextEditor)this.getView().getControl("contenthighlights");
        contentHighlights.setText(dataMap.getLightDetail());
        this.getView().updateView("contenthighlights");
        String detailText = dataMap.getDetailText();
        this.setDetailText(detailText);
        this.refreshResourceList(dataMap);
        String scoreVal = dataMap.getGrade();
        this.getModel().setValue("re_score", (Object)scoreVal);
        Label score = (Label)this.getControl(LABEI_SCORE);
        score.setText(scoreVal);
        Rate rate = (Rate)this.getView().getControl(RATE_CONTROL);
        rate.setRateScore((Number)Double.valueOf(scoreVal));
        this.getModel().setValue("collectstatus", (Object)(CollectHelper.isCollect(resourceNumber, RequestContext.get().getCurrUserId()) ? "collect" : "uncollect"));
    }

    private void setLabValueAndVisible(String key, String value) {
        Label versionLabel = (Label)this.getView().getControl(key);
        versionLabel.setText(value);
        this.getView().setVisible(Boolean.valueOf(!kd.bos.util.StringUtils.isEmpty((String)value)), new String[]{key});
    }

    private void setDetailText(String detailText) {
        if (!kd.bos.util.StringUtils.isEmpty((String)detailText)) {
            detailText = ResourceInfoUtil.convertFromBase64Image(detailText);
            RichTextEditor richTextEditor = (RichTextEditor)this.getView().getControl(CONTROL_RICH_TEXT);
            richTextEditor.setText(detailText);
            this.getView().updateView(CONTROL_RICH_TEXT);
        }
    }

    public void click(EventObject evt) {
        Control control = (Control)evt.getSource();
        String fieldKey = control.getKey();
        String billNo = (String)this.getModel().getValue("billno");
        if ("picture".equals(fieldKey)) {
            String pictUrlCacheStr = this.getView().getPageCache().get("pictUrlCache");
            List pictUrlCache = (List)SerializationUtils.fromJsonString((String)pictUrlCacheStr, List.class);
            this.getView().showPictureView(pictUrlCache.toArray(new String[0]), 0);
        } else if ("collectpic".equals(fieldKey)) {
            CollectHelper.cancelCollectClick(billNo, "cc_resourcenew", this.getView(), this.getPluginName());
        } else if ("uncollectpic".equals(fieldKey)) {
            CollectHelper.collectClick(billNo, "cc_mycontent", this.getView());
        }
    }

    private void refreshResourceList(ContentDetailModel dataMap) {
        String packStr = dataMap.getpInfoContent();
        if (kd.bos.util.StringUtils.isEmpty((String)packStr)) {
            return;
        }
        Map mapData = (Map)SerializationUtils.fromJsonString((String)packStr, Map.class);
        List contentList = (List)mapData.get("files");
        if (contentList != null) {
            DynamicObjectCollection dynamicObjectCollection = this.getModel().getEntryEntity("entryentity");
            dynamicObjectCollection.clear();
            for (Map content : contentList) {
                DynamicObject dynamicObjectRow = dynamicObjectCollection.addNew();
                dynamicObjectRow.set("sourcename", content.get("fileName"));
                dynamicObjectRow.set("businessobjecttype", content.get("businessObjectType"));
                dynamicObjectRow.set("billName", content.get("billName"));
                dynamicObjectRow.set("dataencrypt", content.get("dataencrypt"));
            }
            this.getView().updateView("entryentity");
        }
    }

    private ContentDetailModel getInfoData(String number) throws KdXkIprmException {
        if (kd.bos.util.StringUtils.isEmpty((String)number)) {
            this.getView().showErrorNotification(ResManager.loadKDString((String)"\u9644\u4ef6\u8def\u5f84\u83b7\u53d6\u5931\u8d25\u3002\u201c\u5185\u5bb9\u5305\u7f16\u7801\u201d\u4e3a\u7a7a\u3002", (String)"NewResourcePlugin_2", (String)"imsc-cc", (Object[])new Object[0]));
            return null;
        }
        HashMap<String, Object> header = new HashMap<String, Object>(4);
        header.put("pkgNum", number);
        BizOperationResult bizOperationResult = GcpManager.getDetail(header);
        if (bizOperationResult == null || !bizOperationResult.getSuccess()) {
            logger.error("\u67e5\u8be2\u4e91\u5185\u5bb9\u8be6\u60c5|\u5931\u8d25\u7ed3\u679c|{}", (Object)JSON.toJSONString((Object)bizOperationResult));
            throw new KdXkIprmException(ResManager.loadKDString((String)"\u5185\u5bb9\u5305\u5df2\u4e0b\u67b6\uff0c\u8bf7\u5237\u65b0\u5217\u8868\u3002", (String)"NewResourcePlugin_0", (String)"imsc-cc", (Object[])new Object[0]), bizOperationResult == null ? 1001 : bizOperationResult.getErrorCode());
        }
        ContentDetailModel contentDetailModel = (ContentDetailModel)JSON.parseObject((String)JSON.toJSONString(bizOperationResult.getData()), ContentDetailModel.class);
        contentDetailModel.setpInfoContent(NewResourceHelper.coverPInfoContent(contentDetailModel.getpInfoContent()));
        return contentDetailModel;
    }

    public static String getLoadTipHintMsg() {
        StringBuilder hintMsgBuilder = new StringBuilder();
        hintMsgBuilder.append(ResManager.loadKDString((String)"1\u3001\u5efa\u8bae\u5148\u5728\u6d4b\u8bd5\u73af\u5883\u52a0\u8f7d\u9a8c\u8bc1\uff0c\u518d\u52a0\u8f7d\u5230\u751f\u4ea7\u73af\u5883\uff1b", (String)"NewResourcePlugin_3", (String)"imsc-cc", (Object[])new Object[0]));
        hintMsgBuilder.append("\r\n");
        hintMsgBuilder.append(ResManager.loadKDString((String)"2\u3001\u53ef\u80fd\u4f1a\u66f4\u65b0\u5df2\u6709\u6570\u636e\uff0c\u5efa\u8bae\u5148\u5907\u4efd\u6570\u636e\uff1b", (String)"NewResourcePlugin_4", (String)"imsc-cc", (Object[])new Object[0]));
        hintMsgBuilder.append("\r\n");
        hintMsgBuilder.append(ResManager.loadKDString((String)"3\u3001\u53ef\u80fd\u51fa\u73b0\u52a0\u8f7d\u5f02\u5e38\uff0c\u8bf7\u6839\u636e\u65e5\u5fd7\u5904\u7406\u3002", (String)"NewResourcePlugin_5", (String)"imsc-cc", (Object[])new Object[0]));
        return hintMsgBuilder.toString();
    }

    public void afterDoOperation(AfterDoOperationEventArgs afterDoOperationEventArgs) {
        if (afterDoOperationEventArgs.getOperateKey().equals(OPERATION_KEY_INSTALL)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(ENTITY_LOAD_PACKAGE);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_KEY_LOAD_PACKAGE));
            formShowParameter.getOpenStyle().setShowType(ShowType.MainNewTabPage);
            ContentDetailModel detailModel = this.getResourceInfo();
            if (detailModel == null) {
                return;
            }
            String packStr = detailModel.getpInfoContent();
            List contentList = null;
            if (!kd.bos.util.StringUtils.isEmpty((String)packStr)) {
                Map mapData = (Map)SerializationUtils.fromJsonString((String)packStr, Map.class);
                contentList = (List)mapData.get("files");
            }
            Map<String, Object> prams = ResourceListProxy.getLoadParam(detailModel.getPkgName(), detailModel.getVersion(), detailModel.getPkgNumber(), contentList);
            formShowParameter.setCustomParams(prams);
            this.getView().showForm(formShowParameter);
        } else if (afterDoOperationEventArgs.getOperateKey().equals(OPERATION_KEY_SCORE)) {
            FormShowParameter formShowParameter = new FormShowParameter();
            formShowParameter.setFormId(ENTITY_RESOURCE_SCORE);
            formShowParameter.setCloseCallBack(new CloseCallBack((IFormPlugin)this, CALLBACK_KEY_RESOURCE_SCORE));
            formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
            ContentDetailModel detailModel = this.getResourceInfo();
            if (detailModel != null) {
                HashMap<String, String> prams = new HashMap<String, String>(12);
                prams.put("form_key_billno", detailModel.getPkgNumber());
                formShowParameter.setCustomParams(prams);
                this.getView().showForm(formShowParameter);
            }
        } else if (afterDoOperationEventArgs.getOperateKey().equals("uncollect") || afterDoOperationEventArgs.getOperateKey().equals("collect")) {
            this.getView().updateView();
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent messageBoxClosedEvent) {
        if ("uncollect".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            OperateOption operateOption = OperateOption.create();
            String params = messageBoxClosedEvent.getCustomVaule();
            Map map = (Map)SerializationUtils.fromJsonString((String)params, Map.class);
            operateOption.setVariableValue("contentNumber", (String)map.get("contentNumber"));
            operateOption.setVariableValue("isCollect", "false");
            operateOption.setVariableValue("isAfterConfirm", "true");
            this.getView().invokeOperation("uncollect", operateOption);
        } else if ("cancelcollect".equals(messageBoxClosedEvent.getCallBackId()) && messageBoxClosedEvent.getResult() == MessageBoxResult.Yes) {
            String params = messageBoxClosedEvent.getCustomVaule();
            Map map = (Map)SerializationUtils.fromJsonString((String)params, Map.class);
            boolean isSuccess = CollectHelper.collect((String)map.get("contentNumber"), RequestContext.get().getCurrUserId(), false);
            if (isSuccess) {
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u53d6\u6d88\u6536\u85cf\u6210\u529f\u3002", (String)"NewResourcePlugin_8", (String)"imsc-cc", (Object[])new Object[0]));
            }
            this.getView().invokeOperation("refresh");
        }
    }

    public void closedCallBack(ClosedCallBackEvent closedCallBackEvent) {
        Map data;
        boolean submitSuccess;
        Object returnData;
        String actionId = closedCallBackEvent.getActionId();
        if (!actionId.equals(CALLBACK_KEY_LOAD_PACKAGE) && actionId.equals(CALLBACK_KEY_RESOURCE_SCORE) && (returnData = closedCallBackEvent.getReturnData()) instanceof Map && (submitSuccess = Boolean.parseBoolean((data = (Map)returnData).get("submitSuccess").toString()))) {
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u63d0\u4ea4\u6210\u529f\u3002", (String)"NewResourcePlugin_9", (String)"imsc-cc", (Object[])new Object[0]));
        }
    }

    public void beforeClosed(BeforeClosedEvent e) {
        e.setCheckDataChange(false);
    }

    public void registerListener(EventObject e) {
        EntryGrid entryGrid = (EntryGrid)this.getControl("entryentity");
        entryGrid.addRowClickListener((RowClickEventListener)this);
        Image image = (Image)this.getControl("picture");
        image.addClickListener((ClickListener)this);
        this.addClickListeners(new String[]{"collectpic", "uncollectpic"});
    }

    public void entryRowClick(RowClickEvent evt) {
        this.getPageCache().put(CACHE_KEY_INDEX, SerializationUtils.toJsonString((Object)evt.getRow()));
    }

    private int getCurRowIndex() {
        int value = -1;
        String content = this.getPageCache().get(CACHE_KEY_INDEX);
        if (!kd.bos.util.StringUtils.isBlank((String)content)) {
            value = (Integer)SerializationUtils.fromJsonString((String)content, Integer.class);
        }
        return value;
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        block22: {
            FormOperate formOperate = (FormOperate)args.getSource();
            String operateKey = formOperate.getOperateKey();
            if ("previewfile".equals(operateKey)) {
                int index = this.getCurRowIndex();
                if (index < 0) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u672a\u9009\u4e2d\u884c\u3002", (String)"NewResourcePlugin_10", (String)"imsc-cc", (Object[])new Object[0]));
                    args.setCancel(true);
                    return;
                }
                String sourceName = this.getModel().getValue("sourcename", index).toString();
                if (kd.bos.util.StringUtils.isEmpty((String)sourceName) || !sourceName.endsWith(".xlsx")) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u4ec5\u652f\u6301\u9884\u89c8xlsx\u683c\u5f0f\u7684Excel\u6587\u4ef6\u3002", (String)"NewResourcePlugin_11", (String)"imsc-cc", (Object[])new Object[0]));
                    return;
                }
                boolean isDataEncrypt = (Boolean)this.getModel().getValue("dataencrypt", index);
                if (isDataEncrypt) {
                    this.getView().showTipNotification(ResManager.loadKDString((String)"\u5185\u5bb9\u5305\u6570\u636e\u52a0\u5bc6\uff0c\u65e0\u6cd5\u9884\u89c8\u3002", (String)"NewResourcePlugin_12", (String)"imsc-cc", (Object[])new Object[0]));
                    return;
                }
                DataPackageInputModel model = this.getDataPackageInputModel();
                FormShowParameter formShowParameter = new FormShowParameter();
                formShowParameter.setFormId("cc_excelpreview");
                formShowParameter.getOpenStyle().setShowType(ShowType.Modal);
                formShowParameter.setCustomParam("c_c_i", (Object)JSONObject.toJSONString((Object)model));
                formShowParameter.setCustomParam("p_f_n", (Object)sourceName);
                this.getView().showForm(formShowParameter);
            } else if (OPERATION_KEY_INSTALL.equals(operateKey)) {
                try {
                    String version;
                    String[] langs;
                    String number = this.getModel().getValue("billno").toString();
                    if (kd.bos.util.StringUtils.isEmpty((String)number)) {
                        throw new KdXkIprmException(ResManager.loadKDString((String)"\u5185\u5bb9\u5305\u7f16\u7801\u4e3a\u7a7a\uff0c\u8bf7\u63d0\u4ea4\u8bc4\u4ef7\u53cd\u9988\u6216\u7a0d\u540e\u518d\u8bd5\u3002", (String)"NewResourcePlugin_13", (String)"imsc-cc", (Object[])new Object[0]), 1001);
                    }
                    ContentDetailModel dataMap = this.getInfoData(number);
                    if (null == dataMap) {
                        throw new KdXkIprmException(ResManager.loadKDString((String)"\u5185\u5bb9\u5305\u8be6\u60c5\u67e5\u8be2\u4e3a\u7a7a\uff0c\u8bf7\u63d0\u4ea4\u8bc4\u4ef7\u53cd\u9988\u6216\u7a0d\u540e\u518d\u8bd5\u3002", (String)"NewResourcePlugin_14", (String)"imsc-cc", (Object[])new Object[0]), 1001);
                    }
                    String supportlanguage = dataMap.getSupportlanguage();
                    if (kd.bos.util.StringUtils.isNotEmpty((String)supportlanguage) && !Arrays.asList(langs = supportlanguage.split(",")).contains(RequestContext.get().getLang().getLocale().toString())) {
                        args.setCancel(true);
                        this.getView().showErrorNotification(ContentHelper.getLanguageAuthenTips());
                        return;
                    }
                    List versions = VersionService.getVersionInfos();
                    boolean backwards = dataMap.isBackwards();
                    Optional<Version> constellation = versions.stream().filter(o -> o.getProductNumber().startsWith("constellation_")).findFirst();
                    List starryVersion = dataMap.getStarryVersion().stream().map(o -> o.split("V")[1]).sorted().collect(Collectors.toList());
                    if (!constellation.isPresent() || starryVersion.contains(version = this.removeLastVersion(constellation.get().getVersion()))) break block22;
                    String maxVersion = (String)starryVersion.get(starryVersion.size() - 1);
                    if (!backwards || maxVersion.compareTo(version) > 0) {
                        args.setCancel(true);
                        this.getView().showErrorNotification(ResManager.loadKDString((String)"\u5185\u5bb9\u5305\u4e0d\u9002\u7528\u4e8e\u5f53\u524d\u7cfb\u7edf\u7248\u672c\u3002", (String)"NewResourcePlugin_15", (String)"imsc-cc", (Object[])new Object[0]));
                        return;
                    }
                }
                catch (KdXkIprmException e) {
                    args.setCancel(true);
                    logger.error("\u52a0\u8f7d\u64cd\u4f5c|\u6821\u9a8c\u5f02\u5e38|", (Throwable)e);
                    this.getView().showErrorNotification(e.getMessage());
                }
            } else if (operateKey.equals("uncollect") || operateKey.equals("collect")) {
                String number = this.getModel().getDataEntity().getString("billno");
                switch (operateKey) {
                    case "collect": {
                        formOperate.getOption().setVariableValue("contentNumber", number);
                        formOperate.getOption().setVariableValue("isCollect", "true");
                        break;
                    }
                    case "uncollect": {
                        if (formOperate.getOption().containsVariable("isAfterConfirm")) break;
                        ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener(operateKey, (IFormPlugin)this);
                        HashMap<Integer, String> btnNameMaps = new HashMap<Integer, String>();
                        btnNameMaps.put(MessageBoxResult.Cancel.getValue(), ResManager.loadKDString((String)"\u53d6\u6d88", (String)"NewResourcePlugin_16", (String)"imsc-cc", (Object[])new Object[0]));
                        btnNameMaps.put(MessageBoxResult.Yes.getValue(), ResManager.loadKDString((String)"\u786e\u8ba4", (String)"NewResourcePlugin_17", (String)"imsc-cc", (Object[])new Object[0]));
                        HashMap<String, String> params = new HashMap<String, String>();
                        String contentName = this.getModel().getDataEntity().getString("name");
                        params.put("contentNumber", number);
                        String confirmTip = String.format(ResManager.loadKDString((String)"\u4e91\u5185\u5bb9\u201c%s\u201d\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u53d6\u6d88\u6536\u85cf\uff1f", (String)"NewResourcePlugin_18", (String)"imsc-cc", (Object[])new Object[0]), contentName);
                        this.getView().showConfirm(confirmTip, "", MessageBoxOptions.OKCancel, ConfirmTypes.Default, confirmCallBacks, btnNameMaps, SerializationUtils.toJsonString(params));
                        args.setCancel(true);
                        break;
                    }
                }
            }
        }
    }

    DataPackageInputModel getDataPackageInputModel() {
        Map mapData;
        List contentList;
        ContentDetailModel dataMap = null;
        try {
            dataMap = this.getInfoData(this.getModel().getValue("billno").toString());
        }
        catch (KdXkIprmException E) {
            logger.error((Throwable)E);
        }
        if (dataMap == null || ObjectUtils.isEmpty((Object)dataMap)) {
            logger.error("getDataPackageInputModel dataMap is null. billno : {}", (Object)this.getModel().getValue("billno").toString());
            return null;
        }
        String id = String.valueOf(dataMap.getPkgNumber());
        String name = String.valueOf(dataMap.getPkgName());
        String version = String.valueOf(dataMap.getVersion());
        HashMap<String, String> billNameMap = new HashMap<String, String>();
        String packStr = dataMap.getpInfoContent();
        if (!kd.bos.util.StringUtils.isEmpty((String)packStr) && (contentList = (List)(mapData = (Map)SerializationUtils.fromJsonString((String)packStr, Map.class)).get("files")) != null) {
            for (Map content : contentList) {
                billNameMap.put((String)content.get("fileName"), (String)content.get("businessObjectType"));
            }
        }
        return new DataPackageInputModel.Builder().id(id).name(name).ver(version).objInfoMap(billNameMap).builder();
    }

    private String removeLastVersion(String version) {
        String[] split;
        if (StringUtils.isNotEmpty((CharSequence)version) && (split = version.split("\\.")).length == 4) {
            version = String.join((CharSequence)".", Arrays.copyOf(split, split.length - 1));
        }
        return version;
    }
}

