/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imbd.common.utils;

import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import kd.bos.entity.AppInfo;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.list.ListFilterParameter;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.bos.util.StringUtils;

public class F7Utils {
    public static final String STATUS = "status";
    public static final String ENABLE = "enable";

    private F7Utils() {
    }

    public static QFilter getEnableStatus() {
        return new QFilter(ENABLE, "=", (Object)"1");
    }

    public static QFilter getDataStatus() {
        return new QFilter(STATUS, "=", (Object)"C");
    }

    public static void addCustomF7Filter(BeforeF7SelectEvent e, QFilter filter) {
        if (filter == null) {
            return;
        }
        ListShowParameter parameter = (ListShowParameter)e.getFormShowParameter();
        parameter.setFormId("bos_listf7");
        parameter.getListFilterParameter().getQFilters().add(filter);
    }

    public static QFilter getEnableFilter() {
        return new QFilter(ENABLE, "=", (Object)"1");
    }

    public static QFilter getCommonStatusFilter() {
        QFilter fs = new QFilter(STATUS, "=", (Object)"C");
        fs.and(ENABLE, "=", (Object)"1");
        return fs;
    }

    public static QFilter getEveFalseFilter() {
        return QFilter.of((String)"1 != 1", (Object[])new Object[0]);
    }

    public static String getSelectCols(List<String> cols) {
        if (cols == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        int len = cols.size();
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(cols.get(i));
        }
        return sb.toString();
    }

    public static String getSelectCols(String ... cols) {
        if (cols == null) {
            return null;
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < cols.length; ++i) {
            if (i > 0) {
                sb.append(',');
            }
            sb.append(cols[i]);
        }
        return sb.toString();
    }

    public static String appendSelectCols(String exsistCols, String ... cols) {
        String selects = F7Utils.getSelectCols(cols);
        if (StringUtils.isEmpty((String)exsistCols)) {
            return selects;
        }
        if (StringUtils.isEmpty((String)selects)) {
            return exsistCols;
        }
        return exsistCols + "," + selects;
    }

    public static void addF7Filter(BeforeF7SelectEvent evt, QFilter qFilter) {
        if (evt != null && qFilter != null) {
            F7Utils.getFilter(evt).getQFilters().add(qFilter);
        }
    }

    public static void addF7Filter(BeforeF7SelectEvent evt, List<QFilter> qFilters) {
        F7Utils.getFilter(evt).getQFilters().addAll(qFilters);
    }

    public static void addEveFalseF7Filter(BeforeF7SelectEvent evt) {
        F7Utils.getFilter(evt).setFilter(F7Utils.getEveFalseFilter());
    }

    public static ListFilterParameter getFilter(BeforeF7SelectEvent evt) {
        return ((ListShowParameter)evt.getFormShowParameter()).getListFilterParameter();
    }

    public static QFilter buildMultiF7QFitler(String multiF7Key, Object multiF7Value) {
        HashSet<Object> multiF7Values = new HashSet<Object>(1);
        multiF7Values.add(multiF7Value);
        return F7Utils.buildMultiF7QFitler(multiF7Key, multiF7Values);
    }

    public static QFilter buildMultiF7QFitler(String multiF7Key, Set<Object> multiF7Values) {
        return new QFilter(String.join((CharSequence)".", multiF7Key, "fbasedataid"), "in", multiF7Values);
    }

    public static QFilter getDataScopeFilter(String appNumber, String entityName, long orgId) {
        long userId = UserServiceHelper.getCurrentUserId();
        AppInfo appInfo = EntityMetadataCache.getAppInfo((String)appNumber);
        String appId = appInfo.getId();
        return PermissionServiceHelper.getDataPermission((long)userId, (String)appId, (String)entityName, Collections.singletonList(orgId));
    }

    public static void setOrgUserF7IncludeAllSub(BeforeF7SelectEvent e) {
        e.getFormShowParameter().setCustomParam("isIncludeAllSub", (Object)Boolean.TRUE);
    }
}

