/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.business.deliveryinitial;

import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.metadata.IDataEntityType;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dlock.DLock;
import kd.bos.entity.MainEntityType;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.DeleteServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.imsc.imic.common.DynamicObjectUtils;
import kd.imsc.imic.common.InitIalSchemeHelper;
import kd.imsc.imic.common.deliveryinitial.ImicProgressunitConstant;
import kd.imsc.imic.deliveryinitial.InitMarkService;
import org.apache.commons.collections4.CollectionUtils;

public class InitMarkServiceImpl
implements InitMarkService {
    public JSONObject resetAction(long schemeId, String dimensionId) {
        return this.markAction(null, schemeId, null, false, dimensionId, null, null, false);
    }

    public JSONObject markComplete(long schemeId, List<Long> initItemIds, Boolean isOrgId, String dimensionId, long userId, Date completeTime) {
        return this.markAction(Boolean.TRUE, schemeId, initItemIds, isOrgId == null ? Boolean.FALSE.booleanValue() : isOrgId.booleanValue(), dimensionId, userId, completeTime, false);
    }

    public JSONObject markUnComplete(long schemeId, List<Long> initItemIds, String dimensionId) {
        return this.markAction(Boolean.FALSE, schemeId, initItemIds, false, dimensionId, null, null, false);
    }

    public Map<Long, JSONObject> batchMarkComplete(long schemeId, List<Long> initItemIds, boolean enableOrg, List<Long> orgIdList, long userId, Date completeTime) {
        if (orgIdList == null || orgIdList.isEmpty()) {
            return new HashMap<Long, JSONObject>(0);
        }
        HashMap<Long, JSONObject> resultMap = new HashMap<Long, JSONObject>(16);
        for (Long orgId : orgIdList) {
            resultMap.put(orgId, this.markAction(Boolean.TRUE, schemeId, initItemIds, enableOrg, orgId.toString(), userId, completeTime, true));
        }
        return resultMap;
    }

    public Map<Long, JSONObject> batchMarkUnComplete(long schemeId, List<Long> initItemIds, List<Long> orgIdList) {
        if (orgIdList == null || orgIdList.isEmpty()) {
            return new HashMap<Long, JSONObject>(0);
        }
        HashMap<Long, JSONObject> resultMap = new HashMap<Long, JSONObject>(16);
        for (Long orgId : orgIdList) {
            resultMap.put(orgId, this.markAction(Boolean.FALSE, schemeId, initItemIds, false, orgId.toString(), null, null, true));
        }
        return resultMap;
    }

    private String getLockId(Object schemeId, String dimensionId) {
        StringBuilder result = new StringBuilder();
        return result.append(InitMarkServiceImpl.class.getName()).append('#').append(schemeId).append('$').append(dimensionId).toString();
    }

    private QFilter[] getProgressUnitFilter(Long schemeId, String dimensionId) {
        return new QFilter[]{new QFilter(ImicProgressunitConstant.dimensiontId, "=", (Object)dimensionId), new QFilter(ImicProgressunitConstant.schemeId, "=", (Object)schemeId)};
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JSONObject markAction(Boolean markCompleted, long schemeId, List<Long> initItemIds, boolean isOrgID, String dimensionId, Long userId, Date completeTime, boolean isBatch) {
        String lockId = this.getLockId(schemeId, dimensionId);
        DLock lock = DLock.create((String)lockId);
        DynamicObject initialScheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"imic_initialscheme");
        if (lock.tryLock()) {
            ArrayList<Long> initItemIdList = new ArrayList<Long>(initItemIds);
            try {
                if (markCompleted == null) {
                    DeleteServiceHelper.delete((String)ImicProgressunitConstant.formId, (QFilter[])this.getProgressUnitFilter(schemeId, dimensionId));
                    JSONObject jSONObject = InitMarkService.SUCCESS();
                    return jSONObject;
                }
                List<DynamicObject> progressesInDB = InitIalSchemeHelper.getProgressUnits(schemeId, dimensionId);
                ArrayList<Long> toBeRemovePUId = new ArrayList<Long>(10);
                ArrayList<Long> entryDetailList = new ArrayList<Long>(10);
                for (DynamicObject progress : progressesInDB) {
                    long schemeEntryDetailId = DynamicObjectUtils.getPkValue(progress.getDynamicObject(ImicProgressunitConstant.schemeEntryDetailId));
                    if (initItemIdList.contains(schemeEntryDetailId)) {
                        toBeRemovePUId.add(progress.getLong("id"));
                    }
                    entryDetailList.add(schemeEntryDetailId);
                }
                MainEntityType progressUnitDt = MetadataServiceHelper.getDataEntityType((String)ImicProgressunitConstant.formId);
                if (markCompleted.booleanValue()) {
                    Collection existsList = CollectionUtils.intersection(initItemIdList, entryDetailList);
                    if (!isBatch && !existsList.isEmpty()) {
                        String name = this.getEntryTaskName(existsList, initialScheme);
                        JSONObject jSONObject = InitMarkService.FAIL((String)String.format(ResManager.loadKDString((String)"%1$s\u4efb\u52a1\u5df2\u7ecf\u88ab\u6807\u8bb0\uff0c", (String)"InitMarkServiceImpl_0", (String)"imsc-imic-platform", (Object[])new Object[0]), name));
                        return jSONObject;
                    }
                    if (isBatch) {
                        initItemIdList.removeAll(existsList);
                    }
                    progressesInDB.forEach(p -> {
                        p.set(ImicProgressunitConstant.lastCompleted, (Object)Boolean.FALSE);
                        p.set(ImicProgressunitConstant.completedItems, (Object)0);
                    });
                    SaveServiceHelper.save((DynamicObject[])progressesInDB.toArray(new DynamicObject[0]));
                    int completedItems = progressesInDB.size();
                    ArrayList<DynamicObject> progressList = new ArrayList<DynamicObject>(10);
                    for (int i = 0; i < initItemIdList.size(); ++i) {
                        DynamicObject progress = new DynamicObject((DynamicObjectType)progressUnitDt);
                        progress.set(ImicProgressunitConstant.schemeId, (Object)schemeId);
                        progress.set(ImicProgressunitConstant.schemeEntryDetailId, initItemIdList.get(i));
                        progress.set(ImicProgressunitConstant.dimensiontId, (Object)dimensionId);
                        if (isOrgID) {
                            progress.set(ImicProgressunitConstant.orgId, (Object)Long.valueOf(dimensionId));
                        }
                        progress.set(ImicProgressunitConstant.completeUser, (Object)userId);
                        progress.set(ImicProgressunitConstant.completeTime, (Object)completeTime);
                        if (i == initItemIdList.size() - 1) {
                            progress.set(ImicProgressunitConstant.completedItems, (Object)(completedItems + initItemIdList.size()));
                            progress.set(ImicProgressunitConstant.lastCompleted, (Object)Boolean.TRUE);
                        } else {
                            progress.set(ImicProgressunitConstant.completedItems, (Object)0);
                            progress.set(ImicProgressunitConstant.lastCompleted, (Object)Boolean.FALSE);
                        }
                        progressList.add(progress);
                    }
                    SaveServiceHelper.save((DynamicObject[])progressList.toArray(new DynamicObject[0]));
                    JSONObject jSONObject = InitMarkService.SUCCESS();
                    return jSONObject;
                }
                Collection beenRemovedList = CollectionUtils.subtract((Iterable)CollectionUtils.union(entryDetailList, initItemIdList), entryDetailList);
                if (!isBatch && !beenRemovedList.isEmpty()) {
                    String name = this.getEntryTaskName(beenRemovedList, initialScheme);
                    JSONObject progressList = InitMarkService.FAIL((String)String.format(ResManager.loadKDString((String)"%1$s\u4efb\u52a1\u5df2\u7ecf\u88ab\u53d6\u6d88\u6807\u8bb0\uff0c", (String)"InitMarkServiceImpl_1", (String)"imsc-imic-platform", (Object[])new Object[0]), name));
                    return progressList;
                }
                DeleteServiceHelper.delete((IDataEntityType)progressUnitDt, (Object[])toBeRemovePUId.toArray());
                progressesInDB = InitIalSchemeHelper.getProgressUnits(schemeId, dimensionId);
                for (int i = 0; i < progressesInDB.size(); ++i) {
                    DynamicObject progress = progressesInDB.get(i);
                    if (i == progressesInDB.size() - 1) {
                        progress.set(ImicProgressunitConstant.completedItems, (Object)progressesInDB.size());
                        progress.set(ImicProgressunitConstant.lastCompleted, (Object)Boolean.TRUE);
                        continue;
                    }
                    progress.set(ImicProgressunitConstant.completedItems, (Object)0);
                    progress.set(ImicProgressunitConstant.lastCompleted, (Object)Boolean.FALSE);
                }
                SaveServiceHelper.save((DynamicObject[])progressesInDB.toArray(new DynamicObject[0]));
                JSONObject jSONObject = InitMarkService.SUCCESS();
                return jSONObject;
            }
            finally {
                lock.unlock();
            }
        }
        return InitMarkService.FAIL((String)String.format(ResManager.loadKDString((String)"\u9501\u7533\u8bf7\u5931\u8d25\uff1a%1$s\u3002", (String)"InitMarkServiceImpl_2", (String)"imsc-imic-platform", (Object[])new Object[0]), lockId));
    }

    private String getEntryTaskName(Collection<Long> ids, DynamicObject initialScheme) {
        StringBuilder name = new StringBuilder("[");
        DynamicObjectCollection itemGroupEntries = initialScheme.getDynamicObjectCollection("itemgroup");
        for (DynamicObject itemGroup : itemGroupEntries) {
            DynamicObjectCollection initEntries = (DynamicObjectCollection)itemGroup.get("imic_initentry_items");
            for (DynamicObject initEntry : initEntries) {
                if (!ids.contains(initEntry.getLong("id"))) continue;
                name.append(initEntry.getString("itemname")).append(',');
            }
        }
        name.deleteCharAt(name.length() - 1);
        name.append(']');
        return name.toString();
    }
}

