/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.business.deliveryinitial;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.google.common.collect.Sets;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.Algo;
import kd.bos.algo.DataSet;
import kd.bos.algo.DataSetBuilder;
import kd.bos.algo.DataType;
import kd.bos.algo.Field;
import kd.bos.algo.JoinType;
import kd.bos.algo.Row;
import kd.bos.algo.RowMeta;
import kd.bos.dataentity.Tuple;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.imsc.imic.common.CommonUtil;
import kd.imsc.imic.common.deliveryinitial.ImicProgressunitConstant;
import kd.imsc.imic.deliveryinitial.InitProgressQueryService;

public class InitProgressQueryServiceImpl
implements InitProgressQueryService {
    private static final String algoKey = "kd.imsc.imic.business.deliveryinitial.InitProgressQueryServiceImpl";

    public JSONObject querySingleSchemeProgress(long schemeId, String dimension, boolean mustSet) {
        JSONArray jsonArray = this.batchQuerySchemeProgress(Sets.newHashSet((Object[])new Long[]{schemeId}), Sets.newHashSet((Object[])new String[]{dimension}), mustSet);
        if (jsonArray != null && !jsonArray.isEmpty()) {
            return (JSONObject)jsonArray.get(0);
        }
        return new JSONObject();
    }

    public JSONArray batchQuerySchemeProgress(Set<Long> schemeIds, Set<String> dimension, boolean mustSet) {
        if (CommonUtil.isNull(schemeIds)) {
            return null;
        }
        DataSet querySchemeProgressDataSet = InitProgressQueryServiceImpl.getQuerySchemeProgressDataSet(schemeIds, dimension, mustSet, null);
        JSONArray querySchemeProgressArray = new JSONArray();
        Iterator iterator = querySchemeProgressDataSet.iterator();
        while (iterator.hasNext()) {
            Row row = (Row)iterator.next();
            BigDecimal completedItems = new BigDecimal(row.getInteger("completeditems"));
            BigDecimal allitem = new BigDecimal(row.getInteger("allitem"));
            BigDecimal percent = BigDecimal.ZERO;
            if (allitem.compareTo(BigDecimal.ZERO) == 0) {
                iterator.remove();
            } else {
                percent = completedItems.divide(allitem, 4, RoundingMode.HALF_UP);
            }
            HashMap<String, Object> schemeProgressMap = new HashMap<String, Object>(8);
            schemeProgressMap.put("initialscheme", row.get("initialscheme"));
            schemeProgressMap.put("dimension", row.get("dimension"));
            schemeProgressMap.put("completeditems", row.get("completeditems"));
            schemeProgressMap.put("allitem", row.get("allitem"));
            schemeProgressMap.put("initprogress", percent);
            schemeProgressMap.put("completeduser", row.get("completeduser"));
            schemeProgressMap.put("completedtime", row.get("completedtime"));
            querySchemeProgressArray.add((Object)new JSONObject(schemeProgressMap));
        }
        return querySchemeProgressArray;
    }

    public static DataSet getQuerySchemeProgressDataSet(Set<Long> schemeIds, Set<String> dimensionIds, boolean mustSet, QFilter otherCondiFilter) {
        QFilter qFilter = new QFilter("enable", "=", (Object)Character.valueOf('1'));
        if (schemeIds != null) {
            qFilter.and(new QFilter("id", "in", schemeIds));
        }
        if (otherCondiFilter != null) {
            qFilter.and(otherCondiFilter);
        }
        DynamicObject[] schemeDbjs = BusinessDataServiceHelper.load((String)"imic_initialscheme", (String)"id,usedimension,isalluse,dimensiontype", (QFilter[])new QFilter[]{qFilter});
        String dimensionBaseNumber = null;
        HashMap<Long, Tuple<String, Boolean>> dimensionMap = new HashMap<Long, Tuple<String, Boolean>>(8);
        ArrayList<Long> noDimensionList = new ArrayList<Long>(16);
        for (DynamicObject schemeDbj : schemeDbjs) {
            long schemeId = schemeDbj.getLong("id");
            if (!schemeDbj.getBoolean("usedimension")) {
                noDimensionList.add(schemeId);
                continue;
            }
            DynamicObject dimensionType = schemeDbj.getDynamicObject("dimensiontype");
            if (dimensionType == null) continue;
            String dimensionTypeNumber = dimensionType.getString("number");
            if (dimensionBaseNumber == null) {
                dimensionBaseNumber = dimensionTypeNumber;
            } else if (!dimensionBaseNumber.equals(dimensionTypeNumber)) {
                throw new KDBizException(ResManager.loadKDString((String)"\u6279\u91cf\u67e5\u8be2\u4e2d\u4e0d\u652f\u6301\u67e5\u8be2\u5206\u914d\u7ef4\u5ea6\u4e0d\u4e00\u6837\u7684\u65b9\u6848\u3002", (String)"InitProgressQueryServiceImpl_0", (String)"imsc-imic-platform", (Object[])new Object[0]));
            }
            boolean globalShare = schemeDbj.getBoolean("isalluse");
            dimensionMap.put(schemeId, (Tuple<String, Boolean>)new Tuple((Object)dimensionTypeNumber, (Object)globalShare));
        }
        DataSet queryDataSet = null;
        if (dimensionMap.size() != 0) {
            queryDataSet = InitProgressQueryServiceImpl.getDimensionDataSet(dimensionMap, dimensionIds, mustSet);
        } else if (!noDimensionList.isEmpty()) {
            queryDataSet = InitProgressQueryServiceImpl.getNoDimensionDataSet(noDimensionList, mustSet);
        }
        if (queryDataSet == null) {
            queryDataSet = InitProgressQueryServiceImpl.getNullProgressDataSet();
        }
        return queryDataSet;
    }

    private static DataSet getNoDimensionDataSet(List<Long> noDimensionSchemeList, boolean mustSet) {
        DataSet queryDataSet = null;
        for (Long schemeId : noDimensionSchemeList) {
            DataSet progresUnitDataSet = InitProgressQueryServiceImpl.getProgresUnitDataSet(schemeId);
            if (queryDataSet == null) {
                queryDataSet = progresUnitDataSet;
                continue;
            }
            queryDataSet.union(progresUnitDataSet);
        }
        return queryDataSet;
    }

    private static DataSet getDimensionDataSet(Map<Long, Tuple<String, Boolean>> dimensionMap, Set<String> dimensionIds, boolean mustSet) {
        DataSet queryDataSet = null;
        Set<Map.Entry<Long, Tuple<String, Boolean>>> entries = dimensionMap.entrySet();
        for (Map.Entry<Long, Tuple<String, Boolean>> entry : entries) {
            Long schemeId = entry.getKey();
            Boolean globalShare = (Boolean)entry.getValue().item2;
            String entityId = (String)entry.getValue().item1;
            DataSet dimensionDataSet = null;
            if (globalShare.booleanValue()) {
                QFilter dimensionFilter = null;
                if (dimensionIds != null) {
                    dimensionFilter = new QFilter("id", "in", dimensionIds.stream().map(Long::parseLong).collect(Collectors.toList()));
                }
                dimensionDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)entityId, (String)"tochar(id) as dimension", (QFilter[])new QFilter[]{dimensionFilter}, null);
                dimensionDataSet = dimensionDataSet.addField(String.valueOf(schemeId), "initialscheme");
            } else {
                QFilter schemeFilter = new QFilter("initialscheme", "=", (Object)schemeId);
                if (dimensionIds != null) {
                    schemeFilter.and(new QFilter("dimension", "in", dimensionIds));
                }
                dimensionDataSet = QueryServiceHelper.queryDataSet((String)algoKey, (String)"imic_assignrecord", (String)String.join((CharSequence)",", "initialscheme", "dimension as dimension"), (QFilter[])new QFilter[]{schemeFilter}, null);
            }
            DataSet progresUnitDataSet = InitProgressQueryServiceImpl.getProgresUnitDataSet(schemeId);
            DataSet completedItemDataSet = dimensionDataSet.join(progresUnitDataSet, JoinType.LEFT).on("dimension", "dimension").select(new String[]{"initialscheme", "dimension"}, new String[]{"completeduser", "completedtime", "completeditems", "allitem", "completedMustItems", "allmustitem"}).finish();
            if (queryDataSet == null) {
                queryDataSet = completedItemDataSet;
                continue;
            }
            queryDataSet = queryDataSet.union(completedItemDataSet);
        }
        return queryDataSet;
    }

    private static DataSet getNullProgressDataSet() {
        return QueryServiceHelper.queryDataSet((String)algoKey, (String)"imic_initialscheme", (String)"0 as initialscheme,' ' as dimension,0 as initmustprogress,0 as initprogress,0 as completeduser,0 as completeditems,0 as allitem, 0 as completedtime,0 as allmustitem, 0 as completedMustItems", (QFilter[])new QFilter[]{new QFilter("1", "!=", (Object)1)}, null);
    }

    private static DataSet getProgresUnitDataSet(long schemeId) {
        ArrayList<Field> fieldList = new ArrayList<Field>();
        fieldList.add(new Field("initialscheme", (DataType)DataType.LongType));
        fieldList.add(new Field("dimension", (DataType)DataType.StringType));
        fieldList.add(new Field("completeduser", (DataType)DataType.LongType));
        fieldList.add(new Field("completedtime", (DataType)DataType.TimestampType));
        fieldList.add(new Field("completeditems", (DataType)DataType.IntegerType));
        fieldList.add(new Field("allitem", (DataType)DataType.IntegerType));
        fieldList.add(new Field("completedMustItems", (DataType)DataType.IntegerType));
        fieldList.add(new Field("allmustitem", (DataType)DataType.IntegerType));
        RowMeta rowMeta = new RowMeta(fieldList.toArray(new Field[fieldList.size()]));
        DataSetBuilder dataSetBuilder = Algo.create((String)"RulesParamData").createDataSetBuilder(rowMeta);
        String selectFields = String.join((CharSequence)",", ImicProgressunitConstant.schemeId, ImicProgressunitConstant.dimensiontId, ImicProgressunitConstant.completeUser, ImicProgressunitConstant.completeTime, ImicProgressunitConstant.completedItems, ImicProgressunitConstant.lastCompleted, ImicProgressunitConstant.schemeEntryDetailId, ImicProgressunitConstant.initconfigmustset, ImicProgressunitConstant.initentryitemsid, "initialscheme.usedimension", "initialscheme.itemgroup.imic_initentry_items.itemenabled");
        QFilter filter = new QFilter(ImicProgressunitConstant.schemeId, "=", (Object)schemeId);
        DynamicObjectCollection progressColl = QueryServiceHelper.query((String)ImicProgressunitConstant.formId, (String)selectFields, (QFilter[])filter.toArray());
        long completedUser = 0L;
        Date completedTime = null;
        String dimensiontId = "";
        Set<Object> finishDetailIdSet = new HashSet(16);
        Set<Object> finishMustDetailIdSet = new HashSet(16);
        Set<Object> allDetailIdSet = new HashSet(16);
        Set<Object> allMustDetailIdSet = new HashSet(16);
        if (!CommonUtil.isNull(progressColl)) {
            Map<String, List<DynamicObject>> progressOrgMap = progressColl.stream().filter(o -> o.getBoolean("initialscheme.itemgroup.imic_initentry_items.itemenabled")).collect(Collectors.groupingBy(o -> o.getString(ImicProgressunitConstant.dimensiontId)));
            for (Map.Entry<String, List<DynamicObject>> mapEntry : progressOrgMap.entrySet()) {
                List<DynamicObject> propressList = mapEntry.getValue();
                DynamicObject progressDynObj = propressList.get(0);
                completedUser = progressDynObj.getLong(ImicProgressunitConstant.completeUser);
                completedTime = progressDynObj.getDate(ImicProgressunitConstant.completeTime);
                if (progressDynObj.getBoolean("initialscheme.usedimension")) {
                    dimensiontId = progressDynObj.getString(ImicProgressunitConstant.dimensiontId);
                }
                finishDetailIdSet = propressList.stream().map(o -> o.getLong(ImicProgressunitConstant.schemeEntryDetailId)).collect(Collectors.toSet());
                finishMustDetailIdSet = propressList.stream().filter(o -> o.getBoolean(ImicProgressunitConstant.initconfigmustset) && o.getLong(ImicProgressunitConstant.schemeEntryDetailId) == o.getLong(ImicProgressunitConstant.initentryitemsid)).map(o -> o.getLong(ImicProgressunitConstant.schemeEntryDetailId)).collect(Collectors.toSet());
                allDetailIdSet = propressList.stream().map(o -> o.getLong(ImicProgressunitConstant.initentryitemsid)).collect(Collectors.toSet());
                allMustDetailIdSet = propressList.stream().filter(o -> o.getBoolean(ImicProgressunitConstant.initconfigmustset)).map(o -> o.getLong(ImicProgressunitConstant.initentryitemsid)).collect(Collectors.toSet());
                List list = propressList.stream().filter(o -> o.getBoolean(ImicProgressunitConstant.lastCompleted)).collect(Collectors.toList());
                if (!CommonUtil.isNull(list)) {
                    completedUser = ((DynamicObject)list.get(0)).getLong(ImicProgressunitConstant.completeUser);
                    completedTime = ((DynamicObject)list.get(0)).getDate(ImicProgressunitConstant.completeTime);
                }
                dataSetBuilder.append(new Object[]{schemeId, dimensiontId, completedUser, completedTime, finishDetailIdSet.size(), allDetailIdSet.size(), finishMustDetailIdSet.size(), allMustDetailIdSet.size()});
            }
        } else {
            dataSetBuilder.append(new Object[]{schemeId, dimensiontId, completedUser, completedTime, finishDetailIdSet.size(), allDetailIdSet.size(), finishMustDetailIdSet.size(), allMustDetailIdSet.size()});
        }
        return dataSetBuilder.build();
    }
}

