/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.formplugin.initialscheme;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import java.util.ArrayList;
import java.util.EventObject;
import java.util.List;
import java.util.Objects;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.metadata.IDataEntityProperty;
import kd.bos.dataentity.metadata.clr.DataEntityPropertyCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.entity.property.BasedataProp;
import kd.bos.entity.property.EntryProp;
import kd.bos.form.control.Control;
import kd.bos.form.control.FilterGrid;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.imsc.imbd.formplugin.tpl.ImbdDymicTplEditPlugin;
import kd.imsc.imic.common.FilterGridUtil;
import kd.imsc.imic.common.StringUtils;

public class ImicSchemeDataJudgeBasis
extends ImbdDymicTplEditPlugin {
    private static final Log log = LogFactory.getLog(ImicSchemeDataJudgeBasis.class);
    private static final String QUERY_ENTITY = "queryentity";
    private static final String QUERYBOUNDFIELD = "queryboundfield";
    private static final String ISQUERYINITITEMHASDATA = "isqueryinititemhasdata";
    private static final String ISBDCTRLSTRTGQUERYHASDATA = "isbdctrlstrtgqueryhasdata";
    private static final String CUSTOMIZE_CONFIG = "customizeconfig";
    private static final String INTERFACE_CONFIG = "interfaceconfig";
    private static final Pattern PATTERN = Pattern.compile("msvc://\\w+\\.\\w+\\.\\w+\\.\\w+");

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{"btnok"});
    }

    public void afterCreateNewData(EventObject e) {
        String conditionJson = (String)this.getView().getFormShowParameter().getCustomParam("conditionJson");
        if (StringUtils.isNotBlank(conditionJson)) {
            String queryBoundField;
            String queryEntity;
            JSONObject paramJson = JSON.parseObject((String)conditionJson);
            Boolean isQueryHasData = paramJson.getBoolean(ISQUERYINITITEMHASDATA);
            if (isQueryHasData == null) {
                this.getModel().setValue(ISQUERYINITITEMHASDATA, (Object)Boolean.TRUE);
            } else {
                this.getModel().setValue(ISQUERYINITITEMHASDATA, (Object)isQueryHasData);
            }
            Boolean isBdCtrlstrtgyHasData = paramJson.getBoolean(ISBDCTRLSTRTGQUERYHASDATA);
            if (isBdCtrlstrtgyHasData == null) {
                this.getModel().setValue(ISBDCTRLSTRTGQUERYHASDATA, (Object)Boolean.FALSE);
            } else {
                this.getModel().setValue(ISBDCTRLSTRTGQUERYHASDATA, (Object)isBdCtrlstrtgyHasData);
            }
            Boolean customizeConfig = paramJson.getBoolean(CUSTOMIZE_CONFIG);
            this.getModel().setValue(CUSTOMIZE_CONFIG, (Object)customizeConfig);
            String interfaceConfig = paramJson.getString(INTERFACE_CONFIG);
            if (StringUtils.isNotBlank(interfaceConfig)) {
                this.getModel().setValue(INTERFACE_CONFIG, (Object)interfaceConfig);
            }
            if (StringUtils.isNotBlank(queryEntity = paramJson.getString(QUERY_ENTITY))) {
                this.getModel().setValue(QUERY_ENTITY, (Object)queryEntity);
            }
            if (StringUtils.isNotBlank(queryBoundField = paramJson.getString(QUERYBOUNDFIELD))) {
                this.getModel().setValue(QUERYBOUNDFIELD, (Object)queryBoundField);
            }
        }
    }

    public void beforeBindData(EventObject e) {
        DynamicObject entity;
        JSONObject paramJson;
        String queryEntity;
        super.beforeBindData(e);
        String entityNumber = (String)this.getView().getFormShowParameter().getCustomParam("initItemNumber");
        String conditionJson = (String)this.getView().getFormShowParameter().getCustomParam("conditionJson");
        if (StringUtils.isNotBlank(conditionJson) && StringUtils.isNotBlank(queryEntity = (paramJson = JSON.parseObject((String)conditionJson)).getString(QUERY_ENTITY))) {
            entityNumber = queryEntity;
        }
        if ((entity = (DynamicObject)this.getModel().getValue(QUERY_ENTITY)) != null) {
            entityNumber = entity.getString("number");
        }
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        FilterGridUtil.setFilterControl(entityNumber, filterGrid);
        String dimensionNumber = (String)this.getView().getFormShowParameter().getCustomParam("dimensionNumber");
        if (StringUtils.isNotBlank(dimensionNumber)) {
            this.setQueryBindField(entityNumber);
        } else {
            this.getView().setVisible(Boolean.FALSE, new String[]{ISBDCTRLSTRTGQUERYHASDATA, QUERYBOUNDFIELD});
        }
    }

    public void afterBindData(EventObject e) {
        String conditionJson = (String)this.getView().getFormShowParameter().getCustomParam("conditionJson");
        String queryEntity = (String)this.getView().getFormShowParameter().getCustomParam("initItemNumber");
        String filterConditionJson = null;
        if (StringUtils.isNotBlank(conditionJson)) {
            JSONObject paramJson = JSON.parseObject((String)conditionJson);
            String queryEntityJson = paramJson.getString(QUERY_ENTITY);
            if (StringUtils.isNotBlank(queryEntityJson)) {
                queryEntity = queryEntityJson;
            }
            filterConditionJson = paramJson.getString("filtercondition");
        }
        DynamicObject formQueryEntity = (DynamicObject)this.getModel().getValue(QUERY_ENTITY);
        FilterGrid filterGrid = (FilterGrid)this.getView().getControl("filtergridap");
        if (formQueryEntity != null && !StringUtils.equals(queryEntity, formQueryEntity.getString("number"))) {
            filterGrid.SetValue(new FilterCondition());
            return;
        }
        FilterCondition filterCondition = null;
        if (StringUtils.isNotBlank(filterConditionJson)) {
            filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterConditionJson, FilterCondition.class);
        }
        if (filterCondition != null) {
            filterGrid.SetValue(filterCondition);
        }
        super.afterBindData(e);
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String key = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        Object newValue = changeSet[0].getNewValue();
        if (StringUtils.equals(key, QUERY_ENTITY)) {
            this.getModel().setValue(ISBDCTRLSTRTGQUERYHASDATA, (Object)Boolean.FALSE);
            String queryEntity = (String)this.getView().getFormShowParameter().getCustomParam("initItemNumber");
            DynamicObject queryEntityDy = (DynamicObject)this.getModel().getValue(QUERY_ENTITY);
            if (Objects.nonNull(queryEntityDy)) {
                queryEntity = queryEntityDy.getString("number");
            }
            this.setQueryBindField(queryEntity);
            this.getView().updateView();
        } else if (StringUtils.equals(key, ISBDCTRLSTRTGQUERYHASDATA)) {
            boolean newValueCtrlstrtg = (Boolean)newValue;
            if (newValueCtrlstrtg) {
                Boolean isCtrlstrtg;
                String dimensionNumber = (String)this.getView().getFormShowParameter().getCustomParam("dimensionNumber");
                if (StringUtils.isBlank(dimensionNumber)) {
                    String tip = ResManager.loadKDString((String)"\u672a\u542f\u7528\u7ef4\u5ea6\u7ba1\u7406\u4e0d\u5141\u8bb8\u6309\u7167\u7ba1\u63a7\u7b56\u7565\u67e5\u8be2\u6709\u65e0\u6570\u636e\uff0c\u8bf7\u6253\u5f00\u542f\u7528\u7ef4\u5ea6\u7ba1\u7406\u5f00\u5173", (String)"ImicSchemeDataJudgeBasis_2", (String)"imsc-imic-platform", (Object[])new Object[0]);
                    this.getView().showTipNotification(tip);
                    this.getModel().initValue(ISBDCTRLSTRTGQUERYHASDATA, (Object)Boolean.FALSE);
                    this.getView().updateView(ISBDCTRLSTRTGQUERYHASDATA);
                    return;
                }
                String queryEntity = (String)this.getView().getFormShowParameter().getCustomParam("initItemNumber");
                DynamicObject queryEntityForm = (DynamicObject)this.getModel().getValue(QUERY_ENTITY);
                if (queryEntityForm != null) {
                    queryEntity = queryEntityForm.getString("number");
                }
                if (Boolean.FALSE.equals(isCtrlstrtg = BaseDataServiceHelper.checkBaseDataCtrl((String)queryEntity))) {
                    String tip = ResManager.loadKDString((String)"\u67e5\u8be2\u5b9e\u4f53\u4e3a\u7a7a\u6216\u4e0d\u662f\u53d7\u63a7\u57fa\u7840\u8d44\u6599\uff0c\u4e0d\u652f\u6301\u6309\u7ba1\u63a7\u7b56\u7565\u67e5\u8be2\u6709\u65e0\u6570\u636e\uff0c\u8bf7\u91cd\u65b0\u9009\u62e9", (String)"ImicSchemeDataJudgeBasis_1", (String)"imsc-imic-platform", (Object[])new Object[0]);
                    this.getView().showTipNotification(tip);
                    this.getModel().initValue(ISBDCTRLSTRTGQUERYHASDATA, (Object)Boolean.FALSE);
                    this.getView().updateView(ISBDCTRLSTRTGQUERYHASDATA);
                } else {
                    this.setQueryBindField("");
                }
            } else {
                String queryEntity = (String)this.getView().getFormShowParameter().getCustomParam("initItemNumber");
                DynamicObject queryEntityDy = (DynamicObject)this.getModel().getValue(QUERY_ENTITY);
                if (Objects.nonNull(queryEntityDy)) {
                    queryEntity = queryEntityDy.getString("number");
                }
                this.setQueryBindField(queryEntity);
            }
        }
    }

    private void setQueryBindField(String entityNumber) {
        ComboEdit comboEdit = (ComboEdit)this.getView().getControl(QUERYBOUNDFIELD);
        ArrayList<ComboItem> keyFieldItems = new ArrayList<ComboItem>(10);
        if (StringUtils.isBlank(entityNumber)) {
            comboEdit.setComboItems(keyFieldItems);
            return;
        }
        MainEntityType entityType = FilterGridUtil.getEntityTypeByFormId(entityNumber);
        if (entityType != null) {
            String dimensionNumber = (String)this.getView().getFormShowParameter().getCustomParam("dimensionNumber");
            this.setAllField(entityType.getProperties(), keyFieldItems, dimensionNumber);
            comboEdit.setComboItems(keyFieldItems);
        }
    }

    private void setAllField(DataEntityPropertyCollection properties, List<ComboItem> keyField, String dimensionNumber) {
        for (IDataEntityProperty property : properties) {
            BasedataProp baseProp;
            if (property instanceof EntryProp) {
                EntryProp p = (EntryProp)property;
                if (StringUtils.isBlank(p.getAlias())) continue;
                DataEntityPropertyCollection entryProperties = p.getDynamicCollectionItemPropertyType().getProperties();
                this.setAllField(entryProperties, keyField, dimensionNumber);
                continue;
            }
            if (!(property instanceof BasedataProp) || !StringUtils.isNotBlank(property.getDisplayName()) || !StringUtils.equals((baseProp = (BasedataProp)property).getBaseEntityId(), dimensionNumber) || !StringUtils.isNotBlank(baseProp.getAlias())) continue;
            LocaleString name = new LocaleString(property.getDisplayName() + "(" + property.getName() + ")");
            keyField.add(new ComboItem(name, property.getName()));
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Control control = (Control)evt.getSource();
        String operateKey = control.getKey();
        if (StringUtils.equals(operateKey, "btnok")) {
            FilterGrid filterGrid;
            FilterGrid.FilterGridState filterGridState;
            FilterCondition condition;
            String queryBoundField;
            DynamicObject queryEntity;
            boolean checkConfig;
            String interfaceConfig = (String)this.getModel().getValue(INTERFACE_CONFIG);
            boolean customizeConfig = (Boolean)this.getModel().getValue(CUSTOMIZE_CONFIG);
            Matcher matcher = PATTERN.matcher(interfaceConfig);
            boolean bl = checkConfig = StringUtils.isBlank(interfaceConfig) || !matcher.find();
            if (customizeConfig && checkConfig) {
                String tips = ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u5fae\u670d\u52a1\u63a5\u53e3\u4e0d\u7b26\u5408\u82cd\u7a79\u7aef\u914d\u7f6e\u5fae\u670d\u52a1\u683c\u5f0f\uff0c\u8bf7\u68c0\u67e5\u540e\u91cd\u65b0\u8f93\u5165", (String)"ImicSchemeDataJudgeBasis_3", (String)"imsc-imic-platform", (Object[])new Object[0]);
                this.getView().showTipNotification(tips);
                return;
            }
            JSONObject jsonParamList = new JSONObject();
            boolean isQueryHasData = (Boolean)this.getModel().getValue(ISQUERYINITITEMHASDATA);
            jsonParamList.put(ISQUERYINITITEMHASDATA, (Object)isQueryHasData);
            boolean isBdCtrlstrtgyHasData = (Boolean)this.getModel().getValue(ISBDCTRLSTRTGQUERYHASDATA);
            jsonParamList.put(ISBDCTRLSTRTGQUERYHASDATA, (Object)isBdCtrlstrtgyHasData);
            jsonParamList.put(CUSTOMIZE_CONFIG, (Object)customizeConfig);
            if (StringUtils.isNotBlank(interfaceConfig)) {
                jsonParamList.put(INTERFACE_CONFIG, (Object)interfaceConfig);
            }
            if ((queryEntity = (DynamicObject)this.getModel().getValue(QUERY_ENTITY)) != null) {
                jsonParamList.put(QUERY_ENTITY, queryEntity.getPkValue());
            }
            if ((queryBoundField = (String)this.getModel().getValue(QUERYBOUNDFIELD)) != null) {
                jsonParamList.put(QUERYBOUNDFIELD, (Object)queryBoundField);
            }
            if ((condition = (filterGridState = (filterGrid = (FilterGrid)this.getView().getControl("filtergridap")).getFilterGridState()).getFilterCondition()) != null && !condition.getFilterRow().isEmpty()) {
                jsonParamList.put("filtercondition", (Object)SerializationUtils.toJsonString((Object)condition));
            }
            log.info("\u6570\u636e\u5224\u65ad\u4f9d\u636e\u8fd4\u56de\u65b9\u6848\u7684\u503c\uff1a{}", (Object)jsonParamList);
            if (!jsonParamList.isEmpty()) {
                this.getView().returnDataToParent((Object)jsonParamList);
            }
            this.getView().close();
        }
    }
}

