/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.formplugin.workbench;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.OperateOption;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.dataentity.utils.StringUtils;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.filter.FilterBuilder;
import kd.bos.entity.filter.FilterCondition;
import kd.bos.form.FormMetadataCache;
import kd.bos.form.IFormView;
import kd.bos.form.cardentry.CardEntry;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.Label;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.operate.FormOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.basedata.BaseDataServiceHelper;
import kd.bos.servicehelper.permission.PermissionServiceHelper;
import kd.bos.servicehelper.user.UserServiceHelper;
import kd.imsc.imic.business.deliveryinitial.InitMarkServiceImpl;
import kd.imsc.imic.common.CommonUtil;
import kd.imsc.imic.common.OpenPageUtil;
import kd.imsc.imic.common.pagemodel.ImicInitialscheme;

public class SchemeTaskItemPlugin
extends AbstractFormPlugin
implements CellClickListener {
    private static final Log log = LogFactory.getLog(SchemeTaskItemPlugin.class);
    private static final Pattern PATTERN = Pattern.compile("msvc://(\\w+\\.\\w+\\.\\w+\\.\\w+)");
    private static final String MUST_FINISH_NUM = "must_finish_num";
    private static final String FINISH_NUM = "finish_num";
    private static final String ALL_NUM = "all_num";
    private static final String MUST_ALL_NUM = "must_all_num";
    private static final String CARD_ENTRY = "inititementry_card";
    private static final String MARK_COMPLETE_ID = "3FWRQ6W3J9=V";
    private static final String CANCEL_COMPLETE_ID = "3FWRS3L87R36";
    private static final String IS_CLICK = "isClick";
    private static final String YES = "yes";
    private static final String NO = "no";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        EntryGrid execEntryGrid = (EntryGrid)this.getView().getControl(CARD_ENTRY);
        execEntryGrid.addCellClickListener((CellClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        String allTaskNum = CommonUtil.getStringCustomParamValue(this.getView(), "allTaskNum");
        String finishTaskNum = CommonUtil.getStringCustomParamValue(this.getView(), "finishTaskNum");
        this.getView().getParentView().getPageCache().put("allTaskNum", allTaskNum);
        this.getView().getParentView().getPageCache().put("finishTaskNum", finishTaskNum);
        String stepLabelStr = CommonUtil.getStringCustomParamValue(this.getView(), "step_label");
        String itemQtyLabelStr = CommonUtil.getStringCustomParamValue(this.getView(), "itemqty_label");
        Label stepLabel = (Label)this.getControl("step_label");
        stepLabel.setText(stepLabelStr);
        Label itemqtyLabel = (Label)this.getControl("itemqty_label");
        itemqtyLabel.setText(itemQtyLabelStr);
        JSONArray stepInitEntryList = (JSONArray)this.getView().getFormShowParameter().getCustomParam(CARD_ENTRY);
        String defaultCaliber = (String)this.getView().getFormShowParameter().getCustomParam("defaultcaliber");
        this.getModel().setValue("defaultcaliber", (Object)defaultCaliber);
        if (!CommonUtil.isNull(stepInitEntryList)) {
            DynamicObjectCollection itemEntryColl = this.getModel().getEntryEntity(CARD_ENTRY);
            itemEntryColl.clear();
            int subEntryRow = 1;
            CardEntry cardEntry = (CardEntry)this.getView().getControl(CARD_ENTRY);
            for (Object jsonObj : stepInitEntryList) {
                JSONObject stepInitEntry = (JSONObject)jsonObj;
                DynamicObject itemEntryDynObj = itemEntryColl.addNew();
                itemEntryDynObj.set("seq", (Object)subEntryRow);
                this.setLabelName(cardEntry, "itemname_card", stepInitEntry.getString(ImicInitialscheme.EF_initentry_itemname), stepInitEntry.getString(ImicInitialscheme.EF_initentry_initconfigdescription), subEntryRow - 1);
                itemEntryDynObj.set("mustset", (Object)stepInitEntry.getBoolean(ImicInitialscheme.EF_initentry_initconfigmustset));
                itemEntryDynObj.set("communityurl", (Object)stepInitEntry.getString(ImicInitialscheme.EF_initentry_url));
                itemEntryDynObj.set("initentrytaskid", (Object)stepInitEntry.getLong(ImicInitialscheme.EF_initentry_items_id));
                itemEntryDynObj.set("inititemnum", (Object)stepInitEntry.getString(ImicInitialscheme.EF_inititem_number));
                itemEntryDynObj.set("pageparam", (Object)stepInitEntry.getString("pageparam"));
                ++subEntryRow;
            }
            this.setHasDataVisible(stepInitEntryList);
            HashMap<String, Integer> map = this.countStepCompletion();
            int allNum = "B".equals(defaultCaliber) ? map.get(MUST_ALL_NUM).intValue() : map.get(ALL_NUM).intValue();
            int finishNum = "B".equals(defaultCaliber) ? map.get(MUST_FINISH_NUM).intValue() : map.get(FINISH_NUM).intValue();
            this.setFlexBgColor(finishNum, allNum);
        }
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        boolean isVisible = this.getView().getModel().getEntryRowCount(CARD_ENTRY) > 0;
        this.getView().setVisible(Boolean.valueOf(isVisible), new String[]{"allcancel_label", "allfinish_label"});
        boolean isFinish = CommonUtil.getBooleanCustomParamValue(this.getView(), "isFinish");
        this.getView().setVisible(Boolean.valueOf(isFinish && isVisible), new String[]{"allcancel_label"});
        this.getView().setVisible(Boolean.valueOf(!isFinish && isVisible), new String[]{"allfinish_label"});
        String targetKey = this.getView().getFormShowParameter().getOpenStyle().getTargetKey();
        this.getView().getParentView().setVisible(Boolean.TRUE, new String[]{targetKey});
        this.getView().sendFormAction(this.getView().getParentView());
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        String opKey;
        super.afterDoOperation(args);
        FormOperate op = (FormOperate)args.getSource();
        switch (opKey = op.getOperateKey()) {
            case "allcancel": {
                this.switchCompletionStatus(false, -1);
                break;
            }
            case "allfinish": {
                this.switchCompletionStatus(true, -1);
                break;
            }
        }
    }

    public void cellClick(CellClickEvent evt) {
        String key = evt.getFieldKey();
        int row = evt.getRow();
        switch (key) {
            case "url_icon_card": {
                this.openCommunityDoc(row);
                break;
            }
            case "markcompleted": {
                this.switchCompletionStatus(true, row);
                break;
            }
            case "markuncompleted": {
                this.switchCompletionStatus(false, row);
                break;
            }
            default: {
                String isClick = this.getView().getPageCache().get(IS_CLICK);
                if (StringUtils.isBlank((CharSequence)isClick) || YES.equals(isClick)) {
                    this.openInitItemForm(row);
                    break;
                }
                this.getView().getPageCache().put(IS_CLICK, YES);
            }
        }
    }

    public void cellDoubleClick(CellClickEvent evt) {
    }

    private void openCommunityDoc(int row) {
        String actualUrl = (String)this.getModel().getValue("communityurl", row);
        if (StringUtils.isNotBlank((CharSequence)actualUrl)) {
            this.getView().openUrl(actualUrl);
        }
    }

    private void openInitItemForm(int row) {
        String formNumber = (String)this.getModel().getValue("inititemnum", row);
        if (StringUtils.isNotBlank((CharSequence)formNumber)) {
            String orgId;
            String pageParamStr = (String)this.getModel().getValue("pageparam", row);
            HashMap<String, Object> map = new HashMap<String, Object>(8);
            HashMap<String, String> customParams = new HashMap<String, String>(2);
            if (!StringUtils.isBlank((CharSequence)pageParamStr)) {
                String caption;
                Map pageParam = (Map)SerializationUtils.fromJsonString((String)pageParamStr, Map.class);
                String paramsentry = (String)pageParam.get("paramsentry");
                if (!StringUtils.isBlank((CharSequence)paramsentry)) {
                    Map formParams = (Map)SerializationUtils.fromJsonString((String)paramsentry, Map.class);
                    customParams.putAll(formParams);
                }
                if (StringUtils.isNotBlank((CharSequence)(caption = (String)pageParam.get("caption")))) {
                    customParams.put("caption", caption);
                }
                customParams.put("filtercondition", (String)pageParam.get("filtercondition"));
                map.put("parametertype", pageParam.get("parametertype"));
                map.put("opentype", pageParam.get("opentype"));
            }
            if (StringUtils.isNotBlank((CharSequence)(orgId = CommonUtil.getStringCustomParamValue(this.getView(), "orgid")))) {
                customParams.put("imicdimension_bos_org", orgId);
            }
            map.put("parameter", customParams);
            map.put("view", this.getView());
            map.put("formnumber", formNumber);
            OpenPageUtil.openConfigPage(this.getView().getFormShowParameter().getAppId(), map);
        }
    }

    private void switchCompletionStatus(boolean isComplete, int row) {
        boolean havePermission = this.checkPermission(isComplete);
        if (!havePermission) {
            String msg = isComplete ? ResManager.loadKDString((String)"\u8be5\u7528\u6237\u65e0\u201c\u6807\u8bb0\u5b8c\u6210\u201d\u6743\u9650\u3002", (String)"SchemeTaskItemPlugin_3", (String)"imsc-imic-platform", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u8be5\u7528\u6237\u65e0\u201c\u53d6\u6d88\u6807\u8bb0\u201d\u6743\u9650\u3002", (String)"SchemeTaskItemPlugin_4", (String)"imsc-imic-platform", (Object[])new Object[0]);
            this.getView().showErrorNotification(msg);
            return;
        }
        boolean isModified = this.checkModify();
        if (isModified) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u65b9\u6848\u5df2\u53d1\u751f\u66f4\u6539\uff0c\u8bf7\u9000\u51fa\u91cd\u65b0\u52a0\u8f7d\u3002", (String)"SchemeTaskItemPlugin_5", (String)"imsc-imic-platform", (Object[])new Object[0]));
            return;
        }
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("initialscheme");
        int[] selectRows = new int[]{row};
        if (row == -1) {
            selectRows = this.getSelectRow(isComplete);
        }
        List<Long> itemEntryIdList = this.getItemIdList(selectRows, isComplete);
        boolean isOrgDimension = (Boolean)this.getView().getFormShowParameter().getCustomParam("usedimension");
        String dimensionId = isOrgDimension ? this.getView().getFormShowParameter().getCustomParam("orgid").toString() : (String)this.getView().getFormShowParameter().getCustomParam("bizapp");
        InitMarkServiceImpl initMarkService = new InitMarkServiceImpl();
        JSONObject result = isComplete ? initMarkService.markComplete(schemeId, itemEntryIdList, isOrgDimension, dimensionId, UserServiceHelper.getCurrentUserId(), new Date()) : initMarkService.markUnComplete(schemeId, itemEntryIdList, dimensionId);
        this.afterMark(result, isComplete, selectRows);
    }

    private int[] getSelectRow(boolean isComplete) {
        ArrayList<Integer> rowList = new ArrayList<Integer>(8);
        DynamicObjectCollection itemEntryColl = this.getModel().getEntryEntity(CARD_ENTRY);
        if (itemEntryColl == null) {
            return new int[0];
        }
        for (int i = 0; i < itemEntryColl.size(); ++i) {
            DynamicObject item = (DynamicObject)itemEntryColl.get(i);
            if (isComplete == item.getBoolean("isfinish")) continue;
            rowList.add(i);
        }
        int[] selectRows = new int[rowList.size()];
        for (int i = 0; i < rowList.size(); ++i) {
            selectRows[i] = (Integer)rowList.get(i);
        }
        return selectRows;
    }

    private void afterMark(JSONObject result, boolean isComplete, int[] selectRows) {
        boolean flag = result.getBoolean("flag");
        if (flag) {
            int finishNum;
            String clicklabel = CommonUtil.getStringCustomParamValue(this.getView(), "param_clicklabel");
            DynamicObjectCollection itemEntryCard = this.getModel().getEntryEntity(CARD_ENTRY);
            int finishMustCount = CommonUtil.getIntCustomParamValue(this.getView(), "finishMustTaskNum");
            CardEntry cardEntry = (CardEntry)this.getView().getControl(CARD_ENTRY);
            for (int selectRow : selectRows) {
                DynamicObject card = (DynamicObject)itemEntryCard.get(selectRow);
                if ("all_label".equals(clicklabel)) {
                    card.set("isfinish", (Object)isComplete);
                    cardEntry.setChildVisible(isComplete, selectRow, new String[]{"finish_card"});
                    cardEntry.setChildVisible(!isComplete, selectRow, new String[]{"unfinish_card"});
                    cardEntry.setChildVisible(!isComplete, selectRow, new String[]{"markcompleted"});
                    cardEntry.setChildVisible(isComplete, selectRow, new String[]{"markuncompleted"});
                }
                if (!card.getBoolean("mustset")) continue;
                if (card.getBoolean("isfinish")) {
                    ++finishMustCount;
                    continue;
                }
                --finishMustCount;
            }
            Label itemqtyLabel = (Label)this.getControl("itemqty_label");
            HashMap<String, Integer> map = this.countStepCompletion();
            int mustFinishNum = map.get(MUST_FINISH_NUM);
            int mustAllNum = map.get(MUST_ALL_NUM);
            int allNum = map.get(ALL_NUM);
            boolean isFinish = allNum == (finishNum = map.get(FINISH_NUM).intValue());
            this.getView().setVisible(Boolean.valueOf(isFinish), new String[]{"allcancel_label"});
            this.getView().setVisible(Boolean.valueOf(!isFinish), new String[]{"allfinish_label"});
            String caliber = (String)this.getModel().getValue("defaultcaliber");
            StringBuilder stepLabel = new StringBuilder("(");
            if ("B".equals(caliber)) {
                this.setFlexBgColor(mustFinishNum, mustAllNum);
                stepLabel.append(mustFinishNum).append('/').append(mustAllNum).append(')');
            } else {
                this.setFlexBgColor(finishNum, allNum);
                stepLabel.append(finishNum).append('/').append(allNum).append(')');
            }
            itemqtyLabel.setText(stepLabel.toString());
            HashMap<String, Integer> taskMap = this.countAllCompletion(selectRows.length, isComplete);
            int allTaskNum = taskMap.get("allTaskNum");
            int finishTaskNum = taskMap.get("finishTaskNum");
            this.childRefreshFather(finishTaskNum, allTaskNum, finishMustCount);
            if ("unfinish_label".equals(clicklabel) || "finish_label".equals(clicklabel)) {
                this.getView().getModel().deleteEntryRows(CARD_ENTRY, selectRows);
                this.getView().getPageCache().put(IS_CLICK, NO);
                if (this.getView().getModel().getEntryRowCount(CARD_ENTRY) == 0) {
                    int count = "unfinish_label".equals(clicklabel) ? allTaskNum - finishTaskNum : finishTaskNum;
                    this.getView().getParentView().setVisible(Boolean.valueOf(count > 0), new String[]{"anchorcontrolap"});
                    String targetKey = this.getView().getFormShowParameter().getOpenStyle().getTargetKey();
                    this.getView().getParentView().setVisible(Boolean.FALSE, new String[]{targetKey});
                    this.getView().sendFormAction(this.getView().getParentView());
                }
            }
            String tip = isComplete ? ResManager.loadKDString((String)"\u6807\u8bb0\u6210\u529f\u3002", (String)"SchemeTaskItemPlugin_0", (String)"imsc-imic-platform", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u53d6\u6d88\u6807\u8bb0\u6210\u529f\u3002", (String)"SchemeTaskItemPlugin_1", (String)"imsc-imic-platform", (Object[])new Object[0]);
            this.getView().showSuccessNotification(tip);
        } else {
            String tip = String.format(ResManager.loadKDString((String)"\u6807\u8bb0\u5931\u8d25\uff0c%s\u8bf7\u5237\u65b0\u754c\u9762\u91cd\u8bd5", (String)"SchemeTaskItemPlugin_2", (String)"imsc-imic-platform", (Object[])new Object[0]), result.getString("errorMsg"));
            this.getView().showErrorNotification(tip);
        }
    }

    private boolean checkModify() {
        Long schemeId = (Long)this.getView().getFormShowParameter().getCustomParam("initialscheme");
        String firstModifyTime = CommonUtil.getStringCustomParamValue(this.getView(), "firstmodifytime");
        DynamicObject scheme = BusinessDataServiceHelper.loadSingle((Object)schemeId, (String)"imic_initialscheme");
        String modifyTime = scheme.getString("modifytime");
        return !modifyTime.equals(firstModifyTime);
    }

    private void childRefreshFather(int finishNum, int allNum, int finishMustCount) {
        BigDecimal total = new BigDecimal(allNum);
        BigDecimal complete = new BigDecimal(finishNum);
        OperateOption operateOption = OperateOption.create();
        operateOption.setVariableValue("finishTaskNum", complete.toString());
        operateOption.setVariableValue("allTaskNum", total.toString());
        operateOption.setVariableValue("finishMustTaskNum", String.valueOf(finishMustCount));
        operateOption.setVariableValue("allMustTaskNum", CommonUtil.getStringCustomParamValue(this.getView(), "allMustTaskNum"));
        operateOption.setVariableValue("defaultcaliber", CommonUtil.getStringCustomParamValue(this.getView(), "defaultcaliber"));
        operateOption.setVariableValue("id", this.getView().getFormShowParameter().getCustomParam("initialscheme").toString());
        operateOption.setVariableValue("number", CommonUtil.getStringCustomParamValue(this.getView(), "number"));
        IFormView parentView = this.getView().getParentView();
        parentView.invokeOperation("childrefresh", operateOption);
        this.getView().sendFormAction(parentView);
    }

    private List<Long> getItemIdList(int[] selectRows, boolean isComplete) {
        DynamicObjectCollection cardEntryEntities = this.getModel().getEntryEntity(CARD_ENTRY);
        ArrayList<Long> itemEntryIdList = new ArrayList<Long>(8);
        for (int selectRow : selectRows) {
            if (((DynamicObject)cardEntryEntities.get(selectRow)).getBoolean("isfinish") == isComplete) continue;
            itemEntryIdList.add(((DynamicObject)cardEntryEntities.get(selectRow)).getLong("initentrytaskid"));
        }
        return itemEntryIdList;
    }

    private boolean checkPermission(boolean isComplete) {
        String permissionId;
        long userId = UserServiceHelper.getCurrentUserId();
        long orgId = CommonUtil.getLongCustomParamValue(this.getView(), "orgid");
        boolean isOrgDimension = CommonUtil.getBooleanCustomParamValue(this.getView(), "usedimension");
        String bizAppNum = CommonUtil.getStringCustomParamValue(this.getView(), ImicInitialscheme.F_bizapp_number);
        String initGuide = CommonUtil.getStringCustomParamValue(this.getView(), "initguide");
        String string = permissionId = isComplete ? MARK_COMPLETE_ID : CANCEL_COMPLETE_ID;
        if (StringUtils.isBlank((CharSequence)initGuide)) {
            initGuide = "imic_initguide";
        }
        if (isOrgDimension) {
            int result = PermissionServiceHelper.checkPermission((long)userId, (String)"bos_org", (long)orgId, (String)bizAppNum, (String)initGuide, (String)permissionId);
            return result == 1;
        }
        return PermissionServiceHelper.checkPermission((Long)userId, (String)bizAppNum, (String)initGuide, (String)permissionId);
    }

    private void setFlexBgColor(int finishNum, int allNum) {
        HashMap<String, String> styleMap = new HashMap<String, String>(2);
        if (finishNum == allNum) {
            styleMap.put("bc", "#EFFBF8");
        } else if (finishNum == 0) {
            styleMap.put("bc", "#F9F9F9 ");
        } else {
            styleMap.put("bc", "#F2F7FF");
        }
        this.getView().updateControlMetadata("imic_schemetaskitem", styleMap);
    }

    private HashMap<String, Integer> countStepCompletion() {
        HashMap<String, Integer> map = new HashMap<String, Integer>(2);
        DynamicObjectCollection itemEntryCard = this.getModel().getEntryEntity(CARD_ENTRY);
        int finishNum = 0;
        int allNum = 0;
        int mustAllNum = 0;
        int mustFinishNum = 0;
        for (DynamicObject card : itemEntryCard) {
            ++allNum;
            if (card.getBoolean("isfinish")) {
                ++finishNum;
            }
            if (!card.getBoolean("mustset")) continue;
            ++mustAllNum;
            if (!card.getBoolean("isfinish")) continue;
            ++mustFinishNum;
        }
        map.put(FINISH_NUM, finishNum);
        map.put(ALL_NUM, allNum);
        map.put(MUST_ALL_NUM, mustAllNum);
        map.put(MUST_FINISH_NUM, mustFinishNum);
        return map;
    }

    private HashMap<String, Integer> countAllCompletion(int variableNum, boolean isComplete) {
        HashMap<String, Integer> map = new HashMap<String, Integer>(2);
        int allTaskNum = Integer.parseInt(this.getView().getParentView().getPageCache().get("allTaskNum"));
        int finishTaskNum = Integer.parseInt(this.getView().getParentView().getPageCache().get("finishTaskNum"));
        finishTaskNum = isComplete ? finishTaskNum + variableNum : finishTaskNum - variableNum;
        this.getView().getParentView().getPageCache().put("finishTaskNum", String.valueOf(finishTaskNum));
        map.put("finishTaskNum", finishTaskNum);
        map.put("allTaskNum", allTaskNum);
        return map;
    }

    private void setHasDataVisible(JSONArray stepInitEntryList) {
        int subEntryRow = 0;
        List<Long> progressEntryIdList = CommonUtil.getListCustomParamValue(this.getView(), "progressEntryIdSet");
        DynamicObjectCollection itemEntryCard = this.getModel().getEntryEntity(CARD_ENTRY);
        for (Object jsonObj : stepInitEntryList) {
            String dataJudgeBasis;
            JSONObject stepInitEntry = (JSONObject)jsonObj;
            String queryEntity = "";
            boolean isQueryHasData = true;
            String modelType = stepInitEntry.getString(ImicInitialscheme.EF_inititem_modeltype);
            if (StringUtils.equals((CharSequence)"BillFormModel", (CharSequence)modelType) || StringUtils.equals((CharSequence)"BaseFormModel", (CharSequence)modelType)) {
                queryEntity = stepInitEntry.getString(ImicInitialscheme.EF_inititem_number);
            }
            if (StringUtils.isNotBlank((CharSequence)(dataJudgeBasis = stepInitEntry.getString(ImicInitialscheme.EF_initentry_datajudgebasisdesc_tag)))) {
                JSONObject paramJson = JSON.parseObject((String)dataJudgeBasis);
                Boolean isQueryHasDataJson = paramJson.getBoolean("isqueryinititemhasdata");
                isQueryHasData = isQueryHasDataJson == null || isQueryHasDataJson != false;
                String queryEntityJson = paramJson.getString("queryentity");
                if (StringUtils.isNotBlank((CharSequence)queryEntityJson)) {
                    queryEntity = queryEntityJson;
                }
            }
            boolean exists = false;
            CardEntry cardEntry = (CardEntry)this.getView().getControl(CARD_ENTRY);
            exists = StringUtils.isBlank((CharSequence)queryEntity) || !isQueryHasData ? false : this.existsData(stepInitEntry);
            cardEntry.setChildVisible(!exists, subEntryRow, new String[]{"notdata_card"});
            cardEntry.setChildVisible(exists, subEntryRow, new String[]{"hasdata_card"});
            boolean isFinish = false;
            if (!CommonUtil.isNull(progressEntryIdList)) {
                isFinish = progressEntryIdList.contains(stepInitEntry.getLong(ImicInitialscheme.EF_initentry_items_id));
            }
            boolean haveUrl = StringUtils.isNotBlank((CharSequence)stepInitEntry.getString(ImicInitialscheme.EF_initentry_url));
            cardEntry.setChildVisible(isFinish, subEntryRow, new String[]{"finish_card"});
            cardEntry.setChildVisible(!isFinish, subEntryRow, new String[]{"unfinish_card"});
            cardEntry.setChildVisible(!isFinish, subEntryRow, new String[]{"markcompleted"});
            cardEntry.setChildVisible(isFinish, subEntryRow, new String[]{"markuncompleted"});
            ((DynamicObject)itemEntryCard.get(subEntryRow)).set("isfinish", (Object)isFinish);
            cardEntry.setChildVisible(haveUrl, subEntryRow, new String[]{"url_icon_card"});
            ++subEntryRow;
        }
    }

    private boolean existsData(JSONObject stepInitEntry) {
        String dataJudgeBasis;
        String queryEntity = "";
        String queryBoundField = "";
        String filterCon = "";
        boolean isQueryCtrlstrtg = false;
        Boolean customizeConfig = null;
        String interfaceConfig = "";
        String modelType = stepInitEntry.getString(ImicInitialscheme.EF_inititem_modeltype);
        if (StringUtils.equals((CharSequence)"BillFormModel", (CharSequence)modelType) || StringUtils.equals((CharSequence)"BaseFormModel", (CharSequence)modelType)) {
            queryEntity = stepInitEntry.getString(ImicInitialscheme.EF_inititem_number);
        }
        if (StringUtils.isNotBlank((CharSequence)(dataJudgeBasis = stepInitEntry.getString(ImicInitialscheme.EF_initentry_datajudgebasisdesc_tag)))) {
            JSONObject paramJson = JSON.parseObject((String)dataJudgeBasis);
            String queryEntityJson = paramJson.getString("queryentity");
            if (StringUtils.isNotBlank((CharSequence)queryEntityJson)) {
                queryEntity = queryEntityJson;
            }
            customizeConfig = paramJson.getBoolean("customizeconfig");
            interfaceConfig = paramJson.getString("interfaceconfig");
            Boolean isQueryCtrlstrtgJson = paramJson.getBoolean("isbdctrlstrtgqueryhasdata");
            isQueryCtrlstrtg = isQueryCtrlstrtgJson != null && isQueryCtrlstrtgJson != false;
            queryBoundField = paramJson.getString("queryboundfield");
            filterCon = paramJson.getString("filtercondition");
        }
        String realEntityId = FormMetadataCache.getFormConfig((String)queryEntity).getEntityTypeId();
        MainEntityType entityType = EntityMetadataCache.getDataEntityType((String)realEntityId);
        queryEntity = entityType.getName();
        if (StringUtils.isBlank((CharSequence)entityType.getAlias())) {
            return false;
        }
        ArrayList<QFilter> qFilterList = new ArrayList<QFilter>();
        boolean exists = false;
        long orgId = CommonUtil.getLongCustomParamValue(this.getView(), "orgid");
        if (Boolean.TRUE.equals(customizeConfig)) {
            Matcher matcher = PATTERN.matcher(interfaceConfig);
            if (matcher.find()) {
                String[] parts = matcher.group(1).split("\\.");
                String cloudId = parts[0];
                String appId = parts[1];
                String serverName = parts[2];
                String method = parts[3];
                try {
                    exists = (Boolean)DispatchServiceHelper.invokeBizService((String)cloudId, (String)appId, (String)serverName, (String)method, (Object[])new Object[]{queryEntity, orgId});
                }
                catch (Exception ex) {
                    log.error("\u901a\u8fc7\u5fae\u670d\u52a1\u67e5\u8be2\u662f\u5426\u6709\u6570\u636e\u51fa\u9519" + ex.getMessage(), (Throwable)ex);
                    return false;
                }
            }
        } else {
            if (StringUtils.isNotBlank((Object)orgId)) {
                if (isQueryCtrlstrtg) {
                    qFilterList.add(BaseDataServiceHelper.getBaseDataFilter((String)queryEntity, (Long)orgId));
                } else if (StringUtils.isNotBlank((CharSequence)queryBoundField)) {
                    qFilterList.add(new QFilter(queryBoundField, "=", (Object)orgId));
                }
            }
            FilterCondition filterCondition = null;
            if (StringUtils.isNotBlank((CharSequence)filterCon)) {
                filterCondition = (FilterCondition)SerializationUtils.fromJsonString((String)filterCon, FilterCondition.class);
            }
            if (filterCondition != null) {
                FilterBuilder filterBuilder = new FilterBuilder(entityType, filterCondition);
                filterBuilder.buildFilter();
                qFilterList.add(filterBuilder.getQFilter());
            }
            exists = QueryServiceHelper.exists((String)queryEntity, (QFilter[])qFilterList.toArray(new QFilter[0]));
        }
        return exists;
    }

    private void setLabelName(CardEntry cardEntry, String labelKey, Object labelValue, String tipContext, int rowIndex) {
        HashMap<String, Object> textMap = new HashMap<String, Object>(1);
        textMap.put("text", labelValue);
        if (StringUtils.isNotEmpty((CharSequence)tipContext)) {
            HashMap<String, String> tipsMap = new HashMap<String, String>(1);
            tipsMap.put("content", tipContext);
            tipsMap.put("type", "text");
            tipsMap.put("showIcon", "false");
            textMap.put("tips", tipsMap);
        }
        HashMap<String, HashMap<String, Object>> map = new HashMap<String, HashMap<String, Object>>(1);
        map.put(labelKey, textMap);
        cardEntry.setCustomProperties(cardEntry.getKey(), rowIndex, map);
    }
}

