/*
 * Decompiled with CFR 0.152.
 */
package kd.imsc.imic.mservice;

import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.db.ResultSetHandler;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.service.upgrade.IUpgradeService;
import kd.bos.service.upgrade.UpgradeResult;
import kd.imsc.imic.common.CommonUtil;

public class UpgradeImicOrgViewTypeServiceImpl
implements IUpgradeService {
    private static final Log logger = LogFactory.getLog(UpgradeImicOrgViewTypeServiceImpl.class);

    public UpgradeResult afterExecuteSqlWithResult(String ver, String iteration, String dbKey, String sqlFileName) {
        UpgradeResult upgradeResult = new UpgradeResult();
        upgradeResult.setSuccess(true);
        StringBuilder msg = new StringBuilder(ResManager.loadKDString((String)"imic\u521d\u59cb\u5316\u65b9\u6848\u804c\u80fd\u7c7b\u578b\u6570\u636e\u5347\u7ea7\u5f00\u59cb--", (String)"UpgradeImicOrgViewTypeServiceImpl_0", (String)"imsc-imic-platform", (Object[])new Object[0]));
        String sql = "SELECT FID, FORGVIEWTYPEID FROM T_IMIC_INITIALSCHEME";
        Map schemeViewTypeMapping = (Map)DB.query((DBRoute)DBRoute.of((String)"imsc"), (String)sql, null, (ResultSetHandler)new ResultSetHandler<Map<Long, Long>>(){

            public Map<Long, Long> handle(ResultSet rs) throws Exception {
                HashMap<Long, Long> result = new HashMap<Long, Long>(2);
                while (rs.next()) {
                    long orgViewTypeId = rs.getLong("forgviewtypeid");
                    if (orgViewTypeId == 0L) continue;
                    result.put(rs.getLong("fid"), orgViewTypeId);
                }
                return result;
            }
        });
        if (!schemeViewTypeMapping.isEmpty()) {
            sql = "SELECT FID FROM T_IMIC_SCHEME_ORGVIEWTYPE";
            List mulViewTypeFidList = (List)DB.query((DBRoute)DBRoute.of((String)"imsc"), (String)sql, null, (ResultSetHandler)new ResultSetHandler<List<Long>>(){

                public List<Long> handle(ResultSet rs) throws Exception {
                    ArrayList<Long> result = new ArrayList<Long>(10);
                    while (rs.next()) {
                        result.add(rs.getLong("fid"));
                    }
                    return result;
                }
            });
            Map<Long, Long> filteredMap = schemeViewTypeMapping.entrySet().stream().filter(entry -> !mulViewTypeFidList.contains(entry.getKey())).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            StringBuilder insertSql = new StringBuilder();
            ArrayList<Object[]> params = new ArrayList<Object[]>(10);
            insertSql.append("INSERT INTO T_IMIC_SCHEME_ORGVIEWTYPE (FPKID,FID, FBASEDATAID) VALUES (?, ?, ?);");
            long[] viewTypesIds = DB.genLongIds((String)"t_imic_scheme_orgviewtype", (int)filteredMap.size());
            int index = 0;
            for (Map.Entry<Long, Long> schemeViewType : filteredMap.entrySet()) {
                Long schemeId = schemeViewType.getKey();
                Long viewTypeId = schemeViewType.getValue();
                ArrayList<Long> list = new ArrayList<Long>(3);
                list.add(viewTypesIds[index]);
                list.add(schemeId);
                list.add(viewTypeId);
                params.add(list.toArray());
                ++index;
            }
            if (!params.isEmpty()) {
                String traceId = RequestContext.get().getTraceId();
                try {
                    DB.executeBatch((DBRoute)DBRoute.of((String)"imsc"), (String)insertSql.toString(), params);
                }
                catch (Exception e) {
                    logger.error(String.format("\u521d\u59cb\u5316\u65b9\u6848\u804c\u80fd\u7c7b\u578b\u5347\u7ea7\u4fdd\u5b58\u591a\u9009\u57fa\u7840\u8d44\u6599\u6570\u636e\u65f6\u5931\u8d25,tracdid: [%1$s], \u5f02\u5e38\u4fe1\u606f: [%2$s]", traceId, e.getMessage()), (Throwable)e);
                    upgradeResult.setSuccess(false);
                    upgradeResult.setErrorInfo(String.format(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u65b9\u6848\u804c\u80fd\u7c7b\u578b\u5347\u7ea7\u4fdd\u5b58\u591a\u9009\u57fa\u7840\u8d44\u6599\u6570\u636e\u65f6\u5931\u8d25\u5931\u8d25, tracdid: [%1$s],\u5f02\u5e38\u4fe1\u606f\uff1a[%2$s]", (String)"UpgradeImicOrgViewTypeServiceImpl_1", (String)"imsc-imic-platform", (Object[])new Object[0]), traceId, CommonUtil.getExceptionDetailInfo(e)));
                }
            }
        } else {
            msg.append(ResManager.loadKDString((String)"\u521d\u59cb\u5316\u65b9\u6848\u804c\u80fd\u7c7b\u578b\u6570\u636e\u4e3a\u7a7a\uff0c\u4e0d\u9700\u8981\u5347\u7ea7\u5904\u7406", (String)"UpgradeImicOrgViewTypeServiceImpl_2", (String)"imsc-imic-platform", (Object[])new Object[0]));
        }
        msg.append(ResManager.loadKDString((String)"imic\u521d\u59cb\u5316\u65b9\u6848\u804c\u80fd\u7c7b\u578b\u6570\u636e\u5347\u7ea7\u7ed3\u675f--", (String)"UpgradeImicOrgViewTypeServiceImpl_3", (String)"imsc-imic-platform", (Object[])new Object[0]));
        upgradeResult.setLog(msg.toString());
        return upgradeResult;
    }
}

