/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.dbc.platform.core;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.isc.dbc.platform.core.DatabaseCompJob;
import kd.isc.dbc.platform.core.DatabaseCompSchema;
import kd.isc.dbc.platform.core.DatabaseCompSubJobFactory;
import kd.isc.dbc.platform.core.Util;
import kd.isc.iscb.platform.core.connector.JdbcConnectionWrapper;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbType;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.StringUtil;

public final class DatabaseCompSubJob
implements Job {
    private long id;
    private String title;
    private DatabaseCompSchema dbc;
    private DataRow current;
    private AtomicLong totalCount = new AtomicLong();
    private AtomicLong compCount = new AtomicLong();
    private AtomicLong bytesCount = new AtomicLong();
    private long startTime;

    public DatabaseCompSubJob(long id, String title) {
        this.id = id;
        this.title = title;
    }

    public String getParam() {
        return String.valueOf(this.id);
    }

    public String getTitle() {
        return this.title;
    }

    public long getOwnerId() {
        return this.id;
    }

    public JobFactory getFactory() {
        return new DatabaseCompSubJobFactory();
    }

    public Job.Progress getRealtimeProgress() {
        DataRow current = this.current;
        if (current == null) {
            return null;
        }
        long compCount = this.compCount.get();
        long totalCount = this.totalCount.get();
        if (totalCount > 0L) {
            String description = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u6bd4\u8f83 %1$s\uff1a%2$s / %3$s...", (String)"DatabaseCompSubJob_6", (String)"isc-dbc-platform-core", (Object[])new Object[0]), current.get((Object)"ftable_name"), totalCount, compCount);
            return new Job.Progress(totalCount, compCount, description);
        }
        String description = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u6bd4\u8f83 %s...", (String)"DatabaseCompSubJob_7", (String)"isc-dbc-platform-core", (Object[])new Object[0]), current.get((Object)"ftable_name"));
        return new Job.Progress(1L, 0L, description);
    }

    public String refreshProgress() {
        Job.Progress p = this.getRealtimeProgress();
        if (p == null) {
            return null;
        }
        this.refreshEntryProgress();
        return p.getDescription();
    }

    private void refreshEntryProgress() {
        String sql = "UPDATE t_dbc_database_comp_items SET frow_count=?, fcomp_count=?,fbytes_count=?,felapsed_time=? WHERE fentryid=?";
        Timestamp now = new Timestamp(System.currentTimeMillis());
        long millis = now.getTime() - this.startTime;
        BigDecimal elapsedTime = BigDecimal.valueOf((double)millis / 1000.0).setScale(1, RoundingMode.CEILING);
        List values = D.asList((Object[])new Object[]{this.totalCount.get(), this.compCount.get(), this.bytesCount.get(), elapsedTime, this.getEntryId()});
        List types = D.asList((Object[])new Integer[]{-5, -5, -5, 3, -5});
        Util.executeSQL(sql, values, types);
    }

    public Job.Returns runX() {
        this.run();
        if (this.current == null) {
            return Job.Returns.DESTRUCTION;
        }
        return Job.Returns.delay((int)0);
    }

    public void run() {
        this.current = this.takeReadyEntry();
        if (this.current == null) {
            return;
        }
        Throwable cause = null;
        try {
            this.doTableComp();
            SignalManager.checkCancelSignal();
        }
        catch (Throwable e) {
            cause = e;
            this.setFailed(e);
        }
        finally {
            boolean hasMore = DatabaseCompJob.updateProgress(this.dbc.getDynamicObject(), cause);
            if (Util.isEnd(hasMore, cause instanceof TaskCancelException)) {
                this.current = null;
            }
        }
    }

    private void doTableComp() throws SQLException {
        this.dbc = DatabaseCompSchema.get(this.id);
        this.totalCount.set(-1L);
        this.compCount.set(-1L);
        this.bytesCount.set(-1L);
        String tableName = D.s((Object)this.current.get((Object)"ftable_name"));
        Table srcTable = this.dbc.getSrcTable(tableName);
        Table tarTable = this.dbc.getTarTable(srcTable);
        String message = Util.checkCompatibility(srcTable, tarTable);
        if (message != null) {
            this.setOmitted(message);
        } else if (this.dbc.isLogTable(srcTable)) {
            this.setOmitted(ResManager.loadKDString((String)"\u65e5\u5fd7\u8868", (String)"DatabaseCompSubJob_1", (String)"isc-dbc-platform-core", (Object[])new Object[0]));
        } else {
            this.doTableComp(this.dbc, srcTable, tarTable);
        }
    }

    private void doTableComp(DatabaseCompSchema dbc, Table srcTable, Table tarTable) throws SQLException {
        try (JdbcConnectionWrapper src = dbc.getSrcConnection();){
            long total = D.l((Object)DbUtil.executeScalar((Connection)src, (String)("SELECT COUNT(*) AS C FROM " + srcTable.getQuotedName())));
            if (total == 0L) {
                this.setOmitted(ResManager.loadKDString((String)"\u6e90\u8868\u662f\u7a7a\u8868", (String)"DatabaseCompSubJob_2", (String)"isc-dbc-platform-core", (Object[])new Object[0]));
            } else {
                this.initCounter(total);
                this.doTableComp(dbc, src, srcTable, tarTable);
            }
        }
    }

    private void doTableComp(DatabaseCompSchema dbc, JdbcConnectionWrapper src, Table srcTable, Table tarTable) throws SQLException {
        try (JdbcConnectionWrapper tar = dbc.getTarConnection();){
            boolean tarIsEmpty = Util.isEmpty(tar, tarTable);
            if (tarIsEmpty) {
                this.setSuccess("DIFF", ResManager.loadKDString((String)"\u76ee\u6807\u8868\u7a7a", (String)"DatabaseCompSubJob_3", (String)"isc-dbc-platform-core", (Object[])new Object[0]));
            } else {
                this.doTableComp(dbc, srcTable, tarTable, src, tar);
            }
        }
    }

    private void setSuccess(String remark) {
        if (remark == null) {
            this.setSuccess("EQUIV", " ");
        } else {
            this.setSuccess("DIFF", remark);
        }
    }

    private void initCounter(long total) {
        this.totalCount.set(total);
        this.compCount.set(0L);
        this.bytesCount.set(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTableComp(DatabaseCompSchema dbc, Table srcTable, Table tarTable, JdbcConnectionWrapper src, JdbcConnectionWrapper tar) throws SQLException {
        DbType srcDb = src.getJdbcConnectionFactory().getDatabaseType();
        srcDb.setBigQuery((Connection)src);
        try {
            String remark = this.innerDoTableComp(dbc, srcTable, tarTable, src, tar);
            this.setSuccess(remark);
        }
        finally {
            srcDb.unsetBigQuery((Connection)src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String innerDoTableComp(DatabaseCompSchema dbc, Table srcTable, Table tarTable, JdbcConnectionWrapper src, JdbcConnectionWrapper tar) {
        SignalManager.checkCancelSignal();
        String sql = Util.generateSelectSQL(srcTable, Util.getFields(srcTable));
        try (ObjectReader reader = DbUtil.executeQuery((Connection)src, (String)sql, Collections.emptyList(), Collections.emptyList());){
            int batchSize = dbc.getBatchSize();
            ArrayList<Object> batch = new ArrayList<DataRow>(batchSize);
            int batchBytes = 0;
            DataRow row = (DataRow)reader.read();
            while (row != null) {
                batch.add(row);
                if (this.batchIsFull(batchSize, batchBytes += DbUtil.calcBytes((DataRow)row), batch)) {
                    String remark = this.compBatch(batch, tar, tarTable, srcTable, batchBytes);
                    if (remark != null) {
                        String string = remark;
                        return string;
                    }
                    batchBytes = 0;
                    batch = new ArrayList(batchSize);
                }
                row = (DataRow)reader.read();
            }
            String string = this.compBatch(batch, tar, tarTable, srcTable, batchBytes);
            return string;
        }
    }

    private boolean batchIsFull(int batchSize, int batchBytes, List<DataRow> batch) {
        return batch.size() >= batchSize || batchBytes >= 10000000;
    }

    private String compBatch(List<DataRow> batch, JdbcConnectionWrapper tar, Table tarTable, Table srcTable, long batchBytes) {
        if (batch.isEmpty()) {
            return null;
        }
        SignalManager.checkCancelSignal();
        Util.replaceZeroChar(batch);
        int batchSize = batch.size();
        String remark = this.batchComp(tar, batch, srcTable, tarTable);
        this.compCount.addAndGet(batchSize);
        this.bytesCount.addAndGet(batchBytes);
        return remark;
    }

    private String batchComp(JdbcConnectionWrapper tar, List<DataRow> batch, Table srcTable, Table tarTable) {
        Map<String, DataRow> srcMapping = Util.groupByPrimaryKeys(batch, tarTable);
        List<DataRow> forUpdate = Util.filterForUpdate(batch, tar, tarTable, srcMapping, srcTable);
        if (!srcMapping.isEmpty()) {
            return String.format(ResManager.loadKDString((String)"\u76ee\u6807\u8868\u7f3a\u5c11\u6570\u636e\uff0c\u6e90\u8868\u4e3b\u952e\u503c\u662f\uff1a%s", (String)"DatabaseCompSubJob_8", (String)"isc-dbc-platform-core", (Object[])new Object[0]), this.collectPrimaryKeyValues(srcMapping.values(), srcTable));
        }
        if (!forUpdate.isEmpty()) {
            return String.format(ResManager.loadKDString((String)"\u76ee\u6807\u8868\u6570\u636e\u4e0d\u540c\uff0c\u6e90\u8868\u4e3b\u952e\u503c\u662f\uff1a%s", (String)"DatabaseCompSubJob_9", (String)"isc-dbc-platform-core", (Object[])new Object[0]), this.collectPrimaryKeyValues(forUpdate, srcTable));
        }
        return null;
    }

    private String collectPrimaryKeyValues(Collection<DataRow> rows, Table srcTable) {
        List pks = srcTable.getPrimaryKeys();
        if (pks.size() == 1) {
            return this.collectSinglePrimaryKeyValues(rows, pks);
        }
        return this.collectMultiPrimaryKeyValues(rows, pks);
    }

    private String collectMultiPrimaryKeyValues(Collection<DataRow> rows, List<Column> pks) {
        StringBuilder sb = new StringBuilder();
        for (DataRow row : rows) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            StringBuilder value = this.collectMultiPrimaryKeyValue(row, pks);
            sb.append('(').append((CharSequence)value).append(')');
        }
        return sb.toString();
    }

    private StringBuilder collectMultiPrimaryKeyValue(DataRow row, List<Column> pks) {
        StringBuilder s = new StringBuilder();
        for (Column pk : pks) {
            if (s.length() > 0) {
                s.append(", ");
            }
            s.append(row.get((Object)pk.getName()));
        }
        return s;
    }

    private String collectSinglePrimaryKeyValues(Collection<DataRow> rows, List<Column> pks) {
        String pk = pks.get(0).getName();
        StringBuilder sb = new StringBuilder();
        for (DataRow row : rows) {
            if (sb.length() > 0) {
                sb.append("; ");
            }
            sb.append(row.get((Object)pk));
        }
        return sb.toString();
    }

    private long getEntryId() {
        return D.l((Object)this.current.get((Object)"fentryid"));
    }

    private DataRow takeReadyEntry() {
        DataRow entry;
        do {
            if ((entry = this.findFirstReadyEntry()) != null) continue;
            return null;
        } while (!this.setRunning(D.l((Object)entry.get((Object)"fentryid"))));
        this.startTime = System.currentTimeMillis();
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataRow findFirstReadyEntry() {
        String sql = "SELECT TOP 1 fentryid,ftable_name FROM t_dbc_database_comp_items WHERE fid=? AND fstate = 'READY'";
        List values = D.asList((Object[])new Object[]{this.id});
        List types = D.asList((Object[])new Integer[]{-5});
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            DataRow dataRow = DbUtil.executeRow((Connection)cn, (String)sql, (List)values, (List)types);
            return dataRow;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setRunning(long entryId) {
        String sql = "UPDATE t_dbc_database_comp_items SET fstate='RUNNING', fremark=' ', fremark_tag=null,frow_count = -1,fcomp_count = -1,fbytes_count = -1, fstart_time = ?, fend_time = null  WHERE fentryid=? AND fstate = 'READY'";
        Timestamp now = new Timestamp(System.currentTimeMillis());
        List values = D.asList((Object[])new Object[]{now, entryId});
        List types = D.asList((Object[])new Integer[]{93, -5});
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            boolean bl = DbUtil.executeUpdate((Connection)cn, (String)sql, (List)values, (List)types) > 0;
            return bl;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private void setFailed(Throwable err) {
        String sql = "UPDATE t_dbc_database_comp_items SET fstate=?, fremark=?, fremark_tag=?,fend_time=?,frow_count=?, fcomp_count=?,fbytes_count=?,felapsed_time=? WHERE fentryid=?";
        String remark = StringUtil.trim((String)StringUtil.getCascadeMessage((Throwable)err), (int)80);
        String remark_tag = StringUtil.toString((Throwable)err);
        String state = err instanceof TaskCancelException ? "ABORTED" : "FAILED";
        Timestamp now = new Timestamp(System.currentTimeMillis());
        long millis = now.getTime() - this.startTime;
        BigDecimal elapsedTime = BigDecimal.valueOf((double)millis / 1000.0).setScale(1, RoundingMode.CEILING);
        List values = D.asList((Object[])new Object[]{state, remark, remark_tag, now, this.totalCount.get(), this.compCount.get(), this.bytesCount.get(), elapsedTime, this.getEntryId()});
        List types = D.asList((Object[])new Integer[]{12, 12, 12, 93, -5, -5, -5, 3, -5});
        Util.executeSQL(sql, values, types);
    }

    private void setOmitted(String message) {
        String sql = "UPDATE t_dbc_database_comp_items SET fstate='OMITTED', fremark=?,fend_time=?,frow_count= -1, fcomp_count= -1  WHERE fentryid=?";
        Timestamp now = new Timestamp(System.currentTimeMillis());
        List values = D.asList((Object[])new Object[]{message, now, this.getEntryId()});
        List types = D.asList((Object[])new Integer[]{12, 93, -5});
        Util.executeSQL(sql, values, types);
    }

    private void setSuccess(String state, String remark) {
        String remark_tag;
        String sql = "UPDATE t_dbc_database_comp_items SET fstate=?, frow_count=?, fcomp_count=?, fbytes_count=?,fend_time=?,felapsed_time=?,fremark=?,fremark_tag=?  WHERE fentryid=?";
        Timestamp now = new Timestamp(System.currentTimeMillis());
        long millis = now.getTime() - this.startTime;
        BigDecimal elapsedTime = BigDecimal.valueOf((double)millis / 1000.0).setScale(1, RoundingMode.CEILING);
        String string = remark_tag = remark != null && remark.length() > 50 ? remark : null;
        if (remark_tag != null) {
            remark = StringUtil.trim((String)remark, (int)50);
            remark_tag = StringUtil.trim((String)remark_tag, (int)4000);
        }
        List values = D.asList((Object[])new Object[]{state, this.totalCount.get(), this.compCount.get(), this.bytesCount.get(), now, elapsedTime, remark, remark_tag, this.getEntryId()});
        List types = D.asList((Object[])new Integer[]{12, -5, -5, -5, 93, 3, 12, 12, -5});
        Util.executeSQL(sql, values, types);
    }
}

