/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.dbc.platform.core;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.db.tx.TX;
import kd.bos.id.IDService;
import kd.isc.dbc.platform.core.DatabaseCopyJobFactory;
import kd.isc.dbc.platform.core.DatabaseCopySchema;
import kd.isc.dbc.platform.core.DatabaseCopySubJob;
import kd.isc.dbc.platform.core.Util;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.JdbcConnectionFactory;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.data.fsm.FSM;

public class DatabaseCopyJob
implements Job {
    private long id;
    private String title;
    private transient FSM inclusive_tab_patterns;
    private transient FSM exclusive_tab_patterns;
    private transient DynamicObject dbc;

    public DatabaseCopyJob(long id, String title) {
        this.id = id;
        this.title = title;
    }

    public String getParam() {
        return String.valueOf(this.id);
    }

    public String getTitle() {
        return this.title;
    }

    public JobFactory getFactory() {
        return new DatabaseCopyJobFactory();
    }

    public long getOwnerId() {
        return this.id;
    }

    public Job.Returns runX() {
        SignalManager.registerTask((String)String.valueOf(this.id));
        try {
            this.run();
            Job.Returns returns = Job.Returns.DESTRUCTION;
            return returns;
        }
        finally {
            SignalManager.unregisterTask((String)String.valueOf(this.id));
        }
    }

    public void run() {
        try {
            this.setRunning();
            this.dbc = DatabaseCopySchema.get(this.id).getDynamicObject();
            this.dbc.set("start_time", (Object)new Timestamp(System.currentTimeMillis()));
            int table_count = this.createTableItems();
            if (DatabaseCopyJob.updateProgress(this.dbc, null)) {
                this.createSubJobs(table_count);
            }
        }
        catch (Throwable e) {
            this.setFailed(e);
        }
    }

    private void createSubJobs(int table_count) {
        int maxThreads = Math.max(1, Math.min(table_count, this.dbc.getInt("max_threads")));
        long now = System.currentTimeMillis();
        for (int i = 0; i < maxThreads; ++i) {
            String subTitle = this.title + "(" + (i + 1) + ")";
            DatabaseCopySubJob job = new DatabaseCopySubJob(this.id, subTitle);
            JobEngine.submit((Job)job, (Timestamp)new Timestamp(now + (long)(i * 100)));
        }
    }

    private void setFailed(Throwable e) {
        String sql = "UPDATE t_dbc_database_copy SET fremark=?, fremark_tag=?, fstate='FAILED', fend_time=? WHERE fid=?";
        String remark = StringUtil.trim((String)StringUtil.getCascadeMessage((Throwable)e), (int)80);
        String remark_tag = StringUtil.toString((Throwable)e);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        List values = D.asList((Object[])new Object[]{remark, remark_tag, now, this.id});
        List types = D.asList((Object[])new Integer[]{12, 12, 93, -5});
        Util.executeSQL(sql, values, types);
    }

    private int createTableItems() {
        int table_count = this.getTableCountFromCache();
        if (table_count > 0) {
            this.resetTableState();
        } else {
            this.initTablePatterns(this.dbc);
            List<String> tables = this.getSourceDbTables();
            List<List<Object>> batch = this.filterTables(tables);
            this.saveTableItems(batch);
            table_count = batch.size();
            this.updateTableCount(table_count);
        }
        return table_count;
    }

    private void resetTableState() {
        String sql = "UPDATE t_dbc_database_copy_items SET fstate='READY',fend_time=null,felapsed_time=0,frow_count=-1,fcomplete_count=-1,fbytes_count=-1 WHERE FID=? AND fstate IN('FAILED','RUNNING','ABORTED')";
        List values = D.asList((Object[])new Object[]{this.id});
        List types = D.asList((Object[])new Integer[]{-5});
        Util.executeSQL(sql, values, types);
    }

    private void updateTableCount(int table_count) {
        String sql = "UPDATE t_dbc_database_copy SET ftable_count=? WHERE fid=?";
        List values = D.asList((Object[])new Object[]{table_count, this.id});
        List types = D.asList((Object[])new Integer[]{4, -5});
        Util.executeSQL(sql, values, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveTableItems(List<List<Object>> batch) {
        if (!batch.isEmpty()) {
            Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
            try {
                String sql = "INSERT INTO t_dbc_database_copy_items(fid,fentryid,fseq,ftable_name,frow_count,fstate,fremark)VALUES(?,?,?,?,-1,'READY',' ')";
                List types = D.asList((Object[])new Integer[]{-5, -5, 4, 12});
                DbUtil.executeBatch((Connection)cn, (String)sql, batch, (List)types);
            }
            finally {
                DbUtil.close((Connection)cn, (boolean)true);
            }
        }
    }

    private void setRunning() {
        Timestamp now = new Timestamp(System.currentTimeMillis());
        String sql = "UPDATE t_dbc_database_copy SET fstart_time=?, fstate=?, fremark=' ', fremark_tag = null WHERE fid=?";
        List values = D.asList((Object[])new Object[]{now, "RUNNING", this.id});
        List types = D.asList((Object[])new Integer[]{93, 12, -5});
        Util.executeSQL(sql, values, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, Integer> queryEntryStates(long id) {
        String sql = "SELECT fstate, count(*) as fcount, sum(fbytes_count) as fbytes FROM t_dbc_database_copy_items WHERE fid=? GROUP BY fstate";
        List values = D.asList((Object[])new Object[]{id});
        List types = D.asList((Object[])new Integer[]{-5});
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            long totalBytes = 0L;
            HashMap<String, Integer> progress = new HashMap<String, Integer>(8);
            for (DataRow row : DbUtil.executeList((Connection)cn, (String)sql, (List)values, (List)types)) {
                progress.put(D.s((Object)row.get((Object)"fstate")), D.i((Object)row.get((Object)"fcount")));
                totalBytes += D.l((Object)row.get((Object)"fbytes"));
            }
            progress.put("TOTAL_BYTES", (int)Math.ceil((double)totalBytes / 1048576.0));
            HashMap<String, Integer> hashMap = progress;
            return hashMap;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    static boolean updateProgress(DynamicObject dbc, Throwable cause) {
        int runningCount;
        int readyCount;
        long id = dbc.getLong("id");
        Map<String, Integer> progress = DatabaseCopyJob.queryEntryStates(id);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        long millis = now.getTime() - D.t((Object)dbc.get("start_time")).getTime();
        BigDecimal elapsedTime = BigDecimal.valueOf((double)millis / 1000.0).setScale(1, RoundingMode.CEILING);
        int successCount = D.i((Object)progress.remove("SUCCESS"));
        int omittedCount = D.i((Object)progress.remove("OMITTED"));
        int failedCount = D.i((Object)progress.remove("FAILED"));
        int totalBytes = D.i((Object)progress.remove("TOTAL_BYTES"));
        int abortedCount = D.i((Object)progress.get("ABORTED"));
        String state = DatabaseCopyJob.calcState(failedCount, abortedCount, readyCount = D.i((Object)progress.get("READY")), runningCount = D.i((Object)progress.get("RUNNING")), cause);
        Timestamp endTime = "RUNNING".equals(state) ? null : now;
        String sql = "UPDATE t_dbc_database_copy SET fsuccess_count=?,fomitted_count=?,ffailed_count=?, fstate=?,fend_time=?,felapsed_time=?,fbytes_count=? WHERE fid=?";
        List values = D.asList((Object[])new Object[]{successCount, omittedCount, failedCount, state, endTime, elapsedTime, totalBytes, id});
        List types = D.asList((Object[])new Integer[]{4, 4, 4, 12, 93, 3, 4, -5});
        Util.executeSQL(sql, values, types);
        return readyCount > 0;
    }

    private static String calcState(int failedCount, int abortedCount, int readyCount, int runningCount, Throwable cause) {
        if (runningCount > 0) {
            return "RUNNING";
        }
        if (readyCount > 0 && !(cause instanceof TaskCancelException)) {
            return "RUNNING";
        }
        if (abortedCount > 0) {
            return "ABORTED";
        }
        if (failedCount > 0) {
            return "FAILED";
        }
        return "SUCCESS";
    }

    private List<List<Object>> filterTables(List<String> tables) {
        ArrayList<List<Object>> batch = new ArrayList<List<Object>>();
        for (String table : tables) {
            if (!Util.isRequired(table, this.inclusive_tab_patterns, this.exclusive_tab_patterns)) continue;
            batch.add(D.asList((Object[])new Object[]{this.id, IDService.get().genLongId(), batch.size() + 1, table}));
        }
        return batch;
    }

    private List<String> getSourceDbTables() {
        long srcDbId = this.dbc.getLong("src_db_id");
        try (ConnectionWrapper cn = ConnectionManager.getConnection((long)srcDbId);){
            JdbcConnectionFactory factory = (JdbcConnectionFactory)cn.getFactory();
            List list = factory.getTables(cn);
            return list;
        }
    }

    private void initTablePatterns(DynamicObject dbc) {
        this.inclusive_tab_patterns = Util.parseTablePatterns(D.s((Object)dbc.get("inclusive_tab_patterns")));
        this.exclusive_tab_patterns = Util.parseTablePatterns(D.s((Object)dbc.get("exclusive_tab_patterns")));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int getTableCountFromCache() {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            String sql = "SELECT COUNT(*) FROM t_dbc_database_copy_items WHERE fid=?";
            int n = D.i((Object)DbUtil.executeScalar((Connection)cn, (String)sql, (List)D.asList((Object[])new Object[]{this.id}), (List)D.asList((Object[])new Integer[]{-5})));
            return n;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }
}

