/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.dbc.platform.core;

import java.sql.Connection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.dbc.platform.core.DatabaseCopySchemaFactory;
import kd.isc.dbc.platform.core.Util;
import kd.isc.iscb.platform.core.cache.CacheableObjectFactory;
import kd.isc.iscb.platform.core.cache.CacheableObjectManager;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.JdbcConnectionFactory;
import kd.isc.iscb.platform.core.connector.JdbcConnectionWrapper;
import kd.isc.iscb.util.connector.TableUtil;
import kd.isc.iscb.util.db.DbType;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.db.type.UserDefineDbType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.mem.ObjectSizeIgnored;
import kd.isc.iscb.util.script.data.fsm.FSM;

public class DatabaseCopySchema
implements ObjectSizeIgnored {
    private DynamicObject dbc;
    private boolean auto_create_table;
    private Set<String> srcTables;
    private Set<String> tarTables;
    private long srcDbId;
    private long tarDbId;
    private transient FSM log_tab_patterns;

    DatabaseCopySchema(DynamicObject dbc) {
        this.dbc = dbc;
        this.auto_create_table = D.x((Object)dbc.get("auto_create_table"));
        this.srcDbId = dbc.getLong("src_db_id");
        this.tarDbId = dbc.getLong("tar_db_id");
        this.log_tab_patterns = Util.parseTablePatterns(D.s((Object)dbc.get("log_tab_patterns")));
    }

    public DynamicObject getDynamicObject() {
        return this.dbc;
    }

    public int getBatchSize() {
        return D.i((Object)this.dbc.get("batch_size"));
    }

    public synchronized Set<String> getSrcTables() {
        if (this.srcTables == null) {
            try (ConnectionWrapper cn = ConnectionManager.getConnection((long)this.srcDbId);){
                JdbcConnectionFactory factory = (JdbcConnectionFactory)cn.getFactory();
                HashSet tables = new HashSet(factory.getTables(cn));
                this.srcTables = Collections.unmodifiableSet(tables);
            }
        }
        return this.srcTables;
    }

    private synchronized Set<String> getTarTables() {
        if (this.tarTables == null) {
            try (ConnectionWrapper cn = ConnectionManager.getConnection((long)this.tarDbId);){
                JdbcConnectionFactory factory = (JdbcConnectionFactory)cn.getFactory();
                List list = factory.getTables(cn);
                HashSet<String> tables = new HashSet<String>(list.size());
                for (String table : list) {
                    tables.add(table.toLowerCase(Locale.ENGLISH));
                }
                this.tarTables = Collections.synchronizedSet(tables);
            }
        }
        return this.tarTables;
    }

    public JdbcConnectionWrapper getSrcConnection() {
        return (JdbcConnectionWrapper)ConnectionManager.getConnection((long)this.srcDbId);
    }

    public JdbcConnectionWrapper getTarConnection() {
        return (JdbcConnectionWrapper)ConnectionManager.getConnection((long)this.tarDbId);
    }

    public Table getSrcTable(String tableName) {
        try (JdbcConnectionWrapper tar = this.getSrcConnection();){
            Table table = tar.getTable(tableName);
            return table;
        }
    }

    public boolean isLogTable(Table srcTable) {
        if (this.log_tab_patterns == null) {
            return false;
        }
        return this.log_tab_patterns.matches(srcTable.getName().toLowerCase(Locale.ENGLISH));
    }

    public Table getTarTable(Table srcTable) {
        String tableName = srcTable.getName().toLowerCase(Locale.ENGLISH);
        Set<String> tables = this.getTarTables();
        if (tables.contains(tableName)) {
            return this.getTarTable0(srcTable);
        }
        if (!this.auto_create_table) {
            return null;
        }
        return this.createTarTable(srcTable);
    }

    private Table getTarTable0(Table srcTable) {
        try (JdbcConnectionWrapper tar = this.getTarConnection();){
            DbType dbType = tar.getJdbcConnectionFactory().getDatabaseType();
            Table table = tar.getTable(dbType.qualifyTableName(srcTable.getName()));
            return table;
        }
    }

    private Table createTarTable(Table srcTable) {
        try (JdbcConnectionWrapper tar = this.getTarConnection();){
            DbType dbType = tar.getJdbcConnectionFactory().getDatabaseType();
            if (dbType instanceof UserDefineDbType) {
                throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6570\u636e\u5e93\u7c7b\u578b\u4e0d\u652f\u6301\u521b\u5efa\u8868\u3002", (String)"UserDefineDbType_Not_creattable", (String)"isc-dbc-platform-core", (Object[])new Object[0]));
            }
            String sql = TableUtil.createTableSQL((Table)srcTable, (DbType)dbType);
            DbUtil.executeUpdate((Connection)tar, (String)sql);
            this.getTarTables().add(srcTable.getName().toLowerCase());
            Table table = tar.getTable(dbType.qualifyTableName(srcTable.getName()));
            return table;
        }
    }

    public static DatabaseCopySchema get(long id) {
        return (DatabaseCopySchema)CacheableObjectManager.get(DatabaseCopySchema.class, (Long)id);
    }

    static {
        CacheableObjectManager.registerFactory((CacheableObjectFactory)new DatabaseCopySchemaFactory());
    }
}

