/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.dbc.platform.core;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.isc.dbc.platform.core.DatabaseCopyJob;
import kd.isc.dbc.platform.core.DatabaseCopySchema;
import kd.isc.dbc.platform.core.DatabaseCopySubJobFactory;
import kd.isc.dbc.platform.core.Util;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.JdbcConnectionWrapper;
import kd.isc.iscb.platform.core.dc.e.DataBatchWriter;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbType;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.StringUtil;

public final class DatabaseCopySubJob
implements Job {
    private long id;
    private String title;
    private DatabaseCopySchema dbc;
    private DataRow current;
    private AtomicLong totalCount = new AtomicLong();
    private AtomicLong completeCount = new AtomicLong();
    private AtomicLong bytesCount = new AtomicLong();
    private long startTime;

    public DatabaseCopySubJob(long id, String title) {
        this.id = id;
        this.title = title;
    }

    public String getParam() {
        return String.valueOf(this.id);
    }

    public String getTitle() {
        return this.title;
    }

    public long getOwnerId() {
        return this.id;
    }

    public JobFactory getFactory() {
        return new DatabaseCopySubJobFactory();
    }

    public Job.Progress getRealtimeProgress() {
        DataRow current = this.current;
        if (current == null) {
            return null;
        }
        long completeCount = this.completeCount.get();
        long totalCount = this.totalCount.get();
        if (totalCount > 0L) {
            String description = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u590d\u5236\uff1a%1$s...%2$s/%3$s", (String)"DatabaseCopySubJob_2", (String)"isc-dbc-platform-core", (Object[])new Object[0]), current.get((Object)"ftable_name"), completeCount, totalCount);
            return new Job.Progress(totalCount, completeCount, description);
        }
        String description = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u590d\u5236\uff1a%s...", (String)"DatabaseCopySubJob_3", (String)"isc-dbc-platform-core", (Object[])new Object[0]), current.get((Object)"ftable_name"));
        return new Job.Progress(1L, 0L, description);
    }

    public String refreshProgress() {
        Job.Progress p = this.getRealtimeProgress();
        if (p == null) {
            return null;
        }
        this.refreshEntryProgress();
        return p.getDescription();
    }

    private void refreshEntryProgress() {
        String sql = "UPDATE t_dbc_database_copy_items SET frow_count=?, fcomplete_count=?,fbytes_count=?,felapsed_time=? WHERE fentryid=?";
        Timestamp now = new Timestamp(System.currentTimeMillis());
        long millis = now.getTime() - this.startTime;
        BigDecimal elapsedTime = BigDecimal.valueOf((double)millis / 1000.0).setScale(1, RoundingMode.CEILING);
        List values = D.asList((Object[])new Object[]{this.totalCount.get(), this.completeCount.get(), this.bytesCount.get(), elapsedTime, this.getEntryId()});
        List types = D.asList((Object[])new Integer[]{-5, -5, -5, 3, -5});
        Util.executeSQL(sql, values, types);
    }

    public Job.Returns runX() {
        this.run();
        if (this.current == null) {
            return Job.Returns.DESTRUCTION;
        }
        return Job.Returns.delay((int)0);
    }

    public void run() {
        this.current = this.takeReadyEntry();
        if (this.current == null) {
            return;
        }
        Throwable cause = null;
        try {
            this.doTableCopy();
            SignalManager.checkCancelSignal();
        }
        catch (Throwable e) {
            cause = e;
            this.setFailed(e);
        }
        finally {
            boolean hasMore = DatabaseCopyJob.updateProgress(this.dbc.getDynamicObject(), cause);
            if (Util.isEnd(hasMore, cause instanceof TaskCancelException)) {
                this.current = null;
            }
        }
    }

    private void doTableCopy() throws SQLException {
        this.dbc = DatabaseCopySchema.get(this.id);
        this.totalCount.set(-1L);
        this.completeCount.set(-1L);
        this.bytesCount.set(-1L);
        String tableName = D.s((Object)this.current.get((Object)"ftable_name"));
        Table srcTable = this.dbc.getSrcTable(tableName);
        Table tarTable = this.dbc.getTarTable(srcTable);
        SignalManager.checkCancelSignal();
        String message = Util.checkCompatibility(srcTable, tarTable);
        if (message != null) {
            this.setOmitted(message);
        } else if (this.dbc.isLogTable(srcTable)) {
            this.setSuccess(ResManager.loadKDString((String)"\u65e5\u5fd7\u8868", (String)"DatabaseCopySubJob_1", (String)"isc-dbc-platform-core", (Object[])new Object[0]));
        } else {
            this.doTableCopy(this.dbc, srcTable, tarTable);
            this.setSuccess(" ");
        }
    }

    private void doTableCopy(DatabaseCopySchema dbc, Table srcTable, Table tarTable) throws SQLException {
        try (JdbcConnectionWrapper src = dbc.getSrcConnection();
             JdbcConnectionWrapper tar = dbc.getTarConnection();){
            long total = D.l((Object)DbUtil.executeScalar((Connection)src, (String)("SELECT COUNT(*) AS C FROM " + srcTable.getQuotedName())));
            this.totalCount.set(total);
            this.completeCount.set(0L);
            this.bytesCount.set(0L);
            if (total > 0L) {
                this.doTableCopy(dbc, srcTable, tarTable, src, tar);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTableCopy(DatabaseCopySchema dbc, Table srcTable, Table tarTable, JdbcConnectionWrapper src, JdbcConnectionWrapper tar) throws SQLException {
        DbType srcDb = src.getJdbcConnectionFactory().getDatabaseType();
        srcDb.setBigQuery((Connection)src);
        try {
            this.innerDoTableCopy(dbc, srcTable, tarTable, src, tar);
        }
        finally {
            srcDb.unsetBigQuery((Connection)src);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerDoTableCopy(DatabaseCopySchema dbc, Table srcTable, Table tarTable, JdbcConnectionWrapper src, JdbcConnectionWrapper tar) {
        boolean tarIsEmpty = Util.isEmpty(tar, tarTable);
        SignalManager.checkCancelSignal();
        String sql = Util.generateSelectSQL(srcTable, Util.getFields(srcTable));
        try (ObjectReader reader = DbUtil.executeQuery((Connection)src, (String)sql, Collections.emptyList(), Collections.emptyList());){
            int batchSize = dbc.getBatchSize();
            ArrayList<Object> batch = new ArrayList<DataRow>(batchSize);
            int batchBytes = 0;
            DataRow row = (DataRow)reader.read();
            while (row != null) {
                batch.add(row);
                if (this.batchIsFull(batchSize, batchBytes += DbUtil.calcBytes((DataRow)row), batch)) {
                    this.copyBatch(batch, tar, tarTable, srcTable, batchBytes, tarIsEmpty);
                    batchBytes = 0;
                    batch = new ArrayList(batchSize);
                }
                row = (DataRow)reader.read();
            }
            this.copyBatch(batch, tar, tarTable, srcTable, batchBytes, tarIsEmpty);
        }
    }

    private boolean batchIsFull(int batchSize, int batchBytes, List<DataRow> batch) {
        return batch.size() >= batchSize || batchBytes >= 10000000;
    }

    private void copyBatch(List<DataRow> batch, JdbcConnectionWrapper tar, Table tarTable, Table srcTable, long batchBytes, boolean tarIsEmpty) {
        if (!batch.isEmpty()) {
            SignalManager.checkCancelSignal();
            Util.replaceZeroChar(batch);
            int batchSize = batch.size();
            if (tarIsEmpty) {
                DataBatchWriter.batchInsert((ConnectionWrapper)tar, (Table)tarTable, batch);
            } else {
                this.batchSave(tar, batch, srcTable, tarTable);
            }
            this.completeCount.addAndGet(batchSize);
            this.bytesCount.addAndGet(batchBytes);
        }
    }

    private void batchSave(JdbcConnectionWrapper tar, List<DataRow> batch, Table srcTable, Table tarTable) {
        Map<String, DataRow> srcMapping = Util.groupByPrimaryKeys(batch, tarTable);
        List<DataRow> forUpdate = Util.filterForUpdate(batch, tar, tarTable, srcMapping, srcTable);
        ArrayList<DataRow> forInsert = new ArrayList<DataRow>(srcMapping.values());
        DataBatchWriter.batchInsert((ConnectionWrapper)tar, (Table)tarTable, forInsert);
        DataBatchWriter.batchUpdate((ConnectionWrapper)tar, (Table)tarTable, forUpdate, (String[])this.collectFieldsForUpdate(srcTable), (List)tarTable.getPrimaryKeys(), (Column)tarTable.getPrimaryKey());
    }

    private String[] collectFieldsForUpdate(Table srcTable) {
        ArrayList<String> fields = new ArrayList<String>(srcTable.getFieldCount());
        for (int i = 0; i < srcTable.getFieldCount(); ++i) {
            Column field = srcTable.getField(i);
            if (field.isPrimaryKey()) continue;
            fields.add(field.getName());
        }
        return fields.toArray(new String[fields.size()]);
    }

    private long getEntryId() {
        return D.l((Object)this.current.get((Object)"fentryid"));
    }

    private DataRow takeReadyEntry() {
        DataRow entry;
        do {
            if ((entry = this.findFirstReadyEntry()) != null) continue;
            return null;
        } while (!this.setRunning(D.l((Object)entry.get((Object)"fentryid"))));
        this.startTime = System.currentTimeMillis();
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataRow findFirstReadyEntry() {
        String sql = "SELECT TOP 1 fentryid,ftable_name FROM t_dbc_database_copy_items WHERE fid=? AND fstate = 'READY'";
        List values = D.asList((Object[])new Object[]{this.id});
        List types = D.asList((Object[])new Integer[]{-5});
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            DataRow dataRow = DbUtil.executeRow((Connection)cn, (String)sql, (List)values, (List)types);
            return dataRow;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setRunning(long entryId) {
        String sql = "UPDATE t_dbc_database_copy_items SET fstate='RUNNING', fremark=' ', fremark_tag=null,frow_count = -1,fcomplete_count = -1,fbytes_count = -1, fstart_time = ?, fend_time = null  WHERE fentryid=? AND fstate = 'READY'";
        Timestamp now = new Timestamp(System.currentTimeMillis());
        List values = D.asList((Object[])new Object[]{now, entryId});
        List types = D.asList((Object[])new Integer[]{93, -5});
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            boolean bl = DbUtil.executeUpdate((Connection)cn, (String)sql, (List)values, (List)types) > 0;
            return bl;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private void setFailed(Throwable err) {
        String sql = "UPDATE t_dbc_database_copy_items SET fstate=?, fremark=?, fremark_tag=?,fend_time=?,frow_count=?, fcomplete_count=?,fbytes_count=?,felapsed_time=? WHERE fentryid=?";
        String remark = StringUtil.trim((String)StringUtil.getCascadeMessage((Throwable)err), (int)80);
        String remark_tag = StringUtil.toString((Throwable)err);
        String state = err instanceof TaskCancelException ? "ABORTED" : "FAILED";
        Timestamp now = new Timestamp(System.currentTimeMillis());
        long millis = now.getTime() - this.startTime;
        BigDecimal elapsedTime = BigDecimal.valueOf((double)millis / 1000.0).setScale(1, RoundingMode.CEILING);
        List values = D.asList((Object[])new Object[]{state, remark, remark_tag, now, this.totalCount.get(), this.completeCount.get(), this.bytesCount.get(), elapsedTime, this.getEntryId()});
        List types = D.asList((Object[])new Integer[]{12, 12, 12, 93, -5, -5, -5, 3, -5});
        Util.executeSQL(sql, values, types);
    }

    private void setOmitted(String message) {
        String sql = "UPDATE t_dbc_database_copy_items SET fstate='OMITTED', fremark=?,fend_time=?,frow_count= -1, fcomplete_count= -1  WHERE fentryid=?";
        Timestamp now = new Timestamp(System.currentTimeMillis());
        List values = D.asList((Object[])new Object[]{StringUtil.trim((String)message, (int)150), now, this.getEntryId()});
        List types = D.asList((Object[])new Integer[]{12, 93, -5});
        Util.executeSQL(sql, values, types);
    }

    private void setSuccess(String remark) {
        String sql = "UPDATE t_dbc_database_copy_items SET fstate='SUCCESS', frow_count=?, fcomplete_count=?, fbytes_count=?,fend_time=?,felapsed_time=?,fremark=?  WHERE fentryid=?";
        Timestamp now = new Timestamp(System.currentTimeMillis());
        long millis = now.getTime() - this.startTime;
        BigDecimal elapsedTime = BigDecimal.valueOf((double)millis / 1000.0).setScale(1, RoundingMode.CEILING);
        List values = D.asList((Object[])new Object[]{this.totalCount.get(), this.completeCount.get(), this.bytesCount.get(), now, elapsedTime, remark, this.getEntryId()});
        List types = D.asList((Object[])new Integer[]{-5, -5, -5, 93, 3, 12, -5});
        Util.executeSQL(sql, values, types);
    }
}

