/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.dbc.platform.core;

import java.util.HashMap;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dlock.DLock;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.dbc.platform.core.TableCopyCronJobFactory;
import kd.isc.dbc.platform.core.TableCopyJob;
import kd.isc.dbc.platform.core.TableCopyTaskUtil;
import kd.isc.dbc.platform.core.Util;
import kd.isc.iscb.platform.core.job.AbstractCronJob;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.startjob.Const;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.Json;

public class TableCopyCronJob
extends AbstractCronJob
implements Const {
    public static final JobFactory FACTORY = new TableCopyCronJobFactory();
    private long id;
    private String title;

    public TableCopyCronJob(String schedule, long count, long id, String title, long expireTime) {
        super(schedule, count, expireTime);
        this.id = id;
        this.title = title;
    }

    public String getParam() {
        HashMap<String, Object> param = new HashMap<String, Object>(5);
        param.put("id", this.id);
        param.put("schedule", this.getSchedule());
        param.put("title", this.title);
        param.put("count", this.getCount());
        param.put("expireTime", this.getExpireTime());
        return Json.toString(param);
    }

    public void run() {
        DynamicObject tableCopy = BusinessDataServiceHelper.loadSingleFromCache((Object)this.id, (String)"dbc_table_copy");
        DynamicObject tableCopyLog = this.createByLock(RequestContext.get(), tableCopy);
        if (tableCopyLog != null) {
            this.updateStateInterruptedJob();
            new TableCopyJob(D.l((Object)tableCopyLog.getPkValue()), this.title).runX();
        }
    }

    private void updateStateInterruptedJob() {
        QFilter filter = new QFilter("table_copy", "=", (Object)this.id).and(new QFilter("state", "=", (Object)"RUNNING"));
        DynamicObject tableCopyLog = BusinessDataServiceHelper.loadSingle((String)"dbc_table_copy_log", (String)"id,state", (QFilter[])new QFilter[]{filter});
        if (tableCopyLog != null) {
            this.updateEntryStateInterruptedJob(D.l((Object)tableCopyLog.getPkValue()));
            tableCopyLog.set("state", (Object)"ABORTED");
            SaveServiceHelper.update((DynamicObject[])new DynamicObject[]{tableCopyLog});
        }
    }

    private void updateEntryStateInterruptedJob(long tableCopyLogId) {
        String sql = "UPDATE t_dbc_tc_log_items SET fstate=? WHERE fid=? and fstate=?";
        List values = D.asList((Object[])new Object[]{"ABORTED", tableCopyLogId, "RUNNING"});
        List types = D.asList((Object[])new Integer[]{12, -5, 12});
        Util.executeSQL(sql, values, types);
    }

    private DynamicObject createByLock(RequestContext ctx, DynamicObject tableCopy) {
        DynamicObject tableLog = null;
        String key = "/isc/dbc/table_copy/" + ctx.getAccountId() + "/" + tableCopy.getPkValue();
        try (DLock lock = DLock.create((String)key).fastMode();){
            if (lock.tryLock()) {
                tableLog = TableCopyTaskUtil.create(tableCopy);
            }
        }
        return tableLog;
    }

    public long getOwnerId() {
        return this.id;
    }

    public String getTitle() {
        return "*" + this.title;
    }

    public JobFactory getFactory() {
        return FACTORY;
    }
}

