/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.dbc.platform.core;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.dbc.platform.core.TableCopyJobFactory;
import kd.isc.dbc.platform.core.TableCopyTaskUtil;
import kd.isc.dbc.platform.core.Util;
import kd.isc.iscb.platform.core.connector.ConnectionManager;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.JdbcConnectionFactory;
import kd.isc.iscb.platform.core.connector.JdbcConnectionWrapper;
import kd.isc.iscb.platform.core.dc.e.DataBatchWriter;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobFactory;
import kd.isc.iscb.platform.core.task.SignalManager;
import kd.isc.iscb.platform.core.util.CommonUtil;
import kd.isc.iscb.util.connector.TableUtil;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbType;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Schema;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.db.type.UserDefineDbType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.TaskCancelException;
import kd.isc.iscb.util.io.ObjectReader;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;

public final class TableCopyJob
implements Job {
    private static final String VALUE_FIXED = "value_fixed";
    private static final String COMPARE = "compare";
    private static final String FILTER_COMPARE = "filter_compare";
    private static final String LEFT_BRACKET = "left_bracket";
    private static final String COLUMN = "column";
    private static final String RIGHT_BRACKET = "right_bracket";
    private static final String LINK = "link";
    private long id;
    private String title;
    private DynamicObject tableCopyLog;
    private DataRow current;
    private AtomicLong totalCount = new AtomicLong();
    private AtomicLong completeCount = new AtomicLong();
    private AtomicLong bytesCount = new AtomicLong();
    private long startTime;

    public TableCopyJob(long id, String title) {
        this.id = id;
        this.title = title;
    }

    public String getParam() {
        return String.valueOf(this.id);
    }

    public String getTitle() {
        return this.title;
    }

    public long getOwnerId() {
        return this.id;
    }

    public JobFactory getFactory() {
        return new TableCopyJobFactory();
    }

    public Job.Returns runX() {
        this.run();
        return Job.Returns.DEFAULT;
    }

    public void run() {
        this.loadTableCopyLog();
        if (this.setRunning()) {
            SignalManager.registerTask((String)D.s((Object)this.id));
            try {
                this.current = this.takeReadyEntry();
                while (this.current != null) {
                    SignalManager.checkCancelSignal();
                    this.executeReadyEntry();
                }
            }
            finally {
                SignalManager.unregisterTask((String)D.s((Object)this.id));
            }
        }
    }

    public Job.Progress getRealtimeProgress() {
        DataRow current = this.current;
        if (current == null) {
            return null;
        }
        long completeCount = this.completeCount.get();
        long totalCount = this.totalCount.get();
        if (totalCount > 0L) {
            String description = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u590d\u5236\uff1a%1$s...%2$s/%3$s", (String)"TableCopyJob_1", (String)"isc-dbc-platform-core", (Object[])new Object[0]), current.get((Object)"ftable_name"), completeCount, totalCount);
            return new Job.Progress(totalCount, completeCount, description);
        }
        String description = String.format(ResManager.loadKDString((String)"\u6b63\u5728\u590d\u5236\uff1a%s...", (String)"TableCopyJob_2", (String)"isc-dbc-platform-core", (Object[])new Object[0]), current.get((Object)"ftable_name"));
        return new Job.Progress(1L, 0L, description);
    }

    public String refreshProgress() {
        Job.Progress p = this.getRealtimeProgress();
        if (p == null) {
            return null;
        }
        this.refreshEntryProgress();
        return p.getDescription();
    }

    private void refreshEntryProgress() {
        String sql = "UPDATE t_dbc_tc_log_items SET frow_count=?, fcomplete_count=?,fbytes_count=?,felapsed_time=? WHERE fentryid=?";
        Timestamp now = new Timestamp(System.currentTimeMillis());
        long millis = now.getTime() - this.startTime;
        BigDecimal elapsedTime = BigDecimal.valueOf((double)millis / 1000.0).setScale(1, RoundingMode.CEILING);
        List values = D.asList((Object[])new Object[]{this.totalCount.get(), this.completeCount.get(), this.bytesCount.get(), elapsedTime, this.getEntryId()});
        List types = D.asList((Object[])new Integer[]{-5, -5, -5, 3, -5});
        Util.executeSQL(sql, values, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeReadyEntry() {
        Throwable cause = null;
        try {
            this.doTableCopy();
            SignalManager.checkCancelSignal();
        }
        catch (Throwable e) {
            cause = e;
            this.setFailed(e);
        }
        finally {
            boolean hasMore = this.updateProgress(this.tableCopyLog, cause);
            if (Util.isEnd(hasMore, cause instanceof TaskCancelException)) {
                DataRow dataRow = TableCopyTaskUtil.queryExeResult(this.id);
                if ("FAILED".equals(dataRow.get((Object)"fstate")) && D.i((Object)dataRow.get((Object)"fexe_count")) < D.i((Object)dataRow.get((Object)"fretry_count"))) {
                    TableCopyTaskUtil.restart(this.tableCopyLog, false);
                }
                this.current = null;
            } else {
                this.current = this.takeReadyEntry();
            }
        }
    }

    private void loadTableCopyLog() {
        this.tableCopyLog = BusinessDataServiceHelper.loadSingle((Object)this.id, (String)"dbc_table_copy_log");
    }

    private void doTableCopy() throws SQLException {
        this.totalCount.set(0L);
        this.completeCount.set(0L);
        this.bytesCount.set(0L);
        String tableName = D.s((Object)this.current.get((Object)"ftable_name"));
        String filter = D.s((Object)this.current.get((Object)"ffilter"));
        String defineCondition = D.s((Object)this.current.get((Object)"fdefine_condition"));
        String link = D.s((Object)this.current.get((Object)"flink"));
        Table srcTable = this.getSrcTable(tableName);
        Table tarTable = this.getTarTable(srcTable);
        SignalManager.checkCancelSignal();
        String message = Util.checkCompatibility(srcTable, tarTable);
        if (message != null) {
            this.setOmitted(message);
        } else {
            this.doTableCopy(this.tableCopyLog, srcTable, tarTable, filter, defineCondition, link);
            this.setSuccess(" ");
        }
    }

    private void doTableCopy(DynamicObject dbc, Table srcTable, Table tarTable, String filter, String defineCondition, String link) throws SQLException {
        try (JdbcConnectionWrapper src = this.getSrcConnection();
             JdbcConnectionWrapper tar = this.getTarConnection();){
            SignalManager.checkCancelSignal();
            ArrayList<Integer> types = new ArrayList<Integer>();
            ArrayList<Object> values = new ArrayList<Object>();
            List<Map<String, Object>> filterColl = this.parseFilter(filter);
            String fieldFilter = this.createFilter(srcTable, filterColl, types, values);
            String lastFilter = this.buildFilter(fieldFilter, defineCondition, link);
            String sql = "";
            sql = StringUtil.isEmpty((String)lastFilter) ? "SELECT COUNT(*) AS C FROM " + srcTable.getQuotedName() : "SELECT COUNT(*) AS C FROM " + srcTable.getQuotedName() + " WHERE " + lastFilter;
            long total = D.l((Object)DbUtil.executeScalar((Connection)src, (String)sql, values, types));
            this.totalCount.set(total);
            this.completeCount.set(0L);
            this.bytesCount.set(0L);
            if (total > 0L) {
                this.doTableCopy(dbc, srcTable, tarTable, src, tar, lastFilter, values, types);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doTableCopy(DynamicObject dbc, Table srcTable, Table tarTable, JdbcConnectionWrapper src, JdbcConnectionWrapper tar, String filter, List<Object> values, List<Integer> types) throws SQLException {
        DbType srcDb = src.getJdbcConnectionFactory().getDatabaseType();
        srcDb.setBigQuery((Connection)src);
        try {
            this.innerDoTableCopy(dbc, srcTable, tarTable, src, tar, filter, values, types);
        }
        finally {
            srcDb.unsetBigQuery((Connection)src);
        }
    }

    private synchronized Set<String> getTarTables() {
        try (JdbcConnectionWrapper tarCn = this.getTarConnection();){
            JdbcConnectionFactory factory = (JdbcConnectionFactory)tarCn.getFactory();
            List list = factory.getTables((ConnectionWrapper)tarCn);
            HashSet<String> tables = new HashSet<String>(list.size());
            for (String table : list) {
                tables.add(table.toLowerCase(Locale.ENGLISH));
            }
            Set set = Collections.synchronizedSet(tables);
            return set;
        }
    }

    private JdbcConnectionWrapper getSrcConnection() {
        DynamicObject srcDbLink = this.tableCopyLog.getDynamicObject("src_db").getDynamicObject("dblink");
        if (srcDbLink == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u6765\u6e90\u6570\u636e\u5e93\u7684\u6570\u636e\u5e93\u8fde\u63a5\u4e3a\u7a7a\uff0c\u8bf7\u524d\u5f80\u6570\u636e\u5e93\u5217\u8868\u4fee\u6539\u5bf9\u5e94\u6570\u636e\u5e93\u7684\u6570\u636e\u5e93\u8fde\u63a5\u3002", (String)"TableCopyJob_src", (String)"isc-dbc-platform-core", (Object[])new Object[0]));
        }
        return (JdbcConnectionWrapper)ConnectionManager.getConnection((long)D.l((Object)srcDbLink.getPkValue()));
    }

    private JdbcConnectionWrapper getTarConnection() {
        DynamicObject tarDbLink = this.tableCopyLog.getDynamicObject("tar_db").getDynamicObject("dblink");
        if (tarDbLink == null) {
            throw new IllegalArgumentException(ResManager.loadKDString((String)"\u76ee\u6807\u6570\u636e\u5e93\u7684\u6570\u636e\u5e93\u8fde\u63a5\u4e3a\u7a7a\uff0c\u8bf7\u524d\u5f80\u6570\u636e\u5e93\u5217\u8868\u4fee\u6539\u5bf9\u5e94\u6570\u636e\u5e93\u7684\u6570\u636e\u5e93\u8fde\u63a5\u3002", (String)"TableCopyJob_tar", (String)"isc-dbc-platform-core", (Object[])new Object[0]));
        }
        return (JdbcConnectionWrapper)ConnectionManager.getConnection((long)D.l((Object)tarDbLink.getPkValue()));
    }

    private Table getSrcTable(String tableName) {
        try (JdbcConnectionWrapper src = this.getSrcConnection();){
            Table table = src.getTable(tableName);
            return table;
        }
    }

    private Table getTarTable(Table tarTable) {
        String tableName = tarTable.getName().toLowerCase(Locale.ENGLISH);
        Set<String> tables = this.getTarTables();
        if (tables.contains(tableName)) {
            return this.getTarTable0(tarTable);
        }
        if (D.x((Object)this.tableCopyLog.get("auto_create_table"))) {
            return this.createTarTable(tarTable);
        }
        return null;
    }

    private Table getTarTable0(Table srcTable) {
        try (JdbcConnectionWrapper tar = this.getTarConnection();){
            DbType dbType = tar.getJdbcConnectionFactory().getDatabaseType();
            Table table = tar.getTable(dbType.qualifyTableName(srcTable.getName()));
            return table;
        }
    }

    private Table createTarTable(Table srcTable) {
        try (JdbcConnectionWrapper tar = this.getTarConnection();){
            DbType dbType = tar.getJdbcConnectionFactory().getDatabaseType();
            if (dbType instanceof UserDefineDbType) {
                throw new UnsupportedOperationException(ResManager.loadKDString((String)"\u81ea\u5b9a\u4e49\u6570\u636e\u5e93\u7c7b\u578b\u4e0d\u652f\u6301\u521b\u5efa\u8868\u3002", (String)"UserDefineDbType_Not_creattable", (String)"isc-dbc-platform-core", (Object[])new Object[0]));
            }
            String sql = TableUtil.createTableSQL((Table)srcTable, (DbType)dbType);
            DbUtil.executeUpdate((Connection)tar, (String)sql);
            this.getTarTables().add(srcTable.getName().toLowerCase());
            Table table = tar.getTable(dbType.qualifyTableName(srcTable.getName()));
            return table;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void innerDoTableCopy(DynamicObject dbc, Table srcTable, Table tarTable, JdbcConnectionWrapper src, JdbcConnectionWrapper tar, String filter, List<Object> values, List<Integer> types) {
        boolean tarIsEmpty = Util.isEmpty(tar, tarTable);
        String sql = "";
        sql = StringUtil.isEmpty((String)filter) ? Util.generateSelectSQL(srcTable, Util.getFields(srcTable)) : Util.generateSelectSQL(srcTable, Util.getFields(srcTable)) + " where " + filter;
        try (ObjectReader reader = DbUtil.executeQuery((Connection)src, (String)sql, values, types);){
            int batchSize = D.i((Object)dbc.get("batch_size"));
            ArrayList<Object> batch = new ArrayList<DataRow>(batchSize);
            int batchBytes = 0;
            DataRow row = (DataRow)reader.read();
            while (row != null) {
                SignalManager.checkCancelSignal();
                batch.add(row);
                if (this.batchIsFull(batchSize, batchBytes += DbUtil.calcBytes((DataRow)row), batch)) {
                    this.copyBatch(batch, tar, tarTable, srcTable, batchBytes, tarIsEmpty);
                    batchBytes = 0;
                    batch = new ArrayList(batchSize);
                }
                row = (DataRow)reader.read();
            }
            this.copyBatch(batch, tar, tarTable, srcTable, batchBytes, tarIsEmpty);
        }
    }

    private boolean batchIsFull(int batchSize, int batchBytes, List<DataRow> batch) {
        return batch.size() >= batchSize || batchBytes >= 10000000;
    }

    private void copyBatch(List<DataRow> batch, JdbcConnectionWrapper tar, Table tarTable, Table srcTable, long batchBytes, boolean tarIsEmpty) {
        if (!batch.isEmpty()) {
            SignalManager.checkCancelSignal();
            Util.replaceZeroChar(batch);
            int batchSize = batch.size();
            if (tarIsEmpty) {
                DataBatchWriter.batchInsert((ConnectionWrapper)tar, (Table)tarTable, batch);
            } else {
                this.batchSave(tar, batch, srcTable, tarTable);
            }
            this.completeCount.addAndGet(batchSize);
            this.bytesCount.addAndGet(batchBytes);
        }
    }

    private void batchSave(JdbcConnectionWrapper tar, List<DataRow> batch, Table srcTable, Table tarTable) {
        Map<String, DataRow> srcMapping = Util.groupByPrimaryKeys(batch, tarTable);
        List<DataRow> forUpdate = Util.filterForUpdate(batch, tar, tarTable, srcMapping, srcTable);
        ArrayList<DataRow> forInsert = new ArrayList<DataRow>(srcMapping.values());
        DataBatchWriter.batchInsert((ConnectionWrapper)tar, (Table)tarTable, forInsert);
        DataBatchWriter.batchUpdate((ConnectionWrapper)tar, (Table)tarTable, forUpdate, (String[])this.collectFieldsForUpdate(srcTable), (List)tarTable.getPrimaryKeys(), (Column)tarTable.getPrimaryKey());
    }

    private String[] collectFieldsForUpdate(Table srcTable) {
        ArrayList<String> fields = new ArrayList<String>(srcTable.getFieldCount());
        for (int i = 0; i < srcTable.getFieldCount(); ++i) {
            Column field = srcTable.getField(i);
            if (field.isPrimaryKey()) continue;
            fields.add(field.getName());
        }
        return fields.toArray(new String[fields.size()]);
    }

    private long getEntryId() {
        return D.l((Object)this.current.get((Object)"fentryid"));
    }

    private DataRow takeReadyEntry() {
        DataRow entry;
        do {
            if ((entry = this.findFirstReadyEntry()) != null) continue;
            return null;
        } while (!this.setEntriesRunning(D.l((Object)entry.get((Object)"fentryid")), D.i((Object)this.tableCopyLog.get("exe_count"))));
        this.startTime = System.currentTimeMillis();
        return entry;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setEntriesRunning(long entryId, int exeCount) {
        String sql = "UPDATE t_dbc_tc_log_items SET fstate='RUNNING', ftable_remark=' ', ftable_remark_tag=null, frow_count = 0,fcomplete_count = 0,fbytes_count = 0, ftable_start_time = ?, ftable_end_time = null,fexe_count =?  WHERE fentryid=? AND fstate = 'READY'";
        Timestamp now = new Timestamp(System.currentTimeMillis());
        List values = D.asList((Object[])new Object[]{now, exeCount, entryId});
        List types = D.asList((Object[])new Integer[]{93, 4, -5});
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            boolean bl = DbUtil.executeUpdate((Connection)cn, (String)sql, (List)values, (List)types) > 0;
            return bl;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DataRow findFirstReadyEntry() {
        String sql = "SELECT TOP 1 fentryid,ftable_name,ffilter,fdefine_condition,flink FROM t_dbc_tc_log_items WHERE fid=? AND fstate = 'READY'";
        List values = D.asList((Object[])new Object[]{this.id});
        List types = D.asList((Object[])new Integer[]{-5});
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            DataRow dataRow = DbUtil.executeRow((Connection)cn, (String)sql, (List)values, (List)types);
            return dataRow;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private void setFailed(Throwable err) {
        String sql = "UPDATE t_dbc_tc_log_items SET fstate=?, ftable_remark=?, ftable_remark_tag=?,ftable_end_time=?,frow_count=?, fcomplete_count=?,fbytes_count=?,felapsed_time=? WHERE fentryid=?";
        String remark = StringUtil.trim((String)StringUtil.getCascadeMessage((Throwable)err), (int)80);
        String remark_tag = StringUtil.toString((Throwable)err);
        String state = err instanceof TaskCancelException ? "ABORTED" : "FAILED";
        Timestamp now = new Timestamp(System.currentTimeMillis());
        long millis = now.getTime() - this.startTime;
        BigDecimal elapsedTime = BigDecimal.valueOf((double)millis / 1000.0).setScale(1, RoundingMode.CEILING);
        List values = D.asList((Object[])new Object[]{state, remark, remark_tag, now, this.totalCount.get(), this.completeCount.get(), this.bytesCount.get(), elapsedTime, this.getEntryId()});
        List types = D.asList((Object[])new Integer[]{12, 12, 12, 93, -5, -5, -5, 3, -5});
        Util.executeSQL(sql, values, types);
    }

    private void setOmitted(String message) {
        String sql = "UPDATE t_dbc_tc_log_items SET fstate='OMITTED', ftable_remark=?,ftable_end_time=?,frow_count= 0, fcomplete_count= 0  WHERE fentryid=?";
        Timestamp now = new Timestamp(System.currentTimeMillis());
        List values = D.asList((Object[])new Object[]{message, now, this.getEntryId()});
        List types = D.asList((Object[])new Integer[]{12, 93, -5});
        Util.executeSQL(sql, values, types);
    }

    private void setSuccess(String remark) {
        String sql = "UPDATE t_dbc_tc_log_items SET fstate='SUCCESS', frow_count=?, fcomplete_count=?, fbytes_count=?,ftable_end_time=?,felapsed_time=?,ftable_remark=?  WHERE fentryid=?";
        Timestamp now = new Timestamp(System.currentTimeMillis());
        long millis = now.getTime() - this.startTime;
        BigDecimal elapsedTime = BigDecimal.valueOf((double)millis / 1000.0).setScale(1, RoundingMode.CEILING);
        List values = D.asList((Object[])new Object[]{this.totalCount.get(), this.completeCount.get(), this.bytesCount.get(), now, elapsedTime, remark, this.getEntryId()});
        List types = D.asList((Object[])new Integer[]{-5, -5, -5, 93, 3, 12, -5});
        Util.executeSQL(sql, values, types);
    }

    private boolean updateProgress(DynamicObject tableLog, Throwable cause) {
        int runningCount;
        int readyCount;
        long id = tableLog.getLong("id");
        Map<String, Long> progress = this.queryEntryStates(id);
        Timestamp now = new Timestamp(System.currentTimeMillis());
        int successCount = D.i((Object)progress.remove("SUCCESS"));
        int omittedCount = D.i((Object)progress.remove("OMITTED"));
        int failedCount = D.i((Object)progress.remove("FAILED"));
        long totalBytes = D.l((Object)progress.remove("TOTAL_BYTES"));
        BigDecimal elapsedTime = BigDecimal.valueOf((double)D.l((Object)progress.remove("ELAPSED_TIME")) / 10.0).setScale(1, RoundingMode.CEILING);
        int abortedCount = D.i((Object)progress.get("ABORTED"));
        String state = this.calcState(failedCount, abortedCount, readyCount = D.i((Object)progress.get("READY")), runningCount = D.i((Object)progress.get("RUNNING")), cause);
        Timestamp endTime = "RUNNING".equals(state) ? null : now;
        String sql = "UPDATE t_dbc_table_copy_log SET fsuccess_count=?,fomitted_count=?,ffailed_count=?, fstate=?,fend_time=?,ftotal_elapsed_time=?,ftotal_bytes_count=? WHERE fid=?";
        List values = D.asList((Object[])new Object[]{successCount, omittedCount, failedCount, state, endTime, elapsedTime, totalBytes, id});
        List types = D.asList((Object[])new Integer[]{4, 4, 4, 12, 93, 3, -5, -5});
        Util.executeSQL(sql, values, types);
        return readyCount > 0;
    }

    private String calcState(int failedCount, int abortedCount, int readyCount, int runningCount, Throwable cause) {
        if (runningCount > 0) {
            return "RUNNING";
        }
        if (readyCount > 0 && !(cause instanceof TaskCancelException)) {
            return "RUNNING";
        }
        if (abortedCount > 0) {
            return "ABORTED";
        }
        if (failedCount > 0) {
            return "FAILED";
        }
        return "SUCCESS";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Map<String, Long> queryEntryStates(long id) {
        String sql = "SELECT fstate, count(*) as fcount, sum(fbytes_count) as fbytes ,sum(felapsed_time) as felapsed FROM t_dbc_tc_log_items WHERE fid=? GROUP BY fstate";
        List values = D.asList((Object[])new Object[]{id});
        List types = D.asList((Object[])new Integer[]{-5});
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            long totalBytes = 0L;
            long elapsed_time = 0L;
            HashMap<String, Long> progress = new HashMap<String, Long>(8);
            for (DataRow row : DbUtil.executeList((Connection)cn, (String)sql, (List)values, (List)types)) {
                progress.put(D.s((Object)row.get((Object)"fstate")), D.l((Object)row.get((Object)"fcount")));
                totalBytes += D.l((Object)row.get((Object)"fbytes"));
                elapsed_time += D.l((Object)(D.d((Object)row.get((Object)"felapsed")) * 10.0));
            }
            progress.put("TOTAL_BYTES", totalBytes);
            progress.put("ELAPSED_TIME", elapsed_time);
            HashMap<String, Long> hashMap = progress;
            return hashMap;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean setRunning() {
        boolean bl;
        Connection cn = null;
        try {
            Timestamp now = new Timestamp(System.currentTimeMillis());
            int table_count = this.tableCopyLog.getDynamicObjectCollection("tables_log").size();
            if (D.i((Object)this.tableCopyLog.get("exe_count")) > 0) {
                now = new Timestamp(D.l((Object)this.tableCopyLog.get("start_time")));
            }
            String sql = "UPDATE t_dbc_table_copy_log SET fstart_time=?,ftable_count=?,fstate=? WHERE fid=? and fstate=?";
            List values = D.asList((Object[])new Object[]{now, table_count, "RUNNING", this.id, "READY"});
            List types = D.asList((Object[])new Integer[]{93, 4, 12, -5, 12});
            cn = TX.getConnection((String)"ISCB", (boolean)false);
            bl = DbUtil.executeUpdate((Connection)cn, (String)sql, (List)values, (List)types) == 1;
        }
        catch (Throwable throwable) {
            DbUtil.close(cn, (boolean)true);
            throw throwable;
        }
        DbUtil.close((Connection)cn, (boolean)true);
        return bl;
    }

    private String createFilter(Table srcTable, List<Map<String, Object>> filter_collection, List<Integer> types, List<Object> values) {
        StringBuilder filter = new StringBuilder();
        for (int i = 0; i < filter_collection.size(); ++i) {
            Map<String, Object> obj = filter_collection.get(i);
            filter.append(this.trim(obj.get(LEFT_BRACKET)));
            Object value = obj.get(VALUE_FIXED);
            Column field = this.getFilterField((Schema)srcTable, obj);
            filter.append(field.getBinding());
            if (value instanceof List) {
                this.handleListTypeParam(filter, values, field, (List)value, types, D.s((Object)obj.get(FILTER_COMPARE)));
            } else if (this.isArray(value)) {
                List list = (List)JSON.parseObject((String)value.toString(), List.class);
                this.handleListTypeParam(filter, values, field, list, types, D.s((Object)obj.get(FILTER_COMPARE)));
            } else {
                this.handleBaseTypeParam(filter, values, obj, field, value, types);
            }
            filter.append(this.trim(obj.get(RIGHT_BRACKET)));
            if (i >= filter_collection.size() - 1) continue;
            filter.append("OR".equals(obj.get(LINK)) ? " OR " : " AND ");
        }
        return filter.toString().trim();
    }

    private Object calScript(String value) {
        if (value.startsWith("<%") && value.endsWith("%>")) {
            Script expr = Script.compileSimpleScript((String)value.substring(2, value.length() - 2));
            return expr.eval();
        }
        return value;
    }

    private String trim(Object value) {
        String s = D.s((Object)value);
        if (s == null) {
            return "";
        }
        return s;
    }

    private void handleBaseTypeParam(StringBuilder filter, List<Object> values, Map<?, ?> obj, Column field, Object value, List<Integer> types) {
        CommonUtil.filterCompareHandle((StringBuilder)filter, values, obj, (Column)field, (Object)value, types);
    }

    private void handleListTypeParam(StringBuilder filter, List<Object> values, Column field, List<?> list, List<Integer> types, String filter_compare) {
        String com = "not in".equalsIgnoreCase(filter_compare) ? "not in" : "in";
        filter.append(com);
        filter.append(" (");
        for (int i = 0; i < list.size(); ++i) {
            if (i > 0) {
                filter.append(',');
            }
            filter.append('?');
            types.add(field.getSqlType());
            values.add(field.toSqlParam(list.get(i)));
        }
        filter.append(')');
    }

    private boolean isArray(Object value) {
        return value instanceof String && value.toString().startsWith("[");
    }

    private Column getFilterField(Schema table, Map<?, ?> filter_item) {
        String filter_field = (String)filter_item.get(COLUMN);
        Column field = table.getField(filter_field);
        return field;
    }

    private List<Map<String, Object>> parseFilter(String filter) {
        if (StringUtil.isEmpty((String)filter)) {
            return new ArrayList<Map<String, Object>>(0);
        }
        JSONArray jsonArray = JSON.parseArray((String)filter);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject json = jsonArray.getJSONObject(i);
            HashMap<String, Object> map = new HashMap<String, Object>(7);
            map.put(LEFT_BRACKET, json.get((Object)LEFT_BRACKET));
            map.put(COLUMN, json.get((Object)COLUMN));
            map.put(FILTER_COMPARE, json.get((Object)COMPARE));
            map.put(VALUE_FIXED, this.calScript(json.getString(VALUE_FIXED)));
            map.put(RIGHT_BRACKET, json.get((Object)RIGHT_BRACKET));
            map.put(LINK, json.get((Object)LINK));
            list.add(map);
        }
        return list;
    }

    private String buildFilter(String filter, String defineCondition, String link) {
        if (StringUtil.isEmpty((String)filter)) {
            if (StringUtil.isEmpty((String)defineCondition)) {
                return null;
            }
            return defineCondition;
        }
        if (StringUtil.isEmpty((String)defineCondition)) {
            return filter;
        }
        return filter + " " + link + " " + defineCondition;
    }
}

