/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.dbc.platform.core;

import java.security.SecureRandom;
import java.sql.Connection;
import java.sql.Timestamp;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.db.tx.TX;
import kd.bos.id.IDService;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.dbc.platform.core.TableCopyCronJob;
import kd.isc.dbc.platform.core.TableCopyJob;
import kd.isc.dbc.platform.core.Util;
import kd.isc.iscb.platform.core.dc.DataCopyTask;
import kd.isc.iscb.platform.core.dc.DataCopyTaskUtil;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.startjob.CronJobUtil;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.NetUtil;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.feature.tool.date.TimeSpan;
import org.quartz.CronExpression;

public class TableCopyTaskUtil {
    private static final int INTERVAL = 5;
    private static final SecureRandom RND = new SecureRandom();
    private static final Log LOGGER = LogFactory.getLog(TableCopyTaskUtil.class);

    public static void createTimerJob(DynamicObject tableCopy) {
        TableCopyTaskUtil.disableTimerJob(tableCopy);
        TableCopyTaskUtil.createScheduleJobByIsc(tableCopy);
    }

    private static void createScheduleJobByIsc(DynamicObject tableCopy) {
        String cron = tableCopy.getString("schedule");
        if (StringUtil.isEmpty((String)cron)) {
            cron = TableCopyTaskUtil.buildCronByInterval(tableCopy);
        } else {
            DataCopyTaskUtil.checkCron((String)cron);
        }
        TableCopyTaskUtil.enable("dbc_table_copy", cron, D.t((Object)tableCopy.get("validated_time")), D.t((Object)tableCopy.get("expired_time")), tableCopy.getLong("id"), tableCopy.getString("name"), RequestContext.get().getCurrUserId());
    }

    public static void disableTimerJob(DynamicObject tableCopy) {
        if ("auto".equals(tableCopy.get("trigger_type"))) {
            CronJobUtil.disable((long)tableCopy.getLong("id"));
        }
    }

    private static void enable(String type, String cron, Timestamp start, Timestamp expire, long id, String title, long creator) {
        Timestamp scheduledTime = TableCopyTaskUtil.getNextTimestamp(cron, start);
        long expireTime = TableCopyTaskUtil.getExpireTime(expire);
        if (scheduledTime.getTime() < expireTime && "dbc_table_copy".equals(type)) {
            TableCopyCronJob job = new TableCopyCronJob(cron, 1L, id, title, expireTime);
            JobEngine.submitX((Job)job, (Timestamp)scheduledTime, (long)creator);
        }
    }

    private static long getExpireTime(Timestamp expire) {
        Calendar calendar = Calendar.getInstance();
        calendar.set(9999, 11, 31);
        return expire != null ? expire.getTime() : calendar.getTime().getTime();
    }

    private static Timestamp getNextTimestamp(String cron, Timestamp start) {
        CronExpression cronEx = null;
        try {
            cronEx = new CronExpression(cron);
        }
        catch (ParseException parseException) {
            // empty catch block
        }
        assert (cronEx != null);
        long time = start != null ? Math.max(System.currentTimeMillis(), start.getTime()) : System.currentTimeMillis();
        Date date = new Date(time);
        Date after = cronEx.getNextValidTimeAfter(date);
        return D.t((Object)after.getTime());
    }

    private static String buildCronByInterval(DynamicObject tableCopy) {
        long startTime = ((Timestamp)TableCopyTaskUtil.getStartTime(tableCopy)).getTime();
        TimeSpan timeSpan = DataCopyTaskUtil.getTimeSpan((long)startTime);
        String interval = D.s((Object)tableCopy.get("interval"));
        return DataCopyTaskUtil.buildCron((String)interval, (TimeSpan)timeSpan);
    }

    private static Object getStartTime(DynamicObject tableCopy) {
        Object start = tableCopy.get("validated_time");
        if (start == null) {
            start = new Timestamp(System.currentTimeMillis() - 86400000L);
        }
        return start;
    }

    public static DynamicObject create(DynamicObject tableCopy) {
        if (TableCopyTaskUtil.findRunningTableCopyLog(tableCopy) != null) {
            LOGGER.info("tableCopy is running. number=" + tableCopy.get("number"));
            return null;
        }
        DynamicObject tableLog = TableCopyTaskUtil.createTableCopyLog(tableCopy);
        TableCopyTaskUtil.refreshTableCopyInfo(tableCopy);
        String message = "execution is created. number=" + tableLog.get("number") + ", id=" + tableLog.getPkValue() + ", tableCopy=" + tableCopy.get("number");
        LOGGER.info(message);
        return tableLog;
    }

    public static void refreshTableCopyInfo(DynamicObject tableCopy) {
        String sql = "UPDATE t_dbc_table_copy SET ftrigged_time=?, ftrigged_count = ftrigged_count+1 WHERE fid=?";
        Connection cn = TX.__getAloneConnection((String)"ISCB", (boolean)false, (String)"t_dbc_table_copy", (String[])new String[0]);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sql, Arrays.asList(new Timestamp(System.currentTimeMillis()), tableCopy.getLong("id")), Arrays.asList(93, -5));
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    private static DynamicObject findRunningTableCopyLog(DynamicObject tableCopy) {
        Timestamp deadline = new Timestamp(System.currentTimeMillis() - 30000L);
        QFilter filter = new QFilter("table_copy", "=", tableCopy.getPkValue()).and(new QFilter("state", "=", (Object)"RUNNING")).and(new QFilter("modifytime", ">", (Object)deadline));
        return BusinessDataServiceHelper.loadSingle((String)"dbc_table_copy_log", (String)"id", (QFilter[])new QFilter[]{filter});
    }

    private static DynamicObject createTableCopyLog(DynamicObject tableCopy) {
        DynamicObject tableLog = TableCopyTaskUtil.createHead(tableCopy);
        TableCopyTaskUtil.createEntrites(tableCopy, D.l((Object)tableLog.getPkValue()));
        return tableLog;
    }

    private static DynamicObject createHead(DynamicObject tableCopy) {
        DynamicObject log = BusinessDataServiceHelper.newDynamicObject((String)"dbc_table_copy_log");
        long id = IDService.get().genLongId();
        String number = DataCopyTask.generateExecutionNumber((DynamicObject)tableCopy);
        log.set("id", (Object)id);
        log.set("number", (Object)number);
        log.set("state", (Object)"READY");
        log.set("host", (Object)NetUtil.getServerId());
        log.set("success_count", (Object)0);
        log.set("failed_count", (Object)0);
        log.set("omitted_count", (Object)0);
        log.set("total_bytes_count", (Object)0);
        log.set("table_count", (Object)0);
        log.set("creator", (Object)RequestContext.get().getCurrUserId());
        log.set("start_time", (Object)new Timestamp(System.currentTimeMillis()));
        log.set("end_time", null);
        log.set("modifytime", null);
        log.set("src_db", tableCopy.getDynamicObject("src_db").getPkValue());
        log.set("tar_db", tableCopy.getDynamicObject("tar_db").getPkValue());
        log.set("table_copy", tableCopy.getPkValue());
        log.set("batch_size", (Object)tableCopy.getInt("batch_size"));
        int retryCount = tableCopy.get("retry_count") == null ? 3 : D.i((Object)tableCopy.get("retry_count"));
        log.set("retry_count", (Object)retryCount);
        log.set("exe_count", (Object)0);
        if (retryCount == 0) {
            log.set("retry_interval", (Object)"");
        } else {
            String retryInterval = D.s((Object)tableCopy.get("retry_interval")) == null ? "1,8,27" : D.s((Object)tableCopy.get("retry_interval"));
            log.set("retry_interval", (Object)retryInterval);
        }
        log.set("auto_create_table", (Object)tableCopy.getString("auto_create_table"));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{log});
        return log;
    }

    private static void createEntrites(DynamicObject tableCopy, long tableLogId) {
        List<List<Object>> batch = TableCopyTaskUtil.getTables(tableCopy, tableLogId);
        TableCopyTaskUtil.saveTableEntites(batch);
    }

    private static List<List<Object>> getTables(DynamicObject tableCopy, long tableLogId) {
        DynamicObjectCollection entites = tableCopy.getDynamicObjectCollection("tables");
        ArrayList<List<Object>> batch = new ArrayList<List<Object>>();
        for (DynamicObject entity : entites) {
            DynamicObject schema = (DynamicObject)entity.get("schema");
            batch.add(D.asList((Object[])new Object[]{tableLogId, IDService.get().genLongId(), batch.size() + 1, schema.get("table_name"), entity.get("filter"), entity.get("define_condition"), entity.get("link")}));
        }
        return batch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveTableEntites(List<List<Object>> batch) {
        if (!batch.isEmpty()) {
            Connection cn = TX.__getConnection((String)"ISCB", (boolean)false);
            try {
                String sql = "INSERT INTO t_dbc_tc_log_items(fid,fentryid,fseq,ftable_name,ffilter,fdefine_condition,flink,frow_count,fstate,ftable_remark,fexe_count)VALUES(?,?,?,?,?,?,?,0,'READY',' ',0)";
                List types = D.asList((Object[])new Integer[]{-5, -5, 4, 12, 12, 12, 12, 4});
                DbUtil.executeBatch((Connection)cn, (String)sql, batch, (List)types);
            }
            finally {
                DbUtil.close((Connection)cn, (boolean)true);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataRow queryExeResult(long tableCopyId) {
        String sql = "SELECT TOP 1 fstate, fretry_count, fexe_count FROM t_dbc_table_copy_log WHERE fid = ?";
        List values = D.asList((Object[])new Object[]{tableCopyId});
        List types = D.asList((Object[])new Integer[]{-5});
        Connection cn = TX.__getConnection((String)"ISCB", (boolean)true);
        try {
            DataRow dataRow = DbUtil.executeRow((Connection)cn, (String)sql, (List)values, (List)types);
            return dataRow;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    public static long restart(DynamicObject tableCopyLog, boolean isService) {
        TableCopyTaskUtil.updateHead(tableCopyLog);
        TableCopyTaskUtil.updateEntries(tableCopyLog);
        if (isService) {
            return JobEngine.submit((Job)new TableCopyJob(D.l((Object)tableCopyLog.getPkValue()), "DBC_S\uff1a" + tableCopyLog.getString("number")));
        }
        long offset = Math.max(TableCopyTaskUtil.getRetryInterval(tableCopyLog), 30000L);
        Timestamp scheduleTime = new Timestamp(System.currentTimeMillis() + offset);
        return JobEngine.submit((Job)new TableCopyJob(D.l((Object)tableCopyLog.getPkValue()), "DBC\uff1a" + tableCopyLog.getString("number")), (Timestamp)scheduleTime);
    }

    private static long getRetryInterval(DynamicObject tableCopyLog) {
        String[] retryIntervals = D.s((Object)tableCopyLog.get("retry_interval")).split(";|,|\uff1b|\uff0c");
        int length = retryIntervals.length;
        int count = Math.max(0, D.i((Object)tableCopyLog.get("exe_count")));
        if (count >= length) {
            return D.l((Object)retryIntervals[length - 1]) * 60L * 1000L + (long)RND.nextInt(30) - 15L;
        }
        return D.l((Object)retryIntervals[count]) * 60L * 1000L + (long)RND.nextInt(30) - 15L;
    }

    private static void updateHead(DynamicObject tableCopyLog) {
        String sql = "UPDATE t_dbc_table_copy_log SET fsuccess_count=?,fomitted_count=?,ffailed_count=?,fstate=?,fend_time=?,ftotal_elapsed_time=?,ftotal_bytes_count=?,fhost=?,fmodifierid=?,fmodifytime=?,fexe_count=?,fremark=?, fremark_tag=? WHERE fid=?";
        List values = D.asList((Object[])new Object[]{0, 0, 0, "READY", null, 0, 0, NetUtil.getServerId(), RequestContext.get().getCurrUserId(), new Timestamp(System.currentTimeMillis()), D.i((Object)tableCopyLog.get("exe_count")) + 1, Character.valueOf(' '), null, D.l((Object)tableCopyLog.getPkValue())});
        List types = D.asList((Object[])new Integer[]{4, 4, 4, 12, 93, 3, -5, 12, -5, 93, 4, 12, 12, -5});
        Util.executeSQL(sql, values, types);
    }

    private static void updateEntries(DynamicObject tableCopyLog) {
        String sql = "UPDATE t_dbc_tc_log_items set frow_count=?,fstate=?,ftable_start_time=?,ftable_end_time=?,felapsed_time=?,fcomplete_count=?,fbytes_count=?  WHERE fid =? and fstate=?";
        List<Object> values = Arrays.asList(0, "READY", null, null, 0, 0, 0, D.l((Object)tableCopyLog.getPkValue()), "FAILED");
        List types = D.asList((Object[])new Integer[]{-5, 12, 93, 93, 3, -5, -5, -5, 12});
        Util.executeSQL(sql, values, types);
    }
}

