/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.dbc.platform.core;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.isc.iscb.platform.core.connector.JdbcConnectionWrapper;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.util.db.Column;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbType;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.db.Table;
import kd.isc.iscb.util.db.type.UserDefineDbType;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.dt.i.Hex;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.data.fsm.FSM;
import kd.isc.iscb.util.script.feature.op.compare.Equals;

class Util {
    Util() {
    }

    static String checkCompatibility(Table srcTable, Table tarTable) {
        if (tarTable == null) {
            return ResManager.loadKDString((String)"\u76ee\u6807\u6570\u636e\u8868\u4e0d\u5b58\u5728", (String)"Util_0", (String)"isc-dbc-platform-core", (Object[])new Object[0]);
        }
        if (srcTable.getPrimaryKeys().isEmpty()) {
            return ResManager.loadKDString((String)"\u6570\u636e\u8868\u6ca1\u6709\u4e3b\u952e\u5b57\u6bb5", (String)"Util_1", (String)"isc-dbc-platform-core", (Object[])new Object[0]);
        }
        if (tarTable.getPrimaryKeys().isEmpty()) {
            return ResManager.loadKDString((String)"\u76ee\u6807\u5e93\u4e2d\u6570\u636e\u8868\u6ca1\u6709\u4e3b\u952e\u5b57\u6bb5", (String)"Util_2", (String)"isc-dbc-platform-core", (Object[])new Object[0]);
        }
        HashSet<String> srcPks = new HashSet<String>(7);
        HashSet<String> tarPks = new HashSet<String>(7);
        for (Column c : srcTable.getPrimaryKeys()) {
            srcPks.add(c.getName());
        }
        for (Column c : tarTable.getPrimaryKeys()) {
            tarPks.add(c.getName());
        }
        if (srcPks.size() != tarPks.size()) {
            return ResManager.loadKDString((String)"\u76ee\u6807\u5e93\u4e2d\u6570\u636e\u8868\u7684\u4e3b\u952e\u5b57\u6bb5\u4e2a\u6570\u4e0d\u4e00\u81f4", (String)"Util_3", (String)"isc-dbc-platform-core", (Object[])new Object[0]);
        }
        tarPks.removeAll(srcPks);
        if (!tarPks.isEmpty()) {
            return ResManager.loadKDString((String)"\u76ee\u6807\u5e93\u4e2d\u6570\u636e\u8868\u7684\u4e3b\u952e\u5b57\u6bb5\u540d\u79f0\u4e0d\u4e00\u81f4", (String)"Util_4", (String)"isc-dbc-platform-core", (Object[])new Object[0]);
        }
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < srcTable.getFieldCount(); ++i) {
            String field = srcTable.getField(i).getName();
            if (tarTable.hasField(field)) continue;
            if (sb.length() > 0) {
                sb.append(',');
            }
            sb.append(field);
        }
        return sb.length() == 0 ? null : String.format(ResManager.loadKDString((String)"\u76ee\u6807\u5e93\u4e2d\u6570\u636e\u8868\u7f3a\u5c11\u5b57\u6bb5 %s", (String)"Util_7", (String)"isc-dbc-platform-core", (Object[])new Object[0]), sb);
    }

    static FSM parseTablePatterns(String patterns) {
        if (patterns == null) {
            return null;
        }
        FSM fsm = new FSM();
        for (String s : patterns.split(",")) {
            String p = D.s((Object)s);
            if (p == null) continue;
            fsm.add("^" + p.toLowerCase(Locale.ENGLISH) + "$");
        }
        return fsm;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void executeSQL(String sql, List<Object> values, List<Integer> types) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    static boolean isRequired(String table, FSM inclusive_tab_patterns, FSM exclusive_tab_patterns) {
        table = table.toLowerCase(Locale.ENGLISH);
        if (inclusive_tab_patterns != null && !inclusive_tab_patterns.matches(table)) {
            return false;
        }
        return exclusive_tab_patterns == null || !exclusive_tab_patterns.matches(table);
    }

    static List<DataRow> filterForUpdate(List<DataRow> batch, JdbcConnectionWrapper tar, Table tarTable, Map<String, DataRow> srcMapping, Table srcTable) {
        ArrayList<DataRow> forUpdate = new ArrayList<DataRow>(batch.size());
        List<DataRow> list = Util.queryTarBatchData(tar, tarTable, batch, srcTable);
        for (DataRow tarRow : list) {
            String key = Util.generateGroupKey(tarTable, tarRow);
            DataRow srcRow = srcMapping.remove(key);
            if (srcRow == null || Util.equals(srcRow, tarRow)) continue;
            forUpdate.add(srcRow);
        }
        return forUpdate;
    }

    private static List<DataRow> queryTarBatchData(JdbcConnectionWrapper tar, Table tarTable, List<DataRow> batch, Table srcTable) {
        ArrayList<DataRow> tarList = new ArrayList<DataRow>(batch.size());
        int _1K = 1024;
        int step = 1024 / tarTable.getPrimaryKeys().size();
        for (int i = 0; i < batch.size(); i += step) {
            ArrayList<Integer> types = new ArrayList<Integer>(1024);
            ArrayList<Object> values = new ArrayList<Object>(1024);
            int from = i;
            int to = Math.min(batch.size(), i + step);
            String sql = Util.generateTarSelectSQL(tarTable, batch.subList(from, to), types, values, srcTable);
            List result = DbUtil.executeList((Connection)tar, (String)sql, values, types);
            tarList.addAll(result);
        }
        return tarList;
    }

    static String generateSelectSQL(Table table, String[] fields) {
        StringBuilder sql = new StringBuilder();
        sql.append("SELECT ");
        for (int i = 0; i < table.getFieldCount(); ++i) {
            if (i > 0) {
                sql.append(',');
            }
            sql.append(table.getField(i).getBinding());
        }
        sql.append(" FROM ").append(table.getQuotedName());
        return sql.toString();
    }

    private static String generateTarSelectSQL(Table tarTable, List<DataRow> batch, List<Integer> types, List<Object> values, Table srcTable) {
        ArrayList<String> wheres = new ArrayList<String>(batch.size());
        String select = Util.generateSelectSQL(tarTable, Util.getFields(srcTable));
        for (DataRow row : batch) {
            StringBuilder where = new StringBuilder();
            for (Column c : tarTable.getPrimaryKeys()) {
                if (where.length() > 0) {
                    where.append(" AND ");
                }
                where.append(c.getBinding()).append("=?");
                types.add(c.getSqlType());
                values.add(c.unwrap(c.narrow(row.get((Object)c.getName()))));
            }
            wheres.add(where.toString());
        }
        return select + " WHERE " + StringUtil.join(wheres, (String)" OR ");
    }

    static String[] getFields(Table srcTable) {
        int fieldCount = srcTable.getFieldCount();
        String[] fields = new String[fieldCount];
        for (int i = 0; i < fieldCount; ++i) {
            fields[i] = srcTable.getField(i).getName();
        }
        return fields;
    }

    static Map<String, DataRow> groupByPrimaryKeys(List<DataRow> batch, Table tarTable) {
        HashMap<String, DataRow> srcMapping = new HashMap<String, DataRow>(batch.size());
        for (DataRow row : batch) {
            String key = Util.generateGroupKey(tarTable, row);
            srcMapping.put(key, row);
        }
        return srcMapping;
    }

    private static String generateGroupKey(Table table, DataRow row) {
        StringBuilder key = new StringBuilder();
        for (Column c : table.getPrimaryKeys()) {
            Object value = row.get((Object)c.getName());
            if (value == null) {
                key.append("");
            } else if (value instanceof byte[]) {
                key.append(Hex.encode((byte[])((byte[])value)));
            } else {
                key.append(value);
            }
            key.append(',');
        }
        return key.toString();
    }

    private static boolean equals(DataRow srcRow, DataRow tarRow) {
        for (int i = 0; i < srcRow.getFieldCount(); ++i) {
            int tarIndex = tarRow.getFieldIndex(srcRow.getKey(i));
            Object tar = tarRow.getValue(tarIndex);
            Object src = tarRow.getField(tarIndex).narrow(srcRow.getValue(i));
            if (Equals.equals((Object)src, (Object)tar).booleanValue()) continue;
            return false;
        }
        return true;
    }

    static void checkExistsJobs(AbstractFormPlugin form, IDataModel model, BeforeDoOperationEventArgs args) {
        long id = (Long)model.getValue("id");
        if (JobEngine.existsJobWithOwnerId((long)id)) {
            form.getView().showMessage(ResManager.loadKDString((String)"\u4e0a\u6b21\u63d0\u4ea4\u7684\u4efb\u52a1\u5c1a\u672a\u7ed3\u675f\uff0c\u8bf7\u5b9a\u671f\u5237\u65b0\u9875\u9762\u4e86\u89e3\u6267\u884c\u8fdb\u5ea6\u3002", (String)"Util_6", (String)"isc-dbc-platform-core", (Object[])new Object[0]));
            args.setCancel(true);
        }
    }

    static boolean isEnd(boolean hasMore, boolean isAborted) {
        if (!hasMore) {
            return true;
        }
        return isAborted;
    }

    static boolean isEmpty(JdbcConnectionWrapper cn, Table table) {
        DbType type = cn.getJdbcConnectionFactory().getDatabaseType();
        if (type instanceof UserDefineDbType) {
            return false;
        }
        String sql = type.emtpyTableTestSQL(table);
        return DbUtil.executeScalar((Connection)cn, (String)sql) == null;
    }

    static void replaceZeroChar(List<DataRow> batch) {
        for (DataRow row : batch) {
            int size = row.size();
            for (int i = 0; i < size; ++i) {
                String s;
                Object value = row.getValue(i);
                if (!(value instanceof String) || (s = StringUtil.replaceZeroChar((String)((String)value))) == value) continue;
                row.setValue(i, (Object)s);
            }
        }
    }
}

