/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.dbc.platform.core.service;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.dbc.platform.core.TableCopyJob;
import kd.isc.dbc.platform.core.TableCopyTaskUtil;
import kd.isc.dbc.service.IscTableCopyService;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.io.ObjectReader;

public class IscTableCopyServiceImpl
implements IscTableCopyService {
    public long start(String tableCopyNumber) {
        QFilter filter = new QFilter("number", "=", (Object)tableCopyNumber);
        DynamicObject tableCopy = BusinessDataServiceHelper.loadSingle((String)"dbc_table_copy", (QFilter[])new QFilter[]{filter});
        if (tableCopy == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u8868\u590d\u5236\u4efb\u52a1\u7f16\u7801\u4e3a\uff1a%s\uff0c\u4e0d\u5b58\u5728\u3002", (String)"IscTableCopyServiceImpl_3", (String)"isc-dbc-platform-core", (Object[])new Object[0]), tableCopyNumber));
        }
        if (!D.x((Object)tableCopy.get("enable"))) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8bf7\u5148\u542f\u7528\u6570\u636e\u8868\u590d\u5236\u4efb\u52a1\uff0c\u7f16\u7801\u662f\uff1a%s", (String)"IscTableCopyServiceImpl_0", (String)"isc-dbc-platform-core", (Object[])new Object[0]), tableCopyNumber));
        }
        DynamicObject tableCopyLog = TableCopyTaskUtil.create(tableCopy);
        if (tableCopyLog == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u8868\u590d\u5236\u4efb\u52a1\u7f16\u7801\u4e3a\uff1a%s\uff1b\u6b63\u5728\u6267\u884c\u5fc5\u987b\u7ed3\u675f\u540e\u624d\u80fd\u518d\u6b21\u6267\u884c\u3002", (String)"IscTableCopyServiceImpl_5", (String)"isc-dbc-platform-core", (Object[])new Object[0]), tableCopyNumber));
        }
        String title = "DBC_S:" + tableCopyLog.get("number");
        TableCopyJob job = new TableCopyJob(D.l((Object)tableCopyLog.getPkValue()), title);
        JobEngine.submit((Job)job);
        return job.getOwnerId();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Map<String, Object>> queryLog(long tableCopyLogId) {
        Connection cn = TX.__getConnection((String)"ISCB", (boolean)true);
        try {
            String sql = "SELECT fentryid,ftable_name,fstate,ftable_end_time,ftable_start_time,felapsed_time,frow_count,fcomplete_count,fexe_count,ftable_remark,ftable_remark_tag FROM  t_dbc_tc_log_items WHERE fid = ?";
            ObjectReader reader = DbUtil.executeQuery((Connection)cn, (String)sql, Collections.singletonList(tableCopyLogId), Collections.singletonList(-5));
            ArrayList<Map<String, Object>> batch = new ArrayList<Map<String, Object>>();
            DataRow row = (DataRow)reader.read();
            while (row != null) {
                HashMap<String, Object> map = new HashMap<String, Object>(row.size());
                map.put("entryid", D.l((Object)row.get((Object)"fentryid")));
                map.put("table", D.s((Object)row.get((Object)"ftable_name")));
                map.put("state", D.s((Object)row.get((Object)"fstate")));
                map.put("startTime", D.t((Object)row.get((Object)"ftable_start_time")));
                map.put("endTime", D.t((Object)row.get((Object)"ftable_end_time")));
                map.put("elapsedTime", D.d((Object)row.get((Object)"felapsed_time")));
                map.put("rowCount", D.l((Object)row.get((Object)"frow_count")));
                map.put("completeCount", D.l((Object)row.get((Object)"fcomplete_count")));
                map.put("exeCount", D.i((Object)row.get((Object)"fexe_count")));
                map.put("tableRemark", D.s((Object)row.get((Object)"ftable_remark")));
                map.put("tableRemarkTag", D.s((Object)row.get((Object)"ftable_remark_tag")));
                batch.add(map);
                row = (DataRow)reader.read();
            }
            ArrayList<Map<String, Object>> arrayList = batch;
            return arrayList;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    public boolean restart(long tableCopyLogId) {
        if (D.l((Object)tableCopyLogId) > 0L) {
            DynamicObject tableCopylog = BusinessDataServiceHelper.loadSingle((Object)tableCopyLogId, (String)"dbc_table_copy_log");
            if (!"FAILED".equals(tableCopylog.getString("state"))) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6570\u636e\u8868\u590d\u5236\u65e5\u5fd7\u72b6\u6001\u4e3a\uff1a%s\uff0c\u53ea\u80fd\u5bf9\u201c\u5931\u8d25\u201d\u72b6\u6001\u7684\u65e5\u5fd7\u8fdb\u884c\u91cd\u8bd5\u3002", (String)"IscTableCopyServiceImpl_1", (String)"isc-dbc-platform-core", (Object[])new Object[0]), this.getStateTitle(tableCopylog.getString("state"))));
            }
            long jobId = TableCopyTaskUtil.restart(tableCopylog, true);
            DynamicObject jobOwner = BusinessDataServiceHelper.loadSingleFromCache((Object)jobId, (String)"isc_job_inst", (String)"id,job_owner");
            return tableCopyLogId == D.l((Object)jobOwner.get("job_owner"));
        }
        return false;
    }

    private String getStateTitle(String state) {
        switch (state) {
            case "FAILED": {
                return ResManager.loadKDString((String)"\u5931\u8d25", (String)"IscTableCopyServiceImpl_FAILED", (String)"isc-dbc-platform-core", (Object[])new Object[0]);
            }
            case "RUNNING": {
                return ResManager.loadKDString((String)"\u6267\u884c\u4e2d", (String)"IscTableCopyServiceImpl_RUNNING", (String)"isc-dbc-platform-core", (Object[])new Object[0]);
            }
            case "READY": {
                return ResManager.loadKDString((String)"\u521b\u5efa", (String)"IscTableCopyServiceImpl_READY", (String)"isc-dbc-platform-core", (Object[])new Object[0]);
            }
            case "SUCCESS": {
                return ResManager.loadKDString((String)"\u5b8c\u6210", (String)"IscTableCopyServiceImpl_SUCCESS", (String)"isc-dbc-platform-core", (Object[])new Object[0]);
            }
            case "ABORTED": {
                return ResManager.loadKDString((String)"\u5df2\u64a4\u9500", (String)"IscTableCopyServiceImpl_ABORTED", (String)"isc-dbc-platform-core", (Object[])new Object[0]);
            }
        }
        throw new UnsupportedOperationException(String.format(ResManager.loadKDString((String)"\u4e0d\u652f\u6301\u6570\u636e\u8868\u590d\u5236\u65e5\u5fd7\u72b6\u6001\uff1a%s", (String)"IscTableCopyServiceImpl_2", (String)"isc-dbc-platform-core", (Object[])new Object[0]), state));
    }
}

