/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.dbc.platform.plugin;

import java.sql.Timestamp;
import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.operate.Save;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.dbc.platform.core.DatabaseCompJobFactory;
import kd.isc.dbc.platform.core.DatabaseJobFactory;
import kd.isc.dbc.platform.plugin.Util;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.connector.DatabaseType;

public class DatabaseCompFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
AfterF7SelectListener {
    private static final String DATABASE_TYPE = "database_type";
    private static final String ISC_DATABASE_LINK = "isc_database_link";
    private static final String SRC_DB_LINK = "src_db";
    private static final String TAR_DB_LINK = "tar_db";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("start_comp".equals(args.getOperateKey())) {
            this.startJob(args);
        } else if ("cancel".equals(args.getOperateKey())) {
            Util.cancelJobs(this.getModel());
        } else if ("view_jobs".equals(args.getOperateKey())) {
            Util.viewJobs(this, this.getModel());
        } else if ("create_copy_job".equals(args.getOperateKey())) {
            this.createCopyJob();
        }
    }

    private void startJob(AfterDoOperationEventArgs args) {
        if (args.getOperationResult().getAllErrorOrValidateInfo().isEmpty()) {
            Util.startJob(this, this.getModel(), (DatabaseJobFactory)new DatabaseCompJobFactory());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            Util.setNumber(this.getModel());
            Util.checkExistsJobs(this, this.getModel(), args);
        }
    }

    private void createCopyJob() {
        Object id = this.getModel().getValue("id");
        DynamicObject dbc = BusinessDataServiceHelper.loadSingle((Object)id, (String)"dbc_database_comp");
        if (!QueryServiceHelper.exists((String)"dbc_database_copy", (Object)id)) {
            this.createNewCopyJob(id, dbc);
        }
        FormOpener.showView((AbstractFormPlugin)this, (String)"dbc_database_copy", (Object)id);
    }

    private void createNewCopyJob(Object id, DynamicObject dbc) {
        DynamicObject obj = BusinessDataServiceHelper.newDynamicObject((String)"dbc_database_copy");
        obj.set("id", id);
        obj.set("number", (Object)("~" + dbc.get("number")));
        obj.set("description", dbc.get("description"));
        obj.set("creator", (Object)RequestContext.get().getCurrUserId());
        obj.set("created_time", (Object)new Timestamp(System.currentTimeMillis()));
        obj.set(SRC_DB_LINK, dbc.get(SRC_DB_LINK));
        obj.set(TAR_DB_LINK, dbc.get(TAR_DB_LINK));
        obj.set("batch_size", dbc.get("batch_size"));
        obj.set("max_threads", dbc.get("max_threads"));
        obj.set("inclusive_tab_patterns", (Object)"// \u6839\u636e\u6570\u636e\u5e93\u6bd4\u8f83\u4efb\u52a1\u521b\u5efa");
        obj.set("exclusive_tab_patterns", (Object)"// \u6839\u636e\u6570\u636e\u5e93\u6bd4\u8f83\u4efb\u52a1\u521b\u5efa");
        obj.set("log_tab_patterns", (Object)"// \u6839\u636e\u6570\u636e\u5e93\u6bd4\u8f83\u4efb\u52a1\u521b\u5efa");
        DynamicObjectCollection src = dbc.getDynamicObjectCollection("tables");
        DynamicObjectCollection tar = obj.getDynamicObjectCollection("tables");
        for (DynamicObject s : src) {
            if (!"DIFF".equals(s.get("task_state"))) continue;
            DynamicObject t = tar.addNew();
            t.set("seq", s.get("seq"));
            t.set("table_name", s.get("table_name"));
            t.set("task_state", (Object)"READY");
        }
        obj.set("table_count", (Object)tar.size());
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{obj});
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.dbLinkListener(SRC_DB_LINK);
        this.dbLinkListener(TAR_DB_LINK);
    }

    private void dbLinkListener(String db_link) {
        BasedataEdit dbLink = (BasedataEdit)this.getControl(db_link);
        IFormView view = this.getView();
        dbLink.addBeforeF7ViewDetailListener(evt -> {
            evt.setCancel(true);
            BillShowParameter param = new BillShowParameter();
            DynamicObject ds = BusinessDataServiceHelper.loadSingle((Object)evt.getPkId(), (String)ISC_DATABASE_LINK, (String)DATABASE_TYPE);
            param.setFormId(DatabaseType.getForm((String)ds.getString(DATABASE_TYPE)));
            param.setPkId(evt.getPkId());
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setStatus(OperationStatus.VIEW);
            view.showForm((FormShowParameter)param);
        });
        dbLink.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
    }
}

