/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.dbc.platform.plugin;

import java.util.EventObject;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.entity.operate.Save;
import kd.bos.form.FormShowParameter;
import kd.bos.form.IFormView;
import kd.bos.form.ShowType;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.events.AfterF7SelectEvent;
import kd.bos.form.field.events.AfterF7SelectListener;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.dbc.platform.core.DatabaseCopyJobFactory;
import kd.isc.dbc.platform.core.DatabaseJobFactory;
import kd.isc.dbc.platform.plugin.Util;
import kd.isc.iscb.platform.core.connector.DatabaseType;

public class DatabaseCopyFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
AfterF7SelectListener {
    private static final String DATABASE_TYPE = "database_type";
    private static final String ISC_DATABASE_LINK = "isc_database_link";
    private static final String SRC_DB_LINK = "src_db";
    private static final String TAR_DB_LINK = "tar_db";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        if ("start_copy".equals(args.getOperateKey())) {
            this.startJob(args);
        } else if ("cancel".equals(args.getOperateKey())) {
            Util.cancelJobs(this.getModel());
        } else if ("view_jobs".equals(args.getOperateKey())) {
            Util.viewJobs(this, this.getModel());
        }
    }

    private void startJob(AfterDoOperationEventArgs args) {
        if (args.getOperationResult().getAllErrorOrValidateInfo().isEmpty()) {
            Util.startJob(this, this.getModel(), (DatabaseJobFactory)new DatabaseCopyJobFactory());
        }
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        if (args.getSource() instanceof Save) {
            Util.setNumber(this.getModel());
            Util.checkExistsJobs(this, this.getModel(), args);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.dbLinkListener(SRC_DB_LINK);
        this.dbLinkListener(TAR_DB_LINK);
    }

    private void dbLinkListener(String db_link) {
        BasedataEdit dbLink = (BasedataEdit)this.getControl(db_link);
        IFormView view = this.getView();
        dbLink.addBeforeF7ViewDetailListener(evt -> {
            evt.setCancel(true);
            BillShowParameter param = new BillShowParameter();
            DynamicObject ds = BusinessDataServiceHelper.loadSingle((Object)evt.getPkId(), (String)ISC_DATABASE_LINK, (String)DATABASE_TYPE);
            param.setFormId(DatabaseType.getForm((String)ds.getString(DATABASE_TYPE)));
            param.setPkId(evt.getPkId());
            param.getOpenStyle().setShowType(ShowType.Modal);
            param.setStatus(OperationStatus.VIEW);
            view.showForm((FormShowParameter)param);
        });
        dbLink.addAfterF7SelectListener((AfterF7SelectListener)this);
    }

    public void afterF7Select(AfterF7SelectEvent afterF7SelectEvent) {
    }
}

