/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.dbc.platform.plugin;

import java.util.Arrays;
import java.util.Collection;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.entity.list.IListDataProvider;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeCreateListDataProviderArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.mvc.list.ListDataProvider;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.license.n.AccountInfo;
import kd.isc.iscb.platform.core.license.n.ConnectionInfo;
import kd.isc.iscb.platform.core.license.n.LicenseCache;
import kd.isc.iscb.platform.core.task.Task;
import kd.isc.iscb.platform.core.task.TaskManager;

public class DbcDatabaseLinkListPlugin
extends AbstractListPlugin {
    private static final String MYSQL = "mysql";
    private static final String ORACLE = "oracle";
    private static final String SQLSERVER = "sqlserver";
    private static final String POSTGRESQL = "PostgreSQL";
    private static final String DB_PROXY = "db_proxy";
    private static final String DM = "DM";
    private static final String CURRENTDB = "CurrentDB";
    private static final String POSTGRESQL_NEW = "PostgreSQL_New";
    private static final String USERDEFINEDBDRIVER = "UserDefineDbDriver";
    private static final String LINK_MYSQL = "isc_database_link_mysql";
    private static final String LINK_ORACLE = "isc_database_link_oracle";
    private static final String LINK_MSSQL = "isc_database_link_mssql";
    private static final String LINK_PGSQL = "isc_database_link_pgsql";
    private static final String LINK_DBPROXY = "isc_database_link_dbproxy";
    private static final String LINK_DM = "isc_database_link_dm";
    private static final String LINK_CURRENTDB = "isc_database_link_curdb";
    private static final String ISC_DBC_LINK_CHOSE = "isc_dbc_link_chose";
    private static final String LINK_PGSQL_NEW = "isc_database_link_pgnew";
    private static final String LINK_UDFDB = "isc_database_link_udf";
    private static final String LICENSE_SN = "license_sn";
    private static final String LICENSE_INFO = "license_info";

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operationKey = args.getOperateKey();
        if ("add_new".equals(operationKey)) {
            FormOpener.showForm((AbstractFormPlugin)this, (String)ISC_DBC_LINK_CHOSE, null);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        Object selectedId = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo().getPrimaryKeyValue();
        DynamicObject dbLink = BusinessDataServiceHelper.loadSingle((Object)selectedId, (String)"dbc_database_link");
        if (MYSQL.equals(dbLink.get("database_type"))) {
            FormOpener.showEdit((AbstractFormPlugin)this, (String)LINK_MYSQL, (Object)selectedId);
        } else if (POSTGRESQL.equals(dbLink.get("database_type"))) {
            FormOpener.showEdit((AbstractFormPlugin)this, (String)LINK_PGSQL, (Object)selectedId);
        } else if (SQLSERVER.equals(dbLink.get("database_type"))) {
            FormOpener.showEdit((AbstractFormPlugin)this, (String)LINK_MSSQL, (Object)selectedId);
        } else if (ORACLE.equals(dbLink.get("database_type"))) {
            FormOpener.showEdit((AbstractFormPlugin)this, (String)LINK_ORACLE, (Object)selectedId);
        } else if (DB_PROXY.equals(dbLink.get("database_type"))) {
            FormOpener.showEdit((AbstractFormPlugin)this, (String)LINK_DBPROXY, (Object)selectedId);
        } else if (DM.equals(dbLink.get("database_type"))) {
            FormOpener.showEdit((AbstractFormPlugin)this, (String)LINK_DM, (Object)selectedId);
        } else if (CURRENTDB.equals(dbLink.get("database_type"))) {
            FormOpener.showEdit((AbstractFormPlugin)this, (String)LINK_CURRENTDB, (Object)selectedId);
        } else if (POSTGRESQL_NEW.equals(dbLink.get("database_type"))) {
            FormOpener.showEdit((AbstractFormPlugin)this, (String)LINK_PGSQL_NEW, (Object)selectedId);
        } else if (USERDEFINEDBDRIVER.equals(dbLink.get("database_type"))) {
            FormOpener.showEdit((AbstractFormPlugin)this, (String)LINK_UDFDB, (Object)selectedId);
        }
    }

    public void beforeCreateListDataProvider(BeforeCreateListDataProviderArgs args) {
        args.setListDataProvider((IListDataProvider)new MyListDataProvider());
        String taskId = "DbcRefreshConnectionLicenseInfo";
        if (!TaskManager.exists((String)taskId)) {
            this.asyncRefreshLicenseInfo(taskId);
        }
    }

    private void asyncRefreshLicenseInfo(final String taskId) {
        TaskManager.submit((Task)new Task(){

            public String getId() {
                return taskId;
            }

            public void run() {
                QFilter qFilter = new QFilter("database_type", "=", (Object)DbcDatabaseLinkListPlugin.MYSQL);
                qFilter.or("database_type", "=", (Object)DbcDatabaseLinkListPlugin.ORACLE);
                qFilter.or("database_type", "=", (Object)DbcDatabaseLinkListPlugin.POSTGRESQL);
                qFilter.or("database_type", "=", (Object)DbcDatabaseLinkListPlugin.SQLSERVER);
                qFilter.or("database_type", "=", (Object)DbcDatabaseLinkListPlugin.DB_PROXY);
                qFilter.or("database_type", "=", (Object)DbcDatabaseLinkListPlugin.DM);
                qFilter.or("database_type", "=", (Object)DbcDatabaseLinkListPlugin.CURRENTDB);
                qFilter.or("database_type", "=", (Object)DbcDatabaseLinkListPlugin.POSTGRESQL_NEW);
                qFilter.or("database_type", "=", (Object)DbcDatabaseLinkListPlugin.USERDEFINEDBDRIVER);
                DynamicObject[] links = BusinessDataServiceHelper.load((String)"isc_database_link", (String)"database_type, license_info,license_sn", (QFilter[])new QFilter[]{qFilter});
                DbcDatabaseLinkListPlugin.this.setLicenseInfo(Arrays.asList(links));
                SaveServiceHelper.save((DynamicObject[])links);
            }
        });
    }

    private void setLicenseInfo(Collection<DynamicObject> links) {
        if (links.isEmpty()) {
            return;
        }
        AccountInfo account = LicenseCache.getTenant().getCurrentAccount();
        if (account == null) {
            account = LicenseCache.refreshTenant2().getCurrentAccount();
        }
        for (DynamicObject link : links) {
            long id = link.getLong("id");
            ConnectionInfo cn = account.getSystemConnection(id);
            if (cn == null) {
                account = LicenseCache.refreshTenant2().getCurrentAccount();
                cn = account.getSystemConnection(id);
            }
            if (cn == null) continue;
            link.set(LICENSE_INFO, (Object)cn.getStateString());
            link.set(LICENSE_SN, (Object)cn.getLicenseSN());
        }
    }

    class MyListDataProvider
    extends ListDataProvider {
        MyListDataProvider() {
        }

        public DynamicObjectCollection getData(int start, int limit) {
            DynamicObjectCollection rows = super.getData(start, limit);
            if (rows.isEmpty() || !((DynamicObject)rows.get(0)).getDataEntityType().getProperties().containsKey((Object)DbcDatabaseLinkListPlugin.LICENSE_INFO)) {
                return rows;
            }
            DbcDatabaseLinkListPlugin.this.setLicenseInfo((Collection)rows);
            return rows;
        }
    }
}

