/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.dbc.platform.plugin;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.BillShowParameter;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.IFormView;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.form.field.events.BeforeF7SelectEvent;
import kd.bos.form.field.events.BeforeF7SelectListener;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.list.ListShowParameter;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.dbc.platform.plugin.TableCopyListPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.dc.DataCopyTaskUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.feature.tool.date.TimeSpan;

public class TableCopyFormPlugin
extends AbstractFormPlugin
implements BeforeF7SelectListener,
CellClickListener {
    private static final String TRIGGER_TYPE = "trigger_type";
    private static final String INTERVAL = "interval";
    private static final String SCHEDULE = "schedule";
    private static final String VALUE_FIXED = "value_fixed";
    private static final String COMPARE = "compare";
    private static final String COLUMN = "column";
    private static final String LEFT_BRACKET = "left_bracket";
    private static final String RIGHT_BRACKET = "right_bracket";
    private static final String LINK = "link";

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        super.beforeDoOperation(evt);
        AbstractOperate operate = (AbstractOperate)evt.getSource();
        String operationKey = operate.getOperateKey();
        if ("save".equals(operationKey)) {
            this.checkTimeIsValid(evt);
            this.checkEnable(evt);
            this.checkEntries(evt);
        } else if ("modify".equals(operationKey)) {
            this.checkEnable(evt);
        }
    }

    private void checkTimeIsValid(BeforeDoOperationEventArgs evt) {
        Timestamp validated_time = D.t((Object)this.getModel().getValue("validated_time"));
        Timestamp expired_time = D.t((Object)this.getModel().getValue("expired_time"));
        if (validated_time != null && expired_time != null && validated_time.after(expired_time)) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u542f\u7528\u65f6\u95f4\u5fc5\u987b\u5728\u8fc7\u671f\u65f6\u95f4\u4e4b\u540e\uff0c\u8bf7\u4fee\u6539\u8be5\u5185\u5bb9\u3002", (String)"TableCopyFormPlugin_0", (String)"isc-dbc-platform-plugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
    }

    private void checkEnable(BeforeDoOperationEventArgs evt) {
        DynamicObject schema;
        Object schemaId = this.getModel().getValue("id");
        if (schemaId != null && Long.parseLong(schemaId.toString()) != 0L && (schema = BusinessDataServiceHelper.loadSingle((Object)schemaId, (String)"dbc_table_copy", (String)"enable")).getInt("enable") == 1) {
            evt.setCancel(true);
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("disable_tableCopy", (IFormPlugin)this);
            String tips = OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus()) ? ResManager.loadKDString((String)"\u6570\u636e\u8868\u590d\u5236\u7981\u7528\u540e\u624d\u80fd\u4fee\u6539\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"TableCopyFormPlugin_1", (String)"isc-dbc-platform-plugin", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u6570\u636e\u8868\u590d\u5236\u7981\u7528\u540e\u624d\u80fd\u4fdd\u5b58\uff0c\u662f\u5426\u7981\u7528\uff1f", (String)"TableCopyFormPlugin_2", (String)"isc-dbc-platform-plugin", (Object[])new Object[0]);
            this.getView().showConfirm(tips, MessageBoxOptions.YesNo, confirmCallBacks);
        }
    }

    private void checkEntries(BeforeDoOperationEventArgs evt) {
        DynamicObjectCollection tables = this.getModel().getEntryEntity("tables");
        if (tables.size() == 0) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u8868\u5bf9\u8c61\u5206\u5f55\u4e3a\u7a7a\u3002", (String)"TableCopyFormPlugin_7", (String)"isc-dbc-platform-plugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
        if (tables.size() > 0 && ((DynamicObject)tables.get(0)).get("schema") == null) {
            this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u8868\u5bf9\u8c61\u7b2c\u4e00\u6761\u5206\u5f55\u6570\u636e\u8868\u540d\u4e3a\u7a7a\u3002", (String)"TableCopyFormPlugin_8", (String)"isc-dbc-platform-plugin", (Object[])new Object[0]));
            evt.setCancel(true);
        }
        for (DynamicObject table : tables) {
            if (StringUtil.isEmpty((String)table.getString(LINK))) {
                if (StringUtil.isEmpty((String)table.getString("filter")) || StringUtil.isEmpty((String)table.getString("define_condition"))) continue;
                this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6570\u636e\u8868\u5bf9\u8c61\u5206\u5f55\u7b2c%s\u884c\u7684\u903b\u8f91\u8fde\u63a5\u7b26\u4e3a\u7a7a\u3002", (String)"TableCopyFormPlugin_9", (String)"isc-dbc-platform-plugin", (Object[])new Object[0]), table.get("seq")));
                evt.setCancel(true);
                continue;
            }
            if (!StringUtil.isEmpty((String)table.getString("filter")) && !StringUtil.isEmpty((String)table.getString("define_condition"))) continue;
            this.getView().showMessage(String.format(ResManager.loadKDString((String)"\u6570\u636e\u8868\u5bf9\u8c61\u5206\u5f55\u7b2c%s\u884c\u7684\u903b\u8f91\u8fde\u63a5\u7b26\u4e0d\u4e3a\u7a7a\u3002", (String)"TableCopyFormPlugin_10", (String)"isc-dbc-platform-plugin", (Object[])new Object[0]), table.get("seq")));
            evt.setCancel(true);
        }
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        Object id;
        DynamicObject tableCopy;
        super.confirmCallBack(evt);
        if (evt.getResult() != MessageBoxResult.Yes) {
            return;
        }
        String callback = evt.getCallBackId();
        if ("disable_tableCopy".equals(callback) && this.updateTableCopyStatus(tableCopy = BusinessDataServiceHelper.loadSingle((Object)(id = this.getModel().getValue("id")), (String)"dbc_table_copy"), "disable")) {
            tableCopy.set("enable", (Object)"0");
            SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{tableCopy});
            if (this.getView().getFormShowParameter() != null && OperationStatus.VIEW.equals((Object)this.getView().getFormShowParameter().getStatus())) {
                this.getView().setStatus(OperationStatus.EDIT);
                this.getView().cacheFormShowParameter();
                this.getView().updateView();
                this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7981\u7528\u6210\u529f\u3002", (String)"TableCopyFormPlugin_3", (String)"isc-dbc-platform-plugin", (Object[])new Object[0]));
            } else {
                this.getView().showMessage(ResManager.loadKDString((String)"\u6570\u636e\u8868\u590d\u5236\u5df2\u7981\u7528\uff0c\u8bf7\u518d\u6b21\u5c1d\u8bd5\u4fdd\u5b58\u3002", (String)"TableCopyFormPlugin_4", (String)"isc-dbc-platform-plugin", (Object[])new Object[0]));
            }
        }
    }

    private boolean updateTableCopyStatus(DynamicObject tableCopy, String operationKey) {
        try {
            if ("enable".equals(operationKey)) {
                TableCopyListPlugin.enable(new DynamicObject[]{tableCopy});
            } else if ("disable".equals(operationKey)) {
                TableCopyListPlugin.disable(new DynamicObject[]{tableCopy});
            }
            return true;
        }
        catch (Exception e) {
            FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
            return false;
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{SCHEDULE});
        BasedataEdit registerservice = (BasedataEdit)this.getView().getControl("schema");
        registerservice.addBeforeF7SelectListener((BeforeF7SelectListener)this);
        EntryGrid tables = (EntryGrid)this.getView().getControl("tables");
        tables.addCellClickListener((CellClickListener)this);
    }

    public void beforeF7Select(BeforeF7SelectEvent beforeF7SelectEvent) {
        DynamicObject src_db = (DynamicObject)this.getModel().getValue("src_db");
        if (src_db == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6765\u6e90\u6570\u636e\u5e93\u4e3a\u7a7a\uff0c\u8bf7\u5148\u9009\u62e9\u6765\u6e90\u6570\u636e\u5e93\u3002", (String)"TableCopyFormPlugin_5", (String)"isc-dbc-platform-plugin", (Object[])new Object[0]));
            beforeF7SelectEvent.setCancel(true);
            return;
        }
        String fieldKey = beforeF7SelectEvent.getProperty().getName();
        if ("schema".equals(fieldKey)) {
            ListShowParameter showParameter = (ListShowParameter)beforeF7SelectEvent.getFormShowParameter();
            ArrayList<QFilter> filters = new ArrayList<QFilter>();
            filters.add(new QFilter("id", "=", (Object)D.l((Object)src_db.getPkValue())));
            showParameter.getTreeFilterParameter().setQFilters(filters);
            showParameter.getListFilterParameter().setFilter(new QFilter("group.id", "=", (Object)D.l((Object)src_db.getPkValue())));
        }
    }

    public void click(EventObject evt) {
        TextEdit edit;
        Object src = evt.getSource();
        if (src instanceof TextEdit && SCHEDULE.equals((edit = (TextEdit)src).getKey())) {
            HashMap<String, Object> params = new HashMap<String, Object>(1);
            params.put("cron_expr", D.s((Object)this.getModel().getValue(SCHEDULE)));
            params.put("end_time", D.t((Object)this.getModel().getValue("expired_time")));
            params.put("start_time", D.t((Object)this.getModel().getValue("validated_time")));
            FormOpener.showForm((AbstractFormPlugin)this, (String)"isc_cron_expression", (String)"", params, (String)SCHEDULE);
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        String name = e.getProperty().getName();
        if (name.equals(TRIGGER_TYPE)) {
            this.initCron();
        } else if (INTERVAL.equals(name)) {
            String interval = D.s((Object)e.getChangeSet()[0].getNewValue());
            this.resetCronVal(interval);
        } else if (e.getChangeSet().length == 1 && "schema".equals(name)) {
            int rowIndex = e.getChangeSet()[0].getRowIndex();
            DynamicObject rowEntity = this.getModel().getEntryRowEntity("tables", rowIndex);
            rowEntity.set("filter", (Object)"");
            this.getView().updateView("tables");
        }
    }

    private void initCron() {
        if ("auto".equals(D.s((Object)this.getModel().getValue(TRIGGER_TYPE)))) {
            String interval = D.s((Object)this.getModel().getValue(INTERVAL));
            String schedule = D.s((Object)this.getModel().getValue(SCHEDULE));
            if (interval != null && schedule == null) {
                this.resetCronVal(interval);
            }
        }
    }

    private void resetCronVal(String interval) {
        if (interval == null) {
            this.getModel().setValue(SCHEDULE, null);
        } else if (!"0".equals(interval)) {
            TimeSpan timeSpan = this.getTimeSpan();
            this.getModel().setValue(SCHEDULE, (Object)DataCopyTaskUtil.buildCron((String)interval, (TimeSpan)timeSpan));
        }
    }

    private TimeSpan getTimeSpan() {
        Date start = (Date)this.getModel().getValue("validated_time");
        if (start == null) {
            start = new Timestamp(System.currentTimeMillis() - 86400000L);
        }
        return DataCopyTaskUtil.getTimeSpan((long)start.getTime());
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        Object data = evt.getReturnData();
        if ("get_table_filter".equals(action) && data instanceof Map) {
            Map map = (Map)data;
            if (!D.x(map.get("btnok")) || map.get("filter") == null) {
                this.getView().updateView("tables");
                return;
            }
            Object rowValue = map.get("$row");
            DynamicObject row = this.getModel().getEntryRowEntity("tables", D.i(rowValue));
            row.set("filter", (Object)this.parseFilter(map));
            this.getView().updateView("tables");
        } else if (SCHEDULE.equals(action)) {
            if (data == null) {
                return;
            }
            this.getModel().setValue(SCHEDULE, ((Map)data).get("cron_expr"));
        }
    }

    private String parseFilter(Map<String, Object> map) {
        DynamicObjectCollection filter_collection = (DynamicObjectCollection)map.get("filter");
        JSONArray jsonArray = new JSONArray();
        for (int i = 0; i < filter_collection.size(); ++i) {
            JSONObject json = new JSONObject();
            DynamicObject obj = (DynamicObject)filter_collection.get(i);
            json.put(LEFT_BRACKET, obj.get(LEFT_BRACKET));
            json.put(COLUMN, obj.get(COLUMN));
            json.put(COMPARE, obj.get(COMPARE));
            json.put(VALUE_FIXED, obj.get(VALUE_FIXED));
            json.put(RIGHT_BRACKET, obj.get(RIGHT_BRACKET));
            json.put(LINK, obj.get(LINK));
            jsonArray.add(i, (Object)json);
        }
        if (jsonArray.size() > 0) {
            return jsonArray.toString();
        }
        return "";
    }

    private List<Map<String, Object>> createFilter(String filter) {
        if (filter == null || "".equals(filter) || !JSON.isValidArray((String)filter)) {
            return null;
        }
        JSONArray jsonArray = JSON.parseArray((String)filter);
        ArrayList<Map<String, Object>> list = new ArrayList<Map<String, Object>>(jsonArray.size());
        for (int i = 0; i < jsonArray.size(); ++i) {
            JSONObject json = jsonArray.getJSONObject(i);
            HashMap<String, String> map = new HashMap<String, String>(7);
            map.put(LEFT_BRACKET, json.getString(LEFT_BRACKET));
            map.put(COLUMN, json.getString(COLUMN));
            map.put(COMPARE, json.getString(COMPARE));
            map.put(VALUE_FIXED, json.getString(VALUE_FIXED));
            map.put(RIGHT_BRACKET, json.getString(RIGHT_BRACKET));
            map.put(LINK, json.getString(LINK));
            list.add(map);
        }
        return list;
    }

    public void cellClick(CellClickEvent cellClickEvent) {
        DynamicObject schema;
        BillShowParameter billShowParameter = (BillShowParameter)this.getView().getFormShowParameter();
        if ("filter".equals(cellClickEvent.getFieldKey()) && (schema = (DynamicObject)this.getModel().getEntryEntity("tables").get(cellClickEvent.getRow())).getDynamicObject("schema") != null) {
            long srcId = D.l((Object)schema.getDynamicObject("schema").getPkValue());
            HashMap<String, Object> params = new HashMap<String, Object>();
            params.put("filter", this.createFilter(D.s((Object)schema.get("filter"))));
            params.put("id", srcId);
            params.put("$row", cellClickEvent.getRow());
            params.put("billStatus", billShowParameter.getBillStatus());
            FormOpener.showForm((AbstractFormPlugin)this, (String)"dbc_table_filter", (String)ResManager.loadKDString((String)"\u6570\u636e\u8868\u8fc7\u6ee4\u6761\u4ef6", (String)"TableCopyFormPlugin_6", (String)"isc-dbc-platform-plugin", (Object[])new Object[0]), params, (String)"get_table_filter");
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
    }
}

