/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.dbc.platform.plugin;

import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.entity.MainEntityType;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.form.IFormView;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.HyperLinkClickArgs;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.BillList;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.dbc.platform.core.TableCopyJob;
import kd.isc.dbc.platform.core.TableCopyTaskUtil;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.util.dt.D;

public class TableCopyListPlugin
extends AbstractListPlugin {
    private static final String TRIGGER_TYPE = "trigger_type";
    private static final String DBC_TABLE_COPY = "dbc_table_copy";
    private static final String DBC_TABLE_COPY_LOG = "dbc_table_copy_log";

    public void beforeDoOperation(BeforeDoOperationEventArgs evt) {
        ListSelectedRowCollection dataCollection = evt.getListSelectedData();
        if (evt.getSource() instanceof AbstractOperate && dataCollection.size() > 0) {
            AbstractOperate operate = (AbstractOperate)evt.getSource();
            String operateKey = operate.getOperateKey();
            try {
                if ("enable".equals(operateKey)) {
                    TableCopyListPlugin.enable(this.getTableCopys(dataCollection));
                } else if ("disable".equals(operateKey)) {
                    TableCopyListPlugin.disable(this.getTableCopys(dataCollection));
                }
            }
            catch (Exception e) {
                evt.setCancel(true);
                FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
            }
        }
    }

    public void afterDoOperation(AfterDoOperationEventArgs evt) {
        super.afterDoOperation(evt);
        try {
            if (evt.getOperationResult() == null || !evt.getOperationResult().isSuccess()) {
                return;
            }
            String operationKey = evt.getOperateKey();
            if ("execute".equals(operationKey)) {
                Object pk = FormOpener.getSelectedId((AbstractFormPlugin)this, (AfterDoOperationEventArgs)evt);
                if (pk != null) {
                    this.manualTrigger(BusinessDataServiceHelper.loadSingle((Object)pk, (String)DBC_TABLE_COPY));
                }
            } else if ("show_executions".equalsIgnoreCase(operationKey)) {
                FormOpener.showList((AbstractFormPlugin)this, (String)DBC_TABLE_COPY_LOG, (String)"table_copy", (AfterDoOperationEventArgs)evt);
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage((IFormView)this.getView(), (Throwable)e);
        }
    }

    private DynamicObject[] getTableCopys(ListSelectedRowCollection dataCollection) {
        Object[] primaryKeyValues = dataCollection.getPrimaryKeyValues();
        MainEntityType dataEntityType = EntityMetadataCache.getDataEntityType((String)DBC_TABLE_COPY);
        return BusinessDataServiceHelper.load((Object[])primaryKeyValues, (DynamicObjectType)dataEntityType);
    }

    private void manualTrigger(DynamicObject tableCopy) {
        DynamicObject tableCopyLog = TableCopyTaskUtil.create((DynamicObject)tableCopy);
        if (tableCopyLog == null) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u6b64\u6570\u636e\u8868\u590d\u5236\u65b9\u6848\u6b63\u5728\u6267\u884c\uff0c\u5fc5\u987b\u7ed3\u675f\u540e\u624d\u80fd\u518d\u6b21\u6267\u884c\u3002", (String)"TableCopyListPlugin_2", (String)"isc-dbc-platform-plugin", (Object[])new Object[0]));
        } else {
            String title = "DBC\uff1a" + tableCopyLog.get("number");
            JobEngine.submit((Job)new TableCopyJob(D.l((Object)tableCopyLog.getPkValue()), title));
            FormOpener.showTabViewIfNotExist((AbstractFormPlugin)this, (String)DBC_TABLE_COPY_LOG, (Object)tableCopyLog.getPkValue());
        }
    }

    public static void enable(DynamicObject[] tableCopys) {
        for (DynamicObject tableCopy : tableCopys) {
            if (!"auto".equals(tableCopy.get(TRIGGER_TYPE))) continue;
            TableCopyTaskUtil.createTimerJob((DynamicObject)tableCopy);
        }
    }

    public static void disable(DynamicObject[] tableCopys) {
        for (DynamicObject tableCopy : tableCopys) {
            if (!"auto".equals(tableCopy.get(TRIGGER_TYPE))) continue;
            TableCopyTaskUtil.disableTimerJob((DynamicObject)tableCopy);
        }
    }

    public void billListHyperLinkClick(HyperLinkClickArgs args) {
        args.setCancel(true);
        Object selectedId = ((BillList)args.getHyperLinkClickEvent().getSource()).getCurrentSelectedRowInfo().getPrimaryKeyValue();
        FormOpener.showTabView((AbstractFormPlugin)this, (String)DBC_TABLE_COPY, (Object)selectedId);
    }
}

