/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.dbc.platform.plugin;

import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.bill.OperationStatus;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.events.ChangeData;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.Button;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.events.CellClickEvent;
import kd.bos.form.control.events.CellClickListener;
import kd.bos.form.events.BeforeClosedEvent;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.list.plugin.AbstractListPlugin;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.misc.StringUtil;

public class TableFilterFormPlugin
extends AbstractListPlugin
implements CellClickListener {
    public static final String ENTRYENTITY = "entryentity";
    public static final String FILTER = "filter";
    public static final String BTN_OK = "btnok";
    private static final String LEFT_BRACKET = "left_bracket";
    private static final String VALUE_FIXED = "value_fixed";
    private static final String COMPARE = "compare";
    private static final String COLUMN = "column";
    private static final String RIGHT_BRACKET = "right_bracket";
    private static final String LINK = "link";

    public void registerListener(EventObject e) {
        super.registerListener(e);
        this.addClickListeners(new String[]{BTN_OK});
        EntryGrid tables = (EntryGrid)this.getView().getControl(ENTRYENTITY);
        tables.addCellClickListener((CellClickListener)this);
    }

    public void afterCreateNewData(EventObject e) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params != null && params.get(FILTER) != null) {
            this.parseFilter((List)params.get(FILTER));
        }
        if (params != null && params.get("billStatus") != null) {
            this.getView().setStatus(this.getBillStatusByParentView(D.s(params.get("billStatus"))));
        }
    }

    private OperationStatus getBillStatusByParentView(String billStatus) {
        if ("ADDNEW".equals(billStatus)) {
            return OperationStatus.ADDNEW;
        }
        if ("EDIT".equals(billStatus) || "AUDIT".equals(billStatus)) {
            return OperationStatus.EDIT;
        }
        return OperationStatus.VIEW;
    }

    public void afterBindData(EventObject e) {
        super.afterBindData(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (params == null || !params.containsKey("id")) {
            this.getView().showTipNotification(ResManager.loadKDString((String)"\u7f3a\u5c11\u5143\u6570\u636eid\uff0c\u65e0\u6cd5\u83b7\u53d6\u5143\u6570\u636e\u5c5e\u6027!", (String)"TableFilterFormPlugin_0", (String)"isc-dbc-platform-plugin", (Object[])new Object[0]));
            return;
        }
    }

    public void propertyChanged(PropertyChangedArgs e) {
        String name = e.getProperty().getName();
        ChangeData[] changeSet = e.getChangeSet();
        if (changeSet.length == 1 && name.equals(COMPARE)) {
            int rowIndex = changeSet[0].getRowIndex();
            DynamicObject row = this.getModel().getEntryRowEntity(ENTRYENTITY, rowIndex);
            if ("IS_NOT_NULL".equals(row.getString(COMPARE)) || "IS_NULL".equals(row.getString(COMPARE))) {
                row.set(VALUE_FIXED, null);
                this.getView().updateView(ENTRYENTITY);
            }
        }
    }

    private void parseFilter(List<Map<String, Object>> filters) {
        DynamicObjectCollection coll = this.getModel().getEntryEntity(ENTRYENTITY);
        coll.clear();
        for (Map<String, Object> filter : filters) {
            DynamicObject item = new DynamicObject(coll.getDynamicObjectType());
            item.set(LEFT_BRACKET, filter.get(LEFT_BRACKET));
            item.set(COLUMN, filter.get(COLUMN));
            item.set(COMPARE, filter.get(COMPARE));
            item.set(VALUE_FIXED, filter.get(VALUE_FIXED));
            item.set(RIGHT_BRACKET, filter.get(RIGHT_BRACKET));
            item.set(LINK, filter.get(LINK));
            coll.add((Object)item);
        }
        this.getView().updateView(ENTRYENTITY);
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        Object data = evt.getReturnData();
        if ("isc_meta_select".equals(action) && data instanceof Map && ((Map)data).size() > 1) {
            Map params = (Map)evt.getReturnData();
            this.setReturnValues(params, action);
        } else if ("get_iscenv_var".equals(action)) {
            this.setIscVariable(evt, this.getView());
        }
    }

    private void setReturnValues(Object data, String action) {
        Map map;
        Object rowValue;
        if (data instanceof Map && (rowValue = (map = (Map)data).get("$row")) != null) {
            int index = Integer.parseInt(rowValue.toString());
            if ("isc_meta_select".equals(action)) {
                DynamicObject row = this.getModel().getEntryRowEntity(ENTRYENTITY, index);
                row.set(COLUMN, map.get("number"));
                this.getView().updateView(ENTRYENTITY);
            }
        }
    }

    public void click(EventObject evt) {
        super.click(evt);
        Object src = evt.getSource();
        if (src instanceof Button) {
            Map params = this.getView().getFormShowParameter().getCustomParams();
            if (BTN_OK.equals(((Button)src).getKey())) {
                if (this.checkFilterEntries(this.getView(), this.getModel())) {
                    return;
                }
                params.put(FILTER, this.getModel().getEntryEntity(ENTRYENTITY));
                params.put(BTN_OK, Boolean.TRUE);
                this.getView().close();
            }
        }
    }

    private boolean checkFilterEntries(IFormView view, IDataModel model) {
        DynamicObjectCollection filterEntries = model.getEntryEntity(ENTRYENTITY);
        if (this.checkFilterValue(filterEntries, view)) {
            return true;
        }
        if (this.validateFilterBracket(filterEntries)) {
            view.showTipNotification(ResManager.loadKDString((String)"\u3010\u8fc7\u6ee4\u6761\u4ef6\u3011\u5206\u5f55\u4e2d\u62ec\u53f7\u672a\u6b63\u786e\u5339\u914d\uff0c\u8bf7\u4fee\u6539\u3002", (String)"TableFilterFormPlugin_1", (String)"isc-dbc-platform-plugin", (Object[])new Object[0]), Integer.valueOf(3000));
            return true;
        }
        return false;
    }

    private boolean checkFilterValue(DynamicObjectCollection filterEntries, IFormView view) {
        for (int i = 0; i < filterEntries.size(); ++i) {
            DynamicObject filter = (DynamicObject)filterEntries.get(i);
            if (StringUtil.isEmpty((String)D.s((Object)filter.get(COLUMN))) || StringUtil.isEmpty((String)D.s((Object)filter.get(COMPARE)))) {
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u3010\u8fc7\u6ee4\u6761\u4ef6\u3011\u5206\u5f55\u4e2d\u7b2c%s\u884c\uff1a\u201c\u6761\u4ef6\u5b57\u6bb5\u201d\u6216\u8005\u201c\u6bd4\u8f83\u65b9\u5f0f\u201c\u4e3a\u7a7a\u3002", (String)"TableFilterFormPlugin_8", (String)"isc-dbc-platform-plugin", (Object[])new Object[0]), i + 1), Integer.valueOf(3000));
                return true;
            }
            String filterCompare = filter.getString(COMPARE);
            if (StringUtil.isEmpty((String)filterCompare)) continue;
            String value_fixed = D.s((Object)filter.get(VALUE_FIXED));
            if (value_fixed == null) {
                if ("IS_NULL".equals(filterCompare) || "IS_NOT_NULL".equals(filterCompare)) continue;
                view.showTipNotification(String.format(ResManager.loadKDString((String)"\u3010\u8fc7\u6ee4\u6761\u4ef6\u3011\u5206\u5f55\u4e2d\u7b2c%s\u884c\uff1a\u672a\u586b\u5199\u201c\u56fa\u5b9a\u6bd4\u8f83\u503c\u201d\u3002", (String)"TableFilterFormPlugin_9", (String)"isc-dbc-platform-plugin", (Object[])new Object[0]), i + 1), Integer.valueOf(3000));
                return true;
            }
            if (!"IS_NULL".equals(filterCompare) && !"IS_NOT_NULL".equals(filterCompare)) continue;
            view.showTipNotification(String.format(ResManager.loadKDString((String)"\u3010\u8fc7\u6ee4\u6761\u4ef6\u3011\u5206\u5f55\u4e2d\u7b2c%s\u884c\uff1a\u6bd4\u8f83\u6761\u4ef6\u662f\u201c\u4e3a\u7a7a\u201d\u6216\u201c\u4e0d\u4e3a\u7a7a\u201d\u65f6\uff0c\u4e0d\u5141\u8bb8\u586b\u5199\u201c\u56fa\u5b9a\u6bd4\u8f83\u503c\u201d\u3002", (String)"TableFilterFormPlugin_10", (String)"isc-dbc-platform-plugin", (Object[])new Object[0]), i + 1), Integer.valueOf(3000));
            return true;
        }
        return false;
    }

    private boolean validateFilterBracket(DynamicObjectCollection filterEntries) {
        int count = 0;
        for (DynamicObject filter : filterEntries) {
            String right_bracket;
            int right;
            String left_bracket = filter.getString(LEFT_BRACKET);
            int left = left_bracket == null ? 0 : left_bracket.length();
            if ((count = count + left - (right = (right_bracket = filter.getString(RIGHT_BRACKET)) == null ? 0 : right_bracket.length())) >= 0) continue;
            return true;
        }
        return count != 0;
    }

    public void beforeClosed(BeforeClosedEvent e) {
        super.beforeClosed(e);
        Map params = this.getView().getFormShowParameter().getCustomParams();
        this.getView().returnDataToParent((Object)params);
    }

    public void cellClick(CellClickEvent cellClickEvent) {
    }

    private void setIscVariable(ClosedCallBackEvent evt, IFormView view) {
        Object data = evt.getReturnData();
        Map map = (Map)data;
        Object rowValue = map.get("$row");
        Object expression = map.get("expression");
        if (rowValue != null && expression != null) {
            DynamicObject row = view.getModel().getEntryRowEntity(ENTRYENTITY, D.i(rowValue));
            row.set(VALUE_FIXED, (Object)D.s(expression));
            view.updateView(ENTRYENTITY);
        }
    }

    public void cellDoubleClick(CellClickEvent cellClickEvent) {
        Map params = this.getView().getFormShowParameter().getCustomParams();
        if (null != params && "VIEW".equals(params.get("billStatus"))) {
            return;
        }
        String fieldKey = cellClickEvent.getFieldKey();
        if (null != params && fieldKey.equals(COLUMN) && D.l(params.get("id")) != 0L) {
            HashMap<String, Number> param = new HashMap<String, Number>();
            param.put("id", D.l(params.get("id")));
            param.put("$row", cellClickEvent.getRow());
            FormOpener.showForm((AbstractFormPlugin)this, (String)"isc_meta_properties", (String)ResManager.loadKDString((String)"\u9009\u62e9\u5b57\u6bb5\u5c5e\u6027", (String)"TableFilterFormPlugin_6", (String)"isc-dbc-platform-plugin", (Object[])new Object[0]), param, (String)"isc_meta_select");
        } else if (fieldKey.equals(VALUE_FIXED)) {
            HashMap<String, Integer> param = new HashMap<String, Integer>();
            param.put("$row", cellClickEvent.getRow());
            FormOpener.showForm((AbstractFormPlugin)this, (String)"fixed_value_selector", (String)ResManager.loadKDString((String)"\u9009\u62e9\u73af\u5883\u53d8\u91cf\u8868\u8fbe\u5f0f", (String)"TableFilterFormPlugin_7", (String)"isc-dbc-platform-plugin", (Object[])new Object[0]), param, (String)"get_iscenv_var");
        }
    }
}

