/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.ds.formplugin.dc;

import java.util.Collections;
import java.util.EventObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.DB;
import kd.bos.db.DBRoute;
import kd.bos.form.ConfirmCallBackListener;
import kd.bos.form.MessageBoxOptions;
import kd.bos.form.MessageBoxResult;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.MessageBoxClosedEvent;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.form.plugin.IFormPlugin;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.DispatchServiceHelper;
import kd.bos.servicehelper.license.LicenseServiceHelper;
import kd.isc.ds.formplugin.util.FormOpener;

public class CloudOrgDepSyncListPlugin
extends AbstractFormPlugin {
    private static final String XK_CQ_FLOW_NUMBER = "KDflow_OrgDepInitAdd(XK-CQ)";
    private static final String CQ_CQ_FLOW_NUMBER = "KDflow_OrgDepInitAdd(CQ-CQ)";
    private static final String XKQJ_XKQJ_FLOW_NUMBER = "KDflow_OrgDepInitAdd(XKQJ-XKQJ)";
    private static final String XKQY_XKQJ_FLOW_NUMBER = "KDflow_OrgDepInitAdd(XKQY-XKQJ)";
    private static final String START = "start";
    private static final Set<String> STATES = new HashSet<String>(12);

    private void cleanState() {
        STATES.clear();
    }

    public void afterDoOperation(AfterDoOperationEventArgs args) {
        super.afterDoOperation(args);
        String operateKey = args.getOperateKey();
        if ("init".equals(operateKey)) {
            if (this.isXK_QJ()) {
                ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("initOrgDepData_XKQJ", (IFormPlugin)this);
                String mes = String.format(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u5c06\u4f1a\u6267\u884c\u7f16\u7801\u4e3a\u3010%s\u3011\u7684\u670d\u52a1\u6d41\u7a0b\uff0c\u540c\u6b65\u661f\u7a7a\u4f01\u4e1a\u7248\u7ec4\u7ec7\u90e8\u95e8\u7684\u6570\u636e\u5230\u661f\u7a7a\u65d7\u8230\u7248\u4e2d\u95f4\u8868\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CloudOrgDepSyncListPlugin_20", (String)"isc-ds-formplugin", (Object[])new Object[0]), XKQY_XKQJ_FLOW_NUMBER);
                this.getView().showConfirm(mes, MessageBoxOptions.YesNo, callBackListener);
            } else {
                ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("initOrgDepData", (IFormPlugin)this);
                String mes = String.format(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u5c06\u4f1a\u6267\u884c\u7f16\u7801\u4e3a\u3010%s\u3011\u7684\u670d\u52a1\u6d41\u7a0b\uff0c\u540c\u6b65\u661f\u7a7a\u4f01\u4e1a\u7248\u7ec4\u7ec7\u90e8\u95e8\u7684\u6570\u636e\u5230\u82cd\u7a79\u4e2d\u95f4\u8868\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CloudOrgDepSyncListPlugin_21", (String)"isc-ds-formplugin", (Object[])new Object[0]), XK_CQ_FLOW_NUMBER);
                this.getView().showConfirm(mes, MessageBoxOptions.YesNo, callBackListener);
            }
        } else if ("builder".equals(operateKey)) {
            if (this.isXK_QJ()) {
                ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("buildOrgDepTree_XKQJ", (IFormPlugin)this);
                String mes = String.format(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u5c06\u4f1a\u6267\u884c\u7f16\u7801\u4e3a\u3010%s\u3011\u7684\u670d\u52a1\u6d41\u7a0b\uff0c\u540c\u6b65\u661f\u7a7a\u65d7\u8230\u7ec4\u7ec7\u4e2d\u95f4\u8868\u7684\u6570\u636e\u5230\u661f\u7a7a\u65d7\u8230\u7684\u884c\u653f\u7ec4\u7ec7\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CloudOrgDepSyncListPlugin_22", (String)"isc-ds-formplugin", (Object[])new Object[0]), XKQJ_XKQJ_FLOW_NUMBER);
                this.getView().showConfirm(mes, MessageBoxOptions.YesNo, callBackListener);
            } else {
                ConfirmCallBackListener callBackListener = new ConfirmCallBackListener("buildOrgDepTree", (IFormPlugin)this);
                String mes = String.format(ResManager.loadKDString((String)"\u6b64\u64cd\u4f5c\u5c06\u4f1a\u6267\u884c\u7f16\u7801\u4e3a\u3010%s\u3011\u7684\u670d\u52a1\u6d41\u7a0b\uff0c\u540c\u6b65\u82cd\u7a79\u4e2d\u95f4\u8868\u7684\u6570\u636e\u5230\u82cd\u7a79\u7684\u884c\u653f\u7ec4\u7ec7\uff0c\u662f\u5426\u7ee7\u7eed\uff1f", (String)"CloudOrgDepSyncListPlugin_23", (String)"isc-ds-formplugin", (Object[])new Object[0]), CQ_CQ_FLOW_NUMBER);
                this.getView().showConfirm(mes, MessageBoxOptions.YesNo, callBackListener);
            }
        } else if ("vieworg".equals(operateKey)) {
            this.viewOrgList();
        } else if ("viewdep".equals(operateKey)) {
            this.viewDepList();
        }
    }

    private boolean isXK_QJ() {
        int type = LicenseServiceHelper.getModeType();
        return 2 == type || 4 == type;
    }

    private void viewDepList() {
        QFilter qFilter = new QFilter("id", ">", (Object)0);
        FormOpener.openBillList(this, "ds_xk_dep", Collections.singletonList(qFilter));
    }

    private void viewOrgList() {
        QFilter qFilter = new QFilter("id", ">", (Object)0);
        FormOpener.openBillList(this, "ds_xk_org", Collections.singletonList(qFilter));
    }

    private void buildOrgDepTree() {
        if (this.checkFlowAndInst(XK_CQ_FLOW_NUMBER, false) || this.checkFlowAndInst(CQ_CQ_FLOW_NUMBER, true)) {
            return;
        }
        try {
            this.start(START, CQ_CQ_FLOW_NUMBER);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u90e8\u95e8\u6570\u636e\u6b63\u5728\u540c\u6b65\u4e2d\uff0c\u7a0d\u540e\u8bf7\u70b9\u51fb\u3010\u5237\u65b0\u3011\u6309\u94ae\u67e5\u770b\u540c\u6b65\u72b6\u6001\u3002", (String)"CloudOrgDepSyncListPlugin_0", (String)"isc-ds-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e, ResManager.loadKDString((String)"\u540c\u6b65\u7ec4\u7ec7\u90e8\u95e8\u4e2d\u95f4\u8868\u7684\u6570\u636e\u5230\u82cd\u7a79\u65f6\u5931\u8d25", (String)"CloudOrgDepSyncListPlugin_1", (String)"isc-ds-formplugin", (Object[])new Object[0]));
        }
    }

    private void buildOrgDepTree_XKQJ() {
        if (this.checkFlowAndInst(XKQY_XKQJ_FLOW_NUMBER, false) || this.checkFlowAndInst(XKQJ_XKQJ_FLOW_NUMBER, true)) {
            return;
        }
        try {
            this.start(START, XKQJ_XKQJ_FLOW_NUMBER);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u7ec4\u7ec7\u90e8\u95e8\u6570\u636e\u6b63\u5728\u540c\u6b65\u4e2d\uff0c\u7a0d\u540e\u8bf7\u70b9\u51fb\u3010\u5237\u65b0\u3011\u6309\u94ae\u67e5\u770b\u540c\u6b65\u72b6\u6001\u3002", (String)"CloudOrgDepSyncListPlugin_0", (String)"isc-ds-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e, ResManager.loadKDString((String)"\u540c\u6b65\u661f\u7a7a\u4f01\u4e1a\u7ec4\u7ec7\u90e8\u95e8\u4e2d\u95f4\u8868\u7684\u6570\u636e\u5230\u661f\u7a7a\u65d7\u8230\u65f6\u5931\u8d25", (String)"CloudOrgDepSyncListPlugin_4", (String)"isc-ds-formplugin", (Object[])new Object[0]));
        }
    }

    private void initOrgDepData() {
        if (this.checkFlowAndInst(XK_CQ_FLOW_NUMBER, true)) {
            return;
        }
        try {
            this.start(START, XK_CQ_FLOW_NUMBER);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u661f\u7a7a\u7ec4\u7ec7\u90e8\u95e8\u6570\u636e\u540c\u6b65\u670d\u52a1\u6d41\u7a0b\u5df2\u542f\u52a8,\u8bf7\u7a0d\u540e\u70b9\u51fb\u3010\u5237\u65b0\u3011\u6309\u94ae\u67e5\u770b\u5217\u8868\u6570\u636e\u3002", (String)"CloudOrgDepSyncListPlugin_2", (String)"isc-ds-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e, ResManager.loadKDString((String)"\u540c\u6b65\u661f\u7a7a\u7ec4\u7ec7\u90e8\u95e8\u7684\u6570\u636e\u5230\u82cd\u7a79\u4e2d\u95f4\u8868\u65f6\u5931\u8d25", (String)"CloudOrgDepSyncListPlugin_3", (String)"isc-ds-formplugin", (Object[])new Object[0]));
        }
    }

    private void initOrgDepData_XKQJ() {
        if (this.checkFlowAndInst(XKQY_XKQJ_FLOW_NUMBER, true)) {
            return;
        }
        try {
            this.start(START, XKQY_XKQJ_FLOW_NUMBER);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u661f\u7a7a\u7ec4\u7ec7\u90e8\u95e8\u6570\u636e\u540c\u6b65\u670d\u52a1\u6d41\u7a0b\u5df2\u542f\u52a8,\u8bf7\u7a0d\u540e\u70b9\u51fb\u3010\u5237\u65b0\u3011\u6309\u94ae\u67e5\u770b\u5217\u8868\u6570\u636e\u3002", (String)"CloudOrgDepSyncListPlugin_2", (String)"isc-ds-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e, ResManager.loadKDString((String)"\u540c\u6b65\u661f\u7a7a\u4f01\u4e1a\u7248\u7ec4\u7ec7\u90e8\u95e8\u7684\u6570\u636e\u5230\u661f\u7a7a\u65d7\u8230\u7248\u4e2d\u95f4\u8868\u65f6\u5931\u8d25", (String)"CloudOrgDepSyncListPlugin_5", (String)"isc-ds-formplugin", (Object[])new Object[0]));
        }
    }

    public boolean checkFlowAndInst(String flowNumber, boolean isCheckFailed) {
        try {
            Map<String, String> flowDataRow = this.getServiceFlow(flowNumber);
            if (this.checkFlowState(flowDataRow, flowNumber)) {
                return true;
            }
            if (this.checkInstState(flowDataRow, flowNumber, isCheckFailed)) {
                return true;
            }
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e, String.format(ResManager.loadKDString((String)"\u68c0\u67e5\u7f16\u7801\u4e3a(%s)\u7684\u670d\u52a1\u6d41\u7a0b\u5931\u8d25", (String)"CloudOrgDepSyncListPlugin_14", (String)"isc-ds-formplugin", (Object[])new Object[0]), flowNumber));
        }
        return false;
    }

    private boolean checkFlowState(Map<String, String> flowDataRow, String flowNumber) {
        if (null == flowDataRow || flowDataRow.size() < 1) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\uff1a[%s]\u7684\u670d\u52a1\u6d41\u7a0b\u4e0d\u5b58\u5728\uff0c\u8bf7\u5bfc\u5165\u670d\u52a1\u6d41\u7a0b\uff01", (String)"CloudOrgDepSyncListPlugin_15", (String)"isc-ds-formplugin", (Object[])new Object[0]), flowNumber));
            return true;
        }
        String fis_released = flowDataRow.get("fis_released");
        if (null != fis_released && fis_released.equals("0")) {
            this.getView().showErrorNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\uff1a[%s]\u7684\u670d\u52a1\u6d41\u7a0b\u672a\u53d1\u5e03\uff0c\u8bf7\u5148\u53d1\u5e03\u5728\u6267\u884c\uff01", (String)"CloudOrgDepSyncListPlugin_16", (String)"isc-ds-formplugin", (Object[])new Object[0]), flowNumber));
            return true;
        }
        return false;
    }

    private Map<String, String> getServiceFlow(String flowNumber) {
        String flowSql = "SELECT FID,FIS_RELEASED,FVERSION FROM T_ISC_SERVICE_FLOW WHERE FNUMBER = ?";
        return (Map)DB.query((DBRoute)DBRoute.of((String)"ISCB"), (String)flowSql, (Object[])new Object[]{flowNumber}, rs -> {
            HashMap<String, String> data = new HashMap<String, String>(3);
            if (rs.next()) {
                data.put("fid", rs.getString(1));
                data.put("fis_released", rs.getString(2));
                data.put("fversion", rs.getString(3));
            }
            return data;
        });
    }

    private boolean checkInstState(Map<String, String> flowDataRow, String flowNumber, boolean isCheckFailed) {
        Map<String, String> instDataRow = this.getInst(flowDataRow);
        if (instDataRow == null || instDataRow.size() < 1) {
            return false;
        }
        if (isCheckFailed && this.checkFailedInst(instDataRow)) {
            ConfirmCallBackListener confirmCallBacks = new ConfirmCallBackListener("retry_execution", (IFormPlugin)this);
            this.getView().showConfirm(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\uff1a[%s]\u7684\u670d\u52a1\u6d41\u7a0b\u5b58\u5728\u6267\u884c\u5931\u8d25\u7684\u6d41\u7a0b\u5b9e\u4f8b\uff0c\u662f\u5426\u91cd\u8bd5\uff1f", (String)"CloudOrgDepSyncListPlugin_17", (String)"isc-ds-formplugin", (Object[])new Object[0]), flowNumber), MessageBoxOptions.YesNo, confirmCallBacks);
            return true;
        }
        return this.checkRunningInst(instDataRow, flowNumber);
    }

    private Map<String, String> getInst(Map<String, String> flowDataRow) {
        Map<String, String> releaseFlow = this.getReleaseFlow(flowDataRow);
        if (releaseFlow.size() < 1) {
            return null;
        }
        Map<String, String> inst = this.getInstByReleaseFlow(releaseFlow);
        if (inst.size() > 0) {
            return inst;
        }
        return null;
    }

    private Map<String, String> getInstByReleaseFlow(Map<String, String> releaseFlow) {
        String instSql = "SELECT FID,FSTATE FROM T_ISC_SF_PROC_INST WHERE FRELEASED_FLOW = ? ORDER BY FMODIFIED_TIME DESC";
        long flowRId = Long.parseLong(releaseFlow.get("fid"));
        return (Map)DB.query((DBRoute)DBRoute.of((String)"ISCB"), (String)instSql, (Object[])new Object[]{flowRId}, rs -> {
            HashMap<String, String> data = new HashMap<String, String>(2);
            if (rs.next()) {
                data.put("fid", rs.getString(1));
                data.put("fstate", rs.getString(2));
            }
            return data;
        });
    }

    private Map<String, String> getReleaseFlow(Map<String, String> flowDataRow) {
        String flowRSql = "SELECT FID FROM T_ISC_SERVICE_FLOW_R WHERE FFLOW_ID = ? AND FVERSION = ? ORDER BY fcreatetime DESC";
        long fid = Long.parseLong(flowDataRow.get("fid"));
        int version = Integer.parseInt(flowDataRow.get("fversion"));
        return (Map)DB.query((DBRoute)DBRoute.of((String)"ISCB"), (String)flowRSql, (Object[])new Object[]{fid, version}, rs -> {
            HashMap<String, String> data = new HashMap<String, String>(1);
            if (rs.next()) {
                data.put("fid", rs.getString(1));
            }
            return data;
        });
    }

    public void confirmCallBack(MessageBoxClosedEvent evt) {
        String callback = evt.getCallBackId();
        if ("retry_execution".equals(callback)) {
            long failedInstId = Long.parseLong(this.getPageCache().get("failed"));
            if (failedInstId == 0L) {
                return;
            }
            if (evt.getResult() == MessageBoxResult.No) {
                this.failedAndStart(failedInstId);
            } else {
                this.failedAndRetry(failedInstId);
            }
        }
        if (evt.getResult() == MessageBoxResult.Yes) {
            if ("initOrgDepData_XKQJ".equals(callback)) {
                this.initOrgDepData_XKQJ();
            }
            if ("initOrgDepData".equals(callback)) {
                this.initOrgDepData();
            }
            if ("buildOrgDepTree_XKQJ".equals(callback)) {
                this.buildOrgDepTree_XKQJ();
            }
            if ("buildOrgDepTree".equals(callback)) {
                this.buildOrgDepTree();
            }
        }
    }

    private void failedAndRetry(long failedInstId) {
        String RETRY = "retry";
        this.start(RETRY, failedInstId);
        this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u5931\u8d25\u6d41\u7a0b\u5b9e\u4f8b\u6b63\u5728\u6267\u884c\u3010\u91cd\u8bd5\u3011,\u8bf7\u7a0d\u540e\u70b9\u51fb\u3010\u5237\u65b0\u3011\u6309\u94ae\u67e5\u770b\u5217\u8868\u6570\u636e\u3002", (String)"CloudOrgDepSyncListPlugin_10", (String)"isc-ds-formplugin", (Object[])new Object[0]));
    }

    private void failedAndStart(long failedInstId) {
        DynamicObject failedInst = BusinessDataServiceHelper.loadSingle((Object)failedInstId, (String)"isc_sf_proc_inst", (String)"flow.number");
        String flowNumber = String.valueOf(failedInst.get("flow.number"));
        if (this.checkFlowAndInst(flowNumber, false)) {
            return;
        }
        try {
            this.start(START, flowNumber);
            this.getView().showSuccessNotification(ResManager.loadKDString((String)"\u661f\u7a7a\u7ec4\u7ec7\u90e8\u95e8\u6570\u636e\u540c\u6b65\u670d\u52a1\u6d41\u7a0b\u5df2\u542f\u52a8,\u8bf7\u7a0d\u540e\u70b9\u51fb\u3010\u5237\u65b0\u3011\u6309\u94ae\u67e5\u770b\u5217\u8868\u6570\u636e\u3002", (String)"CloudOrgDepSyncListPlugin_2", (String)"isc-ds-formplugin", (Object[])new Object[0]));
        }
        catch (Exception e) {
            FormOpener.showErrorMessage(this.getView(), e, String.format(ResManager.loadKDString((String)"\u6267\u884c\u7f16\u7801\u4e3a(%s)\u7684\u670d\u52a1\u6d41\u7a0b\u5931\u8d25", (String)"CloudOrgDepSyncListPlugin_18", (String)"isc-ds-formplugin", (Object[])new Object[0]), flowNumber));
        }
    }

    private boolean checkRunningInst(Map<String, String> instDataRow, String flowNumber) {
        String state = instDataRow.get("fstate");
        if (null != state && STATES.contains(state)) {
            this.getView().showTipNotification(String.format(ResManager.loadKDString((String)"\u7f16\u7801\u4e3a\uff1a[%1$s]\u7684\u670d\u52a1\u6d41\u7a0b\u5df2\u5b58\u5728\u72b6\u6001\u4e3a:[%2$s]\u7684\u6d41\u7a0b\u5b9e\u4f8b\uff0c\u8bf7\u4e0d\u8981\u9891\u7e41\u64cd\u4f5c\u3002", (String)"CloudOrgDepSyncListPlugin_19", (String)"isc-ds-formplugin", (Object[])new Object[0]), flowNumber, state));
            return true;
        }
        return false;
    }

    private boolean checkFailedInst(Map<String, String> instDataRow) {
        String state = instDataRow.get("fstate");
        if (null != state && state.equals("Failed")) {
            this.getPageCache().put("failed", instDataRow.get("fid"));
            return true;
        }
        return false;
    }

    private void start(String operation, Object number) {
        DispatchServiceHelper.invokeBizService((String)"isc", (String)"iscb", (String)"IscFlowService", (String)operation, (Object[])new Object[]{number});
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        if (this.isXK_QJ()) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"builder"});
            this.getView().setVisible(Boolean.TRUE, new String[]{"builder2"});
        } else {
            this.getView().setVisible(Boolean.TRUE, new String[]{"builder"});
            this.getView().setVisible(Boolean.FALSE, new String[]{"builder2"});
        }
    }

    static {
        STATES.add("Created");
        STATES.add("Waiting");
        STATES.add("Running");
    }
}

