/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.formplugin.tools.ds;

import java.io.BufferedOutputStream;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.sql.Connection;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.EventObject;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import java.util.function.Consumer;
import kd.bos.cache.CacheFactory;
import kd.bos.context.RequestContext;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.entity.datamodel.ListSelectedRow;
import kd.bos.entity.datamodel.ListSelectedRowCollection;
import kd.bos.entity.datamodel.events.PackageDataEvent;
import kd.bos.entity.datamodel.events.PropertyChangedArgs;
import kd.bos.form.IFormView;
import kd.bos.form.control.AttachmentPanel;
import kd.bos.form.control.EntryGrid;
import kd.bos.form.control.OperationColumn;
import kd.bos.form.control.events.RowClickEvent;
import kd.bos.form.control.events.RowClickEventListener;
import kd.bos.form.control.events.UploadEvent;
import kd.bos.form.control.events.UploadListener;
import kd.bos.form.events.AfterDoOperationEventArgs;
import kd.bos.form.events.BeforeDoOperationEventArgs;
import kd.bos.form.events.ClosedCallBackEvent;
import kd.bos.form.field.ComboEdit;
import kd.bos.form.field.ComboItem;
import kd.bos.form.operate.AbstractOperate;
import kd.bos.form.operatecol.OperationColItem;
import kd.bos.form.plugin.AbstractFormPlugin;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.formplugin.util.FormOpener;
import kd.isc.iscb.platform.core.connector.self.AttachmentUtil;
import kd.isc.iscb.platform.core.dts.replica.ConvertMode;
import kd.isc.iscb.platform.core.dts.route.DataSourceConvertJob;
import kd.isc.iscb.platform.core.dts.route.DtsFileResourceParseJob;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.platform.core.job.JobInfo;
import kd.isc.iscb.platform.core.util.FileUtil;
import kd.isc.iscb.platform.core.util.ZipUtils;
import kd.isc.iscb.util.db.DataRow;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.Script;

public class DataSourceConvertFormPlugin
extends AbstractFormPlugin
implements RowClickEventListener,
UploadListener {
    private static Log logger = LogFactory.getLog(DataSourceConvertFormPlugin.class);
    private static final String RES_TYPE = "res_type";
    private static final String BILLNO = "billno";
    private static final String REF_RESOURCES = "ref_resources";
    private static final String BTN_REF_RES_DIFF_COMP = "btn_ref_res_diff_comp";
    private static final String BTN_REF_RES_STACKTRACE = "btn_ref_res_stacktrace";
    private static final String BTN_MAIN_RES_DIFF_COMP = "btn_main_res_diff_comp";
    private static final String PROGRESS = "progress";
    public static final String READY = "READY";
    public static final String PARSED = "PARSED";
    public static final String CONVETING = "CONVERTING";
    public static final String CONVERTED = "CONVERTED";
    private static final String PARSING = "PARSING";
    public static final String T_ISCB_DTS_CONV_RRS_2 = "t_iscb_dts_conv_rrs2";

    public void afterCreateNewData(EventObject e) {
        super.afterCreateNewData(e);
        this.setComboEdit();
    }

    private void setComboEdit() {
        String tenantId = RequestContext.get().getTenantId();
        boolean isDev = "tenant_devother_dev".equals(tenantId) || "tenant_devother_test".equals(tenantId) || "tenant_patchother_test".equals(tenantId);
        ComboEdit fieldCombo = (ComboEdit)this.getControl("mode");
        ArrayList<ComboItem> items = new ArrayList<ComboItem>(2);
        String cover = ResManager.loadKDString((String)"\u8986\u76d6", (String)"DataSourceConvertFormPlugin_14", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
        String copy = ResManager.loadKDString((String)"\u590d\u5236", (String)"DataSourceConvertFormPlugin_15", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
        items.add(new ComboItem(new LocaleString(cover), "cover"));
        items.add(new ComboItem(new LocaleString(copy), "copy"));
        if (isDev) {
            String reset_trace = ResManager.loadKDString((String)"\u91cd\u7f6e\u8ffd\u6eaf\u4fe1\u606f", (String)"DataSourceConvertFormPlugin_16", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
            items.add(new ComboItem(new LocaleString(reset_trace), "reset_trace"));
        }
        fieldCombo.setComboItems(items);
    }

    public void beforeBindData(EventObject e) {
        super.beforeBindData(e);
        this.setResType();
        this.setBillNo();
        String progress = D.s((Object)this.getModel().getValue(PROGRESS));
        this.setButtonSave(progress);
        this.setButtonParse(progress);
        this.setButtonConvert(progress);
        this.setButtonGenerateFile(progress);
        this.setVisibleByState(progress);
        this.setSaveByResIsEmpty();
        this.setComboEdit();
    }

    private void setResType() {
        if (D.s((Object)this.getModel().getValue(RES_TYPE)) == null) {
            String entity = (String)this.getView().getFormShowParameter().getCustomParam("entity");
            this.getModel().setValue(RES_TYPE, (Object)entity);
        }
    }

    private void setBillNo() {
        String billNo = D.s((Object)this.getModel().getValue(BILLNO));
        if (billNo == null) {
            this.getModel().setValue(BILLNO, (Object)Hash.mur32((Object[])new Object[]{UUID.randomUUID().toString()}));
        }
    }

    private void setButtonSave(String progress) {
        boolean ready = READY.equals(progress);
        this.getView().setVisible(Boolean.valueOf(ready), new String[]{"bar_save"});
        this.getView().setVisible(Boolean.valueOf(!ready), new String[]{"data_source_entry_flex", "advconap2", "advconap", "out_attachment"});
        if (ConvertMode.reset_trace.name().equals(D.s((Object)this.getModel().getValue("mode")))) {
            this.getView().setVisible(Boolean.FALSE, new String[]{"data_source_entry_flex"});
        }
    }

    private void setButtonParse(String progress) {
        boolean isParseable = PARSING.equals(progress) || PARSED.equals(progress);
        this.getView().setEnable(Boolean.valueOf(isParseable), new String[]{"btn_parse", "mode", "isv", "protect_level", "source_tenant", "source_trace"});
        boolean showTraceInfo = ConvertMode.reset_trace.name().equals(this.getModel().getValue("mode"));
        this.getView().setVisible(Boolean.valueOf(showTraceInfo), new String[]{"isv", "protect_level", "source_tenant", "source_trace"});
    }

    private void setButtonConvert(String progress) {
        final boolean isConvertable = PARSED.equals(progress) || CONVETING.equals(progress);
        this.getView().setEnable(Boolean.valueOf(isConvertable), new String[]{"btn_convert"});
        if (isConvertable) {
            String s = ResManager.loadKDString((String)"\u8bf7\u68c0\u67e5\u8d44\u6e90\u6587\u4ef6\u6570\u636e\uff0c\u786e\u8ba4\u540e\u518d\u70b9\u51fb\u201c\u6267\u884c\u8f6c\u6362\u201d\u3002", (String)"DataSourceConvertFormPlugin_13", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
            this.getView().showSuccessNotification(s, Integer.valueOf(3000));
        }
        EntryGrid entryGrid = (EntryGrid)this.getControl("data_source_entry");
        entryGrid.addPackageDataListener((Consumer)new Consumer<PackageDataEvent>(){

            @Override
            public void accept(PackageDataEvent e) {
                if (e.getSource() instanceof OperationColumn) {
                    List operationColItems = (List)e.getFormatValue();
                    for (OperationColItem i : operationColItems) {
                        i.setLocked(!isConvertable);
                    }
                }
            }
        });
    }

    private void setButtonGenerateFile(String progress) {
        this.getView().setVisible(Boolean.valueOf(CONVERTED.equals(progress)), new String[]{"btn_generate_file"});
    }

    private void setVisibleByState(String progress) {
        this.getView().setVisible(Boolean.valueOf(PARSED.equals(progress) || CONVETING.equals(progress) || CONVERTED.equals(progress)), new String[]{BTN_REF_RES_DIFF_COMP, BTN_MAIN_RES_DIFF_COMP});
        this.getView().setVisible(Boolean.valueOf(!CONVETING.equals(progress) && !CONVERTED.equals(progress)), new String[0]);
    }

    private void setSaveByResIsEmpty() {
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        List list = attachmentPanel.getAttachmentData();
        this.getView().setEnable(Boolean.valueOf(!list.isEmpty()), new String[]{"bar_save"});
    }

    public void beforeDoOperation(BeforeDoOperationEventArgs args) {
        super.beforeDoOperation(args);
        AbstractOperate operate = (AbstractOperate)args.getSource();
        String operationKey = operate.getOperateKey();
        if ("convert".equals(operationKey)) {
            String mode = D.s((Object)this.getModel().getValue("mode"));
            if (StringUtil.isEmpty((String)mode)) {
                String tips = ResManager.loadKDString((String)"\u8bf7\u9009\u62e9\u8f6c\u6362\u6a21\u5f0f", (String)"DataSourceConvertFormPlugin_17", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
                this.getView().showTipNotification(tips);
                args.setCancel(true);
                return;
            }
            if (ConvertMode.copy == ConvertMode.valueOf(mode) && !this.dataSourceEmpty() && !this.dataSourceHasConfig()) {
                this.copyDataSourceSrcToTar();
                args.setCancel(true);
                this.getView().invokeOperation(operationKey);
            } else if (!this.dataSourceEmpty()) {
                this.checkMapping(args);
            }
        }
    }

    private void copyDataSourceSrcToTar() {
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("data_source_entry");
        for (DynamicObject obj : entries) {
            obj.set("tar_pk", obj.get("src_pk"));
            obj.set("tar_number", obj.get("src_number"));
            obj.set("tar_name", obj.get("src_name"));
        }
        this.getView().updateView("data_source_entry");
    }

    private boolean dataSourceHasConfig() {
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("data_source_entry");
        for (DynamicObject obj : entries) {
            Object tarPk = obj.get("tar_pk");
            if (D.s((Object)tarPk) == null) continue;
            return true;
        }
        return false;
    }

    private boolean dataSourceEmpty() {
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("data_source_entry");
        return entries.isEmpty();
    }

    private void checkMapping(BeforeDoOperationEventArgs args) {
        if (ConvertMode.reset_trace.name().equals(D.s((Object)this.getModel().getValue("mode")))) {
            return;
        }
        DynamicObjectCollection entries = this.getModel().getDataEntity(true).getDynamicObjectCollection("data_source_entry");
        for (DynamicObject obj : entries) {
            Object srcPk = obj.get("src_pk");
            Object tarPk = obj.get("tar_pk");
            if (D.s((Object)srcPk) == null || D.s((Object)tarPk) == null) continue;
            return;
        }
        String s = ResManager.loadKDString((String)"\u6ca1\u6709\u914d\u7f6e\u6570\u636e\u6e90\u6620\u5c04\u5173\u7cfb\uff0c\u65e0\u9700\u8f6c\u6362\u3002", (String)"DataSourceConvertFormPlugin_12", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
        this.getView().showTipNotification(s);
        args.setCancel(true);
    }

    public void afterDoOperation(AfterDoOperationEventArgs e) {
        super.afterDoOperation(e);
        if ("parse".equals(e.getOperateKey())) {
            this.startParsingFiles();
        } else if ("change_ds".equals(e.getOperateKey())) {
            FormOpener.showF7((AbstractFormPlugin)this, (String)"isc_data_source", (String)"change_ds_callback", (boolean)false);
        } else if ("reset_ds".equals(e.getOperateKey())) {
            this.restDataSourceMapping();
        } else if ("convert".equals(e.getOperateKey())) {
            this.startConvertResource();
        } else if ("view_ref_res_error".equals(e.getOperateKey())) {
            this.showStackTrace(REF_RESOURCES, T_ISCB_DTS_CONV_RRS_2);
        } else if ("ref_res_diff_comp".equals(e.getOperateKey())) {
            this.showDiffComp(REF_RESOURCES, T_ISCB_DTS_CONV_RRS_2);
        } else if ("generate_file".equals(e.getOperateKey())) {
            this.generateFile();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showDiffComp(String entryKey, String entryTable) {
        int row = D.i((Object)this.getPageCache().get(entryKey));
        if (row < 0) {
            String s = ResManager.loadKDString((String)"\u8bf7\u81f3\u5c11\u9009\u62e9\u4e00\u884c", (String)"DataSourceConvertFormPlugin_9", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
            throw new IscBizException(s);
        }
        long entryId = D.l((Object)this.getModel().getEntryRowEntity(entryKey, row).get("id"));
        String sql = "SELECT fcontent,fnew_content,ftype FROM " + entryTable + " WHERE fentryid = ?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            DataRow data = DbUtil.executeRow((Connection)cn, (String)sql, Collections.singletonList(entryId), Collections.singletonList(-5));
            Map res = (Map)Script.parseJson((String)((String)data.get((Object)"fcontent")));
            Map newRes = (Map)Script.parseJson((String)((String)data.get((Object)"fnew_content")));
            String entity = D.s((Object)data.get((Object)"ftype"));
            String s1 = ResManager.loadKDString((String)"\u539f\u59cb\u8d44\u6e90\uff08\u65e7\uff09", (String)"DataSourceConvertFormPlugin_10", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
            String s2 = ResManager.loadKDString((String)"\u8f6c\u6362\u8d44\u6e90\uff08\u65b0\uff09", (String)"DataSourceConvertFormPlugin_11", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
            FormOpener.showDiffComp((AbstractFormPlugin)this, (String)entity, (Map)res, (String)s1, (Map)newRes, (String)s2);
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void showStackTrace(String entryKey, String entryTable) {
        int row = D.i((Object)this.getPageCache().get(entryKey));
        long entryId = D.l((Object)this.getModel().getEntryRowEntity(entryKey, row).get("id"));
        String sql = "SELECT fstack_trace FROM " + entryTable + " WHERE fentryid = ?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            String stacktrace = (String)DbUtil.executeScalar((Connection)cn, (String)sql, Collections.singletonList(entryId), Collections.singletonList(-5));
            String s = ResManager.loadKDString((String)"\u9519\u8bef\u4fe1\u606f", (String)"DataSourceConvertFormPlugin_8", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
            FormOpener.showInfo((IFormView)this.getView(), (String)stacktrace, (String)s);
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private void generateFile() {
        String billstatus = D.s((Object)this.getModel().getValue("billstatus"));
        if ("Z".equals(billstatus)) {
            this.generateFileFromDatabase();
        } else {
            this.generateFileFromAttachment();
        }
    }

    private void generateFileFromDatabase() {
        String sql = "select ffile, ffileid from t_iscb_dts_conv_res_file WHERE fid=?";
        List<Object> values = Collections.singletonList(this.getModel().getValue("id"));
        List<Integer> types = Collections.singletonList(-5);
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        String fileId = "";
        String filename = "";
        try {
            List dataRows = DbUtil.executeList((Connection)cn, (String)sql, values, types);
            if (dataRows.isEmpty()) {
                String s = ResManager.loadKDString((String)"\u6570\u636e\u9519\u8bef\uff0c\u6ca1\u6709\u627e\u5230\u8d44\u6e90\u5bf9\u5e94\u7684\u6587\u4ef6\u4fe1\u606f", (String)"DataSourceConvertFormPlugin_7", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
                throw new IscBizException(s);
            }
            fileId = D.s((Object)((DataRow)dataRows.get(0)).get((Object)"ffileid"));
            filename = D.s((Object)((DataRow)dataRows.get(0)).get((Object)"ffile"));
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
        finally {
            DbUtil.close((Connection)cn);
        }
        this.doGenerate(filename, fileId);
    }

    private void generateFileFromAttachment() {
        Object id = this.getModel().getValue("id");
        List files = AttachmentUtil.getAttachmentList((String)"isc_source_convert", (Object)id);
        if (files.isEmpty()) {
            String s = ResManager.loadKDString((String)"\u4e0a\u4f20\u7684\u9644\u4ef6\u4e3a\u7a7a\uff0c\u65e0\u6cd5\u83b7\u53d6\u6587\u4ef6\u540d\u751f\u6210\u6587\u4ef6\u3002", (String)"DataSourceConvertFormPlugin_5", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
            this.getView().showErrorNotification(s);
        }
        if (files.size() <= 3) {
            this.download(files);
        } else {
            this.downloadZip(files);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void downloadZip(List<Map<String, Object>> files) {
        String zipPath = System.getProperty("user.home") + File.separator + "downloads" + File.separator + "temp";
        ArrayList<String> filesTemp = new ArrayList<String>(files.size());
        for (Map<String, Object> file : files) {
            String oldFileName = D.s((Object)file.get("name"));
            String prefix = ResManager.loadKDString((String)"\u65b0_%1$s%2$s", (String)"DataSourceConvertFormPlugin_6", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
            String newFileName = String.format(prefix, oldFileName, ".dts");
            String fileId = D.s((Object)file.get("srcAttachId"));
            String tempFilePath = FileUtil.getLocalPath((String)newFileName, (String)"");
            this.doGenerateWriteTempFile(tempFilePath, fileId);
            filesTemp.add(tempFilePath);
        }
        FileInputStream in = null;
        String path = null;
        try {
            path = ZipUtils.compressFile(filesTemp, (String)zipPath, (String)this.zipFileName());
            FileUtil.checkFilePath((String)path);
            in = new FileInputStream(path);
            String url = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(path.substring(path.lastIndexOf(File.separator) + 1), (InputStream)in, 1800);
            this.getView().openUrl(url);
        }
        catch (Exception e) {
            logger.error("\u6570\u636e\u6e90\u5207\u6362\uff0c\u751f\u6210\u538b\u7f29zip\u6587\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (Throwable)e);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    logger.error("\u6570\u636e\u6e90\u5207\u6362\uff0c\u5173\u95ed\u6587\u4ef6\u8f93\u5165\u6d41\u5931\u8d25\uff0c\u539f\u56e0\uff1a", (Throwable)e);
                }
            }
            filesTemp.forEach(FileUtil::delete);
            FileUtil.delete((String)path);
        }
    }

    private void download(List<Map<String, Object>> files) {
        for (Map<String, Object> file : files) {
            String oldFileName = D.s((Object)file.get("name"));
            String prefix = ResManager.loadKDString((String)"\u65b0_%1$s%2$s", (String)"DataSourceConvertFormPlugin_6", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
            String newFileName = String.format(prefix, oldFileName, ".dts");
            String fileId = D.s((Object)file.get("srcAttachId"));
            this.doGenerate(newFileName, fileId);
        }
    }

    private String zipFileName() {
        SimpleDateFormat df = new SimpleDateFormat("yyyyMMdd-HHmmss");
        String date = df.format(new Date());
        return D.s((Object)this.getModel().getValue(BILLNO)) + '_' + date;
    }

    private void doGenerate(String filename, String fileId) {
        this.checkDatasourceAndFixIt(fileId);
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            this.writeResources(output, fileId);
            try (ByteArrayInputStream input = new ByteArrayInputStream(output.toByteArray());){
                String urls = CacheFactory.getCommonCacheFactory().getTempFileCache().saveAsUrl(filename, (InputStream)input, 1800);
                this.getView().openUrl(urls);
            }
        }
        catch (Exception e) {
            String s = ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"DataSourceConvertFormPlugin_4", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
            s = String.format(s, StringUtil.getCascadeMessage((Throwable)e));
            throw new IscBizException(s, (Throwable)e);
        }
    }

    private void doGenerateWriteTempFile(String tempFilePath, String fileId) {
        this.checkDatasourceAndFixIt(fileId);
        FileUtil.checkFilePath((String)tempFilePath);
        try (BufferedOutputStream output = new BufferedOutputStream(new FileOutputStream(tempFilePath), 524288);){
            this.writeResources(output, fileId);
        }
        catch (Exception e) {
            String s = ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"DataSourceConvertFormPlugin_4", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
            s = String.format(s, StringUtil.getCascadeMessage((Throwable)e));
            throw new IscBizException(s, (Throwable)e);
        }
    }

    private void writeResources(OutputStream output, String fileId) {
        long id = D.l((Object)this.getModel().getValue("id"));
        String sql = "SELECT res.ftype, res.fcontent, res.fnew_content, res.fstate, f.fisref FROM t_iscb_dts_conv_rrs2 res, t_iscb_dts_conv_res_file f where res.fres_pk = f.fres_pk and f.fis_need='true' and res.fid = ? and f.ffileid = ? order by f.fseq";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            List<Object> values = Arrays.asList(id, fileId);
            List<Integer> types = Arrays.asList(-5, 12);
            List dataRows = DbUtil.executeList((Connection)cn, (String)sql, values, types);
            this.checkIsrefAndFixIt(dataRows);
            for (DataRow row : dataRows) {
                String state = D.s((Object)row.get((Object)"fstate"));
                String s = "SUCCESS".equals(state) ? D.s((Object)row.get((Object)"fnew_content")) : D.s((Object)row.get((Object)"fcontent"));
                output.write(s.getBytes(StandardCharsets.UTF_8));
                output.write(10);
            }
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private void checkIsrefAndFixIt(List<DataRow> dataRows) {
        for (DataRow row : dataRows) {
            String state = D.s((Object)row.get((Object)"fstate"));
            String content = "SUCCESS".equals(state) ? D.s((Object)row.get((Object)"fnew_content")) : D.s((Object)row.get((Object)"fcontent"));
            Map contentData = (Map)Json.toObject((String)content);
            contentData.put("$isref", D.x((Object)row.get((Object)"fisref")));
            content = Json.toString((Object)contentData);
            if ("SUCCESS".equals(state)) {
                row.setValue(row.getFieldIndex("fnew_content"), (Object)content);
                continue;
            }
            row.setValue(row.getFieldIndex("fcontent"), (Object)content);
        }
    }

    private void checkDatasourceAndFixIt(String fileId) {
        long id = D.l((Object)this.getModel().getValue("id"));
        String sql = "select f.fentryid, res.fres_pk, res.fnew_res_pk, res.fstate from t_iscb_dts_conv_rrs2 res, t_iscb_dts_conv_res_file f where f.fres_pk=res.fres_pk and f.ftype='isc_data_source' and f.ffileid=? and res.fid=?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)true);
        try {
            List<Object> values = Arrays.asList(fileId, id);
            List<Integer> types = Arrays.asList(12, -5);
            List dataRows = DbUtil.executeList((Connection)cn, (String)sql, values, types);
            ArrayList<Long> successResPk = new ArrayList<Long>();
            ArrayList<DataRow> omittedRes = new ArrayList<DataRow>();
            this.classify(dataRows, successResPk, omittedRes);
            ArrayList<Long> omitteEntryIds = new ArrayList<Long>(16);
            for (DataRow row : omittedRes) {
                if (!successResPk.contains(D.l((Object)row.get((Object)"fres_pk")))) continue;
                omitteEntryIds.add(D.l((Object)row.get((Object)"fentryid")));
            }
            if (!omitteEntryIds.isEmpty()) {
                this.omitteFileRes(omitteEntryIds);
            }
        }
        catch (Exception e) {
            throw D.e((Throwable)e);
        }
        finally {
            DbUtil.close((Connection)cn);
        }
    }

    private void classify(List<DataRow> dataRows, List<Long> successResPk, List<DataRow> omittedRes) {
        for (DataRow row : dataRows) {
            String state = D.s((Object)row.get((Object)"fstate"));
            if (state.equals("SUCCESS")) {
                successResPk.add(D.l((Object)row.get((Object)"fnew_res_pk")));
                continue;
            }
            if (!state.equals("OMITTED")) continue;
            omittedRes.add(row);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void omitteFileRes(List<Long> omitteEntryIds) {
        ArrayList<String> placeholds = new ArrayList<String>(omitteEntryIds.size());
        ArrayList<Long> values = new ArrayList<Long>(omitteEntryIds.size());
        ArrayList<Integer> types = new ArrayList<Integer>(omitteEntryIds.size());
        for (Long entryid : omitteEntryIds) {
            placeholds.add("?");
            values.add(entryid);
            types.add(-5);
        }
        String placehold = String.join((CharSequence)",", placeholds);
        String sql = "UPDATE t_iscb_dts_conv_res_file SET fis_need='false' WHERE fentryid in (" + placehold + ')';
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sql, values, types);
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    public void registerListener(EventObject e) {
        super.registerListener(e);
        ((EntryGrid)this.getView().getControl(REF_RESOURCES)).addRowClickListener((RowClickEventListener)this);
        AttachmentPanel attachmentPanel = (AttachmentPanel)this.getView().getControl("attachmentpanel");
        attachmentPanel.addUploadListener((UploadListener)this);
    }

    public void entryRowClick(RowClickEvent e) {
        EntryGrid entryGrid = (EntryGrid)e.getSource();
        int row = e.getRow();
        String entryKey = entryGrid.getKey();
        this.getPageCache().put(entryKey, String.valueOf(row));
        this.getView().setVisible(Boolean.valueOf(this.isFailed(entryKey, row)), new String[]{BTN_REF_RES_STACKTRACE});
        this.getView().setVisible(this.isConverted(entryKey, row), new String[]{BTN_REF_RES_DIFF_COMP});
    }

    private Boolean isConverted(String entryKey, int row) {
        if (row == -1) {
            return Boolean.TRUE;
        }
        String state = D.s((Object)this.getModel().getValue("ref_state", row));
        return "SUCCESS".equals(state) || "FAILED".equals(state);
    }

    private boolean isFailed(String entryKey, int row) {
        return "FAILED".equals(this.getModel().getValue("ref_state", row));
    }

    private void restDataSourceMapping() {
        this.getModel().setValue("tar_pk", null);
        this.getModel().setValue("tar_number", null);
        this.getModel().setValue("tar_name", null);
    }

    private void startParsingFiles() {
        IDataModel m = this.getModel();
        long id = D.l((Object)m.getValue("id"));
        List jobs = JobEngine.getJobsWithOwnerId((long)id);
        if (jobs.isEmpty()) {
            String s = ResManager.loadKDString((String)"\u8d44\u6e90\u89e3\u6790\uff0c\u6279\u53f7\uff1a%s", (String)"DataSourceConvertFormPlugin_3", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
            s = String.format(s, m.getValue(BILLNO));
            DtsFileResourceParseJob job = new DtsFileResourceParseJob(id, s);
            FormOpener.startJob((AbstractFormPlugin)this, (Job)job, (String)PARSED);
        } else {
            JobInfo jobInfo = (JobInfo)jobs.get(0);
            FormOpener.reopenJob((AbstractFormPlugin)this, (long)jobInfo.getId(), (String)jobInfo.getTitle(), (String)PARSED);
        }
        this.getView().setEnable(Boolean.FALSE, new String[]{"mode"});
    }

    private void startConvertResource() {
        IDataModel m = this.getModel();
        long id = D.l((Object)m.getValue("id"));
        List jobs = JobEngine.getJobsWithOwnerId((long)id);
        if (jobs.isEmpty()) {
            HashMap<String, Object> paramMap = new HashMap<String, Object>(4);
            paramMap.put("id", id);
            paramMap.put("mode", m.getValue("mode"));
            paramMap.put("resetInfo", this.getResetInfo());
            paramMap.put("autoSuffix", D.x((Object)m.getValue("auto_suffix")));
            String s = ResManager.loadKDString((String)"\u8d44\u6e90\u8f6c\u6362\uff0c\u6279\u53f7\uff1a%s", (String)"DataSourceConvertFormPlugin_2", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
            s = String.format(s, m.getValue(BILLNO));
            DataSourceConvertJob job = new DataSourceConvertJob(Json.toString(paramMap), s);
            FormOpener.startJob((AbstractFormPlugin)this, (Job)job, (String)CONVERTED);
        } else {
            JobInfo jobInfo = (JobInfo)jobs.get(0);
            FormOpener.reopenJob((AbstractFormPlugin)this, (long)jobInfo.getId(), (String)jobInfo.getTitle(), (String)CONVERTED);
        }
    }

    private Map<String, Object> getResetInfo() {
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        paramMap.put("isv", this.getModel().getValue("isv"));
        paramMap.put("protect_level", this.getModel().getValue("protect_level"));
        paramMap.put("source_tenant", this.getModel().getValue("source_tenant"));
        paramMap.put("source_trace", this.getModel().getValue("source_trace"));
        return paramMap;
    }

    public void closedCallBack(ClosedCallBackEvent evt) {
        super.closedCallBack(evt);
        String action = evt.getActionId();
        if ("change_ds_callback".equals(action)) {
            this.setDataSourceMapping(evt);
        } else if (PARSED.equals(action) || CONVERTED.equals(action)) {
            this.getView().invokeOperation("refresh");
        }
    }

    private void setDataSourceMapping(ClosedCallBackEvent evt) {
        Object returnData = evt.getReturnData();
        ListSelectedRowCollection rows = (ListSelectedRowCollection)returnData;
        if (rows == null) {
            return;
        }
        if (rows.size() == 1) {
            ListSelectedRow row = rows.get(0);
            String pk = D.s((Object)row.getPrimaryKeyValue());
            if (Objects.equals(pk, this.getModel().getValue("src_pk"))) {
                String s = ResManager.loadKDString((String)"\u6570\u636e\u6e90\u672a\u53d1\u751f\u53d8\u5316\u3002", (String)"DataSourceConvertFormPlugin_1", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
                this.getView().showTipNotification(s);
            } else {
                this.getModel().setValue("tar_pk", (Object)pk);
                this.getModel().setValue("tar_number", (Object)D.s((Object)row.getNumber()));
                this.getModel().setValue("tar_name", (Object)D.s((Object)row.getName()));
            }
        } else {
            String s = ResManager.loadKDString((String)"\u4ec5\u80fd\u9009\u62e9\u4e00\u884c\u6570\u636e\u6e90\u8fdb\u884c\u5207\u6362", (String)"DataSourceConvertFormPlugin_0", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
            this.getView().showErrorNotification(s);
        }
    }

    public void afterUpload(UploadEvent evt) {
        this.setSaveByResIsEmpty();
    }

    public void propertyChanged(PropertyChangedArgs e) {
        super.propertyChanged(e);
        if ("mode".equals(e.getProperty().getName())) {
            if (ConvertMode.reset_trace.name().equals(e.getChangeSet()[0].getNewValue())) {
                this.getView().setVisible(Boolean.FALSE, new String[]{"data_source_entry_flex"});
            } else {
                this.getView().setVisible(Boolean.TRUE, new String[]{"data_source_entry_flex"});
            }
            this.getView().updateView();
        }
    }
}

