/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.dts.route;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.sql.Connection;
import java.sql.Timestamp;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.db.tx.TX;
import kd.bos.id.IDService;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.MetadataServiceHelper;
import kd.bos.servicehelper.operation.SaveServiceHelper;
import kd.isc.iscb.platform.core.dts.ExportDynamicObject;
import kd.isc.iscb.platform.core.dts.route.DataSourceConvertJob;
import kd.isc.iscb.platform.core.job.Job;
import kd.isc.iscb.platform.core.job.JobEngine;
import kd.isc.iscb.util.db.DbUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.Hash;
import kd.isc.iscb.util.misc.Json;
import kd.isc.iscb.util.misc.Pair;
import kd.isc.iscb.util.misc.StringUtil;

public class DtsFileResourceUtil {
    private static final String TABLE_HEADER = "T_ISCB_DTS_SRC_CONVERT";

    static void setFailed(long id) {
        String sql = "UPDATE T_ISCB_DTS_SRC_CONVERT SET fstate=? WHERE fid=?";
        List<Object> values = Arrays.asList("FAILED", id);
        List<Integer> types = Arrays.asList(12, -5);
        DtsFileResourceUtil.executeSql(sql, values, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void setParsed(long id, String remark) {
        String sql = "UPDATE T_ISCB_DTS_SRC_CONVERT SET fprogress='PARSED',fstate='READY', fremark=? WHERE fid=?";
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            DbUtil.executeUpdate((Connection)cn, (String)sql, Arrays.asList(StringUtil.trim((String)remark, (int)255), id), Arrays.asList(12, -5));
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    static void setConverting(long id) {
        String sql = "UPDATE T_ISCB_DTS_SRC_CONVERT SET fprogress=? WHERE fid=?";
        List<Object> values = Arrays.asList("CONVERTING", id);
        List<Integer> types = Arrays.asList(12, -5);
        DtsFileResourceUtil.executeSql(sql, values, types);
    }

    static void setConverted(long id, int success, int failed, int omitted, int total) {
        String sql = "UPDATE T_ISCB_DTS_SRC_CONVERT SET fprogress=?,fstate=?,fremark=? WHERE fid=?";
        String s = ResManager.loadKDString((String)"\u603b\u8ba1\u5904\u7406\uff1a%1$s\uff0c\u6210\u529f\uff1a%2$s\uff0c\u5ffd\u7565\uff1a%3$s\uff1b\u5931\u8d25\uff1a%4$s", (String)"DtsFileResourceUtil_5", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
        String remark = String.format(s, total, success, omitted, failed);
        List<Object> values = Arrays.asList("CONVERTED", "SUCCESS", remark, id);
        List<Integer> types = Arrays.asList(12, 12, 12, -5);
        DtsFileResourceUtil.executeSql(sql, values, types);
    }

    static void setCanceled(long id) {
        String sql = "UPDATE T_ISCB_DTS_SRC_CONVERT SET fprogress=?,fstate=? WHERE fid=?";
        List<Object> values = Arrays.asList("PAUSED", "CANCELED", id);
        List<Integer> types = Arrays.asList(12, 12, -5);
        DtsFileResourceUtil.executeSql(sql, values, types);
    }

    static void setEntryState(String table, long enryId, String state, Throwable err) {
        String sql = "UPDATE " + table + " SET fstate=?, fstack_trace = ? WHERE fentryid=?";
        List<Object> values = Arrays.asList(state, StringUtil.toString((Throwable)err), enryId);
        List<Integer> types = Arrays.asList(12, 12, -5);
        DtsFileResourceUtil.executeSql(sql, values, types);
    }

    static void setEntrySuccess(String table, long entryId, String newName, String newNumber, String newId, String data) {
        String sql = "UPDATE " + table + " SET fstate='SUCCESS', fnew_name = ?, fnew_number=?, fnew_res_pk=?, fnew_content=? WHERE fentryid=?";
        List<Object> values = Arrays.asList(newName, newNumber, newId, data, entryId);
        List<Integer> types = Arrays.asList(12, 12, 12, 12, -5);
        DtsFileResourceUtil.executeSql(sql, values, types);
    }

    static void setEntryOmitted(String table, long entryId) {
        String sql = "UPDATE " + table + " SET fstate='OMITTED' WHERE fentryid=?";
        List<Object> values = Collections.singletonList(entryId);
        List<Integer> types = Collections.singletonList(-5);
        DtsFileResourceUtil.executeSql(sql, values, types);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean executeSql(String sql, List<Object> values, List<Integer> types) {
        Connection cn = TX.getConnection((String)"ISCB", (boolean)false);
        try {
            boolean bl = DbUtil.executeUpdate((Connection)cn, (String)sql, values, types) == 1;
            return bl;
        }
        finally {
            DbUtil.close((Connection)cn, (boolean)true);
        }
    }

    static String getResName(Map<String, Object> data) {
        Object value = data.get("name");
        String s = value instanceof Map ? D.s(((Map)value).get("zh_CN")) : D.s((Object)value);
        String none = ResManager.loadKDString((String)"(\u65e0)", (String)"DtsFileResourceUtil_4", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
        return s == null ? none : s;
    }

    static String getNumber(Map<String, Object> data) {
        String none = ResManager.loadKDString((String)"(\u65e0)", (String)"DtsFileResourceUtil_4", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
        String number = D.s((Object)data.get("number"));
        return number == null ? none : number;
    }

    static String getTimeField(String entity) {
        String field = "isc_apic_permission".equals(entity) ? "created_time" : "modifytime";
        return field;
    }

    public static void startConvertResource(String entityType, List<Object> resourceId, Map<String, String> mapping, Map<String, Object> config) {
        DynamicObject convert = DtsFileResourceUtil.saveConvertBill(config);
        try {
            DtsFileResourceUtil.parse(entityType, resourceId, mapping, convert);
        }
        catch (Throwable e) {
            String sql = "delete from t_iscb_dts_src_convert where fid=?";
            List<Integer> types = Collections.singletonList(-5);
            List<Object> values = Collections.singletonList(convert.getPkValue());
            DtsFileResourceUtil.executeSql(sql, values, types);
            throw e;
        }
        HashMap<String, Object> paramMap = new HashMap<String, Object>(2);
        paramMap.put("id", convert.getPkValue());
        paramMap.put("mode", config.get("mode"));
        paramMap.put("suffix", config.get("suffix"));
        String s = ResManager.loadKDString((String)"\u8d44\u6e90\u8f6c\u6362\uff0c\u6279\u53f7\uff1a%s", (String)"DtsFileResourceUtil_3", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
        DataSourceConvertJob job = new DataSourceConvertJob(Json.toString(paramMap), String.format(s, convert.getString("billno")));
        JobEngine.submit((Job)job);
    }

    private static DynamicObject saveConvertBill(Map<String, Object> config) {
        DynamicObject convert = BusinessDataServiceHelper.newDynamicObject((String)"isc_source_convert");
        convert.set("billno", (Object)Hash.mur32((Object[])new Object[]{UUID.randomUUID().toString()}));
        convert.set("mode", config.get("mode"));
        convert.set("state", (Object)"READY");
        convert.set("progress", (Object)"PARSED");
        convert.set("billstatus", (Object)Character.valueOf('Z'));
        SaveServiceHelper.save((DynamicObject[])new DynamicObject[]{convert});
        return convert;
    }

    private static void parse(String entityType, List<Object> resourceId, Map<String, String> mapping, DynamicObject convert) {
        DynamicObject[] objects = BusinessDataServiceHelper.load((Object[])resourceId.toArray(), (DynamicObjectType)MetadataServiceHelper.getDataEntityType((String)entityType));
        if (objects.length == 0) {
            String s = ResManager.loadKDString((String)"\u53c2\u6570entityType\u6216resourceId\u9519\u8bef\uff0c\u672a\u67e5\u8be2\u5230\u7c7b\u578b\u4e3a%s\u7684\u6570\u636e", (String)"DtsFileResourceUtil_2", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
            throw new IscBizException(String.format(s, entityType));
        }
        String[] jsons = DtsFileResourceUtil.dynamicObjectToDts(objects);
        HashSet<String> ref_imported = new HashSet<String>(256);
        HashSet<Long> ds_imported = new HashSet<Long>(4);
        HashSet<String> res_file_imported = new HashSet<String>(128);
        long fileid = IDService.get().genLongId();
        String filename = System.currentTimeMillis() + "_" + convert.getString("billno") + ".dts";
        for (String json : jsons) {
            Object resPk;
            Map data = (Map)Json.toObject((String)json);
            if (data == null) continue;
            String entity = D.s(data.get("$entityname"));
            if (ref_imported.add(DtsFileResourceUtil.generateKey(entity, resPk = data.get("id")))) {
                DtsFileResourceUtil.saveRefResource(json, data, entity, ref_imported.size(), convert.getPkValue());
            }
            if (res_file_imported.add(DtsFileResourceUtil.generateKey(D.s((Object)fileid), resPk))) {
                DtsFileResourceUtil.saveResFile(data, (Pair<String, String>)new Pair((Object)D.s((Object)fileid), (Object)filename), entity, res_file_imported.size(), convert.getPkValue());
            }
            if (!"isc_data_source".equals(entity) || !ds_imported.add(D.l(resPk))) continue;
            DtsFileResourceUtil.saveDataSourceEntries(data, ds_imported.size(), convert.getPkValue(), mapping);
        }
    }

    private static String generateKey(String entity, Object resPk) {
        return resPk + "@" + entity;
    }

    private static void saveRefResource(String json, Map<String, Object> data, String entity, int seq, Object convertPk) {
        long entryId = IDService.get().genLongId();
        String name = DtsFileResourceUtil.getResName(data);
        String number = DtsFileResourceUtil.getNumber(data);
        String resPk = D.s((Object)data.get("id"));
        Timestamp resTime = D.t((Object)data.get(DtsFileResourceUtil.getTimeField(entity)));
        String sql = "INSERT INTO T_ISCB_DTS_CONV_RRS2(FID,FENTRYID, FSEQ, FTYPE,FSTATE,FNAME,FNUMBER,FRES_PK,FRES_TIME,FCONTENT) VALUES(?,?,?,?,?,   ?,?,?,   ?,?)";
        List<Integer> types = Arrays.asList(-5, -5, 4, 12, 12, 12, 12, 12, 93, 12);
        List<Object> values = Arrays.asList(convertPk, entryId, seq, entity, "READY", name, number, resPk, resTime, json);
        DtsFileResourceUtil.executeSql(sql, values, types);
    }

    private static void saveResFile(Map<String, Object> data, Pair<String, String> file, String entity, int seq, Object convertPk) {
        long entryId = IDService.get().genLongId();
        String resPk = D.s((Object)data.get("id"));
        String isref = D.s((Object)data.get("$isref"));
        String sql = "INSERT INTO T_ISCB_DTS_CONV_RES_FILE(FID, FENTRYID, FSEQ,FTYPE, FRES_PK, FISREF,FFILE, FFILEID, FIS_NEED) VALUES(?,?,?,  ?,?,?,  ?,?,?)";
        List<Integer> types = Arrays.asList(-5, -5, 4, 12, 12, 12, 12, 12, 12);
        List<Object> values = Arrays.asList(convertPk, entryId, seq, entity, resPk, isref, file.getB(), file.getA(), "true");
        DtsFileResourceUtil.executeSql(sql, values, types);
    }

    private static void saveDataSourceEntries(Map<String, Object> data, int seq, Object convertPk, Map<String, String> mapping) {
        String srcName = DtsFileResourceUtil.getResName(data);
        String srcNumber = DtsFileResourceUtil.getNumber(data);
        String srcResPk = D.s((Object)data.get("id"));
        String tarNumber = mapping.get(srcNumber);
        String tarName = "";
        String tarResPk = "";
        if (tarNumber != null) {
            QFilter qFilter = new QFilter("number", "=", (Object)tarNumber);
            DynamicObject tarDatasource = BusinessDataServiceHelper.loadSingle((String)"isc_data_source", (QFilter[])new QFilter[]{qFilter});
            if (tarDatasource == null) {
                String s = ResManager.loadKDString((String)"\u76ee\u6807\u6570\u636e\u6e90\u7f16\u7801\u914d\u7f6e\u4e0d\u6b63\u786e\uff0c\u672a\u627e\u5230\u7f16\u7801\u4e3a\u3010%s\u3011\u7684\u6570\u636e\u6e90\uff0c\u8bf7\u68c0\u67e5\u5f85\u5207\u6362\u6570\u636e\u6e90\u7684\u7f16\u7801\u53c2\u6570", (String)"DtsFileResourceUtil_1", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
                throw new IscBizException(String.format(s, tarNumber));
            }
            tarName = tarDatasource.getString("name");
            tarResPk = D.s((Object)tarDatasource.getPkValue());
        } else {
            tarNumber = "";
        }
        long entryId = IDService.get().genLongId();
        String sql = "INSERT INTO T_ISCB_DTS_DS_MAPPING(FID,FENTRYID, FSEQ,FSRC_NAME,FSRC_NUMBER,FSRC_PK,  FTAR_NAME,FTAR_NUMBER,FTAR_PK)  VALUES(?,?,?,   ?,?,?,   ?,?,?) ";
        List<Integer> types = Arrays.asList(-5, -5, 4, 12, 12, 12, 12, 12, 12);
        List<Object> values = Arrays.asList(convertPk, entryId, seq, srcName, srcNumber, srcResPk, tarName, tarNumber, tarResPk);
        DtsFileResourceUtil.executeSql(sql, values, types);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String[] dynamicObjectToDts(DynamicObject[] objects) {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            ExportDynamicObject.export((OutputStream)output, (DynamicObject[])objects, (boolean)true);
            String content = output.toString("utf-8");
            String[] stringArray = content.split("\\n");
            return stringArray;
        }
        catch (Exception e) {
            String s = ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"DtsFileResourceUtil_0", (String)"isc-iscb-ds-convert", (Object[])new Object[0]);
            throw new IscBizException(String.format(s, StringUtil.getCascadeMessage((Throwable)e)), (Throwable)e);
        }
    }
}

