/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.resource.ResManager;
import kd.isc.iscb.platform.core.cache.data.ServiceFlow;
import kd.isc.iscb.platform.core.sf.ServiceFlowHelper;
import kd.isc.iscb.platform.core.sf.ServiceFlowParser;
import kd.isc.iscb.platform.core.trace.Caller;
import kd.isc.iscb.platform.core.trace.TraceStack;
import kd.isc.iscb.service.IscFlowService;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.flow.core.Flow;
import kd.isc.iscb.util.flow.core.Variable;
import kd.isc.iscb.util.trace.TraceTask;

public class IscFlowServiceImpl
implements IscFlowService {
    public Map<String, Object> execute(String number) {
        return this.execute(number, Collections.emptyList());
    }

    public Map<String, Object> execute(final String number, final List<Object> inputs) {
        return (Map)TraceStack.trace((Caller)Caller.MicroSVC, (TraceTask)new TraceTask(){

            public Object invoke() {
                return ServiceFlowHelper.execute((String)number, (List)inputs);
            }
        });
    }

    public Map<String, Object> execute2(String number, Map<String, Object> params) {
        Long flowReleasedId = this.getFlowReleasedId(number);
        List<Object> inputs = this.getInputs(params, flowReleasedId);
        return this.execute(number, inputs);
    }

    public void release(String number) {
        ServiceFlowHelper.release((String)number);
    }

    public long start(String number) {
        return this.start(number, Collections.emptyList());
    }

    public long start(final String number, final List<Object> inputs) {
        return (Long)TraceStack.trace((Caller)Caller.MicroSVC, (TraceTask)new TraceTask(){

            public Object invoke() {
                return ServiceFlowHelper.start((String)number, (List)inputs);
            }
        });
    }

    public long start2(String number, Map<String, Object> params) {
        Long flowReleasedId = this.getFlowReleasedId(number);
        List<Object> inputs = this.getInputs(params, flowReleasedId);
        return this.start(number, inputs);
    }

    public Map<String, Object> getState(long instId) {
        return ServiceFlowHelper.getState((long)instId);
    }

    public boolean retry(long instId) {
        return ServiceFlowHelper.retry((long)instId);
    }

    public boolean terminate(long instId) {
        return ServiceFlowHelper.terminate((long)instId);
    }

    private Long getFlowReleasedId(String number) {
        ServiceFlow flow = ServiceFlow.getSchema((String)number);
        if (flow == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u672a\u627e\u5230\u7f16\u7801\u662f%s\u7684\u670d\u52a1\u6d41\u7a0b\u3002", (String)"IscFlowServiceImpl_0", (String)"isc-api-msservice", (Object[])new Object[0]), number));
        }
        long releasedId = flow.getReleasedFlowId();
        return releasedId;
    }

    private List<Object> getInputs(Map<String, Object> data, long flowId) {
        this.checkInputParams(data);
        Flow flow = ServiceFlowParser.getFlow((long)flowId);
        List vars = flow.getInputVariables();
        ArrayList<Object> inputs = new ArrayList<Object>(vars.size());
        ArrayList<String> unPassedParams = new ArrayList<String>(vars.size());
        this.convertToInputs(data, vars, inputs, unPassedParams);
        if (unPassedParams.size() > 0) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u53c2\u6570\u4e0d\u6b63\u786e\uff0c\u8bf7\u68c0\u67e5\u4f20\u53c2\u4e2d\u662f\u5426\u542b\u6709\u53c2\u6570\uff1a%s", (String)"IscFlowServiceImpl_1", (String)"isc-api-msservice", (Object[])new Object[0]), String.join((CharSequence)",", unPassedParams)));
        }
        return inputs;
    }

    private void convertToInputs(Map<String, Object> data, List<? extends Variable> vars, List<Object> inputs, List<String> notExistParams) {
        for (Variable variable : vars) {
            String name = variable.getName();
            Object o = data.get(name);
            if (o == null && !data.containsKey(name)) {
                notExistParams.add(name);
                continue;
            }
            inputs.add(o);
        }
    }

    private void checkInputParams(Map<String, Object> data) {
        if (data == null) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u8f93\u5165\u53c2\u6570\u4e3anull\uff0c\u8bf7\u4f20\u5165\u6d41\u7a0b\u53d8\u91cf\u8f93\u5165\u53c2\u6570", (String)"IscFlowServiceImpl_2", (String)"isc-api-msservice", (Object[])new Object[0]), new Object[0]));
        }
    }
}

