/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.context.RequestContextCreator;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.metadata.dynamicobject.DynamicObjectType;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.EntityMetadataCache;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.isc.iscb.platform.core.dts.ExportDynamicObject;
import kd.isc.iscb.platform.core.dts.ImportDynamicObject;
import kd.isc.iscb.platform.core.imp.ImportResourceUtil;
import kd.isc.iscb.platform.core.util.ContextUtil;
import kd.isc.iscb.service.IscResourceService;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;

public class IscResourceServiceImpl
implements IscResourceService {
    public void importResource(String dtsFileContent) {
        this.importResourceWithPattern(dtsFileContent, false);
    }

    public void importResourceWithPattern(String dts, boolean override) {
        RequestContext current = RequestContext.get();
        if (D.l((Object)current.getUserId()) == 0L) {
            this.executeWithContext(dts, override);
        } else {
            ImportDynamicObject.innerImport((String)dts, (boolean)override);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeWithContext(String dts, boolean override) {
        RequestContext current = RequestContext.get();
        RequestContext newRc = ContextUtil.createRequestContext((String)current.getAccountId(), (String)current.getTenantId());
        try {
            RequestContextCreator.restoreForMQ((RequestContext)newRc);
            ImportDynamicObject.innerImport((String)dts, (boolean)override);
        }
        finally {
            RequestContextCreator.restoreForMQ((RequestContext)current);
        }
    }

    public String exportResource(String entityNumber, String id) {
        DynamicObject object = BusinessDataServiceHelper.loadSingle((Object)id, (String)entityNumber);
        if (object == null) {
            String s = ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u539f\u56e0\uff1a\u6839\u636e\u5b9e\u4f53\u7f16\u7801[%1$s]\u6ca1\u6709\u67e5\u8be2id\u4e3a[%2$s]\u5230\u96c6\u6210\u8d44\u6e90", (String)"IscResourceServiceImpl_1", (String)"isc-api-msservice", (Object[])new Object[0]);
            throw new IscBizException(String.format(s, entityNumber, id));
        }
        return IscResourceServiceImpl.dynamicObjectToDts(new DynamicObject[]{object});
    }

    public String exportResourceByMultiId(String entityNumber, List<String> idList) {
        if (idList.size() > 100) {
            String s = ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u5bfc\u51fa\u7684\u8d44\u6e90\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e100", (String)"IscResourceServiceImpl_2", (String)"isc-api-msservice", (Object[])new Object[0]);
            throw new IscBizException(s);
        }
        DynamicObject[] objects = BusinessDataServiceHelper.load((Object[])idList.toArray(), (DynamicObjectType)EntityMetadataCache.getDataEntityType((String)entityNumber));
        return IscResourceServiceImpl.dynamicObjectToDts(objects);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static String dynamicObjectToDts(DynamicObject[] objects) {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            ExportDynamicObject.export((OutputStream)output, (DynamicObject[])objects, (boolean)true);
            String string = output.toString("utf-8");
            return string;
        }
        catch (Exception e) {
            String s = ResManager.loadKDString((String)"\u5bfc\u51fa\u5931\u8d25\uff0c\u539f\u56e0\uff1a%s", (String)"IscResourceServiceImpl_0", (String)"isc-api-msservice", (Object[])new Object[0]);
            throw new IscBizException(String.format(s, StringUtil.getCascadeMessage((Throwable)e)), (Throwable)e);
        }
    }

    public List<Map<String, Object>> importResourceWithResponse(String dtsFileContent) {
        return ImportResourceUtil.doImport((String)dtsFileContent);
    }
}

