/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.db2;

import com.ibm.db2.jcc.DB2SimpleDataSource;
import java.sql.SQLException;
import kd.bos.dataentity.entity.DynamicObject;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.JdbcConnectionWrapper;
import kd.isc.iscb.platform.core.connector.jdbc.AbstractConnectionFactory;
import kd.isc.iscb.util.connector.server.MetaType;

public class Db2ConnectionFactory
extends AbstractConnectionFactory {
    protected DB2SimpleDataSource createDataSource(String url, String user, String password) throws SQLException {
        DB2SimpleDataSource db2DataSource = new DB2SimpleDataSource();
        db2DataSource.setUser(user);
        db2DataSource.setPassword(password);
        String[] urlPara = url.split(":");
        String serverName = urlPara[0];
        int portNumber = Integer.parseInt(urlPara[1]);
        String databaseName = urlPara[2];
        String schema = urlPara[3];
        db2DataSource.setServerName(serverName);
        db2DataSource.setPortNumber(portNumber);
        db2DataSource.setDatabaseName(databaseName);
        db2DataSource.setDriverType(4);
        db2DataSource.setCurrentSchema(schema);
        return db2DataSource;
    }

    protected String getURL(DynamicObject cfg) {
        String server = cfg.getString("server_ip");
        int port = cfg.getInt("server_port");
        String service = cfg.getString("sql_database");
        String schame = cfg.getString("attr1");
        return server + ":" + port + ":" + service + ":" + schame;
    }

    protected String getTestSQL() {
        return "select 1 from SYSIBM.SYSDUMMY1";
    }

    public String topSQL(JdbcConnectionWrapper cn, String sql, int topN) {
        if (sql.startsWith("select") || sql.startsWith("SELECT")) {
            return sql + " FETCH FIRST " + Math.max(1, topN) + " ROWS ONLY";
        }
        throw new IllegalArgumentException(sql);
    }

    public boolean hasMetaData(String metaFullname, String type, ConnectionWrapper cn) {
        switch (MetaType.valueOf((String)type)) {
            case VIEW: {
                return true;
            }
            case TABLE: {
                return true;
            }
        }
        return false;
    }

    public char getQuot() {
        return ' ';
    }
}

