/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.email;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.BodyPart;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.PasswordAuthentication;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimeUtility;
import javax.mail.search.AndTerm;
import javax.mail.search.FlagTerm;
import javax.mail.search.ReceivedDateTerm;
import javax.mail.search.SearchTerm;
import javax.mail.search.SentDateTerm;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.AttachmentServiceHelper;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.url.UrlService;
import kd.isc.iscb.platform.core.connector.sunftp.FtpUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.err.CommonError;
import kd.isc.iscb.util.except.IscBizException;
import kd.isc.iscb.util.misc.StringUtil;
import kd.isc.iscb.util.script.misc.HttpDownloadFile;

public class EmailUtil {
    private static final long MAX_SIZE = 0x300000L;

    public static Map<String, Object> parsePop3Message(Message message, String maxSize) throws MessagingException, IOException {
        if (message == null) {
            return null;
        }
        HashMap<String, Object> msg = new HashMap<String, Object>();
        MimeMessage mimeMessage = (MimeMessage)message;
        String messageID = mimeMessage.getMessageID();
        msg.put("messageID", messageID);
        EmailUtil.getEmailHead(msg, mimeMessage);
        ArrayList<Map<String, Object>> contents = new ArrayList<Map<String, Object>>();
        EmailUtil.getEmailContents((Part)message, contents);
        msg.put("contents", contents);
        ArrayList<Map<String, Object>> attachments = new ArrayList<Map<String, Object>>();
        EmailUtil.getEmailAtts((Part)mimeMessage, attachments, maxSize);
        if (!attachments.isEmpty()) {
            msg.put("attachments", attachments);
        }
        return msg;
    }

    public static Map<String, Object> parseImapMessage(Message message, String maxSize) throws MessagingException, IOException {
        if (message == null) {
            return null;
        }
        return EmailUtil.parsePop3Message(message, maxSize);
    }

    private static List<Map<String, Object>> getEmailContents(Part part, List<Map<String, Object>> contents) throws MessagingException, IOException {
        boolean isContainTextAttach;
        ArrayList<Map<String, Object>> parts = new ArrayList<Map<String, Object>>();
        boolean bl = isContainTextAttach = part.getContentType().indexOf("name") > 0;
        if (part.isMimeType("text/plain") && !isContainTextAttach) {
            EmailUtil.handleContent(contents, D.s((Object)part.getContent()), true);
        } else if (part.isMimeType("text/html")) {
            EmailUtil.handleContent(contents, D.s((Object)part.getContent()), false);
        } else if (EmailUtil.isMimeType(part)) {
            EmailUtil.getEmailContents((Part)part.getContent(), contents);
        } else if (EmailUtil.isMultipart(part)) {
            Multipart multipart = (Multipart)part.getContent();
            int partCount = multipart.getCount();
            for (int i = 0; i < partCount; ++i) {
                BodyPart bodyPart = multipart.getBodyPart(i);
                EmailUtil.getEmailContents((Part)bodyPart, contents);
            }
        }
        return parts;
    }

    private static void getEmailHead(Map<String, Object> msg, MimeMessage mimeMessage) throws MessagingException {
        msg.put("subject", mimeMessage.getSubject());
        Address[] from = mimeMessage.getFrom();
        msg.put("from", InternetAddress.toUnicodeString((Address[])from));
        Address[] to = mimeMessage.getRecipients(Message.RecipientType.TO);
        msg.put("to", InternetAddress.toUnicodeString((Address[])to));
        Address[] cc = mimeMessage.getRecipients(Message.RecipientType.CC);
        msg.put("cc", InternetAddress.toUnicodeString((Address[])cc));
        msg.put("sentDate", mimeMessage.getSentDate());
    }

    private static void handleContent(List<Map<String, Object>> contents, String content, boolean isPlain) {
        HashMap<String, Object> conMap = new HashMap<String, Object>(2);
        conMap.put("text", content);
        conMap.put("isPlain", isPlain);
        contents.add(conMap);
    }

    private static void getEmailAtts(Part part, List<Map<String, Object>> attachments, String maxSize) throws MessagingException, IOException {
        if (EmailUtil.isMultipart(part)) {
            Multipart multipart = (Multipart)part.getContent();
            int partCount = multipart.getCount();
            for (int i = 0; i < partCount; ++i) {
                BodyPart bodyPart = multipart.getBodyPart(i);
                String disp = bodyPart.getDisposition();
                if (disp != null && (disp.equalsIgnoreCase("attachment") || disp.equalsIgnoreCase("inline"))) {
                    EmailUtil.handleEmailAtt(bodyPart, attachments, maxSize);
                    continue;
                }
                if (EmailUtil.isMultipart(part)) {
                    EmailUtil.getEmailAtts((Part)bodyPart, attachments, maxSize);
                    continue;
                }
                String contentType = bodyPart.getContentType();
                if (!contentType.contains("name") && !contentType.contains("application")) continue;
                EmailUtil.handleEmailAtt(bodyPart, attachments, maxSize);
            }
        } else if (EmailUtil.isMimeType(part)) {
            EmailUtil.getEmailAtts((Part)part.getContent(), attachments, maxSize);
        }
    }

    private static void handleEmailAtt(BodyPart bodyPart, List<Map<String, Object>> attachments, String maxFsize) {
        long maxSize = Math.min(0x300000L, FtpUtil.getMaxFileSize((String)maxFsize));
        try (InputStream in = bodyPart.getInputStream();){
            if ((long)bodyPart.getSize() > maxSize) {
                throw new IscBizException(String.format(ResManager.loadKDString((String)"\u6700\u5927\u652f\u6301\u83b7\u53d6\u6587\u4ef6\u5927\u5c0f\u4e3a[%1$s \u5b57\u8282], \u6587\u4ef6\u540d\u4e3a[%2$s], \u5b9e\u9645\u6587\u4ef6\u5927\u5c0f\u4e3a[%3$s \u5b57\u8282]\u3002", (String)"EmailUtil_1", (String)"isc-iscb-connector-email", (Object[])new Object[0]), maxSize, EmailUtil.decodeText(bodyPart.getFileName()), bodyPart.getSize()));
            }
            HashMap<String, Object> files = new HashMap<String, Object>(2);
            files.put("fileName", EmailUtil.decodeText(bodyPart.getFileName()));
            ByteArrayOutputStream byteArray = new ByteArrayOutputStream();
            HttpDownloadFile.copyStream((InputStream)in, (ByteArrayOutputStream)byteArray);
            files.put("fileByte", byteArray.toByteArray());
            attachments.add(files);
        }
        catch (IOException | MessagingException e) {
            throw new IscBizException(e);
        }
    }

    public static SearchTerm buildPop3Terms(Object status, Object dateFrom, Object dateTo) {
        String df;
        ArrayList<SearchTerm> termList = new ArrayList<SearchTerm>(3);
        String seen = D.s((Object)status);
        if (!StringUtil.isEmpty((String)seen)) {
            termList.add((SearchTerm)new FlagTerm(new Flags(Flags.Flag.SEEN), D.x((Object)seen)));
        }
        if (StringUtil.isEmpty((String)(df = D.s((Object)dateFrom)))) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671fdateFrom\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EmailUtil_5", (String)"isc-iscb-connector-email", (Object[])new Object[0]));
        }
        termList.add((SearchTerm)new SentDateTerm(6, EmailUtil.createDate(df)));
        String dt = D.s((Object)dateTo);
        if (StringUtil.isEmpty((String)dt)) {
            termList.add((SearchTerm)new SentDateTerm(1, new Date()));
        } else {
            termList.add((SearchTerm)new SentDateTerm(1, EmailUtil.createDate(dt)));
        }
        return EmailUtil.getSearchTerms(termList);
    }

    public static SearchTerm buildImapTerms(Object status, Object dateFrom, Object dateTo) {
        String df;
        ArrayList<SearchTerm> termList = new ArrayList<SearchTerm>(3);
        String seen = D.s((Object)status);
        if (!StringUtil.isEmpty((String)seen)) {
            termList.add((SearchTerm)new FlagTerm(new Flags(Flags.Flag.SEEN), D.x((Object)seen)));
        }
        if (StringUtil.isEmpty((String)(df = D.s((Object)dateFrom)))) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5f00\u59cb\u65e5\u671fdateFrom\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EmailUtil_0", (String)"isc-iscb-connector-email", (Object[])new Object[0]));
        }
        termList.add((SearchTerm)new ReceivedDateTerm(6, EmailUtil.createDate(df)));
        String dt = D.s((Object)dateTo);
        if (StringUtil.isEmpty((String)dt)) {
            termList.add((SearchTerm)new ReceivedDateTerm(1, new Date()));
        } else {
            termList.add((SearchTerm)new ReceivedDateTerm(1, EmailUtil.createDate(dt)));
        }
        return EmailUtil.getSearchTerms(termList);
    }

    private static Date createDate(String dateStr) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
        try {
            return sdf.parse(dateStr);
        }
        catch (ParseException e) {
            throw new IscBizException(String.format(ResManager.loadKDString((String)"\u89e3\u6790\u65e5\u671f%1$s\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a", (String)"EmailUtil_7", (String)"isc-iscb-connector-email", (Object[])new Object[0]), dateStr), (Throwable)e);
        }
    }

    private static SearchTerm getSearchTerms(List<SearchTerm> termList) {
        SearchTerm[] terms = new SearchTerm[termList.size()];
        for (int i = 0; i < termList.size(); ++i) {
            terms[i] = termList.get(i);
        }
        return new AndTerm(terms);
    }

    public static void buildMultipart(MimeMultipart multipart, Map<String, String> billMap, String charset) throws MessagingException {
        DynamicObject dynamicObject = EmailUtil.getDynamicObject(billMap);
        if (dynamicObject != null) {
            List attPanels = AttachmentServiceHelper.getAttachments((String)billMap.get("entityName"), (Object)dynamicObject.getPkValue(), (String)billMap.get("attPanel"));
            for (Map panel : attPanels) {
                EmailUtil.multipartAddPart(multipart, charset, panel.get("relativeUrl"));
            }
            DynamicObjectCollection attFields = (DynamicObjectCollection)dynamicObject.get(D.s((Object)billMap.get("attField")));
            for (DynamicObject field : attFields) {
                DynamicObject basedata = field.getDynamicObject("fbasedataId");
                EmailUtil.multipartAddPart(multipart, charset, basedata.get("url"));
            }
        }
    }

    private static DynamicObject getDynamicObject(Map<String, String> billMap) {
        String entityName = D.s((Object)billMap.get("entityName"));
        if (StringUtil.isEmpty((String)entityName)) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5355\u636e\u6807\u8bc6entityName\u4e0d\u80fd\u4e3a\u7a7a\u3002", (String)"EmailUtil_9", (String)"isc-iscb-connector-email", (Object[])new Object[0]));
        }
        if (StringUtil.isEmpty((String)D.s((Object)billMap.get("attField")))) {
            return null;
        }
        QFilter[] filters = new QFilter[]{new QFilter("id", "=", (Object)billMap.get("id"))};
        return BusinessDataServiceHelper.loadSingle((String)entityName, (String)D.s((Object)billMap.get("attField")), (QFilter[])filters);
    }

    private static void multipartAddPart(MimeMultipart multipart, String charset, Object url) throws MessagingException {
        String fileUrl = UrlService.getAttachmentFullUrl((String)D.s((Object)url));
        MimeBodyPart mbp = new MimeBodyPart();
        mbp.setContent((Object)EmailUtil.decoderUrl(fileUrl, charset), EmailUtil.getType(charset));
        multipart.addBodyPart((BodyPart)mbp);
    }

    public static String getType(String charset) {
        return "text/plain;charset=" + charset;
    }

    private static boolean isMimeType(Part part) throws MessagingException {
        return part.isMimeType("message/rfc822");
    }

    private static boolean isMultipart(Part part) throws MessagingException {
        return part.isMimeType("multipart/*");
    }

    private static String decoderUrl(String url, String charset) {
        try {
            return URLDecoder.decode(url, charset);
        }
        catch (UnsupportedEncodingException e) {
            throw CommonError.INVALID_CHARSET.create((Throwable)e, new String[]{charset});
        }
    }

    private static String decodeText(String encodeText) throws UnsupportedEncodingException {
        if (encodeText == null || "".equals(encodeText)) {
            return "";
        }
        return MimeUtility.decodeText((String)encodeText);
    }

    public static Session getSession(Properties props, final DynamicObject cfg) {
        return Session.getInstance((Properties)props, (Authenticator)new Authenticator(){

            protected PasswordAuthentication getPasswordAuthentication() {
                return new PasswordAuthentication(cfg.getString("user"), cfg.getString("newpwd"));
            }
        });
    }

    public static void close(Store store, Folder folder, boolean isDelMsg) {
        try {
            if (folder != null) {
                folder.close(isDelMsg);
            }
            if (store != null) {
                store.close();
            }
        }
        catch (MessagingException e) {
            throw new IscBizException(ResManager.loadKDString((String)"\u5173\u95ed\u90ae\u4ef6\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a", (String)"EmailUtil_3", (String)"isc-iscb-connector-email", (Object[])new Object[0]), (Throwable)e);
        }
    }
}

