/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.connector.email;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.mail.Flags;
import javax.mail.Folder;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.Store;
import javax.mail.internet.MimeMessage;
import javax.mail.search.SearchTerm;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.isc.iscb.platform.core.connector.ConnectionFactory;
import kd.isc.iscb.platform.core.connector.ConnectionWrapper;
import kd.isc.iscb.platform.core.connector.email.EmailUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.except.IscBizException;

public class Pop3ConnectionWrapper
extends ConnectionWrapper {
    private static final Log LOGGER = LogFactory.getLog(Pop3ConnectionWrapper.class);
    private static final int DEFAULT_TIMEOUT = 3000;
    private static final String PROTOCOL = "pop3";
    private static final String INBOX = "INBOX";

    public Pop3ConnectionWrapper(ConnectionFactory factory, DynamicObject cfg) {
        super(factory, cfg);
    }

    public void test() {
        DynamicObject cfg = this.getConfig();
        Session session = EmailUtil.getSession(this.getProps(), cfg);
        Store store = null;
        try {
            store = session.getStore();
            store.connect();
        }
        catch (MessagingException e) {
            throw new IscBizException(ResManager.loadKDString((String)"\u90ae\u4ef6\u8fde\u63a5\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a", (String)"Pop3ConnectionWrapper_test", (String)"isc-iscb-connector-email", (Object[])new Object[0]), (Throwable)e);
        }
        finally {
            EmailUtil.close(store, null, false);
        }
    }

    public List<String> search(Object status, Object dateFrom, Object dateTo) {
        ArrayList<String> arrayList;
        DynamicObject cfg = this.getConfig();
        Session session = EmailUtil.getSession(this.getProps(), cfg);
        Store store = null;
        Folder folder = null;
        try {
            store = session.getStore();
            store.connect();
            folder = store.getFolder(INBOX);
            int type = "READ_WRITE".equals(cfg.getString("attr8")) ? 2 : 1;
            folder.open(type);
            Message[] messages = folder.search(EmailUtil.buildPop3Terms(status, dateFrom, dateTo));
            ArrayList<String> msgList = new ArrayList<String>(messages.length);
            for (Message msg : messages) {
                MimeMessage mimeMsg = (MimeMessage)msg;
                msgList.add(mimeMsg.getMessageID());
            }
            arrayList = msgList;
        }
        catch (MessagingException e) {
            try {
                throw new IscBizException(ResManager.loadKDString((String)"\u90ae\u4ef6\u67e5\u8be2\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a", (String)"Pop3ConnectionWrapper_search", (String)"isc-iscb-connector-email", (Object[])new Object[0]), (Throwable)e);
            }
            catch (Throwable throwable) {
                EmailUtil.close(store, folder, false);
                throw throwable;
            }
        }
        EmailUtil.close(store, folder, false);
        return arrayList;
    }

    public Map<String, Object> receive(final String msgID) {
        Map<String, Object> map;
        Message[] messages;
        int type;
        boolean isDelMsg;
        Folder folder;
        Store store;
        DynamicObject cfg;
        block6: {
            cfg = this.getConfig();
            Session session = EmailUtil.getSession(this.getProps(), cfg);
            store = null;
            folder = null;
            isDelMsg = false;
            store = session.getStore();
            store.connect();
            folder = store.getFolder(INBOX);
            type = "READ_WRITE".equals(cfg.getString("attr8")) ? 2 : 1;
            folder.open(type);
            SearchTerm searchTerm = new SearchTerm(){

                public boolean match(Message msg) {
                    try {
                        MimeMessage mimeMsg = (MimeMessage)msg;
                        return msgID.equals(mimeMsg.getMessageID());
                    }
                    catch (MessagingException e) {
                        LOGGER.error("kd.isc.iscb.platform.core.connector.email.Pop3ConnectionWrapper.receive", (Throwable)e);
                        return false;
                    }
                }
            };
            messages = folder.search(searchTerm);
            if (messages.length != 0) break block6;
            Map<String, Object> map2 = null;
            EmailUtil.close(store, folder, isDelMsg);
            return map2;
        }
        try {
            Message message = messages[0];
            if (type == 2) {
                message.setFlag(Flags.Flag.DELETED, true);
                isDelMsg = true;
            }
            map = EmailUtil.parsePop3Message(message, D.s((Object)cfg.getString("attr5")));
        }
        catch (IOException | MessagingException e) {
            try {
                isDelMsg = false;
                throw new IscBizException(ResManager.loadKDString((String)"\u90ae\u4ef6\u63a5\u6536\u5931\u8d25\uff0c\u539f\u56e0\u662f\uff1a", (String)"Pop3ConnectionWrapper_receive", (String)"isc-iscb-connector-email", (Object[])new Object[0]), e);
            }
            catch (Throwable throwable) {
                EmailUtil.close(store, folder, isDelMsg);
                throw throwable;
            }
        }
        EmailUtil.close(store, folder, isDelMsg);
        return map;
    }

    private Properties getProps() {
        DynamicObject cfg = this.getConfig();
        int timeout = D.i((Object)cfg.get("attr1")) <= 0 ? 3000 : D.i((Object)cfg.get("attr1")) * 1000;
        Properties props = new Properties();
        props.setProperty("mail.store.protocol", PROTOCOL);
        props.setProperty("mail.pop3.host", D.s((Object)cfg.get("server_ip")));
        props.setProperty("mail.pop3.port", D.s((Object)cfg.get("server_port")));
        props.setProperty("mail.pop3.connectiontimeout", D.s((Object)timeout));
        props.setProperty("mail.pop3.timeout", D.s((Object)timeout));
        if (D.x((Object)cfg.get("attr2"))) {
            props.setProperty("mail.pop3.ssl.enable", "true");
        }
        return props;
    }
}

