/*
 * Decompiled with CFR 0.152.
 */
package kd.isc.iscb.platform.core.task;

import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.context.RequestContext;
import kd.bos.dc.utils.AccountUtils;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.schedule.executor.AbstractTask;
import kd.isc.iscb.platform.core.license.IscLicenseUtil;
import kd.isc.iscb.platform.core.license.n.AccountInfo;
import kd.isc.iscb.platform.core.license.n.ConnectionInfo;
import kd.isc.iscb.platform.core.license.n.GroupCategory;
import kd.isc.iscb.platform.core.license.n.GroupInfo;
import kd.isc.iscb.platform.core.license.n.TenantInfo;
import kd.isc.iscb.platform.core.task.AbstractDataPush;
import kd.isc.iscb.platform.core.task.DataPushUtil;
import kd.isc.iscb.util.dt.D;
import kd.isc.iscb.util.script.encoding.Murmur;

public class LicenseDataPushTimerTask
extends AbstractTask {
    private static Log logger = LogFactory.getLog(LicenseDataPushTimerTask.class);

    public void execute(RequestContext requestContext, Map<String, Object> map) {
        if (DataPushUtil.disablePush()) {
            return;
        }
        try {
            TenantInfo tenantLicenseInfo = IscLicenseUtil.getTenantLicenseInfo();
            this.pushLicenseBase(tenantLicenseInfo);
            this.pushLicenseDetail(tenantLicenseInfo);
        }
        catch (Exception e) {
            logger.warn("\u63a8\u9001\u96c6\u6210\u4e91\u8bb8\u53ef\u4fe1\u606f\u5931\u8d25\uff0c\u539f\u56e0\uff1a" + e);
        }
    }

    private void pushLicenseDetail(TenantInfo tenantLicenseInfo) {
        List<Object> licenseDetails = this.getLicenseDetails(tenantLicenseInfo);
        DataPushUtil.pushData(licenseDetails);
    }

    private List<Object> getLicenseDetails(TenantInfo tenantLicenseInfo) {
        Map accounts = tenantLicenseInfo.getAccounts();
        ArrayList<Object> list = new ArrayList<Object>(accounts.size());
        for (AccountInfo licenseInfo : accounts.values()) {
            Map groups = licenseInfo.getGroups();
            this.getAllGroupFromAccount(list, licenseInfo, groups);
        }
        return list;
    }

    private void getAllGroupFromAccount(List<Object> list, AccountInfo licenseInfo, Map<GroupCategory, GroupInfo> groups) {
        for (Map.Entry<GroupCategory, GroupInfo> group : groups.entrySet()) {
            GroupInfo groupInfo = group.getValue();
            Collection<ConnectionInfo> connectionInfos = groupInfo.getConnections().values();
            this.getAllConnectionFromGroup(list, licenseInfo, groupInfo, connectionInfos);
        }
    }

    private void getAllConnectionFromGroup(List<Object> list, AccountInfo licenseInfo, GroupInfo groupInfo, Collection<ConnectionInfo> connectionInfos) {
        for (ConnectionInfo connectionInfo : connectionInfos) {
            Map<String, Object> pushValue = this.getDetailPushValue(licenseInfo, groupInfo, connectionInfo);
            list.add(pushValue);
        }
    }

    private Map<String, Object> getDetailPushValue(AccountInfo licenseInfo, GroupInfo groupInfo, ConnectionInfo connectionInfo) {
        HashMap<String, Object> licenseDetail = new HashMap<String, Object>(12);
        HashMap<String, Object> map = new HashMap<String, Object>(12);
        AbstractDataPush.setHeadInfo(map);
        map.put("event_name", "license_detail_table");
        licenseDetail.put("link_type_id", Murmur.calc((byte[])D.s((Object)connectionInfo.getId()).getBytes(StandardCharsets.UTF_8)));
        licenseDetail.put("link_type", connectionInfo.getType());
        licenseDetail.put("link_name", connectionInfo.getName());
        licenseDetail.put("link_number", connectionInfo.getNumber());
        licenseDetail.put("link_create_time", connectionInfo.getCreateTime());
        licenseDetail.put("license_category", this.getCateGory(groupInfo.getCategory().name()));
        licenseDetail.put("license_status", this.getLicenseState(connectionInfo.getState().name()));
        licenseDetail.put("license_sn", connectionInfo.getLicenseSN());
        map.put("var", licenseDetail);
        return map;
    }

    private void pushLicenseBase(TenantInfo tenantLicenseInfo) {
        List<Object> pushData = this.getPushData(tenantLicenseInfo);
        DataPushUtil.pushData(pushData);
    }

    private List<Object> getPushData(TenantInfo tenantLicenseInfo) {
        Map<String, Object> pushValue = this.getPushValue(tenantLicenseInfo);
        ArrayList<Object> dataList = new ArrayList<Object>(1);
        dataList.add(pushValue);
        return dataList;
    }

    private Map<String, Object> getPushValue(TenantInfo licenseInfo) {
        AccountInfo currentAccount = licenseInfo.getCurrentAccount();
        String tenantId = currentAccount.getTenant().getId();
        kd.bos.tenant.TenantInfo tenantInfo = AccountUtils.getTenantByid((String)tenantId);
        HashMap<String, Object> data = new HashMap<String, Object>(12);
        HashMap<String, Object> map = new HashMap<String, Object>(12);
        AbstractDataPush.setHeadInfo(map);
        map.put("event_name", "license_base_table");
        data.put("license_type", this.getType(licenseInfo.getFileType()));
        data.put("license_version", licenseInfo.getLicenseVersion());
        data.put("expired_date", licenseInfo.getExpiredDate());
        data.put("total_count", licenseInfo.getTotalLicenseCount());
        data.put("used_count", licenseInfo.getUsedLicenseCount());
        data.put("unused_count", licenseInfo.getUnusedLicenseCount());
        map.put("var", data);
        return map;
    }

    private String getType(String fileType) {
        String type = "\u4e34\u65f6";
        if (fileType.equals("1")) {
            type = "\u6b63\u5f0f";
        }
        return type;
    }

    private String getLicenseState(String state) {
        String s;
        switch (state) {
            case "free": {
                s = "\u9ed8\u8ba4\u514d\u8d39";
                break;
            }
            case "yes": {
                s = "\u6b63\u5e38";
                break;
            }
            case "no": {
                s = "\u8bb8\u53ef\u4e0d\u8db3";
                break;
            }
            case "expired": {
                s = "\u8bb8\u53ef\u5931\u6548";
                break;
            }
            default: {
                s = state;
            }
        }
        return s;
    }

    private String getCateGory(String cateGory) {
        String c;
        switch (cateGory) {
            case "MQ_SERVER": {
                c = "\u6d88\u606f\u670d\u52a1";
                break;
            }
            case "BIZ_WEBAPI": {
                c = "WebAPI\u8fde\u63a5";
                break;
            }
            case "BIZ_DEDICATED": {
                c = "\u4e13\u7528\u8fde\u63a5";
                break;
            }
            case "BIZ_OTHER": {
                c = "\u5176\u4ed6";
                break;
            }
            default: {
                c = cateGory;
            }
        }
        return c;
    }
}

